/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.io;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.FileUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKds;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class WizardExport
implements ISpreadWizzard {
    private static final Logger logger = LogUtil.getPackageLogger(WizardExport.class);
    private KDExt _ext;
    private KDFileChooser fileChooser;
    private String lastFilePath;
    private static final String EXTCALLBACK_NAME = "com.kingdee.cosmic.ctrl.ext.BasicExtCallback";

    public WizardExport(KDExt ext) {
        this._ext = ext;
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser = new KDFileChooser();
        this.fileChooser.setDialogTitle(ExtGuiExecutor.getLocalText("export"));
        this.fileChooser.putClientProperty(KDFileChooser.NO_PATH_MESS_ON_JVM6, KDFileChooser.NO_PATH_MESS_ON_JVM6);
        this.fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "kds"));
        FileFilter[] ff = this.fileChooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.fileChooser.removeChoosableFileFilter(ff[i]);
        }
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".kds");
            }

            @Override
            public String getDescription() {
                return CtrlEXTMessages.getMLS("lightReportFile", "\u8f7b\u62a5\u8868\u6587\u4ef6\uff08*.kds\uff09");
            }
        });
    }

    @Override
    public void show() {
        String fName;
        Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
        try {
            book = BookIOUtil.unpack(BookIOUtil.pack(book));
        }
        catch (Exception e1) {
            logger.error((Object)"err", (Throwable)e1);
        }
        if (StringUtil.isEmptyString((String)this.lastFilePath)) {
            String[] name = this._ext.getTitle().split(" - ");
            if (name != null && name.length == 2) {
                fName = WizardExport.cutCloudReportNameFlag(book, name[1]);
                this.fileChooser.setSelectedFile(new File(FilenameUtils.normalize((String)fName)));
            }
        } else {
            String[] paths = this.lastFilePath.split("\\\\");
            fName = paths[paths.length - 1];
            this.fileChooser.setSelectedFile(new File(FilenameUtils.normalize((String)fName)));
        }
        int mark = this.fileChooser.showSaveDialog((Component)((Object)this._ext));
        if (mark != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        try {
            String fileName = file.getName();
            fileName = WizardExport.cutCloudReportNameFlag(book, fileName);
            book.setName(fileName);
            String path = file.getAbsolutePath();
            path = this.winLibraryPathHandle(path, fileName);
            path = WizardExport.cutCloudReportNameFlag(book, path);
            book.clearCloudDemoData();
            if (path.endsWith("kdszip")) {
                if (this.checkFileName(path, fileName)) {
                    try (FileOutputStream os = new FileOutputStream(file);){
                        os.write(BookIOUtil.pack(book));
                    }
                }
            } else {
                if (!path.endsWith("kds")) {
                    path = path + ".kds";
                }
                if (this.checkFileName(path, fileName)) {
                    new BookToKds().export(book, path);
                }
            }
            this.lastFilePath = path;
            if (this._ext.getExtCallback().getClass().getName().equals(EXTCALLBACK_NAME)) {
                int index = path.lastIndexOf(File.separatorChar);
                this._ext.setTitle(CtrlEXTMessages.getMLS("lightReportDesigner", "\u8f7b\u62a5\u8868\u62a5\u8868\u8bbe\u8ba1\u5668  -  ") + path.substring(index + 1));
            }
        }
        catch (Exception e) {
            MessageUtil.msgboxWarning((Component)this.fileChooser, CtrlEXTMessages.getMLS("exportBinaryFileException", "\u5bfc\u51fa\u62a5\u8868\u4e8c\u8fdb\u5236\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a") + e);
            return;
        }
    }

    private String winLibraryPathHandle(String absolutePath, String fileName) {
        int index = absolutePath.indexOf("::{031E4825-7B94-4DC3-B131-E946B44C8DD5}\\Documents.library-ms");
        String temp = System.getProperty("user.home") + File.separatorChar;
        if (index >= 0) {
            return temp + "Documents" + File.separatorChar + fileName;
        }
        index = absolutePath.indexOf("::{031E4825-7B94-4DC3-B131-E946B44C8DD5}\\Music.library-ms");
        if (index >= 0) {
            return temp + "Music" + File.separatorChar + fileName;
        }
        index = absolutePath.indexOf("::{031E4825-7B94-4DC3-B131-E946B44C8DD5}\\Pictures.library-ms");
        if (index >= 0) {
            return temp + "Pictures" + File.separatorChar + fileName;
        }
        index = absolutePath.indexOf("::{031E4825-7B94-4DC3-B131-E946B44C8DD5}\\Videos.library-ms");
        if (index >= 0) {
            return temp + "Videos" + File.separatorChar + fileName;
        }
        return absolutePath;
    }

    private boolean checkFileName(String filePath, String fileName) {
        String msg;
        boolean result;
        if (FileUtil.isExist((String)filePath) && !(result = MessageUtil.msgboxOkCancel((Component)((Object)this._ext), msg = CtrlEXTMessages.getMLS("fileOverwriteWarning", "\u6b64\u6587\u4ef6\u5939\u5df2\u7ecf\u5305\u542b\u4e00\u4e2a\u540d\u4e3a\u201c" + fileName + "\u201d\u7684\u6587\u4ef6\uff0c\u662f\u5426\u8986\u76d6\uff1f").replace("#1", fileName)))) {
            this.show();
            return false;
        }
        return true;
    }

    public void setPersistedFilePath(String filePath) {
        this.lastFilePath = filePath;
        if (this._ext.getExtCallback().getClass().getName().equals(EXTCALLBACK_NAME) && !StringUtil.isEmptyString((String)this.lastFilePath)) {
            int index = filePath.lastIndexOf(File.separatorChar);
            this._ext.setTitle(CtrlEXTMessages.getMLS("lightReportDesigner", "\u8f7b\u62a5\u8868\u62a5\u8868\u8bbe\u8ba1\u5668  -  ") + filePath.substring(index + 1));
        } else if (this._ext.getExtCallback().getClass().getName().equals(EXTCALLBACK_NAME)) {
            this._ext.setTitle(CtrlEXTMessages.getMLS("lightweightReportDesigner", "\u8f7b\u62a5\u8868\u62a5\u8868\u8bbe\u8ba1\u5668 "));
        }
    }

    public String getPersistedFilePath() {
        return this.lastFilePath;
    }

    public void saveDirectly() {
        block16: {
            if (!StringUtil.isEmptyString((String)this.lastFilePath)) {
                try {
                    Book book = MiscUtil.getActiveSpreadContext(this._ext).getBook();
                    File file = new File(FilenameUtils.normalize((String)this.lastFilePath));
                    String fileName = file.getName();
                    fileName = WizardExport.cutCloudReportNameFlag(book, fileName);
                    book.setName(fileName.substring(0, fileName.lastIndexOf(46) == -1 ? fileName.length() : fileName.lastIndexOf(46)));
                    if (this.lastFilePath.endsWith("kdszip")) {
                        try (FileOutputStream os = new FileOutputStream(file);){
                            os.write(BookIOUtil.pack(book));
                            break block16;
                        }
                    }
                    new BookToKds().export(book, this.lastFilePath);
                }
                catch (Exception e) {
                    MessageUtil.msgboxWarning((Component)this.fileChooser, CtrlEXTMessages.getMLS("exportReportBinaryException", "\u5bfc\u51fa\u62a5\u8868\u4e8c\u8fdb\u5236\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a") + e);
                    return;
                }
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    public static String cutCloudReportNameFlag(Book book, String name) {
        String[] names;
        Object demoData = book.getUserObjectValue("CLOUD_REPORT_DEMO_BOOK_DATA");
        if (demoData != null && (names = name.split("\uff08CRC_.+_[0-9]{4}(\\$[0-9]{2}){0,2}\uff09(\\.kds)?")) != null && names.length == 1) {
            return names[0];
        }
        return name;
    }
}

