/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.io;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.io.WizardExport;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.read.POIXlsReader;
import com.kingdee.cosmic.ctrl.kdf.read.POIXlsxReader;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSBookToBook;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class WizardImport
implements ISpreadWizzard {
    private static final Logger logger = LogUtil.getPackageLogger(WizardImport.class);
    private KDExt _ext;
    private KDFileChooser fileChooser;
    private boolean _isMobileTemplate;
    private String[] history;
    public static final int HISTORY_LENGTH = 5;
    private boolean logOpenHistory = false;

    public WizardImport(KDExt ext) {
        this._ext = ext;
        this._isMobileTemplate = this._ext.getExtCallback().isMobileTemplate();
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser = new KDFileChooser();
        this.fileChooser.putClientProperty(KDFileChooser.NO_PATH_MESS_ON_JVM6, KDFileChooser.NO_PATH_MESS_ON_JVM6);
        this.fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "kds"));
        this.fileChooser.setFileSelectionMode(0);
        FileFilter[] ff = this.fileChooser.getChoosableFileFilters();
        for (int i = 0; i < ff.length; ++i) {
            this.fileChooser.removeChoosableFileFilter(ff[i]);
        }
        FileFilter kdsFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".kds");
            }

            @Override
            public String getDescription() {
                return CtrlEXTMessages.getMLS("lightReportFile", "\u8f7b\u62a5\u8868\u6587\u4ef6\uff08*.kds\uff09");
            }
        };
        this.fileChooser.addChoosableFileFilter(kdsFilter);
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".xls");
            }

            @Override
            public String getDescription() {
                return CtrlEXTMessages.getMLS("msExcelFileXls", "MS Excel\u6587\u4ef6(*.xls)");
            }
        });
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".xlsx");
            }

            @Override
            public String getDescription() {
                return CtrlEXTMessages.getMLS("msExcelFileXlsx", "MS Excel\u6587\u4ef6(*.xlsx)");
            }
        });
        this.fileChooser.setFileFilter(kdsFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void show() {
        Book book = null;
        int mark = this.fileChooser.showOpenDialog((Component)((Object)this._ext));
        if (mark != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        if (!file.exists()) {
            MessageUtil.msgboxWarning((Component)((Object)this._ext), CtrlEXTMessages.getMLS("importFileNotExist", "\u5bfc\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        if (this.logOpenHistory) {
            this.registerHistory(file.getAbsolutePath());
        }
        if (file.getName().endsWith("xls")) {
            book = this.openSheetListFromXls(file.getPath());
            if (book == null) {
                MessageUtil.msgboxWarning((Component)((Object)this._ext), "xls " + CtrlEXTMessages.getMLS("importFileNotExist", "\u5bfc\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
                return;
            }
            this.setOriginalDefRowHeight(book);
            String fileName = file.getName();
            book.setName(fileName.substring(0, fileName.lastIndexOf(46) == -1 ? fileName.length() : fileName.lastIndexOf(46)));
            this._ext.setBook(book);
        } else if (file.getName().endsWith("xlsx")) {
            book = this.openSheetListFromXlsx(file.getPath());
            if (book == null) {
                MessageUtil.msgboxWarning((Component)((Object)this._ext), "xlsx " + CtrlEXTMessages.getMLS("importFileNotExist", "\u5bfc\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
                return;
            }
            this.setOriginalDefRowHeight(book);
            String fileName = file.getName();
            book.setName(fileName.substring(0, fileName.lastIndexOf(46) == -1 ? fileName.length() : fileName.lastIndexOf(46)));
            this._ext.setBook(book);
        } else {
            FileInputStream fileStream = null;
            try {
                String fileName;
                byte[] data = new byte[(int)file.length()];
                fileStream = new FileInputStream(file);
                fileStream.read(data);
                book = MiscUtil.unpack(data);
                if (this._isMobileTemplate) {
                    this._ext.setDefaultRowColLenght(book, false);
                }
                book.setName(fileName.substring(0, (fileName = file.getName()).lastIndexOf(46) == -1 ? fileName.length() : fileName.lastIndexOf(46)));
                this._ext.setBook(book);
                ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).setPersistedFilePath(file.getPath());
            }
            catch (Exception e) {
                MiscUtil.handleFileCheckingException(e, (Component)((Object)this._ext));
                return;
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private Book openSheetListFromXls(String fileName) {
        KDSBook kdsbook = null;
        try {
            kdsbook = POIXlsReader.parse2((String)fileName);
        }
        catch (FileNotFoundException e) {
            MessageUtil.msgboxWarning((Component)((Object)this._ext), CtrlEXTMessages.getMLS("fileNotFound", "\u6587\u4ef6\u672a\u627e\u5230"), e.getMessage());
            return null;
        }
        catch (IOException e) {
            MessageUtil.msgboxWarning((Component)((Object)this._ext), CtrlEXTMessages.getMLS("fileIOException", "\u6587\u4ef6IO\u5f02\u5e38"), e.getMessage());
            return null;
        }
        if (kdsbook != null) {
            ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).setPersistedFilePath(null);
            return KDSBookToBook.traslate(kdsbook, this._isMobileTemplate);
        }
        MessageUtil.msgboxWarning((Component)((Object)this._ext), CtrlEXTMessages.getMLS("xlsImportFailed", "XLS\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
        return null;
    }

    private Book openSheetListFromXlsx(String fileName) {
        KDSBook kdsbook = null;
        try {
            kdsbook = POIXlsxReader.parse((String)fileName);
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        if (kdsbook != null) {
            ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).setPersistedFilePath(null);
            return KDSBookToBook.traslate(kdsbook, this._isMobileTemplate);
        }
        MessageUtil.msgboxWarning((Component)((Object)this._ext), "XLSX " + CtrlEXTMessages.getMLS("fileImportFailed", "\u6587\u4ef6\u5bfc\u5165\u5931\u8d25!"));
        return null;
    }

    public boolean isLogOpenHistory() {
        return this.logOpenHistory;
    }

    public void setLogOpenHistory(boolean logOpenHistory) {
        this.logOpenHistory = logOpenHistory;
    }

    private void registerHistory(String fileName) {
        if (this.history == null) {
            this.history = new String[1];
            this.history[0] = fileName;
        } else {
            int i;
            if (this.checkName(fileName)) {
                this.resetHistoryList(fileName);
                return;
            }
            String[] temp = this.history;
            if (temp.length < 5) {
                this.history = new String[temp.length + 1];
                for (i = 0; i < temp.length; ++i) {
                    this.history[i + 1] = temp[i];
                }
                this.history[0] = fileName;
            } else {
                this.history = new String[5];
                for (i = 0; i < this.history.length - 1; ++i) {
                    this.history[i + 1] = temp[i];
                }
                this.history[0] = fileName;
            }
        }
        String[] history = this.getUserOpenHistory();
        String configDir = System.getProperty("user.dir");
        if (history != null) {
            try (PrintWriter writer = new PrintWriter(new FileWriter(new File(FilenameUtils.normalize((String)(configDir + File.separator + "OpenHistory.text")))));){
                int l = history.length;
                writer.println(l);
                for (int i = 0; i < l; ++i) {
                    writer.println(history[i]);
                }
                writer.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void resetHistoryList(String fileName) {
        String[] temp = this.history;
        this.history = new String[temp.length];
        int i = 1;
        for (int j = 0; j < temp.length; ++j) {
            if (!fileName.equals(temp[j])) {
                this.history[i] = temp[j];
            } else {
                --i;
            }
            ++i;
        }
        this.history[0] = fileName;
    }

    public String[] getUserOpenHistory() {
        return this.history;
    }

    public void setUserOpenHistory(String[] history) {
        this.history = history;
    }

    public void openFile(String filePath) {
        File file = new File(FilenameUtils.normalize((String)filePath));
        try {
            byte[] data = new byte[(int)file.length()];
            this.resetHistoryList(filePath);
            try (FileInputStream fileStream = new FileInputStream(file);){
                fileStream.read(data);
            }
            Book book = MiscUtil.unpack(data);
            this.setOriginalDefRowHeight(book);
            this._ext.setBook(book);
            ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).setPersistedFilePath(file.getPath());
        }
        catch (Exception e) {
            MessageUtil.msgboxWarning((Component)this.fileChooser, CtrlEXTMessages.getMLS("exportReportBinaryException", "\u5bfc\u51fa\u62a5\u8868\u4e8c\u8fdb\u5236\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a") + e);
            return;
        }
    }

    private boolean checkName(String fileName) {
        boolean flag = false;
        int length = this.history.length;
        for (int i = 0; i < length; ++i) {
            if (!fileName.equals(this.history[i])) continue;
            flag = true;
            break;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openFileByDND(File file) {
        if (this.logOpenHistory) {
            this.registerHistory(file.getAbsolutePath());
        }
        if (file.getName().endsWith("xls")) {
            Book book = this.openSheetListFromXls(file.getPath());
            this._ext.setBook(book);
            if (this._isMobileTemplate) {
                this._ext.setDefaultRowColLenght(book, false);
            }
        } else {
            FileInputStream fileStream = null;
            try {
                byte[] data = new byte[(int)file.length()];
                fileStream = new FileInputStream(file);
                fileStream.read(data);
                Book book = MiscUtil.unpack(data);
                this.setOriginalDefRowHeight(book);
                this._ext.setBook(book);
                ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export, true)).setPersistedFilePath(file.getPath());
            }
            catch (Exception e) {
                MessageUtil.msgboxWarning((Component)this.fileChooser, CtrlEXTMessages.getMLS("exportBinaryFileException", "\u5bfc\u51fa\u62a5\u8868\u4e8c\u8fdb\u5236\u6587\u4ef6\u51fa\u73b0\u5f02\u5e38\uff1a") + e);
                return;
            }
            finally {
                if (fileStream != null) {
                    try {
                        fileStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    private void setOriginalDefRowHeight(Book book) {
        if (this._isMobileTemplate) {
            int sheetCount = book.getSheetCount();
            for (int i = 0; i < sheetCount; ++i) {
                Sheet sheet = book.getSheet(i);
                sheet.setOriginalDefRowHeight(30);
                sheet.setOriginalDefColWidth(79);
            }
            this._ext.setDefaultRowColLenght(book, false);
        }
    }
}

