/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.pic;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class ImagePreview
extends JComponent
implements PropertyChangeListener,
ImageObserver {
    private Image _img = null;
    private static BufferedImage NoImage = null;
    private static Object lock = new Object();
    protected MediaTracker tracker = new MediaTracker(this);
    private static int mediaTrackerID;

    public ImagePreview(JFileChooser fc) {
        this.setPreferredSize(new Dimension(200, 200));
        if (NoImage == null) {
            NoImage = new BufferedImage(200, 200, 2);
            Graphics2D g = (Graphics2D)NoImage.getGraphics();
            g.setColor(Color.gray);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(Color.black);
            g.drawString(CtrlEXTMessages.getMLS("cannotPreview", "\u4e0d\u80fd\u9884\u89c8"), 30, 100);
            g.dispose();
        }
        fc.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this._img = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            File file = (File)e.getNewValue();
            update = true;
            if (file != null) {
                try {
                    this._img = ImageIO.read(file);
                    this.loadEnsured(this._img);
                    if (this._img == null) {
                        this._img = NoImage;
                    }
                }
                catch (IOException e1) {
                    this._img = NoImage;
                }
            }
        }
        if (update) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadEnsured(Image image) {
        Object object = lock;
        synchronized (object) {
            int id = this.getNextID();
            this.tracker.addImage(image, id);
            try {
                this.tracker.waitForID(id, 100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.tracker.removeImage(image, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextID() {
        Object object = lock;
        synchronized (object) {
            return ++mediaTrackerID;
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.gray);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this._img != null) {
            int w = this._img.getWidth(this);
            int h = this._img.getHeight(this);
            int ow = w;
            int oh = h;
            int side = Math.max(w, h);
            double scale = 200.0 / (double)side;
            w = (int)(scale * (double)w);
            h = (int)(scale * (double)h);
            g2d.drawImage(this._img, 0, 0, w, h, this);
            String dim = ow + " x " + oh;
            g2d.setColor(Color.black);
            g2d.drawString(dim, 31, 196);
            g2d.setColor(Color.white);
            g2d.drawString(dim, 30, 195);
        } else {
            g2d.setColor(Color.black);
            g2d.drawString(CtrlEXTMessages.getMLS("notImage", "\u4e0d\u662f\u56fe\u7247"), 30, 100);
        }
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        if ((infoflags & 0x80) != 0) {
            return false;
        }
        if ((infoflags & 0x20) != 0) {
            this.repaint();
            return false;
        }
        if ((infoflags & 0x10) != 0) {
            this.revalidate();
            this.repaint();
        }
        return true;
    }
}

