/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.model;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.StringVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.exception.ValidateException;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.kpi.KPIDefine;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.model.PropellingModel;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Format;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.io.File;
import java.math.BigDecimal;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class IndexDefine
implements Cloneable {
    private static Logger logger = Logger.getLogger(IndexDefine.class);
    private static Font msyhFont;
    private static Font msyhbdFont;
    private int position;
    private Book book;
    private Expr nameFormula;
    private Expr dataFormula;
    private Expr foregroundNameFormula;
    private Expr foregroundValueFormula;
    private Expr backgroundFormula;
    private StringVFPair dataFormat;
    private Rectangle area;
    private Font titleFont = msyhbdFont == null ? new Font(CtrlEXTMessages.getMLS("font", "\u5fae\u8f6f\u96c5\u9ed1"), 0, 29) : msyhbdFont.deriveFont(29.0f);
    private Font valueFont = msyhFont == null ? new Font(CtrlEXTMessages.getMLS("font", "\u5fae\u8f6f\u96c5\u9ed1"), 0, 50) : msyhFont.deriveFont(50.0f);

    public IndexDefine(int position, Rectangle area, Book book) {
        this.position = position;
        this.area = area;
        this.book = book;
    }

    public String getNameFormula() {
        return PropellingModel.getFormula(this.book, this.nameFormula);
    }

    public IndexDefine setNameFormula(String nameFormula) {
        this.nameFormula = PropellingModel.parseFormula(this.book, nameFormula);
        return this;
    }

    public String getDataFormula() {
        return PropellingModel.getFormula(this.book, this.dataFormula);
    }

    public IndexDefine setDataFormula(String dataFormula) {
        this.dataFormula = PropellingModel.parseFormula(this.book, dataFormula);
        return this;
    }

    public String getForegroundNameFormula() {
        return PropellingModel.getFormula(this.book, this.foregroundNameFormula);
    }

    public String getForegroundValueFormula() {
        return PropellingModel.getFormula(this.book, this.foregroundValueFormula);
    }

    public IndexDefine setForegroundNameFormula(String foregroundFormula) {
        this.foregroundNameFormula = PropellingModel.parseFormula(this.book, foregroundFormula);
        return this;
    }

    public IndexDefine setForegroundValueFormula(String foregroundFormula) {
        this.foregroundValueFormula = PropellingModel.parseFormula(this.book, foregroundFormula);
        return this;
    }

    public String getBackgroundFormula() {
        return PropellingModel.getFormula(this.book, this.backgroundFormula);
    }

    public IndexDefine setBackgroundFormula(String backgroundFormula) {
        this.backgroundFormula = PropellingModel.parseFormula(this.book, backgroundFormula);
        return this;
    }

    public StringVFPair getDataFormat() {
        return this.dataFormat;
    }

    public IndexDefine setDataFormat(StringVFPair dataFormat) {
        this.dataFormat = dataFormat;
        return this;
    }

    public int getPosition() {
        return this.position;
    }

    public Rectangle getArea() {
        return this.area;
    }

    public void setArea(Rectangle area) {
        this.area = area;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public IndexDefine setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
        return this;
    }

    public IndexDefine setValueFont(Font valueFont) {
        this.valueFont = valueFont;
        return this;
    }

    Object[] execute() throws SyntaxErrorException {
        Object[] ret = new Object[6];
        ExprContext ctx = this.book.getDeps().getExprContext();
        Cell exprOwner = this.book.getSheet(0).getCell(0, 0, true);
        ret[0] = this.nameFormula.execute(ctx, exprOwner).toString();
        Variant dataV = this.dataFormula.execute(ctx, exprOwner);
        ret[1] = this.formatDataValue(dataV, ctx, exprOwner);
        ret[2] = this.getBlockFormulaColor(this.foregroundNameFormula, PropellingModel.DEFAULT_NAME_FORECOLOR, ctx, exprOwner);
        ret[3] = this.getBlockFormulaColor(this.foregroundValueFormula, PropellingModel.DEFAULT_VALUE_FORECOLOR, ctx, exprOwner);
        ret[4] = this.getBlockFormulaColor(this.backgroundFormula, PropellingModel.DEFAULT_BG_COLOR[this.position], ctx, exprOwner);
        return ret;
    }

    private Color getBlockFormulaColor(Expr expr, Color defaultColor, ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant varColor = expr.execute(ctx, exprOwner);
        if (varColor.isError() || !varColor.isNumeric()) {
            logger.error((Object)(CtrlEXTMessages.getMLS("PageView_CN_DI", "\u7b2c") + (this.position + 1) + "\u4e2a\u8272\u5757\u80cc\u666f\u8272\u6216\u524d\u666f\u8272\u8bbe\u7f6e\u6709\u8bef\uff0c\u5df2\u91c7\u7528\u9ed8\u8ba4\u989c\u8272\u503c\u4ee3\u66ff\uff01"));
            return defaultColor;
        }
        int intColor = varColor.intValue();
        return new Color(intColor >> 16 & 0xFF, intColor >> 8 & 0xFF, intColor >> 0 & 0xFF);
    }

    KPIDefine toKPI() throws SyntaxErrorException {
        ExprContext ctx = this.book.getDeps().getExprContext();
        Cell exprOwner = this.book.getSheet(0).getCell(0, 0, true);
        return new KPIDefine(this.nameFormula.execute(ctx, exprOwner).toString(), this.dataFormula.execute(ctx, exprOwner).toString(), this.dataFormat.getStringValue());
    }

    private String formatDataValue(Variant dataValue, ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        while (dataValue != null && dataValue.isReferences()) {
            dataValue = dataValue.getVariant();
        }
        if (dataValue == null) {
            return ExprErr.getString(524288L);
        }
        if (dataValue.isError()) {
            return ExprErr.getString(1L);
        }
        if (dataValue.isNull() || !dataValue.isNumeric()) {
            return dataValue.toString();
        }
        BigDecimal value = dataValue.toBigDecimal();
        if (this.dataFormat != null) {
            String pattern = null;
            if (!StringUtil.isEmptyString((String)this.dataFormat.getStringValue())) {
                pattern = this.dataFormat.getStringValue();
            } else if (!StringUtil.isEmptyString((String)this.dataFormat.getFormula())) {
                Variant v = PropellingModel.parseFormula(this.book, this.dataFormat.getFormula()).execute(ctx, exprOwner);
                if (v == null || v.isError()) {
                    logger.error((Object)(CtrlEXTMessages.getMLS("PageView_CN_DI", "\u7b2c") + (this.position + 1) + "\u4e2a\u8272\u5757\u6570\u5b57\u683c\u5f0f\u516c\u5f0f\u8bbe\u7f6e\u6709\u8bef\uff0c\u5df2\u91c7\u7528\u9ed8\u8ba4\u683c\u5f0f\u4ee3\u66ff\uff01"));
                    pattern = PropellingModel.getDefaultDataFormat();
                } else {
                    pattern = v.getValue().toString();
                }
            }
            Format formatObj = this.book.getFormat(pattern);
            if (formatObj != null) {
                Variant v = new Variant(value, 10);
                FormatResult fr = formatObj.format(v, true);
                return fr.getText();
            }
        }
        return dataValue.toString();
    }

    public void validate() throws ValidateException {
        if (this.nameFormula == null) {
            throw new ValidateException(7, CtrlEXTMessages.getMLS("indexNameFormulaNotSet", "\u6307\u6807\u540d\u79f0\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"), this.position);
        }
        if (this.dataFormula == null) {
            throw new ValidateException(9, CtrlEXTMessages.getMLS("indexValueFormulaNotSet", "\u6307\u6807\u503c\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"), this.position);
        }
        if (this.foregroundNameFormula == null) {
            throw new ValidateException(11, CtrlEXTMessages.getMLS("indexNameForegroundColorFormulaNotSet", "\u6307\u6807\u540d\u79f0\u524d\u666f\u8272\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"), this.position);
        }
        if (this.foregroundValueFormula == null) {
            throw new ValidateException(11, CtrlEXTMessages.getMLS("indexValueForegroundColorFormulaNotSet", "\u6307\u6807\u503c\u524d\u666f\u8272\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"), this.position);
        }
        if (this.backgroundFormula == null) {
            throw new ValidateException(13, CtrlEXTMessages.getMLS("indexBackgroundColorFormulaNotSet", "\u6307\u6807\u80cc\u666f\u8272\u516c\u5f0f\u672a\u8bbe\u7f6e\uff01"), this.position);
        }
        if (this.nameFormula.isSyntaxError()) {
            throw new ValidateException(8, CtrlEXTMessages.getMLS("indexNameFormulaValidationFailed", "\u6307\u6807\u540d\u79f0\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"), this.position);
        }
        if (this.dataFormula.isSyntaxError()) {
            throw new ValidateException(10, CtrlEXTMessages.getMLS("indexValueFormulaValidationFailed", "\u6307\u6807\u503c\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"), this.position);
        }
        if (this.foregroundNameFormula.isSyntaxError()) {
            throw new ValidateException(12, CtrlEXTMessages.getMLS("indexNameForegroundColorFormulaValidationFailed", "\u6307\u6807\u540d\u79f0\u524d\u666f\u8272\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"), this.position);
        }
        if (this.foregroundValueFormula.isSyntaxError()) {
            throw new ValidateException(12, CtrlEXTMessages.getMLS("indexValueForegroundColorFormulaValidationFailed", "\u6307\u6807\u503c\u524d\u666f\u8272\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"), this.position);
        }
        if (this.backgroundFormula.isSyntaxError()) {
            throw new ValidateException(14, CtrlEXTMessages.getMLS("indexBackgroundColorFormulaValidationFailed", "\u6307\u6807\u80cc\u666f\u8272\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"), this.position);
        }
        if (!StringUtil.isEmptyString((String)this.dataFormat.getFormula()) && PropellingModel.parseFormula(this.book, this.dataFormat.getFormula()).isSyntaxError()) {
            throw new ValidateException(14, CtrlEXTMessages.getMLS("dataFormatFormulaValidationFailed", "\u6570\u636e\u683c\u5f0f\u516c\u5f0f\u6821\u9a8c\u5931\u8d25\uff01"), this.position);
        }
    }

    public IndexDefine clone() {
        IndexDefine ret = new IndexDefine(this.position, this.area, this.book);
        ret.backgroundFormula = this.backgroundFormula;
        ret.dataFormula = this.dataFormula;
        ret.foregroundNameFormula = this.foregroundNameFormula;
        ret.foregroundValueFormula = this.foregroundValueFormula;
        ret.dataFormat = this.dataFormat;
        ret.nameFormula = this.nameFormula;
        return ret;
    }

    static {
        String ctrlHome = System.getProperty("ctrlhome");
        String msyhFileName = ctrlHome + File.separator + "msyh.ttf";
        String msyhbdFileName = ctrlHome + File.separator + "msyhbd.ttf";
        try {
            msyhFont = Font.createFont(0, new File(FilenameUtils.normalize((String)msyhFileName)));
            msyhbdFont = Font.createFont(0, new File(FilenameUtils.normalize((String)msyhbdFileName)));
        }
        catch (Throwable e) {
            logger.error((Object)"failed to create font", e);
        }
    }
}

