/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.report;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupColorChooser;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupReportColumnFilter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ReportComposerWizard;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDTree;
import com.kingdee.cosmic.ctrl.swing.KDTreeView;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.plaf.KingdeeTreeUI;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.cosmic.ctrl.swing.tree.KingdeeTreeModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;

public class GroupReportComposer
extends KDPanel
implements IReportComposer,
IWizardStep {
    public static final String KEY_TOTAL_GROUP = "totalGroup";
    public static final String KEY_GROUP_TYPE = "groupType";
    public static final String KEY_STATISTIC = "statistic";
    public static final String KEY_TOTAL = "total";
    public static final String KEY_GROUP = "group";
    public static final String KEY_LABEL_CREATE = "createGroupReportAndFields";
    public static final String KEY_STAT = "stat";
    public static final String KEY_REMOVE = "remove";
    public static final String KEY_AVAILABLE_FIELDS = "availableFields";
    public static final String KEY_GROUP_AND_STAT = "groupAndStat";
    public static final String KEY_TO_STAT_OF = "toStatOf";
    public static final String KEY_SUM = "sum";
    public static final String KEY_AVG = "avg";
    public static final String KEY_MAX = "max";
    public static final String KEY_MIN = "min";
    public static final String KEY_CNT = "cnt";
    public static final String KEY_STAT_PROP = "statProp";
    public static final String KEY_STAT_TYPE = "statType";
    public static final String KEY_OK = "ok";
    public static final String KEY_CANCEL = "cancel";
    private KDWorkButton up;
    private KDWorkButton down;
    private KDWorkButton modify;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private KDList leftList;
    private KDTreeView treeView;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private KDWorkButton addGroup;
    private KDWorkButton addStat;
    private KDWorkButton remove;
    private KDExt _ext;
    private IWizardStep next;
    private FormulaTypeDialog formulaTypeDialog;
    private GroupReportColumnFilter prev;
    private ExtDataSet currentDs;
    public int[] mergeScopes;
    public KDTree tree;
    public List addedFields;
    public List groupFields = new ArrayList();
    public DefaultKingdeeTreeNode sumNode = new DefaultKingdeeTreeNode(GroupReportComposer.getLocalText("totalGroup", "\u5206\u7ec4\uff1a\u603b\u8ba1")){

        public boolean isLeaf() {
            return false;
        }
    };
    public DefaultKingdeeTreeNode sum;

    public static String getLocalText(String key, String defaultStr) {
        return CtrlEXTMessages.getMLS(key, defaultStr);
    }

    public GroupReportComposer(KDExt ext) {
        this._ext = ext;
        this.initComponents();
        this.initListeners();
    }

    public void addNotify() {
        super.addNotify();
        if (this.formulaTypeDialog == null) {
            this.formulaTypeDialog = new FormulaTypeDialog((KDDialog)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    @Override
    public boolean prepare() {
        this.sum = null;
        this.leftList.removeAllElements();
        DatasetImporter importer = (DatasetImporter)this.getPrevStep().getPrevStep();
        List list = importer.getAllExtDataSets();
        List selected = importer.getSelectedExtDataSets();
        if (list.size() == 0) {
            ((DefaultKingdeeTreeNode)this.tree.getModel().getRoot()).removeAllChildren();
            return true;
        }
        ExtDataSet ds = (ExtDataSet)selected.get(0);
        this.addedFields = this.prev.getListFields();
        this.groupFields.clear();
        Iterator iterator = this.addedFields.iterator();
        while (iterator.hasNext()) {
            this.leftList.addElement(iterator.next());
        }
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        if (this.currentDs != ds) {
            this.tree.removeAllChildrenFromParent((MutableTreeNode)root);
            this.sumNode.removeAllChildren();
            this.tree.addNodeInto((MutableTreeNode)this.sumNode, (MutableTreeNode)root);
            this.tree.expandAllNodes(true, (TreeNode)this.sumNode);
        } else {
            this.fieldValidAssured(root);
            int size = this.groupFields.size();
            for (int i = 0; i < size; ++i) {
                this.leftList.removeElement(this.groupFields.get(i));
            }
        }
        if (this.sumNode.getParent() == null) {
            this.sumNode.removeAllChildren();
            this.tree.addNodeInto((MutableTreeNode)this.sumNode, (MutableTreeNode)root);
            this.tree.expandAllNodes(true, (TreeNode)this.sumNode);
        }
        this.tree.setSelectionNode(this.sumNode);
        this.currentDs = ds;
        this.leftList.setSelectedIndex(0);
        return true;
    }

    @Override
    public IWizardStep getNextStep() {
        if (this.next == null) {
            this.next = (GroupColorChooser)((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getGroupColorChooser();
        }
        return this.next;
    }

    @Override
    public IWizardStep getPrevStep() {
        if (this.prev == null) {
            this.prev = (GroupReportColumnFilter)((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getComposeStepOneByType();
        }
        return this.prev;
    }

    private void fieldValidAssured(DefaultKingdeeTreeNode parent) {
        if (!parent.isLeaf()) {
            for (int i = parent.getChildCount() - 1; i >= 0; --i) {
                DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)parent.getChildAt(i);
                Object o = node.getUserObject();
                if (o instanceof String) {
                    this.fieldValidAssured(node);
                    continue;
                }
                if (this.leftList.getIndexOfElement(o) == -1) {
                    this.tree.removeNodeFromParent((MutableTreeNode)node);
                    continue;
                }
                Object obj = node.getUserObject();
                if (obj instanceof BinaryElement) {
                    this.groupFields.add(obj);
                }
                this.fieldValidAssured(node);
            }
        }
    }

    @Override
    public void compose() {
        Cell cell;
        Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
        DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
        int count = root.getChildCount();
        if (count == 1 && ((DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject() instanceof String) {
            return;
        }
        if (this.addedFields == null) {
            return;
        }
        this.addedFields.removeAll(this.groupFields);
        StyleAttributes titleSa = Styles.getEmptySA();
        titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        titleSa.setFontSize(10);
        titleSa.setBold(true);
        StyleAttributes sumTitle = Styles.getEmptySA();
        sumTitle.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        sumTitle.setFontSize(10);
        sumTitle.setFontColor(Color.MAGENTA);
        StyleAttributes detailsSa = Styles.getEmptySA();
        detailsSa.setFontSize(10);
        boolean hasSumRow = false;
        if (this.sumNode.getParent() != null) {
            --count;
            hasSumRow = true;
        }
        boolean leadingComposed = false;
        int integer = count;
        for (BinaryElement tele : this.addedFields) {
            if (!leadingComposed) {
                cell = sheet.getCell(0, integer, true);
                cell.setFormula(tele.getColName());
                cell.setSSA((ShareStyleAttributes)titleSa);
                cell = sheet.getCell(1, integer, true);
                cell.setFormula(this.buildFormula(new String[]{"=select(", this.currentDs.getAlias(), " , ", tele.getColName(), ")"}));
                cell.setSSA((ShareStyleAttributes)detailsSa);
                leadingComposed = true;
            } else {
                cell = sheet.getCell(0, integer, true);
                cell.setFormula(tele.getColName());
                cell.setSSA((ShareStyleAttributes)titleSa);
                cell = sheet.getCell(1, integer, true);
                cell.setFormula(this.buildFormula(new String[]{"=field(", this.currentDs.getAlias(), " , ", tele.getColName(), ")"}));
                cell.setSSA((ShareStyleAttributes)detailsSa);
            }
            ++integer;
        }
        this.mergeScopes = new int[count];
        integer = 0;
        for (int i = count - 1; i >= 0; --i) {
            Cell c;
            String ref;
            DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
            boolean hasSubTotal = this.hasSumRow(subNode);
            this.mergeScopes[i] = ++integer;
            BinaryElement be = (BinaryElement)subNode.getUserObject();
            Cell cell2 = sheet.getCell(0, i, true);
            cell2.setFormula(GroupReportComposer.getLocalText(KEY_GROUP_TYPE, "\u7ec4\u522b ") + be.getColName());
            cell2.setSSA((ShareStyleAttributes)titleSa);
            cell2 = sheet.getCell(1, i, true);
            cell2.setFormula(this.buildFormula(new String[]{"=group(", this.currentDs.getAlias(), " , ", be.getColName(), " , false)"}));
            cell2.setSSA((ShareStyleAttributes)titleSa);
            if (!hasSubTotal) continue;
            if (i == count - 1) {
                ref = sheet.getCell(1, i, true).getName(false, false);
                c = sheet.getCell(integer + 1, i, true);
                c.setFormula(this.buildFormula(new String[]{"=disp(", ref, ") & \" ", GroupReportComposer.getLocalText(KEY_STATISTIC, CtrlEXTMessages.getMLS(KEY_STATISTIC, "\u7edf\u8ba1")), ":\""}));
                c.getExtProps(true).setHead(ref, true);
                c.setSSA((ShareStyleAttributes)sumTitle);
            } else {
                ref = sheet.getCell(1, i, true).getName(false, false);
                c = sheet.getCell(integer + 1, i + 1, true);
                c.setFormula(this.buildFormula(new String[]{"=disp(", ref, ") & \" ", GroupReportComposer.getLocalText(KEY_STATISTIC, CtrlEXTMessages.getMLS(KEY_STATISTIC, "\u7edf\u8ba1")), ":\""}));
                c.setSSA((ShareStyleAttributes)sumTitle);
            }
            int temp = 0;
            for (BinaryElement tele : this.addedFields) {
                for (int m = 0; m < subNode.getChildCount(); ++m) {
                    TrinityElement te = (TrinityElement)((DefaultKingdeeTreeNode)subNode.getChildAt(m)).getUserObject();
                    if (!te.equals(tele)) continue;
                    int col = count + temp;
                    String ref2 = sheet.getCell(1, col, true).getName(false, false);
                    Cell c2 = sheet.getCell(integer + 1, col, true);
                    c2.setFormula(this.buildFormula(new String[]{"=", te.getFormulaNameByMode(), "(exs(", ref2, "))"}));
                    detailsSa.setNumberFormat(te.getI18nModeName() + "\\: 0.00;" + te.getI18nModeName() + "\\: -0.00");
                    c2.setSSA((ShareStyleAttributes)detailsSa);
                }
                ++temp;
            }
        }
        for (int j = 0; j < this.mergeScopes.length - 1; ++j) {
            sheet.getMerger(true).insert(CellBlock.getCellBlock(1, j, this.mergeScopes[j] + 1, j));
        }
        if (hasSumRow) {
            int sumRowID = this.mergeScopes[0] + 2;
            cell = sheet.getCell(sumRowID, 0, true);
            cell.setFormula(GroupReportComposer.getLocalText(KEY_TOTAL, "\u603b\u8ba1\uff1a"));
            cell.setSSA((ShareStyleAttributes)titleSa);
            int temp = 0;
            for (BinaryElement tele : this.addedFields) {
                for (int m = 0; m < this.sumNode.getChildCount(); ++m) {
                    TrinityElement te = (TrinityElement)((DefaultKingdeeTreeNode)this.sumNode.getChildAt(m)).getUserObject();
                    if (!te.equals(tele)) continue;
                    int col = count + temp;
                    String ref = sheet.getCell(1, col, true).getName(false, false);
                    Cell c = sheet.getCell(sumRowID, col, true);
                    c.setFormula(this.buildFormula(new String[]{"=", te.getFormulaNameByMode(), "(exs(", ref, "))"}));
                    detailsSa.setNumberFormat(te.getI18nModeName() + "\\: 0.00;" + te.getI18nModeName() + "\\: -0.00");
                    c.setSSA((ShareStyleAttributes)detailsSa);
                }
                ++temp;
            }
        }
        MiscUtil.getActiveSpreadContext(this._ext).repaint();
    }

    private String buildFormula(String[] ele) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ele.length; ++i) {
            sb.append(ele[i]);
        }
        return sb.toString();
    }

    private boolean hasSumRow(DefaultKingdeeTreeNode node) {
        int count = node.getChildCount();
        return count != 0;
    }

    private void initListeners() {
        this.tree.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && ((DefaultKingdeeTreeNode)GroupReportComposer.this.tree.getSelectionPath().getLastPathComponent()).isLeaf()) {
                    GroupReportComposer.this.modify.doClick();
                }
            }
        });
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = GroupReportComposer.this.tree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (node == GroupReportComposer.this.sumNode) {
                        return;
                    }
                    DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
                    int index = parent.getIndex((TreeNode)node) - 1;
                    GroupReportComposer.this.tree.removeNodeFromParent((MutableTreeNode)node);
                    if (index < 0) {
                        if (GroupReportComposer.this.sumNode.getParent() != null && node.getUserObject() instanceof BinaryElement) {
                            GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, parent.getChildCount() - 1);
                        } else {
                            GroupReportComposer.this.tree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)parent);
                        }
                    } else {
                        GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, index);
                    }
                    GroupReportComposer.this.tree.setSelectionNode(node);
                    GroupReportComposer.this.tree.expandAllNodes(true, (TreeNode)node);
                }
            }
        });
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = GroupReportComposer.this.tree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
                    if (node == GroupReportComposer.this.sumNode) {
                        return;
                    }
                    DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)node.getParent();
                    if (parent.getChildCount() == 1) {
                        return;
                    }
                    int index = parent.getIndex((TreeNode)node) + 1;
                    GroupReportComposer.this.tree.removeNodeFromParent((MutableTreeNode)node);
                    if (node.getUserObject() instanceof BinaryElement) {
                        if (GroupReportComposer.this.sumNode.getParent() != null && index == parent.getChildCount()) {
                            GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, 0);
                        } else {
                            GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, index);
                        }
                    } else if (index == parent.getChildCount() + 1) {
                        GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, 0);
                    } else {
                        GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parent, index);
                    }
                    GroupReportComposer.this.tree.setSelectionNode(node);
                    GroupReportComposer.this.tree.expandAllNodes(true, (TreeNode)node);
                }
            }
        });
        this.modify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultKingdeeTreeNode target;
                Object obj;
                TreePath treepath = GroupReportComposer.this.tree.getSelectionPath();
                if (treepath != null && (obj = (target = (DefaultKingdeeTreeNode)treepath.getLastPathComponent()).getUserObject()) instanceof TrinityElement) {
                    TrinityElement te = (TrinityElement)obj;
                    GroupReportComposer.this.formulaTypeDialog.setTrinityElement(te);
                    GroupReportComposer.this.formulaTypeDialog.setLocationRelativeTo(null);
                    GroupReportComposer.this.formulaTypeDialog.setVisible(true);
                    target.setText(te.toString());
                    ((KingdeeTreeUI)GroupReportComposer.this.tree.getUI()).redoLayout();
                    GroupReportComposer.this.tree.repaint();
                }
            }
        });
        this.addStat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryElement be = (BinaryElement)GroupReportComposer.this.leftList.getSelectedValue();
                if (be != null) {
                    TreePath path = GroupReportComposer.this.tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    TrinityElement te = new TrinityElement(be.getAlias(), be.getColName());
                    DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode((Object)te);
                    DefaultKingdeeTreeNode parent = (DefaultKingdeeTreeNode)path.getPathComponent(1);
                    for (int i = 0; i < parent.getChildCount(); ++i) {
                        if (!node.getUserObject().equals(((DefaultKingdeeTreeNode)parent.getChildAt(i)).getUserObject())) continue;
                        return;
                    }
                    node.setAllowsChildren(false);
                    GroupReportComposer.this.tree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)parent);
                    GroupReportComposer.this.tree.setSelectionNode(node);
                }
            }
        });
        this.addGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BinaryElement be = (BinaryElement)GroupReportComposer.this.leftList.getSelectedValue();
                if (be != null) {
                    DefaultKingdeeTreeNode node = new DefaultKingdeeTreeNode(new BinaryElement(GroupReportComposer.this.buildFormula(new String[]{GroupReportComposer.getLocalText(GroupReportComposer.KEY_GROUP, "\u5206\u7ec4"), "\uff1a", be.getAlias()}), be.getColName())){

                        public boolean isLeaf() {
                            return false;
                        }
                    };
                    DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)GroupReportComposer.this.tree.getModel().getRoot();
                    for (int i = 0; i < root.getChildCount(); ++i) {
                        if (!node.getUserObject().equals(((DefaultKingdeeTreeNode)root.getChildAt(i)).getUserObject())) continue;
                        return;
                    }
                    TreePath path = GroupReportComposer.this.tree.getSelectionPath();
                    if (path != null) {
                        DefaultKingdeeTreeNode selected = (DefaultKingdeeTreeNode)path.getPathComponent(1);
                        if (selected != GroupReportComposer.this.sumNode) {
                            int index = root.getIndex((TreeNode)selected) + 1;
                            GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)root, index);
                        } else {
                            int index = root.getChildCount() > 0 ? root.getChildCount() - 1 : 0;
                            GroupReportComposer.this.tree.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)root, index);
                        }
                    } else {
                        GroupReportComposer.this.tree.addNodeInto((MutableTreeNode)node, (MutableTreeNode)root);
                    }
                    GroupReportComposer.this.tree.expandAllNodes(true, (TreeNode)node);
                    GroupReportComposer.this.tree.setSelectionNode(node);
                    GroupReportComposer.this.groupFields.add(be);
                    int index = GroupReportComposer.this.leftList.getSelectedIndex();
                    GroupReportComposer.this.leftList.removeElement((Object)be);
                    if (index >= GroupReportComposer.this.leftList.getElementCount()) {
                        GroupReportComposer.this.leftList.setSelectedIndex(index - 1);
                    } else {
                        GroupReportComposer.this.leftList.setSelectedIndex(index);
                    }
                }
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = GroupReportComposer.this.tree.getSelectionPath();
                if (path != null) {
                    DefaultKingdeeTreeNode target;
                    Object obj;
                    int lastRow = GroupReportComposer.this.tree.getSelectionRows()[0] - 1;
                    if (lastRow < 0) {
                        lastRow = 0;
                    }
                    if ((obj = (target = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) instanceof BinaryElement) {
                        GroupReportComposer.this.groupFields.remove(obj);
                        GroupReportComposer.this.leftList.addElement((Object)new BinaryElement(((BinaryElement)obj).getAlias().substring(3), ((BinaryElement)obj).getColName()));
                        GroupReportComposer.this.leftList.setSelectedIndex(GroupReportComposer.this.leftList.getElementCount() - 1);
                    }
                    GroupReportComposer.this.tree.removeNodeFromParent((MutableTreeNode)target);
                    GroupReportComposer.this.tree.setSelectionRow(lastRow);
                    if (target.getUserObject() instanceof String) {
                        GroupReportComposer.this.sum = target;
                    }
                }
            }
        });
    }

    private void initComponents() {
        this.addGroup = new KDWorkButton();
        this.addStat = new KDWorkButton();
        this.remove = new KDWorkButton();
        this.addGroup.setFocusable(false);
        this.addStat.setFocusable(false);
        this.remove.setFocusable(false);
        this.addGroup.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_right.gif"));
        this.addStat.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_right.gif"));
        this.remove.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_left.gif"));
        this.up = new KDWorkButton();
        this.down = new KDWorkButton();
        this.modify = new KDWorkButton();
        this.up.setFocusable(false);
        this.down.setFocusable(false);
        this.modify.setFocusable(false);
        this.up.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveup.gif"));
        this.down.setIcon((Icon)ResourceManager.getImageIcon("tbtn_movedown.gif"));
        this.modify.setIcon((Icon)ResourceManager.getImageIcon("tbtn_edit.gif"));
        this.jSeparator1 = new JSeparator();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.leftList = new KDList();
        this.leftList.getSelectionModel().setSelectionMode(0);
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.treeView = new KDTreeView();
        this.treeView.setShowButton(false);
        DefaultKingdeeTreeNode root = new DefaultKingdeeTreeNode((Object)"root");
        this.tree = new KDTree((TreeModel)new KingdeeTreeModel((TreeNode)root, true), false);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.treeView.setTree(this.tree);
        this.jLabel1.setText(GroupReportComposer.getLocalText(KEY_LABEL_CREATE, "\u5efa\u7acb\u5206\u7ec4\u6c47\u603b\u62a5\u8868 - \uff082\uff09\u9009\u62e9\u5206\u7ec4\u4f9d\u636e\u4ee5\u53ca\u6c47\u603b\u5b57\u6bb5"));
        this.jScrollPane1.setViewportView((Component)this.leftList);
        this.addStat.setText(GroupReportComposer.getLocalText(KEY_STAT, "\u6c47\u603b"));
        this.addGroup.setText(GroupReportComposer.getLocalText(KEY_GROUP, "\u5206\u7ec4"));
        this.remove.setText(GroupReportComposer.getLocalText(KEY_REMOVE, "\u79fb\u9664"));
        this.jLabel2.setText(GroupReportComposer.getLocalText(KEY_AVAILABLE_FIELDS, "\u53ef\u9009\u5b57\u6bb5"));
        this.jLabel3.setText(GroupReportComposer.getLocalText(KEY_GROUP_AND_STAT, "\u5206\u7ec4\u6c47\u603b"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel2, -2, 140, -2).add((Component)this.jScrollPane1, -2, 319, -2)).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.addStat, -1, 64, Short.MAX_VALUE).add((Component)this.addGroup, -1, -1, Short.MAX_VALUE).add((Component)this.remove)).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(13, 13, 13).add((Component)this.jLabel3).addPreferredGap(0, 180, Short.MAX_VALUE).add((Component)this.up, -2, 30, -2).addPreferredGap(0).add((Component)this.down, -2, 30, -2).addPreferredGap(0).add((Component)this.modify, -2, 30, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(18, 18, 18).add((Component)this.treeView, -1, 313, Short.MAX_VALUE)))).add((Component)this.jSeparator1, -1, 732, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 15, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(148, 148, 148).add((Component)this.addGroup).addPreferredGap(0).add((Component)this.addStat).add(121, 121, 121).add((Component)this.remove, -2, 23, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.up, -2, 21, -2).add((Component)this.down, -2, 21, -2).add((Component)this.modify, -2, 21, -2)).addPreferredGap(0).add((Component)this.treeView, -2, 438, -2)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 442, -2))))).addContainerGap(138, Short.MAX_VALUE)));
    }

    @Override
    public boolean checkValid() {
        if (this.groupFields.size() > 0) {
            return true;
        }
        MessageUtil.msgboxInfo((Component)((Object)this), CtrlEXTMessages.getMLS("atLeastSelectOneGroupField", "\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u5206\u7ec4\u5b57\u6bb5!"));
        return false;
    }

    public void compose(boolean mergeORnot) {
        if (mergeORnot) {
            this.compose();
        } else {
            Cell cell;
            Sheet sheet = MiscUtil.getActiveSpreadContext(this._ext).getBook().getActiveSheet();
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)this.tree.getModel().getRoot();
            int count = root.getChildCount();
            if (count == 1 && ((DefaultKingdeeTreeNode)root.getChildAt(0)).getUserObject() instanceof String) {
                return;
            }
            if (this.addedFields == null) {
                return;
            }
            this.addedFields.removeAll(this.groupFields);
            StyleAttributes titleSa = Styles.getEmptySA();
            titleSa.setFontSize(10);
            titleSa.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            titleSa.setBold(true);
            StyleAttributes sumTitle = Styles.getEmptySA();
            sumTitle.setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
            sumTitle.setFontColor(Color.MAGENTA);
            StyleAttributes detailsSa = Styles.getEmptySA();
            detailsSa.setFontColor(new Color(Integer.parseInt("357692", 16)));
            detailsSa.setFontSize(10);
            boolean hasSumRow = false;
            if (this.sumNode.getParent() != null) {
                --count;
                hasSumRow = true;
            }
            boolean leadingComposed = false;
            int integer = count;
            for (BinaryElement tele : this.addedFields) {
                if (!leadingComposed) {
                    cell = sheet.getCell(0, integer, true);
                    cell.setFormula(tele.getColName());
                    cell.setSSA((ShareStyleAttributes)titleSa);
                    cell = sheet.getCell(1, integer, true);
                    cell.setFormula(this.buildFormula(new String[]{"=select(", this.currentDs.getAlias(), " , ", tele.getColName(), ")"}));
                    cell.setSSA((ShareStyleAttributes)detailsSa);
                    leadingComposed = true;
                } else {
                    cell = sheet.getCell(0, integer, true);
                    cell.setFormula(tele.getColName());
                    cell.setSSA((ShareStyleAttributes)titleSa);
                    cell = sheet.getCell(1, integer, true);
                    cell.setFormula(this.buildFormula(new String[]{"=field(", this.currentDs.getAlias(), " , ", tele.getColName(), ")"}));
                    cell.setSSA((ShareStyleAttributes)detailsSa);
                }
                ++integer;
            }
            this.mergeScopes = new int[count];
            integer = 0;
            for (int i = count - 1; i >= 0; --i) {
                DefaultKingdeeTreeNode subNode = (DefaultKingdeeTreeNode)root.getChildAt(i);
                boolean hasSubTotal = this.hasSumRow(subNode);
                this.mergeScopes[i] = ++integer;
                BinaryElement be = (BinaryElement)subNode.getUserObject();
                Cell cell2 = sheet.getCell(0, i, true);
                cell2.setFormula(GroupReportComposer.getLocalText(KEY_GROUP_TYPE, "\u7ec4\u522b ") + be.getColName());
                cell2.setSSA((ShareStyleAttributes)titleSa);
                cell2 = sheet.getCell(1, i, true);
                cell2.setFormula(this.buildFormula(new String[]{"=group(", this.currentDs.getAlias(), " , ", be.getColName(), " , false)"}));
                cell2.setSSA((ShareStyleAttributes)titleSa);
                if (!hasSubTotal) continue;
                int temp = 0;
                for (BinaryElement tele : this.addedFields) {
                    for (int m = 0; m < subNode.getChildCount(); ++m) {
                        TrinityElement te = (TrinityElement)((DefaultKingdeeTreeNode)subNode.getChildAt(m)).getUserObject();
                        if (!te.equals(tele)) continue;
                        int col = count + temp;
                        String ref = sheet.getCell(1, col, true).getName(false, false);
                        Cell c = sheet.getCell(integer + 1, col, true);
                        c.setFormula(this.buildFormula(new String[]{"=", te.getFormulaNameByMode(), "(exs(", ref, "))"}));
                        detailsSa.setNumberFormat(te.getI18nModeName() + "\\: 0.00;" + te.getI18nModeName() + "\\: -0.00");
                        c.setSSA((ShareStyleAttributes)detailsSa);
                    }
                    ++temp;
                }
            }
            titleSa.setFontColor(new Color(229, 113, 9));
            if (hasSumRow) {
                int sumRowID = this.mergeScopes[0] + 2;
                cell = sheet.getCell(sumRowID, 0, true);
                cell.setFormula(GroupReportComposer.getLocalText(KEY_TOTAL, "\u603b\u8ba1\uff1a"));
                cell.setSSA((ShareStyleAttributes)titleSa);
                int temp = 0;
                for (BinaryElement tele : this.addedFields) {
                    for (int m = 0; m < this.sumNode.getChildCount(); ++m) {
                        TrinityElement te = (TrinityElement)((DefaultKingdeeTreeNode)this.sumNode.getChildAt(m)).getUserObject();
                        if (!te.equals(tele)) continue;
                        int col = count + temp;
                        String ref = sheet.getCell(1, col, true).getName(false, false);
                        Cell c = sheet.getCell(sumRowID, col, true);
                        c.setFormula(this.buildFormula(new String[]{"=", te.getFormulaNameByMode(), "(exs(", ref, "))"}));
                        detailsSa.setNumberFormat(te.getI18nModeName() + "\\: 0.00;" + te.getI18nModeName() + "\\: -0.00");
                        c.setSSA((ShareStyleAttributes)detailsSa);
                    }
                    ++temp;
                }
            }
            MiscUtil.getActiveSpreadContext(this._ext).repaint();
        }
    }

    public int getFieldsCount() {
        return this.addedFields.size();
    }

    private static class FormulaTypeDialog
    extends KDDialog {
        private KDButton ok;
        private KDButton cancel;
        private KDPanel jPanel1;
        private KDRadioButton jRadioButton1;
        private KDRadioButton jRadioButton2;
        private KDRadioButton jRadioButton3;
        private KDRadioButton jRadioButton4;
        private KDRadioButton jRadioButton5;
        private ButtonGroup btnGroup;
        private TrinityElement trinityElement;

        FormulaTypeDialog(KDDialog parent) {
            super((Dialog)parent);
            this.initComponents();
            this.initListeners();
            this.setModal(true);
            this.setTitle(GroupReportComposer.getLocalText(GroupReportComposer.KEY_STAT_PROP, "\u6c47\u603b\u5b57\u6bb5\u5c5e\u6027"));
            this.setSize(200, 300);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
        }

        private void initListeners() {
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ButtonModel model = btnGroup.getSelection();
                    if (model == jRadioButton1.getModel()) {
                        trinityElement.setMode(0);
                    } else if (model == jRadioButton2.getModel()) {
                        trinityElement.setMode(1);
                    } else if (model == jRadioButton3.getModel()) {
                        trinityElement.setMode(2);
                    } else if (model == jRadioButton4.getModel()) {
                        trinityElement.setMode(3);
                    } else if (model == jRadioButton5.getModel()) {
                        trinityElement.setMode(4);
                    }
                    this.setVisible(false);
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.setVisible(false);
                }
            });
        }

        private void setTrinityElement(TrinityElement trinityElement) {
            this.trinityElement = trinityElement;
            int mode = trinityElement.getMode();
            switch (mode) {
                case 0: {
                    this.jRadioButton1.setSelected(true);
                    break;
                }
                case 1: {
                    this.jRadioButton2.setSelected(true);
                    break;
                }
                case 2: {
                    this.jRadioButton3.setSelected(true);
                    break;
                }
                case 3: {
                    this.jRadioButton4.setSelected(true);
                    break;
                }
                case 4: {
                    this.jRadioButton5.setSelected(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unsupported STAT argument");
                }
            }
        }

        private void initComponents() {
            this.jPanel1 = new KDPanel();
            this.jRadioButton1 = new KDRadioButton();
            this.jRadioButton2 = new KDRadioButton();
            this.jRadioButton3 = new KDRadioButton();
            this.jRadioButton4 = new KDRadioButton();
            this.jRadioButton5 = new KDRadioButton();
            this.btnGroup = new ButtonGroup();
            this.btnGroup.add((AbstractButton)this.jRadioButton1);
            this.btnGroup.add((AbstractButton)this.jRadioButton2);
            this.btnGroup.add((AbstractButton)this.jRadioButton3);
            this.btnGroup.add((AbstractButton)this.jRadioButton4);
            this.btnGroup.add((AbstractButton)this.jRadioButton5);
            this.ok = new KDButton();
            this.cancel = new KDButton();
            this.jPanel1.setBorder((Border)BorderFactory.createTitledBorder(GroupReportComposer.getLocalText(GroupReportComposer.KEY_STAT_TYPE, "\u7edf\u8ba1\u7c7b\u578b")));
            this.jRadioButton1.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_SUM, "\u6c42\u548c"));
            this.jRadioButton2.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_AVG, "\u5e73\u5747\u503c"));
            this.jRadioButton3.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_MAX, "\u6700\u5927\u503c"));
            this.jRadioButton4.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_MIN, "\u6700\u5c0f\u503c"));
            this.jRadioButton5.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_CNT, "\u8ba1\u6570"));
            GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
            this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
            jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jRadioButton1).add((Component)this.jRadioButton2).add((Component)this.jRadioButton3).add((Component)this.jRadioButton4).add((Component)this.jRadioButton5)).addContainerGap(78, Short.MAX_VALUE)));
            jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButton1).add(18, 18, 18).add((Component)this.jRadioButton2).add(18, 18, 18).add((Component)this.jRadioButton3).add(18, 18, 18).add((Component)this.jRadioButton4).add(18, 18, 18).add((Component)this.jRadioButton5).add(18, 18, 18).addContainerGap(14, Short.MAX_VALUE)));
            this.ok.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_OK, "\u786e\u5b9a"));
            this.cancel.setText(GroupReportComposer.getLocalText(GroupReportComposer.KEY_CANCEL, "\u53d6\u6d88"));
            GroupLayout layout = new GroupLayout(this.getContentPane());
            this.getContentPane().setLayout((LayoutManager)layout);
            layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.ok).addPreferredGap(0).add((Component)this.cancel))).addContainerGap()));
            layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(18, 18, 18).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.cancel).add((Component)this.ok)).addContainerGap()));
        }
    }

    public static class TrinityElement
    implements IElement {
        static final int SUM = 0;
        static final int AVG = 1;
        static final int MAX = 2;
        static final int MIN = 3;
        static final int CNT = 4;
        private String alias;
        private String colName;
        private int mode;

        TrinityElement(String alias, String colName) {
            this.alias = alias;
            this.colName = colName;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public String getColName() {
            return this.colName;
        }

        public int getMode() {
            return this.mode;
        }

        public void setMode(int mode) {
            this.mode = mode;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(GroupReportComposer.getLocalText(GroupReportComposer.KEY_TO_STAT_OF, "\u7edf\u8ba1  {#1}  \u7684  {#2}").replace("#1", this.alias).replace("#2", this.getI18nModeName()));
            return sb.toString();
        }

        public String getI18nModeName() {
            switch (this.mode) {
                case 0: {
                    return GroupReportComposer.getLocalText(GroupReportComposer.KEY_SUM, "\u6c42\u548c");
                }
                case 1: {
                    return GroupReportComposer.getLocalText(GroupReportComposer.KEY_AVG, "\u5e73\u5747\u503c");
                }
                case 2: {
                    return GroupReportComposer.getLocalText(GroupReportComposer.KEY_MAX, "\u6700\u5927\u503c");
                }
                case 3: {
                    return GroupReportComposer.getLocalText(GroupReportComposer.KEY_MIN, "\u6700\u5c0f\u503c");
                }
                case 4: {
                    return GroupReportComposer.getLocalText(GroupReportComposer.KEY_CNT, "\u8ba1\u6570");
                }
            }
            throw new IllegalArgumentException("unsupported STAT argument");
        }

        public String getFormulaNameByMode() {
            switch (this.mode) {
                case 0: {
                    return "SUM";
                }
                case 1: {
                    return "AVERAGE";
                }
                case 2: {
                    return "MAX";
                }
                case 3: {
                    return "MIN";
                }
                case 4: {
                    return "COUNTA";
                }
            }
            throw new IllegalArgumentException("unsupported STAT argument");
        }

        public int hashCode() {
            return this.colName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IElement)) {
                return false;
            }
            IElement byObj = (IElement)obj;
            return this.colName.equals(byObj.getColName());
        }
    }

    static class BinaryElement
    implements IElement {
        private String alias;
        private String colName;

        BinaryElement(String alias, String colName) {
            this.alias = alias;
            this.colName = colName;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public String getColName() {
            return this.colName;
        }

        public String toString() {
            return this.alias;
        }

        public int hashCode() {
            return this.colName.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IElement)) {
                return false;
            }
            IElement byObj = (IElement)obj;
            return this.colName.equals(byObj.getColName());
        }
    }

    static interface IElement {
        public String getAlias();

        public String getColName();
    }
}

