/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.scheduler;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.border.Border;

public class WizardScheduler
extends KDPanel
implements ISpreadWizzard {
    private ShowcaseConfig.SchedulerConfig _config;
    private KDButton confirm;
    private KDButton cancel;
    private KDCheckBox refreshEnabled;
    private KDLabel jLabel1;
    private KDLabel jLabel2;
    private KDLabel jLabel3;
    private KDLabel jLabel4;
    private KDPanel jPanel1;
    private KDPanel jPanel2;
    private KDRadioButton perHoursRadio;
    private KDRadioButton perMinutesRadio;
    private KDRadioButton perSecondsRadio;
    private KDRadioButton circularRadio;
    private KDRadioButton limitTimesRadio;
    private KDFormattedTextField seconds;
    private KDFormattedTextField hours;
    private KDFormattedTextField minutes;
    private KDFormattedTextField limitTimes;
    private ButtonGroup perGroup;
    private ButtonGroup timesGroup;
    private KDDialog shell;
    private FocusTranferer focusTransferer = new FocusTranferer();

    public WizardScheduler() {
        this.init();
        this.initComps();
        this.initListeners();
    }

    private void init() {
        this.setPreferredSize(new Dimension(280, 400));
    }

    private void initComps() {
        this.refreshEnabled = new KDCheckBox();
        this.jPanel1 = new KDPanel();
        this.perHoursRadio = new KDRadioButton();
        this.perMinutesRadio = new KDRadioButton();
        this.perSecondsRadio = new KDRadioButton();
        this.perGroup = new ButtonGroup();
        this.perGroup.add((AbstractButton)this.perHoursRadio);
        this.perGroup.add((AbstractButton)this.perMinutesRadio);
        this.perGroup.add((AbstractButton)this.perSecondsRadio);
        this.perMinutesRadio.setSelected(true);
        this.circularRadio = new KDRadioButton();
        this.limitTimesRadio = new KDRadioButton();
        this.timesGroup = new ButtonGroup();
        this.timesGroup.add((AbstractButton)this.circularRadio);
        this.timesGroup.add((AbstractButton)this.limitTimesRadio);
        this.circularRadio.setSelected(true);
        this.seconds = new KDFormattedTextField();
        this.hours = new KDFormattedTextField();
        this.minutes = new KDFormattedTextField();
        this.jLabel1 = new KDLabel();
        this.jLabel2 = new KDLabel();
        this.jLabel3 = new KDLabel();
        this.jPanel2 = new KDPanel();
        this.limitTimes = new KDFormattedTextField();
        this.jLabel4 = new KDLabel();
        this.confirm = new KDButton();
        this.cancel = new KDButton();
        this.setLayout(null);
        this.refreshEnabled.setText(CtrlEXTMessages.getMLS("enableAutoRefresh", "\u542f\u7528\u81ea\u52a8\u5237\u65b0"));
        this.add((Component)this.refreshEnabled);
        this.refreshEnabled.setBounds(30, 20, 100, 23);
        this.jPanel1.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("autoRefreshFrequency", "\u81ea\u52a8\u5237\u65b0\u9891\u7387")));
        this.jPanel1.setLayout(null);
        this.perHoursRadio.setText(CtrlEXTMessages.getMLS("every", "\u6bcf"));
        this.jPanel1.add((Component)this.perHoursRadio);
        this.perHoursRadio.setBounds(30, 30, 40, 23);
        this.perMinutesRadio.setText(CtrlEXTMessages.getMLS("every", "\u6bcf"));
        this.jPanel1.add((Component)this.perMinutesRadio);
        this.perMinutesRadio.setBounds(30, 70, 40, 23);
        this.perSecondsRadio.setText(CtrlEXTMessages.getMLS("every", "\u6bcf"));
        this.jPanel1.add((Component)this.perSecondsRadio);
        this.perSecondsRadio.setBounds(30, 110, 40, 23);
        this.jPanel1.add((Component)this.seconds);
        this.seconds.setBounds(90, 110, 60, 21);
        this.jPanel1.add((Component)this.hours);
        this.hours.setBounds(90, 30, 60, 21);
        this.jPanel1.add((Component)this.minutes);
        this.minutes.setBounds(90, 70, 60, 21);
        this.jLabel1.setText(CtrlEXTMessages.getMLS("second", "\u79d2"));
        this.jPanel1.add((Component)this.jLabel1);
        this.jLabel1.setBounds(170, 110, 40, 20);
        this.jLabel2.setText(CtrlEXTMessages.getMLS("minute", "\u5206"));
        this.jPanel1.add((Component)this.jLabel2);
        this.jLabel2.setBounds(170, 70, 40, 20);
        this.jLabel3.setText(CtrlEXTMessages.getMLS("hour", "\u5c0f\u65f6"));
        this.jPanel1.add((Component)this.jLabel3);
        this.jLabel3.setBounds(170, 30, 40, 20);
        this.add((Component)this.jPanel1);
        this.jPanel1.setBounds(30, 60, 220, 160);
        this.jPanel2.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("refreshCount", "\u5237\u65b0\u6b21\u6570")));
        this.jPanel2.setLayout(null);
        this.circularRadio.setText(CtrlEXTMessages.getMLS("loopRefresh", "\u5faa\u73af\u5237\u65b0"));
        this.jPanel2.add((Component)this.circularRadio);
        this.circularRadio.setBounds(30, 30, 73, 23);
        this.limitTimesRadio.setText(CtrlEXTMessages.getMLS("refresh", "\u5237\u65b0"));
        this.jPanel2.add((Component)this.limitTimesRadio);
        this.limitTimesRadio.setBounds(30, 60, 60, 23);
        this.jPanel2.add((Component)this.limitTimes);
        this.limitTimes.setBounds(90, 60, 60, 21);
        this.jLabel4.setText(CtrlEXTMessages.getMLS("endAfterTimes", "\u6b21\u540e\u7ed3\u675f"));
        this.jPanel2.add((Component)this.jLabel4);
        this.jLabel4.setBounds(160, 60, 50, 20);
        this.add((Component)this.jPanel2);
        this.jPanel2.setBounds(30, 230, 220, 110);
        this.confirm.setText(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this.add((Component)this.confirm);
        this.confirm.setBounds(90, 360, 70, 25);
        this.cancel.setText(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this.add((Component)this.cancel);
        this.cancel.setBounds(180, 360, 70, 25);
    }

    private void initListeners() {
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (WizardScheduler.this.assembleSchedulerConfig()) {
                    WizardScheduler.this.shell.setVisible(false);
                    WizardScheduler.this.shell.dispose();
                }
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardScheduler.this.shell.setVisible(false);
                WizardScheduler.this.shell.dispose();
            }
        });
        this.refreshEnabled.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WizardScheduler.this.switchComponents(WizardScheduler.this.refreshEnabled.isSelected());
            }
        });
        this.hours.addFocusListener((FocusListener)this.focusTransferer);
        this.minutes.addFocusListener((FocusListener)this.focusTransferer);
        this.seconds.addFocusListener((FocusListener)this.focusTransferer);
        this.limitTimes.addFocusListener((FocusListener)this.focusTransferer);
        this.perHoursRadio.addFocusListener((FocusListener)this.focusTransferer);
        this.perMinutesRadio.addFocusListener((FocusListener)this.focusTransferer);
        this.perSecondsRadio.addFocusListener((FocusListener)this.focusTransferer);
        this.limitTimesRadio.addFocusListener((FocusListener)this.focusTransferer);
    }

    public ShowcaseConfig.SchedulerConfig getSchedulerConfig() {
        return this._config;
    }

    public void setSchedulerConfig(ShowcaseConfig.SchedulerConfig config) {
        this._config = config;
        if (config == null) {
            this.perMinutesRadio.setSelected(true);
            this.circularRadio.setSelected(true);
            this.hours.setValue(null);
            this.minutes.setValue((Object)5);
            this.seconds.setValue(null);
            this.limitTimes.setValue(null);
            this.switchComponents(false);
        } else {
            int step = config.getStep();
            if (step % 3600 == 0) {
                this.perHoursRadio.setSelected(true);
                this.hours.setValue((Object)(step / 3600));
                this.minutes.setValue(null);
                this.seconds.setValue(null);
            } else if (step % 60 == 0) {
                this.perMinutesRadio.setSelected(true);
                this.minutes.setValue((Object)(step / 60));
                this.hours.setValue(null);
                this.seconds.setValue(null);
            } else {
                this.perSecondsRadio.setSelected(true);
                this.seconds.setValue((Object)step);
                this.hours.setValue(null);
                this.minutes.setValue(null);
            }
            int count = config.getCount();
            if (count == -1) {
                this.circularRadio.setSelected(true);
                this.limitTimes.setValue(null);
            } else {
                this.limitTimesRadio.setSelected(true);
                this.limitTimes.setValue((Object)count);
            }
            this.switchComponents(config.isEnabled());
        }
    }

    private void switchComponents(boolean isEnabled) {
        this.perHoursRadio.setEnabled(isEnabled);
        this.perMinutesRadio.setEnabled(isEnabled);
        this.perSecondsRadio.setEnabled(isEnabled);
        this.circularRadio.setEnabled(isEnabled);
        this.limitTimesRadio.setEnabled(isEnabled);
        this.hours.setEnabled(isEnabled);
        this.minutes.setEnabled(isEnabled);
        this.seconds.setEnabled(isEnabled);
        this.limitTimes.setEnabled(isEnabled);
    }

    private boolean assembleSchedulerConfig() {
        boolean shouldPersist;
        int value;
        Integer h;
        int loopSenconds = -1;
        ButtonModel bm = this.perGroup.getSelection();
        if (bm == this.perHoursRadio.getModel()) {
            h = (Integer)this.hours.getValue(Integer.class);
            if (h != null) {
                value = h;
                if (value <= 0 && this.refreshEnabled.isSelected()) {
                    this.showErrorMsg();
                    return false;
                }
                loopSenconds = value * 3600;
            } else if (this.refreshEnabled.isSelected()) {
                this.showErrorMsg();
                return false;
            }
        } else if (bm == this.perMinutesRadio.getModel()) {
            h = (Integer)this.minutes.getValue(Integer.class);
            if (h != null) {
                value = h;
                if (value <= 0 && this.refreshEnabled.isSelected()) {
                    this.showErrorMsg();
                    return false;
                }
                loopSenconds = value * 60;
            } else if (this.refreshEnabled.isSelected()) {
                this.showErrorMsg();
                return false;
            }
        } else {
            h = (Integer)this.seconds.getValue(Integer.class);
            if (h != null) {
                value = h;
                if (value <= 0 && this.refreshEnabled.isSelected()) {
                    this.showErrorMsg();
                    return false;
                }
                loopSenconds = value;
            } else if (this.refreshEnabled.isSelected()) {
                this.showErrorMsg();
                return false;
            }
        }
        int loopTimes = 0;
        bm = this.timesGroup.getSelection();
        if (bm == this.limitTimesRadio.getModel()) {
            Integer h2 = (Integer)this.limitTimes.getValue(Integer.class);
            if (h2 != null) {
                int value2 = h2;
                if (value2 <= 0 && this.refreshEnabled.isSelected()) {
                    this.showErrorMsg();
                    return false;
                }
                loopTimes = value2;
            } else if (this.refreshEnabled.isSelected()) {
                this.showErrorMsg();
                return false;
            }
        } else {
            loopTimes = -1;
        }
        boolean bl = shouldPersist = loopSenconds != -1 && loopTimes != 0;
        if (!this.refreshEnabled.isSelected()) {
            if (shouldPersist) {
                if (this._config == null) {
                    this._config = new ShowcaseConfig.SchedulerConfig();
                }
                this._config.setEnabled(this.refreshEnabled.isSelected());
                this._config.setStep(loopSenconds);
                this._config.setCount(loopTimes);
            }
            return true;
        }
        if (this._config == null) {
            this._config = new ShowcaseConfig.SchedulerConfig();
        }
        this._config.setEnabled(this.refreshEnabled.isSelected());
        this._config.setStep(loopSenconds);
        this._config.setCount(loopTimes);
        return true;
    }

    private void showErrorMsg() {
        MessageUtil.msgboxInfo((Component)((Object)this), CtrlEXTMessages.getMLS("valueMustBePositiveInteger", "\u6570\u503c\u5fc5\u987b\u4e3a\u6b63\u6574\u6570\uff0c\u8bf7\u4fee\u6b63\uff01"));
    }

    @Override
    public void commit() {
    }

    @Override
    public void show() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        this.shell = w instanceof Frame ? new KDDialog((Frame)w) : (w instanceof Dialog ? new KDDialog((Dialog)w) : new KDDialog((Frame)null));
        this.shell.setContentPane((Container)((Object)this));
        this.shell.setSize(280, 420);
        this.shell.setModal(true);
        this.shell.setResizable(false);
        this.shell.setLocationRelativeTo(null);
        this.shell.setTitle(CtrlEXTMessages.getMLS("autoRefreshSettings", "\u81ea\u52a8\u5237\u65b0\u8bbe\u7f6e"));
        this.shell.show();
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public boolean isModal() {
        return true;
    }

    private class FocusTranferer
    implements FocusListener {
        private FocusTranferer() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() == WizardScheduler.this.hours) {
                if (WizardScheduler.this.hours.getValue(Integer.class) == null) {
                    WizardScheduler.this.hours.setValue((Object)1);
                }
                WizardScheduler.this.perHoursRadio.setSelected(true);
            } else if (e.getSource() == WizardScheduler.this.minutes) {
                if (WizardScheduler.this.minutes.getValue(Integer.class) == null) {
                    WizardScheduler.this.minutes.setValue((Object)5);
                }
                WizardScheduler.this.perMinutesRadio.setSelected(true);
            } else if (e.getSource() == WizardScheduler.this.seconds) {
                if (WizardScheduler.this.seconds.getValue(Integer.class) == null) {
                    WizardScheduler.this.seconds.setValue((Object)30);
                }
                WizardScheduler.this.perSecondsRadio.setSelected(true);
            } else if (e.getSource() == WizardScheduler.this.limitTimes) {
                if (WizardScheduler.this.limitTimes.getValue(Integer.class) == null) {
                    WizardScheduler.this.limitTimes.setValue((Object)10);
                }
                WizardScheduler.this.limitTimesRadio.setSelected(true);
            } else if (e.getSource() == WizardScheduler.this.perHoursRadio) {
                WizardScheduler.this.hours.requestFocusInWindow();
            } else if (e.getSource() == WizardScheduler.this.perMinutesRadio) {
                WizardScheduler.this.minutes.requestFocusInWindow();
            } else if (e.getSource() == WizardScheduler.this.perSecondsRadio) {
                WizardScheduler.this.seconds.requestFocusInWindow();
            } else if (e.getSource() == WizardScheduler.this.limitTimesRadio) {
                WizardScheduler.this.limitTimes.requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }
}

