/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.util.IntegratedEnvCheck;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.ui.ClientControlManager;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKds;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.ISimpleStatusBarRenderer;
import com.kingdee.cosmic.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.cosmic.ctrl.swing.KDEditorPane;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDStatusBar;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.MemoryInspector;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarPart;
import com.kingdee.cosmic.ctrl.swing.SimpleStatusBarRenderer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.apache.log4j.Logger;

public class ExtConsole
extends KDFrame
implements ComponentListener {
    private static final Logger logger = LogUtil.getPackageLogger(ExtConsole.class);
    private KDWorkButton clear;
    private KDWorkButton copy;
    private KDWorkButton close;
    private KDWorkButton showPanelReport;
    private KDWorkButton showConsoleReport;
    private KDWorkButton showSheetReport;
    private KDWorkButton mem;
    private KDWorkButton gc;
    private KDWorkButton logLevel;
    private KDWorkButton showCalcThreads;
    private KDScrollPane scrollpane;
    private KDEditorPane logRecorder;
    private KDCheckBoxMenuItem fatalLog;
    private KDCheckBoxMenuItem errorLog;
    private KDCheckBoxMenuItem warnLog;
    private KDCheckBoxMenuItem infoLog;
    private KDCheckBoxMenuItem debugLog;
    private int _logLevel = 4;
    private transient Element element;
    private SimpleDateFormat format;
    private HTMLDocument document;
    private KDStatusBar statusBar;
    private static final int REPORTER_TYPE_CONSOLE = 1;
    private static final int REPORTER_TYPE_PANLE = 0;
    private static final String FUNCTION_METER_NAME = "functionCalls";
    private static final String FUNCTION_COUNTER_NAME = "functionNums";
    private static final String FUNCTION_CALC_TIMER = "functionCalcTimer";
    private static final long REPORT_PERIOD = 30L;
    private static final String STATISTICS_SHEET_NAME = "formula statistics";
    private KDExt ext;
    private int before;
    private boolean flag = false;
    private int after;
    private Rectangle viewRect;
    private int width;
    private int height;

    private static final String getReportLogStr() {
        return CtrlEXTMessages.getMLS("reportCalculationLog", "\u62a5\u8868\u8ba1\u7b97\u65e5\u5fd7");
    }

    public ExtConsole() {
        this(null);
    }

    public ExtConsole(KDExt ext) {
        this.ext = ext;
        this.initConsole();
        this.initComps();
        this.initListeners();
    }

    public void log(int logLevel, String logTxt) {
        if (logLevel > this._logLevel) {
            return;
        }
        if (StringUtil.isEmptyString((String)logTxt)) {
            logTxt = "";
        } else {
            logTxt = logTxt.replaceAll("<", "&lt;");
            logTxt = logTxt.replaceAll(">", "&gt;");
            logTxt = logTxt.replaceAll("\r\n", "<br>");
        }
        try {
            this.viewRect = this.scrollpane.getViewport().getViewRect();
            this.before = this.scrollpane.getViewport().getView().getHeight();
            if (this.before < this.viewRect.y + this.viewRect.height + 20 && this.viewRect.height < this.before) {
                this.flag = true;
            }
            this.document.insertBeforeEnd(this.element, "<p align='left'><b>" + this.getLogPrefix(logLevel) + "</b>" + logTxt + "</p>");
            this.document.insertBeforeEnd(this.element, "<br>");
            this.after = this.scrollpane.getViewport().getView().getHeight();
            if (this.flag) {
                this.scrollpane.getViewport().scrollRectToVisible(new Rectangle(this.viewRect.x, this.after - this.viewRect.height, this.viewRect.width, this.viewRect.height));
                this.flag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExt(KDExt ext) {
        this.ext = ext;
    }

    public void log(Throwable t) {
        StringWriter writer = new StringWriter();
        t.printStackTrace(new PrintWriter(writer));
        String html = writer.toString().trim();
        html = html.replaceAll("<", "&lt;");
        html = html.replaceAll(">", "&gt;");
        html = html.replaceAll("\\n", "<br>");
        try {
            this.viewRect = this.scrollpane.getViewport().getViewRect();
            this.before = this.scrollpane.getViewport().getView().getHeight();
            if (this.before < this.viewRect.y + this.viewRect.height + 20 && this.viewRect.height < this.before) {
                this.flag = true;
            }
            this.document.insertBeforeEnd(this.element, "<p align='left' ><b>" + this.getErrorPrefix().trim() + "</b>" + html + "</p>");
            this.document.insertBeforeEnd(this.element, "<br>");
            this.after = this.scrollpane.getViewport().getView().getHeight();
            if (this.flag) {
                this.scrollpane.getViewport().scrollRectToVisible(new Rectangle(this.viewRect.x, this.after - this.viewRect.height, this.viewRect.width, this.viewRect.height));
                this.flag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getLogPrefix(int logLevel) {
        String date = this.format.format(new Date());
        switch (logLevel) {
            case 0: {
                return CtrlEXTMessages.getMLS("fatalError", "[\u81f4\u547d  #1]\uff1a ").replace("#1", date);
            }
            case 1: {
                return CtrlEXTMessages.getMLS("error", "[\u9519\u8bef  #1]\uff1a ").replace("#1", date);
            }
            case 2: {
                return CtrlEXTMessages.getMLS("warning", "[\u8b66\u544a  #1]\uff1a ").replace("#1", date);
            }
            case 3: {
                return CtrlEXTMessages.getMLS("info", "[\u4fe1\u606f  #1]\uff1a ").replace("#1", date);
            }
            case 4: {
                return CtrlEXTMessages.getMLS("debug", "[\u8c03\u8bd5  #1]\uff1a ").replace("#1", date);
            }
        }
        throw new IllegalArgumentException();
    }

    private String getErrorPrefix() {
        return CtrlEXTMessages.getMLS("programException", "[\u7a0b\u5e8f\u5f02\u5e38  #1]:").replace("#1", this.format.format(new Date()));
    }

    private void initConsole() {
        this.setTitle(CtrlEXTMessages.getMLS("kingdeeCloudReportBackend", "\u91d1\u8776\u4e91\u82cd\u7a79\u8f7b\u62a5\u8868\u540e\u53f0"));
        this.setSize(750, 525);
        this.setLocationRelativeTo(null);
        this.setResizable(true);
        this.fatalLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(0));
        this.errorLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(1));
        this.warnLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(2));
        this.infoLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(3));
        this.debugLog = new KDCheckBoxMenuItem((Action)new LogLevelAction(4));
        this.debugLog.setSelected(true);
        this.format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }

    private void initComps() {
        Container c = this.getContentPane();
        c.setLayout(null);
        this.initDefaultStatusBar();
        this.scrollpane = new KDScrollPane();
        this.logRecorder = new KDEditorPane("text/html", this.getIntroduce());
        this.document = (HTMLDocument)this.logRecorder.getDocument();
        this.element = this.document.getElement("ins");
        this.logRecorder.setEditable(false);
        this.clear = new KDWorkButton();
        this.copy = new KDWorkButton();
        this.close = new KDWorkButton();
        this.showPanelReport = new KDWorkButton();
        this.showConsoleReport = new KDWorkButton();
        this.showSheetReport = new KDWorkButton();
        this.mem = new KDWorkButton();
        this.gc = new KDWorkButton();
        this.logLevel = new KDWorkButton();
        this.logLevel.addAssistMenuItem((JMenuItem)this.fatalLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.errorLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.warnLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.infoLog);
        this.logLevel.addAssistMenuItem((JMenuItem)this.debugLog);
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane.setViewportView((Component)this.logRecorder);
        c.add((Component)this.scrollpane);
        this.scrollpane.setBounds(160, 18, 570, 435);
        this.clear.setText(CtrlEXTMessages.getMLS("clearLogs", "\u6e05\u9664\u65e5\u5fd7"));
        c.add((Component)this.clear);
        this.clear.setBounds(30, 20, 120, 30);
        this.copy.setText(CtrlEXTMessages.getMLS("copyLogs", "\u590d\u5236\u65e5\u5fd7"));
        c.add((Component)this.copy);
        this.copy.setBounds(30, 60, 120, 30);
        this.gc.setText(CtrlEXTMessages.getMLS("garbageCollection", "\u5783\u573e\u6536\u96c6"));
        c.add((Component)this.gc);
        this.gc.setBounds(30, 100, 120, 30);
        this.mem.setText(CtrlEXTMessages.getMLS("memoryUsage", "\u5185\u5b58\u8017\u7528"));
        c.add((Component)this.mem);
        this.mem.setBounds(30, 140, 120, 30);
        this.logLevel.setText(CtrlEXTMessages.getMLS("logLevel", "\u65e5\u5fd7\u7ea7\u522b"));
        c.add((Component)this.logLevel);
        this.logLevel.setBounds(30, 180, 120, 30);
        this.showPanelReport.setText(CtrlEXTMessages.getMLS("showExecutionReport", "\u663e\u793a\u6267\u884c\u62a5\u544a"));
        c.add((Component)this.showPanelReport);
        this.showPanelReport.setBounds(30, 220, 120, 30);
        this.showConsoleReport.setText(CtrlEXTMessages.getMLS("showBackendReport", "\u663e\u793a\u540e\u53f0\u62a5\u544a"));
        c.add((Component)this.showConsoleReport);
        this.showConsoleReport.setBounds(30, 260, 120, 30);
        this.showSheetReport.setText(CtrlEXTMessages.getMLS("workbookReport", "\u5de5\u4f5c\u7c3f\u62a5\u544a"));
        c.add((Component)this.showSheetReport);
        this.showSheetReport.setBounds(30, 300, 120, 30);
        this.close.setText(CtrlEXTMessages.getMLS("KEY_CLOSE", "\u5173\u95ed"));
        c.add((Component)this.close);
        this.close.setBounds(30, 425, 120, 30);
        this.addComponentListener(this);
        this.showCalcThreads = new KDWorkButton((Action)new AbstractAction(ExtConsole.getReportLogStr()){
            WindowListener l;
            {
                this.l = new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        ExtConsole.this.showCalcThreads.setText(ExtConsole.getReportLogStr());
                        ClientControlManager.restoreUI(ExtConsole.this, (JComponent)ExtConsole.this.scrollpane);
                        ExtConsole.this.removeWindowListener(this);
                    }
                };
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals(ExtConsole.getReportLogStr())) {
                    ExtConsole.this.showCalcThreads.setText(CtrlEXTMessages.getMLS("return", "\u8fd4   \u56de"));
                    ClientControlManager.replaceUI(ExtConsole.this, (JComponent)ExtConsole.this.scrollpane);
                    ExtConsole.this.addWindowListener(this.l);
                } else {
                    ExtConsole.this.showCalcThreads.setText(ExtConsole.getReportLogStr());
                    ClientControlManager.restoreUI(ExtConsole.this, (JComponent)ExtConsole.this.scrollpane);
                    ExtConsole.this.removeWindowListener(this.l);
                }
            }
        });
        this.showCalcThreads.setBounds(30, 220, 120, 30);
        if (IntegratedEnvCheck.checkIsIntegratedEAS()) {
            c.add((Component)this.showCalcThreads);
        }
    }

    private KDStatusBar initDefaultStatusBar() {
        this.statusBar = new KDStatusBar();
        this.statusBar.addPart(this.createStatusPartMemory(this.statusBar));
        this.setStatusBar(this.statusBar);
        return this.statusBar;
    }

    private SimpleStatusBarPart createStatusPartMemory(KDStatusBar statusBar) {
        SimpleStatusBarPart part = new SimpleStatusBarPart(statusBar);
        part.setPreferredSize(new Dimension(500, 30));
        part.setHgrap(0);
        String str = CtrlEXTMessages.getMLS("memoryStatus", "\u5185\u5b58\u72b6\u6001");
        SimpleStatusBarRenderer render1 = new SimpleStatusBarRenderer((JComponent)new MemoryInspector(0L, 1000000), str);
        render1.getComponent(statusBar).setToolTipText(str);
        part.addRenderer((ISimpleStatusBarRenderer)render1, (Object)"memory");
        return part;
    }

    private String getIntroduce() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        if (IntegratedEnvCheck.checkIsIntegratedEAS()) {
            sb.append("<p align='center' color='red'><b><font size=5>#1<font></b></p>".replace("#1", CtrlEXTMessages.getMLS("cloudCeilingLightReportBackend", "\u91d1\u8776\u4e91\u82cd\u7a79\u8f7b\u62a5\u8868\u540e\u53f0")));
        } else {
            sb.append("<p align='center' color='red'><b><font size=5>#1<font></b></p>".replace("#1", CtrlEXTMessages.getMLS("kbiBiAnalyticsBackend", "\u91d1\u8776KBI\u667a\u80fd\u5206\u6790\u540e\u53f0")));
        }
        sb.append("<p>");
        sb.append("<b>#1</b>".replace("#1", CtrlEXTMessages.getMLS("javaProvider", "Java\u63d0\u4f9b\u5546\uff1a"))).append(System.getProperty("java.vm.vendor")).append("<br>");
        sb.append("<b>#1</b>".replace("#1", CtrlEXTMessages.getMLS("javaRuntimeVersion", "Java\u8fd0\u884c\u65f6\u7248\u672c\uff1a"))).append(System.getProperty("java.version")).append("<br>");
        sb.append("<b>#1</b>".replace("#1", CtrlEXTMessages.getMLS("operatingSystem", "\u64cd\u4f5c\u7cfb\u7edf\uff1a"))).append(System.getProperty("os.name")).append("<br>");
        sb.append("<b>#1</b>".replace("#1", CtrlEXTMessages.getMLS("binaryReaderVersion", "\u4e8c\u8fdb\u5236\u8bfb\u53d6\u5668\u7248\u672c\uff1a"))).append(BookToKds.getVersion()).append("<br>");
        sb.append("<b>#1</b>".replace("#1", CtrlEXTMessages.getMLS("temporaryFileDirectory", "\u4e34\u65f6\u6587\u4ef6\u76ee\u5f55\uff1a"))).append(System.getProperty("java.io.tmpdir")).append("<br>");
        sb.append("</p>");
        sb.append("<p id='ins'>&nbsp;</p>");
        sb.append("</body></html>");
        return sb.toString();
    }

    public void show() {
        this.logRecorder = new KDEditorPane("text/html", this.getIntroduce());
        super.show();
    }

    public String getDoctments() {
        try {
            return this.document.getText(0, this.document.getLength());
        }
        catch (BadLocationException e) {
            return "Class:" + this.getClass() + "\r\n Method: getDoctments() \r\n" + e.getMessage();
        }
    }

    private void initListeners() {
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConsole.this.clearRecorder();
            }
        });
        this.copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                clipboard.setContents(new StringSelection(ExtConsole.this.getDoctments()), null);
            }
        });
        this.gc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.gc();
            }
        });
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtConsole.this.dispose();
            }
        });
        this.showConsoleReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        this.showSheetReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SpreadContext cxt;
                Book book;
                Sheet sheet;
                if (null != ExtConsole.this.ext && null == (sheet = (book = (cxt = MiscUtil.getActiveSpreadContext(ExtConsole.this.ext)).getBook()).getSheet(ExtConsole.STATISTICS_SHEET_NAME))) {
                    sheet = new Sheet(book, ExtConsole.STATISTICS_SHEET_NAME);
                    book.addSheet(sheet);
                }
            }
        });
        this.mem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int kb = (int)((Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L);
                try {
                    ExtConsole.this.document.insertAfterEnd(ExtConsole.this.element, "<div><b>#1 #2 KB</b></div>".replace("#1", CtrlEXTMessages.getMLS("currentSystemTotalMemoryUsage", "\u5f53\u524d\u7cfb\u7edf\u603b\u5185\u5b58\u8017\u7528")).replace("#2", String.valueOf(kb)));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    public void clearRecorder() {
        this.logRecorder.setText(this.getIntroduce());
        try {
            this.document.setOuterHTML(this.element.getParentElement(), this.getIntroduce());
            this.element = this.document.getElement("ins");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        ExtConsole console = (ExtConsole)((Object)e.getComponent());
        Dimension consoleDim = console.getSize();
        if (this.width != consoleDim.width || this.height != consoleDim.height) {
            this.width = consoleDim.width - 750 + 570;
            this.height = consoleDim.height - 525 + 435;
            if (this.showCalcThreads.getText().equals(CtrlEXTMessages.getMLS("return", "\u8fd4   \u56de"))) {
                ClientControlManager.queueUI.setSize(new Dimension(this.width + 30, this.height));
                ClientControlManager.queueUI.revalidate();
                ClientControlManager.queueUI.repaint();
            } else {
                console.scrollpane.setSize(new Dimension(this.width, this.height));
                console.scrollpane.revalidate();
                console.scrollpane.repaint();
            }
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    private class LogLevelAction
    extends AbstractAction {
        private int _level;

        private LogLevelAction(int level) {
            this._level = level;
            switch (level) {
                case 0: {
                    this.putValue("Name", CtrlEXTMessages.getMLS("fatalLevel", "\u81f4\u547d\u7ea7"));
                    break;
                }
                case 1: {
                    this.putValue("Name", CtrlEXTMessages.getMLS("errorLevel", "\u9519\u8bef\u7ea7"));
                    break;
                }
                case 2: {
                    this.putValue("Name", CtrlEXTMessages.getMLS("warningLevel", "\u8b66\u544a\u7ea7"));
                    break;
                }
                case 3: {
                    this.putValue("Name", CtrlEXTMessages.getMLS("infoLevel", "\u4fe1\u606f\u7ea7"));
                    break;
                }
                case 4: {
                    this.putValue("Name", CtrlEXTMessages.getMLS("debugLevel", "\u8c03\u8bd5\u7ea7"));
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtConsole.this._logLevel = this._level;
            this.exclisiveSelection(ExtConsole.this.fatalLog);
            this.exclisiveSelection(ExtConsole.this.errorLog);
            this.exclisiveSelection(ExtConsole.this.warnLog);
            this.exclisiveSelection(ExtConsole.this.infoLog);
            this.exclisiveSelection(ExtConsole.this.debugLog);
        }

        private void exclisiveSelection(KDCheckBoxMenuItem menu) {
            if (((LogLevelAction)menu.getAction())._level != this._level) {
                menu.setSelected(false);
            }
        }
    }
}

