/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.digitalstyle;

import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Node;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import java.math.BigDecimal;

class FractionFormat
extends SimpleFormat {
    private boolean _sureDenom;
    private String _denomPattern;
    private String _numerPattern;
    private int _fractionIndex;
    private boolean _hasSign;

    FractionFormat() {
    }

    void setHasSign(boolean b) {
        this._hasSign = b;
    }

    boolean hasSign() {
        return this._hasSign;
    }

    void setFractionIndex(int fi) {
        this._fractionIndex = fi;
    }

    void setSureDenom(boolean b) {
        this._sureDenom = b;
    }

    void setDenomPattern(String denomP) {
        this._denomPattern = denomP;
    }

    void setNumerPattern(String numerP) {
        this._numerPattern = numerP;
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        String numer;
        String denom;
        if (var == null) {
            return FormatResult.NullResult;
        }
        BigDecimal bg = null;
        try {
            if (parse || var.isNumber() || var.isDate()) {
                bg = var.toBigDecimal();
            }
        }
        catch (SyntaxErrorException e) {
            bg = null;
        }
        if (bg == null) {
            return FormatResult.NullResult;
        }
        boolean minus = bg.signum() < 0;
        bg = bg.abs();
        if (this._sureDenom) {
            denom = this._denomPattern;
            numer = bg.multiply(new BigDecimal(denom)).toBigInteger().toString();
        } else {
            int maxDenom = (int)Math.pow(10.0, this._denomPattern.length());
            double value = bg.doubleValue();
            int rightDenom = 0;
            int rightNumer = 0;
            double rightDelta = 1.0;
            double minDelta = 0.0;
            for (int i = 1; i < maxDenom; ++i) {
                double dNumer = (double)i * value;
                int iNumer = (int)dNumer;
                double delta = dNumer - (double)iNumer;
                if (ArrayUtil.isEqual((Double)delta, (Double)minDelta)) {
                    rightDenom = i;
                    rightNumer = iNumer;
                    break;
                }
                if (!(delta < rightDelta)) continue;
                rightDelta = delta;
                rightDenom = i;
                rightNumer = iNumer;
            }
            denom = String.valueOf(rightDenom);
            numer = String.valueOf(rightNumer);
        }
        StringBuffer sb = new StringBuffer();
        if (this.hasSign() && minus) {
            sb.append('-');
        }
        int repeatIndex = this.getNumer(sb, numer);
        sb.append('/');
        int repeatIndex2 = this.getDenom(sb, denom);
        if (repeatIndex == -1) {
            repeatIndex = repeatIndex2;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    private int getNumer(StringBuffer toAppend, String numer) {
        StringBuilder numerString = new StringBuilder();
        int repeatIndex = -1;
        int numIndex = numer.length() - 1;
        int patternIndex = this._numerPattern.length() - 1;
        for (int i = this._fractionIndex - 1; i >= 0; --i) {
            Node node = (Node)this._nodes.get(i);
            if (node.isNumber()) {
                if (numIndex >= 0) {
                    if (patternIndex <= 0) {
                        for (int j = numIndex; j >= 0; --j) {
                            numerString.append(numer.charAt(j));
                        }
                        numIndex = -1;
                        continue;
                    }
                    char c = numer.charAt(numIndex);
                    if (c == ',') {
                        numerString.append(c);
                        --numIndex;
                    }
                    numerString.append(numer.charAt(numIndex));
                    --numIndex;
                    --patternIndex;
                    continue;
                }
                if (node.getType() == 2) {
                    numerString.append(' ');
                    continue;
                }
                if (node.getType() != 0) continue;
                numerString.append('0');
                continue;
            }
            if (node.getType() == 24) {
                numerString.append(node.getText());
                repeatIndex = numerString.length() - 1;
                continue;
            }
            numerString.append(new StringBuffer(node.getText()).reverse());
        }
        if (repeatIndex != -1) {
            repeatIndex = numerString.length() - 1 - repeatIndex + toAppend.length();
        }
        toAppend.append((CharSequence)numerString.reverse());
        return repeatIndex;
    }

    private int getDenom(StringBuffer toAppend, String denom) {
        StringBuffer denomString = new StringBuffer();
        int repeatIndex = -1;
        if (this._sureDenom) {
            for (int i = this._fractionIndex + 1; i < this._nodes.size(); ++i) {
                Node node = (Node)this._nodes.get(i);
                denomString.append(new StringBuffer(node.getText()));
                if (node.getType() != 24) continue;
                repeatIndex = denomString.length() - 1;
            }
            toAppend.append(denomString);
        } else {
            int numIndex = 0;
            for (int i = this._nodes.size() - 1; i >= this._fractionIndex + 1; --i) {
                Node node = (Node)this._nodes.get(i);
                if (node.isNumber()) {
                    if (numIndex < denom.length()) {
                        denomString.append(denom.charAt(numIndex));
                        ++numIndex;
                        continue;
                    }
                    if (node.getType() == 2) {
                        denomString.append(' ');
                        continue;
                    }
                    if (node.getType() != 0) continue;
                    denomString.append('0');
                    continue;
                }
                if (node.getType() == 24) {
                    denomString.append(node.getText());
                    repeatIndex = denomString.length() - 1;
                    continue;
                }
                denomString.append(new StringBuffer(node.getText()));
            }
            if (repeatIndex != -1) {
                repeatIndex = denomString.length() - 1 - repeatIndex + toAppend.length();
            }
            toAppend.append(denomString);
        }
        return repeatIndex;
    }
}

