/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.digitalstyle;

import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.NumberFormat;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Util;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import java.math.BigDecimal;
import java.util.ArrayList;

class ScienceFormat
extends SimpleFormat {
    int _decimalSepIndex;
    int _decimalSepIndex2;
    boolean _hasGroupSep;
    boolean _hasGroupSep2;
    int _scienceIndex;
    private boolean _hasSign;

    ScienceFormat() {
    }

    void setHasSign(boolean b) {
        this._hasSign = b;
    }

    boolean hasSign() {
        return this._hasSign;
    }

    void setScienceIndex(int index) {
        this._scienceIndex = index;
    }

    void setDecIndex(int index) {
        this._decimalSepIndex = index;
    }

    void setDecIndex2(int index) {
        this._decimalSepIndex2 = index;
    }

    void setHasGroupSep(boolean b) {
        this._hasGroupSep = b;
    }

    void setHasGroupSep2(boolean b) {
        this._hasGroupSep2 = b;
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        int exp;
        if (var == null) {
            return FormatResult.NullResult;
        }
        BigDecimal bg = null;
        try {
            if (parse || var.isNumber() || var.isDate()) {
                bg = var.toBigDecimal();
            }
        }
        catch (SyntaxErrorException e) {
            bg = null;
        }
        if (bg == null) {
            return FormatResult.NullResult;
        }
        boolean minus = bg.signum() < 0;
        bg = bg.abs();
        int scale = bg.scale();
        String val = null;
        if (scale > 0) {
            val = Util.bigDecimalToPlainString(bg.movePointRight(scale));
            exp = val.length() - 1 - scale;
        } else if (scale < 0) {
            val = Util.bigDecimalToPlainString(bg);
            exp = val.length() - 1;
        } else {
            val = Util.bigDecimalToPlainString(bg);
            exp = val.length() - 1 - scale;
        }
        val = val.substring(0, 1) + '.' + val.substring(1);
        StringBuffer sb = new StringBuffer();
        NumberFormat baseFormat = this.createBaseFormat();
        int repeatIndex = baseFormat.formatString(sb, new Variant(new BigDecimal(val)), parse);
        if (this.hasSign() && minus) {
            sb.insert(0, '-');
            if (repeatIndex != -1) {
                ++repeatIndex;
            }
        }
        sb.append('E');
        StringBuffer sb2 = new StringBuffer();
        NumberFormat expFormat = this.createExpFormat();
        int repeatIndex2 = expFormat.formatString(sb2, new Variant(exp), parse);
        if (repeatIndex == -1 && repeatIndex2 != -1) {
            repeatIndex = repeatIndex2 + sb.length();
        }
        sb.append(sb2);
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    private NumberFormat createBaseFormat() {
        NumberFormat nf = new NumberFormat();
        nf.setDecimalSepIndex(this._decimalSepIndex);
        nf.setHasGroupSep(this._hasGroupSep);
        ArrayList al = new ArrayList();
        for (int i = 0; i < this._scienceIndex; ++i) {
            al.add(this._nodes.get(i));
        }
        nf.setNodes(al);
        int ePatternIndex = this._pattern.indexOf(101);
        nf.setPattern(this._pattern.substring(0, ePatternIndex));
        return nf;
    }

    private NumberFormat createExpFormat() {
        NumberFormat nf = new NumberFormat();
        int dsi = this._decimalSepIndex2 == -1 ? -1 : this._decimalSepIndex2 - this._scienceIndex - 1;
        nf.setDecimalSepIndex(dsi);
        nf.setHasSign(true);
        nf.setHasGroupSep(this._hasGroupSep2);
        ArrayList al = new ArrayList();
        for (int i = this._scienceIndex + 1; i < this._nodes.size(); ++i) {
            al.add(this._nodes.get(i));
        }
        nf.setNodes(al);
        int ePatternIndex = this._pattern.indexOf(101);
        nf.setPattern(this._pattern.substring(ePatternIndex + 1, this._pattern.length()));
        return nf;
    }
}

