/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.variant;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class Util {
    public static final ThreadLocal<DateFormat> FMT_DATE = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-M-d");
        }
    };
    public static final ThreadLocal<DateFormat> FMT_DATETIME = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-M-d H:mm");
        }
    };
    public static final ThreadLocal<DateFormat> FMT_FULLDATETIME = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-M-d H:mm:ss");
        }
    };
    public static final ThreadLocal<DateFormat> FMT_TIME = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("H:mm");
        }
    };
    public static final ThreadLocal<DateFormat> FMT_MONTHDAY = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("M-d");
        }
    };
    public static final int MAX_PRECISION = 15;
    public static final int MAX_DATE_PRECISION = 7;
    public static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    public static final BigInteger TEN = BigInteger.valueOf(10L);
    public static final BigDecimal MINI_SECS_OF_DAY = BigDecimal.valueOf(86400000L);
    public static final Calendar BASE_DATE = Calendar.getInstance();
    static final int FALSE = 0;
    static final int TRUE = 1;
    private static final Locale[] locales;
    private static final int[] styles;
    private static final int QUICKPARSE = 0;
    private static final int FULLAFTERQUICK = 2;
    private static final int LOCALESNUMINQUICKPARSE = 4;
    private static final String[] weekFields;
    private static final String[] yearFields;
    private static final String[] monthFields;
    private static final String timeInAmpmFields = "K:m:s";
    private static final String timeInDayFields = "H:m:s";
    private static final String ampmFields = "aa";
    private static final String dayFields = "dd";
    private static final String defaultPattern = "EEE yy MM dd HH:mm:ss";
    private static final int[][] mix;
    private static final String[] dateWeekPatterns;
    private static final String[] datePatterns;
    private static final String[] timeField;
    private static int flag;
    private static Method method;

    static Calendar addCalendar(BigDecimal bd) {
        return Util.addCalendar(BASE_DATE, bd);
    }

    static Calendar addCalendar(Calendar srcCal, BigDecimal bd) {
        Calendar cal = (Calendar)srcCal.clone();
        double num = bd.doubleValue();
        int dates = (int)num;
        double dHours = (num - (double)dates) * 24.0;
        int hours = (int)Math.round(dHours);
        double dMins = (dHours - (double)hours) * 60.0;
        int mins = (int)Math.round(dMins);
        double dSecs = (dMins - (double)mins) * 60.0;
        int secs = (int)Math.round(dSecs);
        cal.add(5, dates - 1);
        cal.add(11, hours);
        cal.add(12, mins);
        cal.add(13, secs);
        cal.add(14, 0);
        cal.setTimeZone(TimeZone.getDefault());
        return cal;
    }

    static int booleanToInt(boolean val) {
        if (val) {
            return 1;
        }
        return 0;
    }

    static char booleanToChar(boolean val) {
        if (val) {
            return 'T';
        }
        return 'F';
    }

    static String booleanToString(boolean val) {
        if (val) {
            return "true";
        }
        return "false";
    }

    public static Number stringToNumber(String str) throws SyntaxErrorException {
        char[] in;
        int kioIndex;
        if (StringUtil.isEmptyString((String)str)) {
            return new BigDecimal(0);
        }
        BigDecimal percent = null;
        int length = str.length();
        if (length > 1 && str.charAt(length - 1) == '%') {
            percent = new BigDecimal(100);
            str = str.substring(0, str.length() - 1);
        }
        if ((kioIndex = str.indexOf(44)) > 0) {
            int i;
            int dotIndex = str.indexOf(46);
            StringBuilder sb = new StringBuilder(str.length());
            if (dotIndex < 0) {
                dotIndex = str.length();
            } else {
                for (i = str.length() - 1; i >= dotIndex; --i) {
                    sb.append(str.charAt(i));
                }
            }
            kioIndex = dotIndex - 4;
            for (i = dotIndex - 1; i >= 0; --i) {
                char c = str.charAt(i);
                if (i == kioIndex) {
                    if (c == ',') {
                        kioIndex -= 4;
                        continue;
                    }
                    kioIndex -= 3;
                    sb.append(c);
                    continue;
                }
                sb.append(c);
            }
            str = sb.reverse().toString();
        }
        if (!Util.isBigDeciaml(in = str.toCharArray(), 0, in.length)) {
            ExprErr.goError(64L, CtrlEXTMessages.getMLS("notNumeric", "\u975e\u6570\u503c"));
        }
        BigDecimal bd = null;
        try {
            bd = new BigDecimal(in, 0, in.length);
        }
        catch (NumberFormatException e2) {
            ExprErr.goError(64L, CtrlEXTMessages.getMLS("notNumeric", "\u975e\u6570\u503c"));
        }
        if (percent != null) {
            bd = bd.divide(percent, 16, 4);
        }
        if (bd.scale() != 0 && str.indexOf(69) == 0 && str.indexOf(101) == 0) {
            bd = bd.setScale(0);
        }
        return bd;
    }

    private static boolean isBigDeciaml(char[] in, int offset, int len) {
        if (offset + len > in.length || offset < 0) {
            return false;
        }
        char c = in[offset];
        if (c == '-' || c == '+') {
            ++offset;
            --len;
        }
        boolean dot = false;
        while (len > 0) {
            c = in[offset];
            if (!(c >= '0' && c <= '9' || Character.isDigit(c))) {
                if (c == '.') {
                    if (dot) {
                        return false;
                    }
                    dot = true;
                } else {
                    if (c == 'e' || c == 'E') {
                        return Util.isBigDeciamlInnerParse(in, offset, len);
                    }
                    return false;
                }
            }
            ++offset;
            --len;
        }
        return true;
    }

    private static boolean isBigDeciamlInnerParse(char[] in, int offset, int len) {
        if (len <= 1) {
            return false;
        }
        char c = in[++offset];
        --len;
        if (c == '-' || c == '+') {
            c = in[++offset];
            --len;
        }
        while (len > 10 && (c == '0' || Character.digit(c, 10) == 0)) {
            c = in[offset++];
            --len;
        }
        if (len > 10) {
            return false;
        }
        while (true) {
            if (!(c >= '0' && c <= '9' || Character.isDigit(c))) {
                return false;
            }
            if (len == 1) break;
            c = in[offset++];
            --len;
        }
        return true;
    }

    public static boolean stringToBoolean(String val) throws SyntaxErrorException {
        if (val.equalsIgnoreCase("true")) {
            return true;
        }
        if (val.equalsIgnoreCase("false")) {
            return false;
        }
        ExprErr.goError(64L, CtrlEXTMessages.getMLS("cannotConvertToBoolean", "\u65e0\u6cd5\u8f6c\u6362\u4e3aBoolean\u7c7b\u578b"));
        return false;
    }

    private static Date stringToDate(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getDateInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                df = DateFormat.getTimeInstance(styles[j], locales[i]);
                df.setLenient(false);
                try {
                    ret = df.parse(src);
                    break block2;
                }
                catch (Exception e) {
                    ret = null;
                    continue;
                }
            }
        }
        return ret;
    }

    private static Date stringToDateTime(String src, int type) {
        Date ret = null;
        DateFormat df = null;
        int localesMax = 0;
        int localeStart = 0;
        if (type == 0) {
            localesMax = 4;
        } else if (type == 2) {
            localeStart = 4;
            localesMax = locales.length;
        } else {
            localesMax = locales.length;
        }
        block2: for (int i = localeStart; i < localesMax; ++i) {
            for (int j = 0; j < styles.length; ++j) {
                for (int k = 0; k < styles.length; ++k) {
                    df = DateFormat.getDateTimeInstance(styles[j], styles[k], locales[i]);
                    df.setLenient(false);
                    try {
                        ret = df.parse(src);
                        break block2;
                    }
                    catch (Exception e) {
                        ret = null;
                        continue;
                    }
                }
            }
        }
        return ret;
    }

    private static String[] getDateWeekPatterns(int dateStyle, int weekStyle) {
        String[] patterns = dateWeekPatterns;
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{weekFields[weekStyle], yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 6; ++i) {
                for (int j = 0; j < 3; ++j) {
                    int n = idates * 6 + i;
                    patterns[n] = patterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 6 + i;
                    patterns[n2] = patterns[n2] + " ";
                }
            }
        }
        return patterns;
    }

    private static String[] getDatePatterns(int dateStyle) {
        String[] patterns = datePatterns;
        String[] dates = new String[]{monthFields[dateStyle] + " " + dayFields, "dd " + monthFields[dateStyle]};
        for (int idates = 0; idates < 2; ++idates) {
            String[] fields = new String[]{null, yearFields[dateStyle], dates[idates]};
            for (int i = 0; i < 2; ++i) {
                for (int j = 1; j < 3; ++j) {
                    int n = idates * 2 + i;
                    patterns[n] = patterns[n] + fields[mix[i][j]];
                    if (j >= 2) continue;
                    int n2 = idates * 2 + i;
                    patterns[n2] = patterns[n2] + " ";
                }
            }
        }
        return patterns;
    }

    static Date stringToDateByPattern(String src) {
        int dateStyle;
        String str = src.replace('.', ' ');
        str = str.replace('-', ' ');
        str = str.replace('/', ' ');
        str = str.replace(',', ' ');
        while (-1 != str.indexOf("  ")) {
            str = str.replaceAll("  ", " ");
        }
        boolean isIncludeTime = false;
        if (-1 != str.indexOf(58, 10)) {
            isIncludeTime = true;
        }
        Date ret = null;
        String[][] ps = new String[9][];
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            ps[dateStyle] = Util.getDatePatterns(dateStyle);
        }
        for (dateStyle = 0; dateStyle < 3; ++dateStyle) {
            for (int weeekStyle = 0; weeekStyle < 2; ++weeekStyle) {
                ps[dateStyle * 2 + weeekStyle + 3] = Util.getDateWeekPatterns(dateStyle, weeekStyle);
            }
        }
        ParsePosition pos = new ParsePosition(0);
        if (isIncludeTime) {
            int i;
            String[] timeFields = timeField;
            String[][] psTime = new String[27][];
            for (i = 0; i < 3; ++i) {
                int k;
                for (k = 0; k < 3; ++k) {
                    psTime[i * 9 + k] = new String[4];
                }
                for (k = 3; k < 9; ++k) {
                    psTime[i * 9 + k] = new String[12];
                }
            }
            for (int k = 0; k < timeFields.length; ++k) {
                for (int i2 = 0; i2 < ps.length; ++i2) {
                    for (int j = 0; j < ps[i2].length; ++j) {
                        psTime[9 * k + i2][j] = ps[i2][j] + " " + timeFields[k];
                    }
                }
            }
            for (i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, psTime, locales[i], pos)) == null; ++i) {
            }
        } else {
            for (int i = 0; i < locales.length && (ret = Util.stringToDateByPattern(str, ps, locales[i], pos)) == null; ++i) {
            }
        }
        return ret;
    }

    private static Date stringToDateByPattern(String src, String[][] patterns, Locale loc, ParsePosition pos) {
        Date ret = null;
        SimpleDateFormat sdf = new SimpleDateFormat(defaultPattern, loc);
        sdf.setLenient(false);
        ret = sdf.parse(src, pos);
        if (ret != null) {
            return ret;
        }
        int i = 0;
        int j = 0;
        block0: for (i = 0; i < patterns.length; ++i) {
            for (j = 0; j < patterns[i].length; ++j) {
                sdf.applyPattern(patterns[i][j]);
                ret = sdf.parse(src, pos);
                if (ret != null) break block0;
            }
        }
        return ret;
    }

    static Date stringToDateEx(String src) {
        DateFormatSymbols dfs = null;
        String[] weekdays = null;
        String str = src.toUpperCase(Locale.ENGLISH);
        String token = null;
        block0: for (int i = 0; i < locales.length; ++i) {
            int k;
            dfs = new DateFormatSymbols(locales[i]);
            weekdays = dfs.getShortWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase(Locale.ENGLISH);
                if (-1 == str.indexOf(token)) continue;
                str = StringUtil.replaceFirst((String)str, (String)token, (String)"");
                str = str.trim();
                break block0;
            }
            weekdays = dfs.getWeekdays();
            for (k = 1; k < weekdays.length; ++k) {
                token = weekdays[k].toUpperCase(Locale.ENGLISH);
                if (-1 == str.indexOf(token)) continue;
                str = StringUtil.replaceFirst((String)str, (String)token, (String)"");
                str = str.trim();
                break block0;
            }
        }
        Date ret = null;
        if (src.length() > 10) {
            ret = Util.stringToDateTime(src, 0);
            if (ret == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    public static Date stringToDate(String src) {
        Date ret = null;
        if (src.length() > 10) {
            try {
                ret = FMT_FULLDATETIME.get().parse(src);
            }
            catch (ParseException e) {
                try {
                    ret = FMT_DATETIME.get().parse(src);
                }
                catch (ParseException e2) {
                    try {
                        ret = FMT_DATE.get().parse(src);
                    }
                    catch (ParseException e3) {
                        ret = null;
                    }
                }
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDate(src, 0)) == null) {
                ret = Util.stringToTime(src, 0);
            }
            if (ret == null && (ret = Util.stringToDate(src, 2)) == null) {
                ret = Util.stringToTime(src, 2);
            }
        } else {
            ret = Util.stringToDate(src, 0);
            if (ret == null) {
                ret = Util.stringToDate(src, 2);
            }
            if (ret == null && (ret = Util.stringToTime(src, 0)) == null) {
                ret = Util.stringToTime(src, 2);
            }
            if (ret == null && (ret = Util.stringToDateTime(src, 0)) == null) {
                ret = Util.stringToDateTime(src, 2);
            }
        }
        return ret;
    }

    static void add(byte left, byte right, Variant result) {
        int ret = left + right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void add(short left, short right, Variant result) {
        int ret = left + right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void add(int left, int right, Variant result) {
        long ret = (long)left + (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void add(long left, long right, Variant result) {
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    static final void add(float left, float right, Variant result) {
        float ret = left + right;
        if (ArrayUtil.isEqual((Float)Float.valueOf(ret), (Float)Float.valueOf(Float.POSITIVE_INFINITY)) || ArrayUtil.isEqual((Float)Float.valueOf(ret), (Float)Float.valueOf(Float.NEGATIVE_INFINITY))) {
            Util.add((double)left, (double)right, result);
        } else {
            result.setFloat(ret);
        }
    }

    static final void add(double left, double right, Variant result) {
        double ret = left + right;
        result.setDouble(ret);
    }

    static final void subtract(byte left, byte right, Variant result) {
        int ret = left - right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void subtract(short left, short right, Variant result) {
        int ret = left - right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void subtract(int left, int right, Variant result) {
        long ret = (long)left - (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void subtract(long left, long right, Variant result) {
        right = -right;
        long ret = left + right;
        if ((left ^ right) >= 0L) {
            if (left > 0L && ret < 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = 0;
                result.setObject(new BigInteger(bta), 9);
            } else if (left < 0L && ret >= 0L) {
                byte[] bta = new byte[9];
                bta[8] = (byte)ret;
                for (int i = 7; i > 0; --i) {
                    bta[i] = (byte)(ret >>= 8);
                }
                bta[0] = -1;
                result.setObject(new BigInteger(bta), 9);
            } else {
                result.setLong(ret);
            }
        } else {
            result.setLong(ret);
        }
    }

    static void subtract(float left, float right, Variant result) {
        float ret = left - right;
        if (ArrayUtil.isEqual((Float)Float.valueOf(ret), (Float)Float.valueOf(Float.POSITIVE_INFINITY)) || ArrayUtil.isEqual((Float)Float.valueOf(ret), (Float)Float.valueOf(Float.NEGATIVE_INFINITY))) {
            Util.subtract((double)left, (double)right, result);
        } else {
            result.setFloat(ret);
        }
    }

    static final void subtract(double left, double right, Variant result) {
        double ret = left - right;
        result.setDouble(ret);
    }

    static void multiply(byte left, byte right, Variant result) {
        int ret = left * right;
        if (ret != (byte)ret) {
            result.setShort((short)ret);
        } else {
            result.setByte((byte)ret);
        }
    }

    static void multiply(short left, short right, Variant result) {
        int ret = left * right;
        if (ret != (short)ret) {
            result.setInt(ret);
        } else {
            result.setShort((short)ret);
        }
    }

    static void multiply(int left, int right, Variant result) {
        long ret = (long)left * (long)right;
        if (ret != (long)((int)ret)) {
            result.setLong(ret);
        } else {
            result.setInt((int)ret);
        }
    }

    static void multiply(long left, long right, Variant result) {
        if (left == 1L) {
            result.setLong(right);
        } else if (right == 1L) {
            result.setLong(left);
        } else {
            double dfValue = (double)left * (double)right;
            long lValue = left * right;
            if (Math.abs(dfValue) > (double)Math.abs(lValue)) {
                result.setDouble(dfValue);
            } else {
                result.setLong(lValue);
            }
        }
    }

    static void multiply(float left, float right, Variant result) {
        float ret = left * right;
        result.setFloat(ret);
    }

    static void multiply(double left, double right, Variant result) {
        double ret = left * right;
        result.setDouble(ret);
    }

    static void divide(byte left, byte right, Variant result) {
        int ret = left / right;
        result.setByte((byte)ret);
    }

    static void divide(short left, short right, Variant result) {
        int ret = left / right;
        result.setShort((short)ret);
    }

    static void divide(int left, int right, Variant result) {
        int ret = left / right;
        result.setInt(ret);
    }

    static void divide(long left, long right, Variant result) {
        long ret = left / right;
        result.setLong(ret);
    }

    static void divide(float left, float right, Variant result) {
        float ret = left / right;
        result.setFloat(ret);
    }

    static void divide(double left, double right, Variant result) {
        double ret = left / right;
        result.setDouble(ret);
    }

    static void mod(byte left, byte right, Variant result) {
        result.setByte((byte)(left % right));
    }

    static void mod(short left, short right, Variant result) {
        result.setShort((short)(left % right));
    }

    static void mod(int left, int right, Variant result) {
        result.setInt(left % right);
    }

    static void mod(long left, long right, Variant result) {
        result.setLong(left % right);
    }

    static void mod(float left, float right, Variant result) {
        result.setFloat(left % right);
    }

    static void mod(double left, double right, Variant result) {
        result.setDouble(left % right);
    }

    static void and(byte left, byte right, Variant result) {
        result.setByte((byte)(left & right));
    }

    static void and(short left, short right, Variant result) {
        result.setShort((short)(left & right));
    }

    static void and(int left, int right, Variant result) {
        result.setInt(left & right);
    }

    static void and(long left, long right, Variant result) {
        result.setLong(left & right);
    }

    static void and(float left, float right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    static void and(double left, double right, Variant result) {
        result.setLong((long)left & (long)right);
    }

    static void or(byte left, byte right, Variant result) {
        result.setByte((byte)(left | right));
    }

    static void or(short left, short right, Variant result) {
        result.setShort((short)(left | right));
    }

    static void or(int left, int right, Variant result) {
        result.setInt(left | right);
    }

    static void or(long left, long right, Variant result) {
        result.setLong(left | right);
    }

    static void or(float left, float right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    static void or(double left, double right, Variant result) {
        result.setLong((long)left | (long)right);
    }

    static void xor(byte left, byte right, Variant result) {
        result.setByte((byte)(left ^ right));
    }

    static void xor(short left, short right, Variant result) {
        result.setShort((short)(left ^ right));
    }

    static void xor(int left, int right, Variant result) {
        result.setInt(left ^ right);
    }

    static void xor(long left, long right, Variant result) {
        result.setLong(left ^ right);
    }

    static void xor(float left, float right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    static void xor(double left, double right, Variant result) {
        result.setLong((long)left ^ (long)right);
    }

    public static BigDecimal reduceScale(BigDecimal bd) {
        BigInteger intval = bd.unscaledValue();
        int ns = 0;
        int scale = bd.scale();
        if (intval.signum() != 0) {
            int i;
            String str = intval.toString();
            int len = str.length();
            int end = len - scale;
            for (i = len - 1; i >= end && str.charAt(i) == '0'; --i) {
            }
            ns = scale - (len - 1 - i);
        }
        if (ns != scale) {
            bd = bd.setScale(ns);
        }
        return bd;
    }

    public static void reduceScale(Variant var) {
        if (var.getVt() == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            BigInteger intval = bd.unscaledValue();
            int ns = 0;
            int scale = bd.scale();
            if (intval.signum() != 0) {
                int i;
                String str = intval.toString();
                int len = str.length();
                int end = len - scale;
                for (i = len - 1; i >= end && str.charAt(i) == '0'; --i) {
                }
                ns = scale - (len - 1 - i);
            }
            if (ns != scale) {
                bd = bd.setScale(ns);
                var.setObject(bd, 10);
            }
        }
    }

    public static String bigDecimalToPlainString(BigDecimal number) {
        if (flag == 0) {
            Class<?> cls = number.getClass();
            try {
                method = cls.getMethod("toPlainString", null);
            }
            catch (SecurityException e) {
                method = null;
            }
            catch (NoSuchMethodException e) {
                method = null;
            }
            ++flag;
        }
        if (method != null) {
            try {
                return (String)method.invoke((Object)number, null);
            }
            catch (IllegalArgumentException e) {
                return number.toString();
            }
            catch (IllegalAccessException e) {
                return number.toString();
            }
            catch (InvocationTargetException e) {
                return number.toString();
            }
        }
        return number.toString();
    }

    public static long getMillis(Calendar cal) {
        return cal.getTimeInMillis() - BASE_DATE.getTimeInMillis();
    }

    public static void main(String[] args) throws SyntaxErrorException {
        System.out.println(Util.stringToNumber(""));
        System.out.println(Util.stringToNumber("000001"));
        System.out.println(Util.stringToNumber("-0"));
        System.out.println(Util.stringToNumber("+0"));
        System.out.println(Util.stringToNumber("0.1"));
        System.out.println(Util.stringToNumber("-0.1"));
        System.out.println(Util.stringToNumber("+0.1"));
        System.out.println(Util.stringToNumber("+1,000"));
        System.out.println(Util.stringToNumber("-1,000"));
        System.out.println(Util.stringToNumber("+1,000.1"));
        System.out.println(Util.stringToNumber("-1,000.1"));
        System.out.println(Util.stringToNumber("-1,000.1E+10"));
        System.out.println(Util.stringToNumber("-1,000.1E-10"));
        System.out.println(Util.stringToNumber("0%"));
        System.out.println(Util.stringToNumber("-0%"));
        System.out.println(Util.stringToNumber("+0%"));
        System.out.println(Util.stringToNumber("0.1%"));
        System.out.println(Util.stringToNumber("-0.1%"));
        System.out.println(Util.stringToNumber("+0.1%"));
        System.out.println(Util.stringToNumber("+1,000%"));
        System.out.println(Util.stringToNumber("-1,000%"));
        System.out.println(Util.stringToNumber("+1,000.1%"));
        System.out.println(Util.stringToNumber("-1,000.1%"));
        System.out.println(Util.stringToNumber("123.4e2"));
    }

    static {
        BASE_DATE.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        BASE_DATE.set(14, 0);
        BASE_DATE.set(1900, 0, 0, 0, 0, 0);
        BASE_DATE.getTimeInMillis();
        locales = new Locale[]{Locale.getDefault(), Locale.US, Locale.UK, Locale.CHINA, Locale.TAIWAN, Locale.ENGLISH, Locale.SIMPLIFIED_CHINESE, Locale.TRADITIONAL_CHINESE, Locale.CHINESE, Locale.PRC};
        styles = new int[]{3, 2, 1, 0};
        weekFields = new String[]{"EEE", "EEEE"};
        yearFields = new String[]{"yy", "yyyy", "yyyy"};
        monthFields = new String[]{"MM", "MMM", "MMMM"};
        mix = new int[][]{{0, 1, 2}, {0, 2, 1}, {1, 2, 0}, {2, 1, 0}, {1, 0, 2}, {2, 0, 1}};
        dateWeekPatterns = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        datePatterns = new String[]{"", "", "", ""};
        timeField = new String[]{"K:m:s aa", timeInDayFields, "aaK:m:s"};
        flag = 0;
    }
}

