/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.variant;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.ArrayUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.VarBase;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import java.math.BigDecimal;
import java.util.Calendar;

class VarCalendar
extends VarBase {
    VarCalendar() {
    }

    @Override
    protected void add(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        BigDecimal bd = Variant.calendarToDecimal(cal).add(right.toBigDecimal());
        result.setObject(Variant.decimalToCalender(bd), 13);
    }

    @Override
    protected void subtract(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        Calendar cal = (Calendar)left.getValue();
        BigDecimal bd = Variant.calendarToDecimal(cal).subtract(right.toBigDecimal());
        result.setObject(Variant.decimalToCalender(bd), 13);
    }

    @Override
    protected void multiply(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        BigDecimal days = left.toBigDecimal().multiply(right.toBigDecimal());
        days = days.setScale(7, 4);
        if (right.isNumber()) {
            result.setObject(Variant.decimalToCalender(days), 13);
        } else {
            result.setObject(days, 10);
        }
    }

    @Override
    protected void divide(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        BigDecimal bdRight = right.toBigDecimal();
        if (ArrayUtil.isEqual((Double)bdRight.doubleValue(), (Double)0.0)) {
            ExprErr.goError(2L, null);
        }
        BigDecimal days = left.toBigDecimal().divide(bdRight, 7, 4);
        result.setObject(days, 10);
    }

    @Override
    protected void mod(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        double dfRight = right.doubleValue();
        if (ArrayUtil.isEqual((Double)dfRight, (Double)0.0)) {
            throw new SyntaxErrorException(2L, null);
        }
        BigDecimal bd = BigDecimal.valueOf(left.doubleValue() % dfRight);
        if (right.isNumber()) {
            result.setObject(Variant.decimalToCalender(bd), 13);
        } else {
            result.setObject(bd, 10);
        }
    }

    @Override
    protected void and(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, CtrlEXTMessages.getMLS("unsupportedDataTypeOperationType", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void or(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, CtrlEXTMessages.getMLS("unsupportedDataTypeOperationType", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }

    @Override
    protected void xor(Variant left, Variant right, Variant result) throws SyntaxErrorException {
        ExprErr.goError(64L, CtrlEXTMessages.getMLS("unsupportedDataTypeOperationType", "\u4e0d\u652f\u6301\u8be5\u6570\u636e\u7c7b\u578b\u8fd0\u7b97"));
    }
}

