/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.core;

import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.core.SpreadViewUI;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;

public class OutlineGroupRowHeaderUI
extends SpreadViewUI {
    private static OutlineGroupRowHeaderUI outlineGroupRowHeaderUI = new OutlineGroupRowHeaderUI();
    private SpreadView _view;
    private Graphics2D _g2d;
    private Sheet _sheet;
    private int _sizeOfRows;
    private SpreadView.RowBuffer[] _rbs;
    private int _rinx;
    private int _rinx2;

    @Override
    protected void installDefaults(SpreadView view) {
        view.setAutoscrolls(true);
    }

    public static ComponentUI createUI(JComponent c2) {
        return outlineGroupRowHeaderUI;
    }

    @Override
    public Dimension getPreferredSize(JComponent c2) {
        return OutlineGroupRowHeaderUI.getSize((SpreadView)c2);
    }

    public static Dimension getSize(SpreadView view) {
        int w;
        Book book = view.getSpread().getBook();
        boolean isShowInlined = false;
        UserObject uo = book.getUserObject("SHOW_TREE_GROUP");
        if (uo != null) {
            isShowInlined = Boolean.parseBoolean(uo.getValue().toString());
        }
        Sheet sheet = book.getActiveSheet();
        if (!isShowInlined && sheet.getUserObject("COLUMN_INLINED_TREE_POSITION") != null) {
            return new Dimension(0, 0);
        }
        SortedAttributeSpanArray sasa = view.getSpread().getBook().getActiveSheet().getRowSpans();
        int depth = 0;
        for (int i = 0; i < sasa.size(); ++i) {
            int level = ((SortedAttributeSpanArray.AttributeSpan)sasa.get(i)).getOutlineGroupLevel();
            depth = level > depth ? level : depth;
        }
        int n = w = depth == 0 ? 0 : (depth + 1) * 15 + 8;
        if (w == 0) {
            return null;
        }
        return new Dimension(w, view.getPreferredHeight());
    }

    @Override
    protected boolean prePaint(Graphics2D g, SpreadView view) {
        int i;
        this._g2d = g;
        this._view = view;
        this._sheet = view.getSpread().getBook().getActiveSheet();
        Rectangle clip = this._g2d.getClipBounds();
        Point upperLeft = clip.getLocation();
        Point lowerRight = new Point(clip.x + clip.width - 1, clip.y + clip.height - 1);
        int cRow = SheetBaseMath.rowAtPoint(this._sheet, upperLeft);
        int cRow2 = SheetBaseMath.rowAtPoint(this._sheet, lowerRight);
        if (cRow < 0) {
            return false;
        }
        cRow2 = SheetBaseMath.dealInvalidRow(cRow2);
        this._rbs = this._view.getRowBuffers(cRow, cRow2);
        if (this._rbs == null) {
            return false;
        }
        this._sizeOfRows = this._rbs.length;
        for (i = 0; i < this._sizeOfRows; ++i) {
            if (cRow > this._rbs[i].getRow()) continue;
            this._rinx = i;
            break;
        }
        for (i = this._sizeOfRows - 1; i >= 0; --i) {
            if (cRow2 < this._rbs[i].getRow()) continue;
            this._rinx2 = i;
            break;
        }
        return true;
    }

    @Override
    protected void paintBase(Graphics2D g, SpreadView view) {
    }

    @Override
    protected void afterPaint(Graphics2D g, SpreadView view) {
        view.setPreferredSize(OutlineGroupRowHeaderUI.getSize(view));
        this._view = null;
        this._g2d = null;
        this._rbs = null;
        this._sheet = null;
    }
}

