/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.IPreCondition;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellPropAction;
import java.util.Map;
import java.util.WeakHashMap;

class CellPropAction_HyperLink
extends CellPropAction {
    private static final WeakHashMap _hyperLinks = new WeakHashMap();

    private static synchronized HyperLink getHyperLink(String linkString) {
        Object obj = _hyperLinks.get(linkString);
        if (obj == null) {
            obj = new HyperLink(null, linkString);
            _hyperLinks.put(linkString, obj);
        }
        return (HyperLink)obj;
    }

    CellPropAction_HyperLink(int intKey, String strKey) {
        super(intKey, strKey);
    }

    @Override
    public void action(Cell cll, Variant value) {
        HyperlinkCalculableProps prop = (HyperlinkCalculableProps)value.getValue();
        String linkString = prop.getLinkString();
        boolean hyper = true;
        ExprContext ctx = cll.getSheet().getDeps().getExprContext();
        ExtProps props = cll.getExtProps(false);
        SortedExtPropFormulasArray formulas = props.getFormulas(false);
        Map<String, Object> hypers = ((HyperlinkCalculableProps)formulas.get(ExtConst.FORMULA_HYPERLINK)).getTargets();
        boolean hasInner = false;
        if (hypers != null) {
            IPreCondition condition;
            Object obj = hypers.get("EXT_INNER");
            if (obj != null) {
                hasInner = true;
                if (hypers.size() == 1) {
                    condition = (IPreCondition)obj;
                    StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                    sa.setFontColor(condition.getBehaviorFontColor());
                    cll.setSSA((ShareStyleAttributes)sa);
                }
            }
            if ((obj = hypers.get("EXTRPT")) != null || (obj = hypers.get("EXTERNAL")) != null) {
                condition = (IPreCondition)obj;
                Expr expr = condition.getBehaviorAction();
                Variant v = CellPropAction_HyperLink.executeBehavior(ctx, expr, cll);
                try {
                    if (v != null) {
                        hyper = v.booleanValue();
                    }
                    if (!hyper) {
                        StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
                        sa.setFontColor(condition.getBehaviorFontColor());
                        cll.setSSA((ShareStyleAttributes)sa);
                    }
                }
                catch (SyntaxErrorException ex) {
                    hyper = true;
                }
                obj = hypers.get("EXTERNAL");
                if (obj != null) {
                    ((ExternalTargets)obj).calc(ctx, cll);
                }
            }
        }
        if (!StringUtil.isEmptyString((String)linkString) && (hyper || hasInner)) {
            if (!hyper) {
                linkString = "rptInner:";
            }
            if (cll.getHyperLink() == null) {
                this.hyperLink(cll, CellPropAction_HyperLink.getHyperLink(linkString));
            } else {
                HyperLink link = new HyperLink();
                String linkTo = CellPropAction_HyperLink.getHyperLink(linkString).getLinkTo();
                if (linkTo.charAt(linkTo.length() - 1) == ';') {
                    link.setLinkTo(linkTo + cll.getHyperLink().getLinkTo());
                } else {
                    link.setLinkTo(linkTo + ";" + cll.getHyperLink().getLinkTo());
                }
                cll.setHyperLink(null);
                this.hyperLink(cll, link);
            }
        }
    }

    static Variant executeBehavior(ExprContext ctx, Expr expr, Cell cll) {
        Variant v = null;
        if (expr == null) {
            return v;
        }
        boolean traceMode = ctx.isTraceMode();
        ctx.setTraceMode(false);
        if (ctx.isCalcLastMode()) {
            ctx.setCalcLastMode(false);
            v = expr.execute(ctx, null).getVariant();
            ctx.setCalcLastMode(true);
        } else {
            v = expr.execute(ctx, cll).getVariant();
        }
        ctx.setTraceMode(traceMode);
        return v;
    }
}

