/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.collection;

import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SBT;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SBTNode;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SBTQueue;
import java.util.Iterator;

public class SBTIterator
implements Iterator {
    private SBT _tree;
    private SBTNode _currentNode;
    private SBTQueue _queue;

    public SBTIterator(SBT tree) {
        this._tree = tree;
        this._currentNode = null;
        this._queue = new SBTQueue();
    }

    @Override
    public boolean hasNext() {
        return !this._queue.isEmpty();
    }

    public Object next() {
        this._currentNode = (SBTNode)this._queue.dequeue();
        return this._currentNode.getKey();
    }

    @Override
    public void remove() {
        this._tree.delete(this._currentNode.getKey());
    }

    public void setPreorder() {
        this._queue.dequeueAll();
        this.preorder(this._tree._root);
    }

    public void setInorder() {
        this._queue.dequeueAll();
        this.inorder(this._tree._root);
    }

    public void setPostorder() {
        this._queue.dequeueAll();
        this.postorder(this._tree._root);
    }

    private void preorder(SBTNode treeNode) {
        if (treeNode != null) {
            this._queue.enqueue(treeNode);
            this.preorder(treeNode.getLeft());
            this.preorder(treeNode.getRight());
        }
    }

    private void inorder(SBTNode treeNode) {
        if (treeNode != null) {
            this.inorder(treeNode.getLeft());
            this._queue.enqueue(treeNode);
            this.inorder(treeNode.getRight());
        }
    }

    private void postorder(SBTNode treeNode) {
        if (treeNode != null) {
            this.postorder(treeNode.getLeft());
            this.postorder(treeNode.getRight());
            this._queue.enqueue(treeNode);
        }
    }
}

