/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.AbstractExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.LocalExtFileWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.AbstractExtFileType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.ExtInputStream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.LocalFileQingInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public abstract class AbstractLocalExtFile
extends AbstractExtFile {
    private static Logger log = LogUtil.getPackageLogger(AbstractLocalExtFile.class);
    protected String DIRECTORY_PATH = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator + this.getRootDir() + File.separator);
    protected File file;

    private static void createRootDir() {
        String tempDirPath = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator);
        File tempDir = new File(FilenameUtils.normalize((String)tempDirPath));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    public AbstractLocalExtFile(AbstractExtFileType fileType) {
        super(fileType);
        FileSysUtil.createAbsolutePathDir(this.DIRECTORY_PATH);
        String fullPath = this.getFullPath();
        this.file = new File(FilenameUtils.normalize((String)fullPath));
    }

    protected AbstractLocalExtFile(AbstractExtFileType fileType, String name) {
        super(fileType, name);
        FileSysUtil.createAbsolutePathDir(this.DIRECTORY_PATH);
        String fullPath = this.getFullPath();
        this.file = new File(FilenameUtils.normalize((String)fullPath));
    }

    public abstract String getRootDir();

    public String getFullPath() {
        return this.getFullPath(this.getPath());
    }

    public String getFullPath(String filePath) {
        return this.checkPath(this.DIRECTORY_PATH + filePath);
    }

    private String checkPath(String path) {
        return path.replace("../", "#");
    }

    @Override
    public boolean exists() {
        if (this.getName() == null || "".equals(this.getName().trim())) {
            return false;
        }
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    @Override
    public long getLength() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file.length();
    }

    @Override
    public long getLastModifiedTimes() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file.lastModified();
    }

    @Override
    public File getLocalFileSystemFile() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file;
    }

    @Override
    public String getLocalFullPath() throws IOException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return this.file.getCanonicalPath();
    }

    @Override
    protected boolean doCreateNewFile() throws IOException {
        File parentFile = this.file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return this.file.createNewFile();
    }

    @Override
    protected boolean doDelete() {
        if (this.exists()) {
            if (this.delFile(this.file)) {
                this.file = null;
                return true;
            }
            log.error((Object)("delete file fail, fileName:" + this.file.getPath()));
        } else if (this.file != null) {
            log.error((Object)("delete file is not exists, fileName:" + this.file.getPath()));
        }
        return false;
    }

    private boolean delFile(File file) {
        try {
            if (file.exists()) {
                File[] children;
                if (file.isDirectory() && (children = file.listFiles()) != null) {
                    for (File child : children) {
                        this.delFile(child);
                    }
                }
                if (!file.delete()) {
                    log.warn((Object)(file.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
                }
            }
            return true;
        }
        catch (Exception e) {
            log.error((Object)("delFile occur some error:" + e.getMessage()));
            return false;
        }
    }

    @Override
    public ExtInputStream getInputStream() throws FileNotFoundException {
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        return new ExtInputStream(this.file.length(), new LocalFileQingInputStream(this.file));
    }

    @Override
    protected IExtFileWriter doCreateWriter() {
        return new LocalExtFileWriter(this.getFullPath());
    }

    static {
        AbstractLocalExtFile.createRootDir();
    }
}

