/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.AbstractFileFilter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.LocalTempExtFile;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class DirUtil {
    private static Logger log = LogUtil.getPackageLogger(DirUtil.class);

    public static boolean delFolder(String path, AbstractFileFilter filter) {
        DirUtil.delAllFile(path, filter);
        File file = new File(FilenameUtils.normalize((String)path));
        return file.delete();
    }

    public static boolean delOverdueFileAndCacheOthers(String folderPath, AbstractFileFilter filter) {
        boolean flag = false;
        File file = new File(FilenameUtils.normalize((String)folderPath));
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = folderPath.endsWith(File.separator) ? new File(FilenameUtils.normalize((String)(folderPath + tempList[i]))) : new File(FilenameUtils.normalize((String)(folderPath + File.separator + tempList[i])));
            if (temp.isFile()) {
                if (null != filter) {
                    if (filter.check(temp)) {
                        DirUtil.delFileAndLog(temp);
                    } else {
                        try {
                            LocalTempExtFile.addTempFileCache(temp.getCanonicalPath());
                        }
                        catch (IOException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                    }
                } else {
                    DirUtil.delFileAndLog(temp);
                }
            }
            if (!temp.isDirectory()) continue;
            DirUtil.delAllFile(folderPath + File.separator + tempList[i], filter);
            DirUtil.delFolder(folderPath + File.separator + tempList[i], filter);
            flag = true;
        }
        return flag;
    }

    public static boolean delAllFile(String folderPath, AbstractFileFilter filter) {
        boolean flag = false;
        File file = new File(FilenameUtils.normalize((String)folderPath));
        if (!file.exists()) {
            return flag;
        }
        if (!file.isDirectory()) {
            return flag;
        }
        String[] tempList = file.list();
        File temp = null;
        for (int i = 0; i < tempList.length; ++i) {
            temp = folderPath.endsWith(File.separator) ? new File(FilenameUtils.normalize((String)(folderPath + tempList[i]))) : new File(FilenameUtils.normalize((String)(folderPath + File.separator + tempList[i])));
            if (temp.isFile()) {
                if (null != filter) {
                    if (filter.check(temp)) {
                        DirUtil.delFileAndLog(temp);
                    }
                } else {
                    DirUtil.delFileAndLog(temp);
                }
            }
            if (!temp.isDirectory()) continue;
            DirUtil.delAllFile(folderPath + File.separator + tempList[i], filter);
            DirUtil.delFolder(folderPath + File.separator + tempList[i], filter);
            flag = true;
        }
        return flag;
    }

    public static void renameTo(File oldDir, String newPath) {
        File[] childFiles;
        File newDir = new File(FilenameUtils.normalize((String)newPath));
        if (!newDir.exists()) {
            if (!oldDir.renameTo(newDir)) {
                log.warn((Object)(oldDir.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            return;
        }
        if (newDir.isFile()) {
            return;
        }
        for (File childFile : childFiles = oldDir.listFiles()) {
            String newChildFileName = newPath + File.separator + childFile.getName();
            log.info((Object)("rename file " + childFile.getPath() + " to " + newChildFileName));
            DirUtil.renameTo(childFile, newChildFileName);
        }
    }

    private static void delFileAndLog(File file) {
        log.info((Object)("delete file " + file.getPath()));
        if (!file.delete()) {
            log.warn((Object)(file.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
        }
    }

    public static void moveDir(String sourcePath, String newPath) throws IOException {
        DirUtil.copyDir(sourcePath, newPath);
        DirUtil.delFolder(sourcePath, null);
    }

    public static void copyDir(String sourcePath, String newPath) throws IOException {
        File file = new File(FilenameUtils.normalize((String)sourcePath));
        String[] filePath = file.list();
        if (!new File(FilenameUtils.normalize((String)newPath)).exists()) {
            new File(FilenameUtils.normalize((String)newPath)).mkdir();
        }
        for (int i = 0; i < filePath.length; ++i) {
            if (new File(FilenameUtils.normalize((String)(sourcePath + File.separator + filePath[i]))).isDirectory()) {
                DirUtil.copyDir(sourcePath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
            }
            if (!new File(FilenameUtils.normalize((String)(sourcePath + File.separator + filePath[i]))).isFile()) continue;
            DirUtil.copyFile(sourcePath + File.separator + filePath[i], newPath + File.separator + filePath[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String oldPath, String newPath) throws IOException {
        File oldFile = new File(FilenameUtils.normalize((String)oldPath));
        File file = new File(FilenameUtils.normalize((String)newPath));
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(oldFile);
            out = new FileOutputStream(file);
            byte[] buffer = new byte[10240];
            int readByte = 0;
            while ((readByte = in.read(buffer)) != -1) {
                out.write(buffer, 0, readByte);
            }
        }
        catch (Throwable throwable) {
            CloseUtil.close(in, out);
            throw throwable;
        }
        CloseUtil.close(in, out);
    }
}

