/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.SystemPropertyUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileUpdater;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.AbstractLocalExtFile;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.DirUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.FileSysUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.filter.FileOverdueFilter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.AbstractExtFileType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtTempFileType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class LocalTempExtFile
extends AbstractLocalExtFile {
    private static Logger log = LogUtil.getPackageLogger(LocalTempExtFile.class);
    private static final String TEMPDIR = "QingTemp";
    private static ConcurrentHashMap<String, TTLEntry> cache = new ConcurrentHashMap();
    private static ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    public static final long ttlIntervalMillis = TimeUnit.HOURS.toMillis(SystemPropertyUtil.getLong((String)"ext.localtempfile.ttl", (long)12L));

    public static void stop() {
        scheduler.shutdown();
    }

    private static void cleanup() {
        Iterator<Map.Entry<String, TTLEntry>> iterator = cache.entrySet().iterator();
        ArrayList<String> fileToRemove = new ArrayList<String>(cache.size());
        while (iterator.hasNext()) {
            Map.Entry<String, TTLEntry> entry = iterator.next();
            if (entry.getValue().isLive()) continue;
            iterator.remove();
            fileToRemove.add(entry.getKey());
        }
        for (String file : fileToRemove) {
            if (new File(FilenameUtils.normalize((String)file)).delete()) continue;
            log.error((Object)("QingLocalTempFile remove file " + file + " failed!"), null);
        }
    }

    public LocalTempExtFile(ExtTempFileType fileType) {
        super(fileType);
        String fullPath = this.getFullPath();
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    private LocalTempExtFile(ExtTempFileType fileType, String name) {
        super(fileType, name);
        String fullPath = this.getFullPath();
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    @Override
    public String getRootDir() {
        return TEMPDIR;
    }

    @Override
    protected boolean doDelete() {
        if (super.doDelete()) {
            cache.remove(this.getFullPath());
            return true;
        }
        return false;
    }

    @Override
    public IExtFileUpdater findFile(AbstractExtFileType fileType, String name) {
        return new LocalTempExtFile((ExtTempFileType)fileType, name);
    }

    public static void addTempFileCache(String fullPath) {
        TTLEntry entry = new TTLEntry(ttlIntervalMillis);
        TTLEntry entry2 = cache.putIfAbsent(fullPath, entry);
        if (entry2 != null) {
            entry = entry2;
            entry.updateTTL(ttlIntervalMillis);
        }
    }

    static {
        Runnable cleanResidualTempTask = new Runnable(){

            @Override
            public void run() {
                File[] childDirs;
                String tempDirPath = FileSysUtil.getAbsoluteFilePath(File.separator + "QingStorage" + File.separator + LocalTempExtFile.TEMPDIR + File.separator);
                File tempDir = new File(FilenameUtils.normalize((String)tempDirPath));
                if (!tempDir.exists()) {
                    return;
                }
                for (File childDir : childDirs = tempDir.listFiles()) {
                    FileOverdueFilter filter = new FileOverdueFilter();
                    DirUtil.delOverdueFileAndCacheOthers(tempDirPath + childDir.getName(), filter);
                }
            }
        };
        scheduler.execute(cleanResidualTempTask);
        Runnable cleanupTask = new Runnable(){

            @Override
            public void run() {
                LocalTempExtFile.cleanup();
            }
        };
        scheduler.scheduleAtFixedRate(cleanupTask, ttlIntervalMillis, ttlIntervalMillis, TimeUnit.MILLISECONDS);
    }

    private static class TTLEntry {
        private long ttl;

        public TTLEntry(long ttl) {
            this.updateTTL(ttl);
        }

        public boolean isLive() {
            return this.ttl > System.currentTimeMillis();
        }

        public void updateTTL(long ttl) {
            this.ttl = System.currentTimeMillis() + ttl;
        }
    }
}

