/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.SeekableInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class LocalFileQingInputStream
extends SeekableInputStream {
    private BufferedInputStream bufferedInputStream;
    private FileInputStream fileInputStream;

    public LocalFileQingInputStream(File file) throws FileNotFoundException {
        this.fileInputStream = new FileInputStream(file);
        this.bufferedInputStream = new BufferedInputStream(this.fileInputStream);
    }

    @Override
    public void seek(long position) throws IOException {
        this.fileInputStream.getChannel().position(position);
        this.bufferedInputStream = null;
        this.bufferedInputStream = new BufferedInputStream(this.fileInputStream);
    }

    @Override
    public int read() throws IOException {
        return this.bufferedInputStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.bufferedInputStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.bufferedInputStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.bufferedInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.bufferedInputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.bufferedInputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.bufferedInputStream.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.bufferedInputStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.bufferedInputStream.markSupported();
    }
}

