/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.spec;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.localimpl.DirUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.IExtDataWriter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.api.IExtDataIterator;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.AbstractExtDataException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.ExtDataPersistenceException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public abstract class AbstractExtDataIterator
implements IExtDataIterator {
    private static Logger log = LogUtil.getPackageLogger(DirUtil.class);
    protected ExtMetaInfo _extMetaInfo;
    protected List<Integer> _interestingFieldIndexs = new ArrayList<Integer>(8);
    protected Set<Integer> _interestingRowIDFieldIndexs = new HashSet<Integer>(8);
    private IExtDataWriter _dataSourceWriter;
    private Exception _exception;
    private long _currentRowIndex = 0L;

    public AbstractExtDataIterator(ExtMetaInfo extMetaInfo) {
        this._extMetaInfo = extMetaInfo;
    }

    @Override
    public final void init(Set<String> fields) throws AbstractExtDataException, InterruptedException {
        try {
            this._extMetaInfo.initSelectedField(this._interestingFieldIndexs, fields);
            for (Integer interestingFieldIndex : this._interestingFieldIndexs) {
                String fieldName = this._extMetaInfo.getFieldName(interestingFieldIndex);
                if (!"_ROWID_".equals(fieldName)) continue;
                this._interestingRowIDFieldIndexs.add(interestingFieldIndex);
            }
            this._currentRowIndex = 0L;
            this.initImpl();
        }
        catch (AbstractExtDataException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
    }

    protected abstract void initImpl() throws AbstractExtDataException, InterruptedException;

    @Override
    public final boolean hasNextRow() throws AbstractExtDataException, InterruptedException {
        try {
            return this.hasNextRowImpl();
        }
        catch (AbstractExtDataException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
    }

    protected abstract boolean hasNextRowImpl() throws AbstractExtDataException, InterruptedException;

    @Override
    public final Map<String, Object> nextRow() throws AbstractExtDataException, InterruptedException {
        try {
            Map<String, Object> row = this.nextRowImpl();
            if (row != null) {
                row.put("_ROWID_", this._currentRowIndex++);
            }
            return row;
        }
        catch (AbstractExtDataException e) {
            this._exception = e;
            throw e;
        }
        catch (InterruptedException e) {
            this._exception = e;
            throw e;
        }
    }

    protected abstract Map<String, Object> nextRowImpl() throws AbstractExtDataException, InterruptedException;

    @Override
    public final void close() {
        this.closeImpl();
        if (this._dataSourceWriter != null) {
            try {
                this._dataSourceWriter.finishWriteData();
            }
            catch (ExtDataPersistenceException e) {
                if (this._exception == null) {
                    this._exception = e;
                }
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            this._dataSourceWriter.close(this._exception);
            this._dataSourceWriter = null;
        }
    }

    protected abstract void closeImpl();
}

