/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.api.IExtFileVisitor;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.manager.model.ExtMetaInfo;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.filesystem.stream.ExtInputStream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.AbstractExtDataIterator;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.exception.AbstractExtDataException;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qs.QSInputstream;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler.DefaultDataHandlerFactory;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler.IQsDataHandler;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler.IQsDataHandlerFactory;
import com.kingdee.cosmic.ctrl.kds.util.CloseUtil;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import q.datasource.io.AbstractInputStream;
import q.storage.columnar.QingStorageRecordReader;
import q.storage.columnar.api.b;
import q.storage.columnar.api.impl.QingStorageReadSupport;
import shaded.org.apache.parquet.example.data.Group;
import shaded.org.apache.parquet.schema.MessageType;
import shaded.org.apache.parquet.schema.PrimitiveType;
import shaded.org.apache.parquet.schema.Type;

public class QSDataIterator
extends AbstractExtDataIterator {
    private static final Map<String, Object> oneRow = new HashMap<String, Object>();
    private static final IQsDataHandler ROW_NUM_DATA_HANDLER = new DefaultDataHandlerFactory.Int64DataHandler(false);
    private IExtFileVisitor _dataFile;
    private List<PrimitiveType> _qsFieldPrimTypes;
    private QingStorageRecordReader _reader;
    private long _rowCount;
    private long _currentRowIndex;
    private MessageType _recordSchema;
    private Group _record;
    private Map<String, Object> _currentRow;
    private IQsDataHandlerFactory dataHandlerFactory;

    public QSDataIterator(IExtFileVisitor dataFile, ExtMetaInfo extMetaInfo, long rowCount, List<PrimitiveType> qsFieldPrimTypes, IQsDataHandlerFactory dataHandlerFactory) {
        super(extMetaInfo);
        this._rowCount = rowCount;
        this._dataFile = dataFile;
        this._qsFieldPrimTypes = qsFieldPrimTypes;
        this.dataHandlerFactory = dataHandlerFactory;
    }

    @Override
    protected void initImpl() throws AbstractExtDataException {
        CloseUtil.close(new Closeable[]{this._reader});
        this._reader = null;
        if (this._interestingFieldIndexs.size() == 0) {
            this._currentRowIndex = 0L;
            return;
        }
        PrimitiveType[] columns = new PrimitiveType[this._interestingFieldIndexs.size()];
        int index = 0;
        Iterator iterator = this._interestingFieldIndexs.iterator();
        while (iterator.hasNext()) {
            int fieldIndex = (Integer)iterator.next();
            columns[index++] = this._qsFieldPrimTypes.get(fieldIndex);
        }
        this._recordSchema = new MessageType("envelope", (Type[])columns);
        ExtInputStream inputStream = null;
        try {
            inputStream = this._dataFile.getInputStream();
            this._reader = new QingStorageRecordReader((b)new QingStorageReadSupport());
            this._reader.initialize((AbstractInputStream)new QSInputstream(inputStream), this._recordSchema);
        }
        catch (IOException e) {
            CloseUtil.close(inputStream);
            AbstractExtDataException.accessExcetpion(e);
        }
    }

    @Override
    protected boolean hasNextRowImpl() throws AbstractExtDataException, InterruptedException {
        this._currentRow = null;
        if (this._recordSchema == null) {
            this._currentRow = oneRow;
            if (this._currentRowIndex < this._rowCount) {
                ++this._currentRowIndex;
                return true;
            }
            return false;
        }
        boolean success = false;
        Object inputstream = null;
        try {
            success = this._reader.nextKeyValue();
            if (success) {
                this._record = (Group)this._reader.getCurrentValue();
            }
        }
        catch (IOException e) {
            CloseUtil.close(new Closeable[]{this._reader});
            CloseUtil.close(new Closeable[]{inputstream});
            this._reader = null;
            AbstractExtDataException.accessExcetpion(e);
        }
        catch (InterruptedException e) {
            CloseUtil.close(new Closeable[]{this._reader});
            CloseUtil.close(new Closeable[]{inputstream});
            this._reader = null;
            throw e;
        }
        if (success) {
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int index = 0; index < this._interestingFieldIndexs.size(); ++index) {
                int fieldIndex = (Integer)this._interestingFieldIndexs.get(index);
                String fieldName = this._extMetaInfo.getFieldNames().get(fieldIndex);
                int count = this._record.getFieldRepetitionCount(index);
                if (count == 0) {
                    row.put(fieldName, null);
                    continue;
                }
                if (this._interestingRowIDFieldIndexs.contains(fieldIndex)) {
                    Object realValue = ROW_NUM_DATA_HANDLER.handle(this._record, index, 4);
                    row.put(fieldName, realValue);
                    continue;
                }
                int dataType = this._extMetaInfo.getFieldDataType(fieldIndex);
                IQsDataHandler dataHandler = this.dataHandlerFactory.getDataHandler(dataType);
                Object realValue = dataHandler.handle(this._record, index, dataType);
                row.put(fieldName, realValue);
            }
            this._currentRow = row;
        }
        return success;
    }

    @Override
    protected Map<String, Object> nextRowImpl() {
        return this._currentRow;
    }

    @Override
    protected void closeImpl() {
        CloseUtil.close(new Closeable[]{this._reader});
        this._reader = null;
    }
}

