/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler;

import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler.IQsDataHandler;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.spec.qsdatahandler.IQsDataHandlerFactory;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import q.storage.columnar.util.QingStorageUtils;
import shaded.org.apache.parquet.example.data.Group;
import shaded.org.apache.parquet.io.api.Binary;

public class DefaultDataHandlerFactory
implements IQsDataHandlerFactory {
    private Map<Integer, IQsDataHandler> dataHandlerMap = new HashMap<Integer, IQsDataHandler>();

    public DefaultDataHandlerFactory(boolean usePrimitive) {
        this.initDataHandles(usePrimitive);
    }

    protected void initDataHandles(boolean usePrimitive) {
        this.dataHandlerMap.put(92, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(91, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(93, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(4, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(-6, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(5, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(-5, new Int64DataHandler(usePrimitive));
        this.dataHandlerMap.put(2, new NumberDataHandler(usePrimitive));
        this.dataHandlerMap.put(6, new NumberDataHandler(usePrimitive));
        this.dataHandlerMap.put(8, new NumberDataHandler(usePrimitive));
        this.dataHandlerMap.put(7, new NumberDataHandler(usePrimitive));
        this.dataHandlerMap.put(3, new NumberDataHandler(usePrimitive));
        this.dataHandlerMap.put(16, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-7, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(1, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(12, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-15, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-9, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-1, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-16, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-2, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-3, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(-4, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(2004, new BinaryDataHandler(usePrimitive));
        this.dataHandlerMap.put(2005, new BinaryDataHandler(usePrimitive));
    }

    @Override
    public IQsDataHandler getDataHandler(Integer dataType) {
        IQsDataHandler dataHandler = this.dataHandlerMap.get(dataType);
        return dataHandler == null ? new NullDataHandler() : dataHandler;
    }

    public static class NumberDataHandler
    implements IQsDataHandler {
        private boolean usePrimitive = false;

        public NumberDataHandler(boolean usePrimitive) {
            this.usePrimitive = usePrimitive;
        }

        @Override
        public Object handle(Group _record, int colIndex, Integer dataType) {
            Binary value = _record.getBinary(colIndex, 0);
            if (this.usePrimitive) {
                return QingStorageUtils.decodeBigDecimal((byte[])value.getBytes()).doubleValue();
            }
            BigDecimal bdValue = QingStorageUtils.decodeBigDecimal((byte[])value.getBytes());
            if (dataType == 6 || dataType == 7) {
                return Float.valueOf(bdValue.floatValue());
            }
            if (dataType == 8) {
                return bdValue.doubleValue();
            }
            return bdValue;
        }
    }

    public static class Int64DataHandler
    implements IQsDataHandler {
        private boolean usePrimitive = false;

        public Int64DataHandler(boolean usePrimitive) {
            this.usePrimitive = usePrimitive;
        }

        @Override
        public Object handle(Group _record, int colIndex, Integer dataType) {
            Long value = _record.getLong(colIndex, 0);
            if (this.usePrimitive) {
                return value;
            }
            if (dataType == 91 || dataType == 92 || dataType == 93) {
                return new Date(value);
            }
            if (dataType == -5) {
                return value;
            }
            return value.intValue();
        }
    }

    public static class BinaryDataHandler
    implements IQsDataHandler {
        private boolean usePrimitive = false;

        public BinaryDataHandler(boolean usePrimitive) {
            this.usePrimitive = usePrimitive;
        }

        @Override
        public Object handle(Group _record, int colIndex, Integer dataType) {
            String value = _record.getString(colIndex, 0);
            if (this.usePrimitive) {
                return value;
            }
            if (dataType == 16) {
                return Boolean.parseBoolean(value);
            }
            if (dataType == -2 || dataType == -3 || dataType == 2004) {
                return value.getBytes(StandardCharsets.ISO_8859_1);
            }
            return value;
        }
    }

    private static class NullDataHandler
    implements IQsDataHandler {
        private NullDataHandler() {
        }

        @Override
        public Object handle(Group _record, int colIndex, Integer dataType) {
            return null;
        }
    }
}

