/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec;

import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.immit.ExtHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.exec.AbstractHyperLinkExec;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Point;
import java.util.Map;
import javax.swing.SwingUtilities;

public abstract class AbstractInnerLinkExec
implements IHyperLinkExec {
    protected ExtGuiExecutor _guiExecutor;
    protected Book _book;
    private SpreadContext _context;
    private IExtRuntimeDataProvider _dataProvider;

    public AbstractInnerLinkExec(ExtGuiExecutor guiExecutor, SpreadContext context, IExtRuntimeDataProvider dataProvider) {
        this._guiExecutor = guiExecutor;
        this._context = context;
        this._dataProvider = dataProvider;
        this.init();
    }

    public void execute(String linkTo) {
        this.init();
    }

    private void init() {
        if (this._guiExecutor != null) {
            this._book = this._guiExecutor.getBook();
        } else if (this._context != null) {
            this._book = this._context.getBook();
        }
    }

    protected void execute(String targetType, final String linkName, final Map<String, IParameter> params) {
        final Book book = this._book;
        if ("fusionChart".equals(targetType)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ExecutionContext ctx = book.getDataSetManager().getExecutionContext();
                    Map oldParams = ctx.getDataSetParameters();
                    ctx.setDataSetParameters(params);
                    ChartRectEmbedment chart = ExtHyperLinkAssembler.getFlashChartByName(book, linkName);
                    if (chart != null) {
                        if (AbstractInnerLinkExec.this._dataProvider != null) {
                            ctx.registerDataSetFactories(AbstractInnerLinkExec.this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(AbstractInnerLinkExec.this._book), ctx));
                        }
                        chart.getModel().getDataNode().setGroupKeys(null);
                        chart.getModel().getDataNode().setSerieskeys(null);
                        ExecutionContext eCtx = new ExecutionContext(null);
                        eCtx.setDataSetParameters(params);
                        String datasetName = chart.getModel().getDataNode().getFromDataset().getDatasetName();
                        ExtDataSet dataset = book.getDataSetManager().getDataSetByName(datasetName);
                        AbstractInnerLinkExec.this._dataProvider.linkParamsDefaultValue(new ExtDataSet[]{dataset}, eCtx);
                        chart.executeRefresh();
                    }
                    ctx.setDataSetParameters(oldParams);
                }
            });
        } else if (this._guiExecutor != null) {
            String[] arrName = linkName.split("!");
            if (arrName == null || arrName.length != 2) {
                return;
            }
            String sheetName = arrName[0];
            Sheet sheet = book.getSheet(sheetName);
            EmbedhLayer layer = sheet.getEmbedments(false);
            if (layer == null || layer.size() == 0) {
                return;
            }
            EmbedhLayer.EmbedIterator iter = layer.getIterator(true);
            while (iter.hasNext()) {
                EmbedObject eObject = iter.next();
                if (!(eObject instanceof SubReportEmbed)) continue;
                SubReportEmbed rptEmbed = (SubReportEmbed)eObject;
                Cell cell = rptEmbed.getCell();
                if (cell == null) {
                    int x = rptEmbed.getX();
                    int y = rptEmbed.getY();
                    Point p = new Point(x, y);
                    int row = SheetBaseMath.rowAtPoint(sheet, p);
                    int col = SheetBaseMath.colAtPoint(sheet, p);
                    if (row != -1 && col != -1) {
                        cell = sheet.getCell(row, col, false);
                    }
                }
                if (cell == null || !cell.getName(false, true).equals(linkName)) continue;
                AbstractHyperLinkExec.executeParamsDefaultValue(this._guiExecutor.getDataProvider(), params, cell.getSubReportInfo(), null);
                ReportProperties properties = this._dataProvider.fetchCurrentReportProperties();
                book.getDataSetManager().getExecutionContext().registerDataSetCacheObject("hyperLinkSourceReportId", properties.getId() == null ? "null" : properties.getId());
                byte[] bookData = this._dataProvider.getTransitionTargetData(cell.getSubReportInfo().getReportProps(), book.getDataSetManager().getExecutionContext());
                book.getDataSetManager().getExecutionContext().unRegisterDataSetCacheObject("hyperLinkSourceReportId");
                Book subBook = this._guiExecutor.getSubReportGuiExecutor().exec(cell, bookData, params);
                if (subBook == null) {
                    String tip = CtrlEXTMessages.getMLS("subReportNotFound2", "\u672a\u627e\u5230\u8981\u8054\u52a8\u7684\u5b50\u62a5\u8868\u3002");
                    if ("100000".equals(cell.getSubReportInfo().getReportProps().getDomain())) {
                        tip = CtrlEXTMessages.getMLS("noPermissionForPresetReport2", "\u60a8\u6ca1\u6709\u8be5\u9884\u7f6e\u62a5\u8868\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u201c\u7ba1\u7406\u5458\u201d\u8fdb\u884c\u6388\u6743\u3002");
                    }
                    MessageDialog.show((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._context)), (Object)tip, (String)CtrlEXTMessages.getMLS("msgTitle", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1);
                    return;
                }
                SpreadContext subContext = (SpreadContext)((Object)rptEmbed.getPhysicalUI());
                if (subContext == null) break;
                subContext.setBook(subBook);
                break;
            }
        }
    }
}

