/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.frame;

import com.kingdee.cosmic.ctrl.kds.frame.MultiViewPane;
import javax.swing.JComponent;
import javax.swing.JViewport;

public class MvpViewManager {
    private MultiViewPane _mvp;
    private JViewport[][] _views;

    public MvpViewManager(MultiViewPane mvp) {
        this._mvp = mvp;
        this._views = new JViewport[this._mvp.getMaxVertCount()][this._mvp.getMaxHoriCount()];
        for (int i = 0; i < this._mvp.getMaxVertCount(); ++i) {
            this._views[i] = new JViewport[this._mvp.getMaxHoriCount()];
        }
    }

    public JComponent getView(int vIndex, int hIndex) {
        JViewport vp = this._views[vIndex][hIndex];
        return vp == null ? null : (JComponent)vp.getView();
    }

    public JViewport getViewport(int vIndex, int hIndex) {
        return this._views[vIndex][hIndex];
    }

    void reset() {
        for (int i = this._mvp.getMaxVertCount() - 1; i >= 0; --i) {
            for (int j = this._mvp.getMaxHoriCount() - 1; j >= 0; --j) {
                this.removeView(i, j);
            }
        }
    }

    void update() {
        int j;
        int i;
        for (i = this._mvp.getVerticalCount(); i < this._mvp.getMaxVertCount(); ++i) {
            for (j = 0; j < this._mvp.getMaxHoriCount(); ++j) {
                this.removeView(i, j);
            }
        }
        for (i = 0; i < this._mvp.getVerticalCount(); ++i) {
            for (j = this._mvp.getHorizonCount(); j < this._mvp.getHorizonCount(); ++j) {
                this.removeView(i, j);
            }
        }
    }

    void addView(int vIndex, int hIndex, JComponent view) {
        JViewport viewport = this.createViewport(view);
        MultiViewPane.setComponentIndex(viewport, vIndex, "VViewIndex");
        MultiViewPane.setComponentIndex(viewport, hIndex, "HViewIndex");
        MultiViewPane.setComponentIndex(view, vIndex, "VViewIndex");
        MultiViewPane.setComponentIndex(view, hIndex, "HViewIndex");
        this.removeView(vIndex, hIndex);
        this._views[vIndex][hIndex] = viewport;
        this._mvp.add(viewport);
    }

    void removeView(int vIndex, int hIndex) {
        JViewport viewport = this._views[vIndex][hIndex];
        if (viewport != null) {
            this._mvp.remove(viewport);
            viewport.setView(null);
        }
        this._views[vIndex][hIndex] = null;
    }

    private JViewport createViewport(JComponent view) {
        JViewport vp = new JViewport();
        vp.setView(view);
        return vp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("************ViewInfo*********\n");
        int vCount = this._mvp.getVerticalCount();
        int hCount = this._mvp.getHorizonCount();
        for (int i = 0; i < vCount; ++i) {
            for (int j = 0; j < hCount; ++j) {
                JViewport vp = this.getViewport(i, j);
                sb.append('(');
                sb.append(i);
                sb.append(',');
                sb.append(j);
                sb.append(")  ");
                sb.append(" View Positon:" + vp.getViewPosition());
                sb.append(" View Port Bounds:" + vp.getBounds());
                sb.append('\n');
            }
        }
        return sb.toString();
    }
}

