/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade;

import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.facade.FilterDialogCallBack;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetFirstNAutoFilter;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JSeparator;

public class FirstNFilterConfigDialog
extends KDDialog {
    private KDLabel label;
    private JSeparator separator;
    private KDComboBox mmComboBox;
    private KDSpinner spinner;
    private KDComboBox unitComboBox;
    private KDButton submit;
    private KDButton cancel;
    private FilterDialogCallBack callBack;

    public FirstNFilterConfigDialog(Frame parent) {
        super(parent);
        this.init();
        this.layoutComps();
        this.initListeners();
    }

    public FirstNFilterConfigDialog(Dialog parent) {
        super(parent);
        this.init();
        this.layoutComps();
        this.initListeners();
    }

    private void initListeners() {
        this.submit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int value = (Integer)FirstNFilterConfigDialog.this.spinner.getValue();
                if (value < 1 || value > 99) {
                    MessageUtil.msgboxInfo((Component)((Object)FirstNFilterConfigDialog.this), MultiLanguageKeys.getLocalText("KEY_AutoFilter_MSG1", "\u6570\u5b57\u5fc5\u987b\u5728 1 \u4e0e 99 \u4e4b\u95f4\u3002\u8bf7\u518d\u6b21\u8f93\u5165\u5c5e\u4e8e\u4e0a\u8ff0\u533a\u57df\u7684\u6570\u5b57\u3002"));
                } else {
                    Object[] params = new Object[]{value, FirstNFilterConfigDialog.this.mmComboBox.getSelectedIndex() != 0, FirstNFilterConfigDialog.this.unitComboBox.getSelectedIndex() != 0};
                    if (FirstNFilterConfigDialog.this.callBack != null) {
                        FirstNFilterConfigDialog.this.callBack.doAfterConfirm(params);
                    }
                }
                FirstNFilterConfigDialog.this.closeDialog();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FirstNFilterConfigDialog.this.closeDialog();
            }
        });
    }

    private void init() {
        this.setTitle(MultiLanguageKeys.getLocalText("KEY_AutoFilter_Title", "\u81ea\u52a8\u7b5b\u9009\u524d N \u4e2a"));
        this.setModal(true);
        this.label = new KDLabel(MultiLanguageKeys.getLocalText("KEY_AutoFilter_Display", "\u663e\u793a"));
        this.separator = new JSeparator(0);
        this.mmComboBox = new KDComboBox(new Object[]{MultiLanguageKeys.getLocalText("KEY_AutoFilter_Max", "\u6700\u5927"), MultiLanguageKeys.getLocalText("KEY_AutoFilter_Min", "\u6700\u5c0f")});
        this.spinner = new KDSpinner();
        this.spinner.setValue((Object)10);
        this.unitComboBox = new KDComboBox(new Object[]{MultiLanguageKeys.getLocalText("KEY_AutoFilter_Item", "\u9879"), MultiLanguageKeys.getLocalText("KEY_AutoFilter_Percentage", "\u767e\u5206\u6bd4")});
        this.submit = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK", "\u786e\u5b9a"));
        this.cancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL", "\u53d6\u6d88"));
    }

    private void layoutComps() {
        Container c = this.getContentPane();
        c.setLayout(null);
        this.setSize(350, 135);
        this.label.setBounds(5, 10, 25, 20);
        this.separator.setBounds(40, 20, 290, 20);
        this.mmComboBox.setBounds(25, 35, 65, 20);
        this.spinner.setBounds(130, 35, 70, 20);
        this.unitComboBox.setBounds(230, 35, 90, 20);
        this.submit.setBounds(160, 70, 75, 20);
        this.cancel.setBounds(250, 70, 75, 20);
        c.add((Component)this.label);
        c.add(this.separator);
        c.add((Component)this.mmComboBox);
        c.add((Component)this.spinner);
        c.add((Component)this.unitComboBox);
        c.add((Component)this.submit);
        c.add((Component)this.cancel);
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
        if (this.callBack != null) {
            this.callBack.doAftercloseDialog();
        }
    }

    public void setValue(SheetFirstNAutoFilter filter) {
        if (filter != null) {
            this.spinner.setValue((Object)filter.getAmount());
            if (filter.isAsc()) {
                this.mmComboBox.setSelectedIndex(1);
            } else {
                this.mmComboBox.setSelectedIndex(0);
            }
            if (filter.isPercent()) {
                this.unitComboBox.setSelectedIndex(1);
            } else {
                this.unitComboBox.setSelectedIndex(0);
            }
        }
    }

    public void setFilterDialogCallBack(FilterDialogCallBack callBack) {
        this.callBack = callBack;
    }
}

