/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.hyperlink;

import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.i18n.model.MultiLangEnumBridge;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import java.awt.Desktop;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FilenameUtils;

public class UriHyperLinkExec
implements IHyperLinkExec {
    private SpreadContext context;
    private String[] webPrefixArr = new String[]{"http:", "https:", "www."};
    private String[] webArr;
    private String[] fileArr;
    private String[] fileTypeArr;
    private String[] directoryArr;
    private boolean enableOpenFile = false;
    private boolean enableOpenWeb = true;

    public SpreadContext getContext() {
        return this.context;
    }

    public void setContext(SpreadContext context) {
        this.context = context;
    }

    public String[] getWebPrefixArr() {
        return this.webPrefixArr;
    }

    public void setWebPrefixArr(String[] webPrefixArr) {
        this.webPrefixArr = webPrefixArr;
    }

    public String[] getWebArr() {
        return this.webArr;
    }

    public void setWebArr(String[] webArr) {
        this.webArr = webArr;
    }

    public String[] getFileArr() {
        return this.fileArr;
    }

    public void setFileArr(String[] fileArr) {
        this.fileArr = fileArr;
    }

    public String[] getFileTypeArr() {
        return this.fileTypeArr;
    }

    public void setFileTypeArr(String[] fileTypeArr) {
        this.fileTypeArr = fileTypeArr;
    }

    public String[] getDirectoryArr() {
        return this.directoryArr;
    }

    public void setDirectoryArr(String[] directoryArr) {
        this.directoryArr = directoryArr;
    }

    public boolean isEnableOpenFile() {
        return this.enableOpenFile;
    }

    public void setEnableOpenFile(boolean enableOpenFile) {
        this.enableOpenFile = enableOpenFile;
    }

    public boolean isEnableOpenWeb() {
        return this.enableOpenWeb;
    }

    public void setEnableOpenWeb(boolean enableOpenWeb) {
        this.enableOpenWeb = enableOpenWeb;
    }

    public UriHyperLinkExec(SpreadContext context) {
        this.context = context;
    }

    public UriHyperLinkExec(SpreadContext context, String[] _webPrefixArr, String[] _webArr, String[] _fileArr, String[] _fileTypeArr, String[] _directoryArr, boolean _enableOpenFile, boolean _enableOpenWeb) {
        this.context = context;
        this.webPrefixArr = _webPrefixArr;
        this.webArr = _webArr;
        this.fileArr = _fileArr;
        this.fileTypeArr = _fileTypeArr;
        this.directoryArr = _directoryArr;
        this.enableOpenFile = _enableOpenFile;
        this.enableOpenWeb = _enableOpenWeb;
        this.initLinkType();
    }

    public UriHyperLinkExec(SpreadContext context, boolean enableOpenFile, boolean enableOpenWeb) {
        this.context = context;
        this.enableOpenFile = enableOpenFile;
        this.enableOpenWeb = enableOpenWeb;
    }

    private void initLinkType() {
        LinkType.URL.setData(this.webArr);
        LinkType.FILE.setData(this.webArr);
        LinkType.FILETYPE.setData(this.webArr);
        LinkType.DIRECTORY.setData(this.webArr);
    }

    public void execute(final String linkTo) {
        if (!StringUtil.isEmptyString((String)linkTo)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    LinkType supportType = UriHyperLinkExec.this.checkUri(linkTo);
                    if (null != supportType) {
                        UriHyperLinkExec.this.openWithDefaulApp(supportType, linkTo);
                    }
                }
            }).start();
        }
    }

    public LinkType checkUri(String linkTo) {
        LinkType supportType = null;
        if (this.enableOpenWeb && this.checkWebUrlWithUrl(linkTo)) {
            String[] webArr = (String[])LinkType.URL.data;
            if (LinkType.URL.enable && this.search(webArr, linkTo) >= 0 || !LinkType.URL.enable && this.search(webArr, linkTo) < 0) {
                supportType = LinkType.URL;
                return supportType;
            }
        }
        if (!this.enableOpenFile) {
            return supportType;
        }
        File file = new File(FilenameUtils.normalize((String)linkTo));
        String[] tempArr = null;
        if (file.isFile()) {
            tempArr = (String[])LinkType.FILE.data;
            if (!LinkType.FILE.enable) {
                if (this.search(tempArr, linkTo) >= 0) {
                    return supportType;
                }
                tempArr = (String[])LinkType.FILETYPE.data;
                if (LinkType.FILETYPE.enable && this.search(tempArr, linkTo) >= 0 || !LinkType.FILETYPE.enable && this.search(tempArr, linkTo) < 0) {
                    supportType = LinkType.FILETYPE;
                    return supportType;
                }
            } else {
                if (LinkType.FILE.enable && this.search(tempArr, linkTo) >= 0 || !LinkType.FILE.enable && this.search(tempArr, linkTo) < 0) {
                    supportType = LinkType.FILE;
                    return supportType;
                }
                if (!LinkType.FILE.enable && this.search(tempArr, linkTo) >= 0 || !LinkType.FILE.enable && this.search(tempArr, linkTo) < 0) {
                    supportType = LinkType.FILE;
                    return supportType;
                }
            }
        } else if (file.isDirectory()) {
            tempArr = (String[])LinkType.DIRECTORY.data;
            if (LinkType.DIRECTORY.enable && this.search(tempArr, linkTo) >= 0 || !LinkType.DIRECTORY.enable && this.search(tempArr, linkTo) < 0) {
                supportType = LinkType.DIRECTORY;
                return supportType;
            }
        }
        return supportType;
    }

    public int search(String[] srcArr, String targetSr) {
        int index = -1;
        if (null != srcArr && srcArr.length > 0 && !StringUtil.isEmptyString((String)targetSr)) {
            for (int i = 0; i < srcArr.length; ++i) {
                if (!targetSr.equals(srcArr[i])) continue;
                index = i;
                break;
            }
        }
        return index;
    }

    public boolean openWithDefaulApp(LinkType linkType, String linkTo) {
        boolean flag = true;
        try {
            File file = new File(FilenameUtils.normalize((String)linkTo));
            Desktop desktop = Desktop.getDesktop();
            switch (linkType) {
                case URL: {
                    desktop.browse(new URI(linkTo));
                    break;
                }
                case FILE: {
                    desktop.open(file);
                    break;
                }
                case FILETYPE: {
                    desktop.open(file);
                    break;
                }
                case DIRECTORY: {
                    desktop.open(file);
                    break;
                }
            }
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    public boolean checkWebUrlWithPrefix(String uriStr) {
        boolean flag = false;
        if (null != this.webPrefixArr && this.webPrefixArr.length > 0) {
            for (int i = 0; i < this.webPrefixArr.length; ++i) {
                if (!uriStr.startsWith(this.webPrefixArr[i])) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    public boolean checkWebUrlWithUrl(String uriStr) {
        boolean flag = false;
        try {
            URL url = new URL(uriStr);
            if (null != url) {
                flag = true;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return flag;
    }

    private static enum LinkType {
        URL(new MultiLangEnumBridge("webAddress", CtrlEXTMessages.getMLS("webAddress", "\u7f51\u9875\u5730\u5740"), CtrlCommonMessages.ProjectName.CTRL_EXT), false, null, 1),
        FILE(new MultiLangEnumBridge("localFile", CtrlEXTMessages.getMLS("localFile", "\u672c\u5730\u6587\u4ef6"), CtrlCommonMessages.ProjectName.CTRL_EXT), false, null, 2),
        FILETYPE(new MultiLangEnumBridge("localFileType", CtrlEXTMessages.getMLS("localFileType", "\u672c\u5730\u6587\u4ef6\u7c7b\u578b"), CtrlCommonMessages.ProjectName.CTRL_EXT), false, null, 3),
        DIRECTORY(new MultiLangEnumBridge("localFileDirectory", CtrlEXTMessages.getMLS("localFileDirectory", "\u672c\u5730\u6587\u4ef6\u76ee\u5f55"), CtrlCommonMessages.ProjectName.CTRL_EXT), false, null, 4);

        private final MultiLangEnumBridge multiLangEnumBridge;
        private boolean enable;
        private Object data;
        private int index;

        private LinkType(MultiLangEnumBridge multiLangEnumBridge, boolean enable, Object data, int index) {
            this.multiLangEnumBridge = multiLangEnumBridge;
            this.enable = enable;
            this.data = data;
            this.index = index;
        }

        public String getName() {
            return this.multiLangEnumBridge.getMLS();
        }

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

