/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.tip;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.tip.AbstractTipPanel;
import com.kingdee.cosmic.ctrl.kds.impl.facade.tip.MenuAction;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDPopupMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.net.URL;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JToolTip;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

public class DefaultTipPanel
extends AbstractTipPanel
implements TimingTarget {
    private String tipString;
    private Image image = DefaultTipPanel.createDefaultCloseImage(false);
    private Image mouseOnImage = DefaultTipPanel.createDefaultCloseImage(true);
    private URL url;
    private KDSpread spread;
    private Dimension prefer;
    private Animator animator;
    private SpreadContext context;
    private boolean isMouseIn = false;
    private Color background = new Color(255, 252, 193);
    private Color mouseOn = new Color(0, 0, 120);
    private Color textColor = new Color(255, 255, 255);
    private Popup closeTip;
    private Window w;
    private KDButton[] buttons;
    private int derection = 1;

    public static final String getTipString() {
        return CtrlEXTMessages.getMLS("previewDataLimited", "\u9884\u89c8\u6570\u636e\u4f5c\u4e86\u9650\u5236\uff0c\u4e3a\u4e86\u5f97\u5230\u6b63\u786e\u7684\u7edf\u8ba1\u7ed3\u679c\uff0c\u8bf7\u5148\u53d1\u5e03\u62a5\u8868\u3002");
    }

    public DefaultTipPanel(String tipString, SpreadContext context) {
        this.url = DefaultTipPanel.class.getResource("tip.wav");
        this.animator = new Animator(300, (TimingTarget)this);
        this.tipString = null != tipString ? tipString : DefaultTipPanel.getTipString();
        this.spread = context.getSpread();
        this.context = context;
        this.prefer = new Dimension(this.spread.getPreferredSize().width, 0);
        this.init();
        this.initListeners();
    }

    public void setTipAction(Action[] actions) {
        block4: {
            block3: {
                if (actions == null || actions.length == 0) {
                    return;
                }
                this.setLayout(null);
                if (this.buttons != null) break block3;
                this.buttons = new KDButton[actions.length];
                for (int index = 0; index < actions.length; ++index) {
                    Action action = actions[index];
                    KDButton button = new KDButton(action);
                    button.setBounds(400 + 125 * index, 0, 120, 19);
                    this.add((Component)button);
                }
                break block4;
            }
            if (actions.length != this.buttons.length) break block4;
            for (int index = 0; index < actions.length; ++index) {
                Action action = actions[index];
                this.buttons[index].setAction(action);
            }
        }
    }

    private void init() {
        KDPopupMenu pm = new KDPopupMenu();
        pm.add(new JMenuItem(new MenuAction(CtrlEXTMessages.getMLS("closeActionBar", "\u5173\u95ed\u52a8\u4f5c\u6761"), this)));
    }

    private void initListeners() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int x = DefaultTipPanel.this.getWidth();
                if (x - e.getX() < 30 && e.getButton() == 1) {
                    DefaultTipPanel.this.hideTip();
                    DefaultTipPanel.this.setPreferredSize(new Dimension(0, 0));
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                DefaultTipPanel.this.isMouseIn = true;
                DefaultTipPanel.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DefaultTipPanel.this.isMouseIn = false;
                DefaultTipPanel.this.repaint();
                if (DefaultTipPanel.this.closeTip != null) {
                    DefaultTipPanel.this.closeTip.hide();
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){
            Cursor cur = Cursor.getPredefinedCursor(12);
            Cursor def = Cursor.getDefaultCursor();

            @Override
            public void mouseMoved(MouseEvent e) {
                int x = DefaultTipPanel.this.getWidth();
                if (x - e.getX() < 30) {
                    DefaultTipPanel.this.setCursor(this.cur);
                    DefaultTipPanel.this.showCloseTip(true, e.getPoint());
                } else {
                    DefaultTipPanel.this.setCursor(this.def);
                    SwingUtilities.convertPointToScreen(e.getPoint(), (Component)((Object)DefaultTipPanel.this));
                    DefaultTipPanel.this.showCloseTip(false, e.getPoint());
                }
            }
        });
    }

    public void setPreferredSize(Dimension d) {
        this.prefer = d;
    }

    public Dimension getPreferredSize() {
        return this.prefer;
    }

    protected void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g.create();
        Composite c = g2.getComposite();
        if (!this.isMouseIn) {
            g2.setColor(this.background);
        } else {
            g2.setColor(this.mouseOn);
        }
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (!this.isMouseIn) {
            g2.setColor(Color.black);
        } else {
            g2.setColor(this.textColor);
        }
        g2.drawString(this.tipString, 10, 15);
        if (!this.isMouseIn) {
            g2.drawImage(this.image, this.getWidth() - 15, 4, null);
        } else {
            g2.drawImage(this.mouseOnImage, this.getWidth() - 15, 4, null);
        }
        g2.setComposite(c);
        g2.dispose();
    }

    @Override
    public synchronized void hideTip() {
        if (this.getHeight() > 0) {
            this.animator.stop();
            this.derection = -1;
            this.animator.setStartDirection(Animator.Direction.FORWARD);
            this.animator.start();
            if (this.closeTip != null) {
                this.closeTip.hide();
            }
            this.playSound();
        }
    }

    @Override
    public synchronized void showTip() {
        if (this.getHeight() == 0) {
            this.animator.stop();
            this.derection = 1;
            this.animator.setStartDirection(Animator.Direction.FORWARD);
            this.animator.start();
            this.playSound();
        }
    }

    @Override
    public URL getTipSoundURL() {
        return this.url;
    }

    public void timingEvent(float fraction) {
        this.prefer = new Dimension(this.spread.getWidth(), (int)(10.0f * (1.0f + (float)this.derection * fraction)));
        Dimension d = this.spread.getSize();
        this.spread.setPreferredSize(new Dimension(d.width, d.height + this.getPreferredSize().height));
        this.context.revalidate();
    }

    public void begin() {
    }

    public void end() {
    }

    public void repeat() {
    }

    public static BufferedImage createDefaultCloseImage(boolean isMouseOn) {
        BufferedImage image = new BufferedImage(20, 20, 2);
        Graphics2D g2 = image.createGraphics();
        g2.setColor(new Color(255, 255, 255, 0));
        g2.setClip(new Rectangle(20, 20));
        g2.fillRect(0, 0, 20, 20);
        if (isMouseOn) {
            g2.setColor(Color.WHITE);
        } else {
            g2.setColor(Color.BLACK);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo(0.0f, 2.0f);
        path.lineTo(2.0f, 0.0f);
        path.lineTo(12.0f, 10.0f);
        path.lineTo(10.0f, 12.0f);
        path.closePath();
        g2.setClip(path);
        g2.fill(path);
        path = new GeneralPath();
        path.moveTo(0.0f, 10.0f);
        path.lineTo(2.0f, 12.0f);
        path.lineTo(12.0f, 2.0f);
        path.lineTo(10.0f, 0.0f);
        path.closePath();
        g2.setClip(path);
        g2.fill(path);
        g2.dispose();
        return image;
    }

    private void showCloseTip(boolean show, Point p) {
        JToolTip tip = new JToolTip();
        tip.setTipText(CtrlEXTMessages.getMLS("closeNotificationBar", "\u5173\u95ed\u63d0\u793a\u6761"));
        if (this.w == null) {
            this.w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        }
        if (show) {
            if (this.closeTip != null) {
                this.closeTip.hide();
            }
            SwingUtilities.convertPointToScreen(p, (Component)((Object)this));
            this.closeTip = PopupFactory.getSharedInstance().getPopup(this.w, tip, p.x - 65, p.y - 30);
            this.closeTip.show();
        } else if (this.closeTip != null) {
            this.closeTip.hide();
        }
    }
}

