/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedSpanArray;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;

public class WizzardCellInsDel
extends KDDialog
implements ISpreadWizzard {
    public static final int MOVE_BY_ROW = 0;
    public static final int MOVE_BY_COLUMN = 1;
    public static final int MOVE_All_ROW = 2;
    public static final int MOVE_ALL_COLUMN = 3;
    public static final int NO_OPERATION = -1;
    protected KDButtonGroup _group;
    protected KDLabel _titleLabel;
    protected KDSeparator _sep;
    protected KDRadioButton _btn1;
    protected KDRadioButton _btn2;
    protected KDRadioButton _btn3;
    protected KDRadioButton _btn4;
    protected KDButton _okBtn;
    protected KDButton _cancelBtn;
    protected int _returnValue = -1;
    protected SpreadContext _context;
    protected boolean _bInsert = true;

    public WizzardCellInsDel(Dialog d, SpreadContext context) {
        super(d, true);
        this._context = context;
        this.initDialog();
        this.initComponents();
        this.initPanel();
    }

    public WizzardCellInsDel(Frame f, SpreadContext context) {
        super(f, true);
        this._context = context;
        this.initDialog();
        this.initComponents();
        this.initPanel();
    }

    public void setInsert(boolean bInsert) {
        this._bInsert = bInsert;
        this.updateTexts(bInsert);
    }

    protected void initDialog() {
        this.setSize(180, 170);
        this.setTitle(MultiLanguageKeys.getLocalText("KEY_INSERT"));
        this.setResizable(false);
    }

    protected void initComponents() {
        this._titleLabel = new KDLabel();
        this._sep = new KDSeparator();
        this._group = new KDButtonGroup();
        this._btn1 = new KDRadioButton();
        this._btn2 = new KDRadioButton();
        this._btn3 = new KDRadioButton();
        this._btn3.setText(MultiLanguageKeys.getLocalText("KEY_ALLROWS"));
        this._btn4 = new KDRadioButton();
        this._btn4.setText(MultiLanguageKeys.getLocalText("KEY_ALLCOLS"));
        this._group.add((AbstractButton)this._btn1);
        this._group.add((AbstractButton)this._btn2);
        this._group.add((AbstractButton)this._btn3);
        this._group.add((AbstractButton)this._btn4);
        this._btn2.setSelected(true);
        this._okBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._okBtn.setLimitedSize(false);
        this._cancelBtn = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._cancelBtn.setLimitedSize(false);
        ActionHandler al = new ActionHandler();
        this._okBtn.addActionListener((ActionListener)al);
        this._cancelBtn.addActionListener((ActionListener)al);
        this.updateTexts(this._bInsert);
    }

    protected void initPanel() {
        this.setPreferredSize(new Dimension(200, 170));
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._titleLabel);
        cp.add((Component)this._sep);
        cp.add((Component)this._btn1);
        cp.add((Component)this._btn2);
        cp.add((Component)this._btn3);
        cp.add((Component)this._btn4);
        cp.add((Component)this._okBtn);
        cp.add((Component)this._cancelBtn);
        this._titleLabel.setBounds(5, 5, 40, 20);
        this._sep.setBounds(45, 15, 130, 10);
        this._btn1.setBounds(5, 30, 190, 20);
        this._btn2.setBounds(5, 50, 190, 20);
        this._btn3.setBounds(5, 70, 190, 20);
        this._btn4.setBounds(5, 90, 190, 20);
        this._okBtn.setBounds(10, 115, 75, 20);
        this._cancelBtn.setBounds(95, 115, 75, 20);
    }

    protected int getReturnValue() {
        return this._returnValue;
    }

    private void deleteCells(boolean bRow) {
        this._context.getRangeManager().getSelectionRangeInBook().delete(bRow);
    }

    private void insertCells(boolean bRow) {
        if (this._context.getRangeManager().getSelectionRangeInBook().insert(bRow)) {
            this._context.getStateManager().addState(this._context.getStateManager().createInsertState(bRow));
        }
    }

    private void deleteRowCols(SortedSpanArray deleteSpans, boolean bRow) {
        this._context.getRangeManager().getCompoundRangeInBook(deleteSpans, bRow).delete();
    }

    private void insertRowCols(SortedSpanArray addSpans, boolean bRow) {
        if (this._context.getRangeManager().getCompoundRangeInBook(addSpans, bRow).insert()) {
            this._context.getStateManager().addState(this._context.getStateManager().createInsertState(bRow));
        }
    }

    private void updateTexts(boolean bInsert) {
        String str3;
        String str2;
        String str;
        if (bInsert) {
            str = MultiLanguageKeys.getLocalText("KEY_INSERT");
            str2 = MultiLanguageKeys.getLocalText("KEY_AVCELLRIGHT");
            str3 = MultiLanguageKeys.getLocalText("KEY_AVCELLDOWN");
        } else {
            str = MultiLanguageKeys.getLocalText("KEY_DELETE");
            str2 = MultiLanguageKeys.getLocalText("KEY_AVCELLLEFT");
            str3 = MultiLanguageKeys.getLocalText("KEY_AVCELLUP");
        }
        this._titleLabel.setText(str);
        this._btn1.setText(str2);
        this._btn2.setText(str3);
    }

    @Override
    public void commit() {
        Selection sel = this._context.getBook().getActiveSheet().getSheetOption().getSelection();
        int value = this.getReturnValue();
        switch (value) {
            case 0: {
                if (this._bInsert) {
                    this.insertCells(false);
                    break;
                }
                this.deleteCells(false);
                break;
            }
            case 1: {
                if (this._bInsert) {
                    this.insertCells(true);
                    break;
                }
                this.deleteCells(true);
                break;
            }
            case 2: {
                if (this._bInsert) {
                    this.insertRowCols(sel.toRowSpans(), true);
                    break;
                }
                this.deleteRowCols(sel.toRowSpans(), true);
                break;
            }
            case 3: {
                if (this._bInsert) {
                    this.insertRowCols(sel.toColumnSpans(), false);
                    break;
                }
                this.deleteRowCols(sel.toColumnSpans(), false);
                break;
            }
        }
    }

    @Override
    public boolean prepare() {
        this._returnValue = -1;
        Selection sel = this._context.getBook().getActiveSheet().getSheetOption().getSelection();
        if (sel.isRowBlocks()) {
            if (this._bInsert) {
                this.insertRowCols(sel.toRowSpans(), true);
            } else {
                this.deleteRowCols(sel.toRowSpans(), true);
            }
            return false;
        }
        if (sel.isColBlocks()) {
            if (this._bInsert) {
                this.insertRowCols(sel.toColumnSpans(), false);
            } else {
                this.deleteRowCols(sel.toColumnSpans(), false);
            }
            return false;
        }
        return true;
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == WizzardCellInsDel.this._okBtn) {
                WizzardCellInsDel.this._returnValue = WizzardCellInsDel.this._group.getValue();
                WizzardCellInsDel.this.dispose();
            } else if (e.getSource() == WizzardCellInsDel.this._cancelBtn) {
                WizzardCellInsDel.this._returnValue = -1;
                WizzardCellInsDel.this.dispose();
            }
        }
    }
}

