/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.export.ExportManager;
import com.kingdee.cosmic.ctrl.kdf.export.ExporterParameter;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kdf.read.POIXlsReader;
import com.kingdee.cosmic.ctrl.kdf.util.printout.PrintableBook;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.IConstants;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.kds.BookToKDSBook;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSBookToBook;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import com.kingdee.cosmic.ctrl.swing.util.SimpleFileFilter;
import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class WizzardDefaultIO
extends KDFileChooser
implements ISpreadWizzard,
IConstants {
    private SpreadContext _context;
    private boolean _beSave;

    public WizzardDefaultIO(SpreadContext context) {
        this._context = context;
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("pdf", "pdf" + this.getLocalText("Key_File")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter(new String[]{"htm", "html"}, this.getLocalText("Key_Page")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("xls", "MS Excel" + this.getLocalText("Key_File")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("kdf", "KDTable" + this.getLocalText("Key_File")));
        this.addChoosableFileFilter((FileFilter)new SimpleFileFilter("xml", "xml" + this.getLocalText("Key_Table")));
    }

    @Override
    public void commit() {
        this._context.getActionManager().getAction("Show_Style_Wizzard").setEnabled(false);
    }

    public void setBeSave(boolean beSave) {
        this._beSave = beSave;
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void show() {
        if (this._beSave) {
            this.showSaveWizzard();
        } else {
            this.showOpenWizzard();
        }
    }

    private String getLocalText(String key) {
        return CtrlEXTMessages.getMLS(key, "hahahaha");
    }

    private String addExtension(String fileName, String extension) {
        if (fileName.endsWith(extension)) {
            return fileName;
        }
        return fileName + "." + extension;
    }

    private void showSaveWizzard() {
        this.setDialogTitle(this.getLocalText("Key_ExportFile"));
        int result = this.showSaveDialog((Component)((Object)this._context));
        if (result == 0) {
            FileFilter filter = this.getFileFilter();
            File file = this.getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (filter instanceof SimpleFileFilter) {
                SimpleFileFilter sff = (SimpleFileFilter)filter;
                if (sff.acceptExtension("xml")) {
                    fileName = this.addExtension(fileName, "xml");
                    try {
                        BookIOUtil.saveToFile(this._context.getBook(), fileName);
                    }
                    catch (FileNotFoundException e) {
                        MessageUtil.msgboxWarning((Component)((Object)this._context), e.getMessage());
                    }
                    catch (IOException e) {
                        MessageUtil.msgboxWarning((Component)((Object)this._context), e.getMessage());
                    }
                } else if (sff.acceptExtension("xls")) {
                    fileName = this.addExtension(fileName, "xls");
                    KDSBook kdsbook = BookToKDSBook.traslate(this._context.getBook());
                    ExportManager em = new ExportManager();
                    em.setExporterParmeter(ExporterParameter.BOOK_LOCKED, (Object)Boolean.TRUE);
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA, (Object)"true");
                    em.setExporterParmeter(ExporterParameter.EXPORT_FORMULA_VALUE, (Object)"true");
                    em.exportToExcel(kdsbook, fileName);
                } else if (sff.acceptExtension("pdf")) {
                    fileName = this.addExtension(fileName, "pdf");
                    KDSBook kdsbook = BookToKDSBook.traslate(this._context.getBook());
                    PrintableBook prtbook = new PrintableBook(kdsbook);
                    new ExportManager().exportToPdfFile(prtbook, fileName);
                } else if (sff.acceptExtension("html")) {
                    fileName = this.addExtension(fileName, "html");
                    KDSBook kdsbook = BookToKDSBook.traslate(this._context.getBook());
                    PrintableBook prtbook = new PrintableBook(kdsbook);
                    new ExportManager().exportToHtmlFile(prtbook, fileName);
                }
            } else {
                try {
                    BookIOUtil.saveToFile(this._context.getBook(), fileName);
                }
                catch (FileNotFoundException e) {
                    MessageUtil.msgboxWarning((Component)((Object)this._context), e.getMessage());
                }
                catch (IOException e) {
                    MessageUtil.msgboxWarning((Component)((Object)this._context), e.getMessage());
                }
            }
        }
    }

    private void showOpenWizzard() {
        this.setDialogTitle(this.getLocalText("Key_ImportFile"));
        int result = this.showOpenDialog((Component)((Object)this._context));
        if (result == 0) {
            File file = this.getSelectedFile();
            String fileName = file.getAbsolutePath();
            String ext = WizzardDefaultIO.getExtension(file);
            String str = this.getLocalText("Key_UnsupportedFileFormat");
            if ("xls".equalsIgnoreCase(ext)) {
                KDSBook kdsbook = POIXlsReader.parse((String)fileName);
                if (kdsbook != null) {
                    Book book = KDSBookToBook.traslate(kdsbook);
                    this._context.setBook(book);
                } else {
                    MessageUtil.msgboxInfo((Component)((Object)this._context), str);
                }
            } else if ("pdf".equalsIgnoreCase(ext)) {
                MessageUtil.msgboxInfo((Component)((Object)this._context), str);
            } else if ("html".equalsIgnoreCase(ext)) {
                MessageUtil.msgboxInfo((Component)((Object)this._context), str);
            } else {
                try {
                    this._context.setBook(BookIOUtil.loadFile(fileName, null));
                }
                catch (Exception e1) {
                    MessageUtil.msgboxWarning((Component)((Object)this._context), e1.getMessage());
                    return;
                }
            }
        }
    }

    public static String getExtension(File f) {
        if (f != null) {
            String filename = f.getName();
            return WizzardDefaultIO.getExtension(filename);
        }
        return null;
    }

    public static String getExtension(String filename) {
        int i;
        if (!StringUtil.isEmptyString((String)filename) && (i = filename.lastIndexOf(46)) > 0 && i < filename.length() - 1) {
            return filename.substring(i + 1).toLowerCase(Locale.ENGLISH);
        }
        return null;
    }
}

