/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.cosmic.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.impl.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class WizzardNameDefine
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDTable _namesList;
    private RangeSelector _rs;
    private KDButton _btnCancel;
    private KDWorkButton _btnInsert;
    private KDWorkButton _btnEdit;
    private KDWorkButton _btnDelete;
    private NameNodeConfigurationDialog _ncd;
    private KDWorkButton _clear;
    private KDWorkButton _commit;
    private NamedObjectNode _selectedNode;
    private IRow _selectedRow;

    public WizzardNameDefine(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(560, 430);
        this.initComponents();
        this.initListeners();
    }

    public WizzardNameDefine(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.setSize(560, 430);
        this.initComponents();
        this.initListeners();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        this.updateValues();
        return true;
    }

    private void updateValues() {
        this._namesList.removeRows();
        if (this._context != null) {
            Book book = this._context.getBook();
            SortedNamedObjectNodeArray bookNames = book.getNames();
            int size = bookNames.size();
            for (int i = 0; i < size; ++i) {
                NamedObjectNode node = (NamedObjectNode)bookNames.get(i);
                if (!node.isVisible() || node.isUndefined()) continue;
                IRow row = this._namesList.addRow();
                this.updateCelll(row, node);
                row.setUserObject((Object)node);
            }
            int len = book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < len; ++sheetIndex) {
                Sheet sheet = book.getSheet(sheetIndex);
                SortedNamedObjectNodeArray sheetNames = sheet.getNames();
                int size2 = sheetNames.size();
                for (int i = 0; i < size2; ++i) {
                    NamedObjectNode node = (NamedObjectNode)sheetNames.get(i);
                    if (!node.isVisible() || node.isUndefined()) continue;
                    IRow row = this._namesList.addRow();
                    this.updateCelll(row, node);
                    row.setUserObject((Object)node);
                }
            }
            this._rs.setText(null);
        }
        this.setConfigButtonState(false);
        if (this._selectedRow != null) {
            KDTableUtil.setSelectedRow((KDTable)this._namesList, (int)this._selectedRow.getRowIndex());
        }
    }

    private void updateCelll(IRow row, NamedObjectNode node) {
        row.getCell(0).setValue((Object)node.getName());
        row.getCell(1).setValue((Object)node.getRefersTo());
        row.getCell(2).setValue((Object)(!node.isLocal() ? CtrlEXTMessages.getMLS("KEY_BOOK", "\u5de5\u4f5c\u7c3f") : node.getSheet().getSheetName()));
    }

    private void initComponents() {
        this._namesList = new KDTable(3, 1, 0);
        this._namesList.setEditable(false);
        IRow row = this._namesList.getHeadRow(0);
        row.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"));
        row.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("KEY_REFPOSITION", "\u5f15\u7528\u4f4d\u7f6e"));
        row.getCell(2).setValue((Object)CtrlEXTMessages.getMLS("KEY_SCOPE", "\u8303\u56f4"));
        this._namesList.getColumn(0).setWidth(160);
        this._namesList.getColumn(1).setWidth(160);
        this._namesList.getColumn(2).setWidth(160);
        this._namesList.getSelectManager().setSelectMode(2);
        KDLabel refLabel = new KDLabel();
        refLabel.setText(MultiLanguageKeys.getLocalText("KEY_REFPOSITION") + ":");
        this._rs = this._context.getFacadeManager().createRangeSelector(MultiLanguageKeys.getLocalText("KEY_REFPOSITION"));
        this._rs.setAbsRangeName(false);
        this._rs.setEnabled(false);
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CLOSE"));
        this._btnInsert = new KDWorkButton(CtrlEXTMessages.getMLS("newWithBorn", "\u65b0\u5efa..."));
        this._btnDelete = new KDWorkButton(MultiLanguageKeys.getLocalText("KEY_DELETE"));
        this._btnDelete.setEnabled(false);
        this._btnEdit = new KDWorkButton(CtrlEXTMessages.getMLS("editWithBorn", "\u7f16\u8f91..."));
        this._btnEdit.setEnabled(false);
        this._clear = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_delete.gif"));
        this._clear.setEnabled(false);
        this._commit = new KDWorkButton((Icon)ResourceManager.getImageIcon("tbtn_save.gif"));
        this._commit.setEnabled(false);
        TableLayout2 layout = new TableLayout2(8, 9);
        layout.setRowsSpacing(TableLayout2.ALL, 3);
        layout.setFixedHeight(new int[]{0, 7}, 10);
        layout.setFixedHeight(new int[]{1, 3, 4, 5, 6}, 20);
        layout.setRatableHeight(2, 100);
        layout.setColsSpacing(TableLayout2.ALL, 4);
        layout.setFixedWidth(new int[]{0, 8}, 10);
        layout.setFixedWidth(new int[]{1, 2, 3}, 20);
        layout.setFixedWidth(new int[]{4, 5}, 68);
        layout.setRatableWidth(6, 100);
        layout.setFixedWidth(7, 72);
        Container cp = this.getContentPane();
        cp.setLayout((LayoutManager)layout);
        cp.add((Component)this._btnInsert, TableLayout2.param((int)1, (int)1, (int)1, (int)3));
        cp.add((Component)this._btnEdit, TableLayout2.param((int)1, (int)4));
        cp.add((Component)this._btnDelete, TableLayout2.param((int)1, (int)5));
        cp.add((Component)this._namesList, TableLayout2.param((int)2, (int)1, (int)2, (int)7));
        cp.add((Component)refLabel, TableLayout2.param((int)3, (int)1, (int)3, (int)3));
        cp.add((Component)this._clear, TableLayout2.param((int)4, (int)1));
        cp.add((Component)this._commit, TableLayout2.param((int)4, (int)2));
        cp.add((Component)this._rs, TableLayout2.param((int)4, (int)3, (int)4, (int)7));
        cp.add((Component)this._btnCancel, TableLayout2.param((int)6, (int)7));
    }

    private void initListeners() {
        BtnHandler bh = new BtnHandler();
        this._btnEdit.addActionListener((ActionListener)bh);
        this._btnCancel.addActionListener((ActionListener)bh);
        this._btnInsert.addActionListener((ActionListener)bh);
        this._btnDelete.addActionListener((ActionListener)bh);
        this._clear.addActionListener((ActionListener)bh);
        this._commit.addActionListener((ActionListener)bh);
        this._namesList.addKDTSelectListener((KDTSelectListener)new ListHandler());
        this._rs.addPropertyChangeListener("RangeSelected", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Object value = evt.getNewValue();
                WizzardNameDefine.this._selectedNode.setRefersTo(value == null ? "" : value.toString());
                WizzardNameDefine.this._selectedNode.updateExpr(true);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WizzardNameDefine.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.setVisible(false);
        super.dispose();
    }

    private void setConfigButtonState(boolean enabled) {
        this._rs.setEnabled(enabled);
        this._clear.setEnabled(enabled);
        this._commit.setEnabled(enabled);
        this._btnEdit.setEnabled(enabled);
        this._btnDelete.setEnabled(enabled);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.updateValues();
        } else {
            this._selectedRow = KDTableUtil.getSelectedRow((KDTable)this._namesList);
            if (this._selectedRow != null) {
                this._selectedNode = (NamedObjectNode)this._selectedRow.getUserObject();
            }
        }
        super.setVisible(b);
    }

    private static boolean isNamed(SortedNamedObjectNodeArray names, String name) {
        NamedObjectNode existNamed = names.searchByName(name);
        return existNamed != null && !existNamed.isUndefined();
    }

    private static void updateAllExprsAtBook(Book book, String oldName, String newName) {
        for (int i = book.getSheetCount() - 1; i >= 0; --i) {
            Sheet sheet = book.getSheet(i);
            if (WizzardNameDefine.isNamed(sheet.getNames(), newName)) continue;
            WizzardNameDefine.updateAllExprsAtSheet(book, sheet, oldName, newName);
        }
    }

    private static void updateAllExprsByDeleteAtSheet(Book book, Sheet sheet, String name) {
        if (WizzardNameDefine.isNamed(book.getNames(), name)) {
            WizzardNameDefine.updateAllExprsAtSheet(book, sheet, name, book.getNames().searchByName(name).getName());
        }
    }

    private static void updateAllExprsAtSheet(Book book, Sheet sheet, String oldName, String newName) {
        SortedRowArray rows = sheet.getRows();
        for (int j = rows.size() - 1; j >= 0; --j) {
            Row row = rows.getAt(j);
            for (int k = row.size() - 1; k >= 0; --k) {
                Cell cell = row.getAt(k);
                Expr expr = cell.getExpr();
                if (expr == null) continue;
                WizzardNameDefine.updateExpr(book, sheet, cell, expr, oldName, newName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateExpr(Book book, Sheet sheet, Cell cell, Expr expr, String oldName, String newName) {
        if (!expr.hasNamedObject()) {
            return;
        }
        boolean isChanged = false;
        IExprNode[] nodes = expr.getAllNodes();
        for (int i = 0; i < nodes.length; ++i) {
            NamedObjectNode node;
            if (!(nodes[i] instanceof NamedObjectNode) || !(node = (NamedObjectNode)nodes[i]).getName().equalsIgnoreCase(oldName)) continue;
            nodes[i] = NamedObjectNode.createUndefinedNamedObject(newName, node.getBook(), node.isLocal() ? node.getSheet() : null);
            isChanged = true;
        }
        if (!isChanged) {
            return;
        }
        boolean isUndoEnabled = book.getUndoManager().isEnable();
        book.getUndoManager().enable(false);
        try {
            expr = Expr.getExpr(null, nodes, expr.getExprNodeState(), 0, nodes.length);
            String formula = expr.decode(sheet.getDeps().getExprContext(), cell);
            Range range = sheet.getRange(cell);
            range.setFormula("=" + formula);
        }
        finally {
            book.getUndoManager().enable(isUndoEnabled);
        }
    }

    private static class NameNodeConfigurationDialog
    extends KDDialog {
        private KDButton _confirm;
        private KDButton _cancel;
        private KDTextField _nameField;
        private RangeSelector _rs;
        private KDComboBox _scopeSelector;
        private KDLabelContainer _name;
        private KDLabelContainer _scope;
        private KDLabelContainer _reference;
        private SpreadContext _context;
        private WizzardNameDefine _parent;
        private NamedObjectNode _editNode;

        NameNodeConfigurationDialog(WizzardNameDefine parent, SpreadContext context) {
            super((Dialog)((Object)parent));
            this.setSize(320, 170);
            this.setDefaultCloseOperation(1);
            this.setLocationRelativeTo((Component)((Object)parent));
            this._context = context;
            this._parent = parent;
            this.initComponents();
        }

        void setSheetNames(String[] sheetNames) {
            this._scopeSelector.removeAllItems();
            this._scopeSelector.addItem((Object)CtrlEXTMessages.getMLS("KEY_BOOK", "\u5de5\u4f5c\u7c3f"));
            int len = sheetNames.length;
            for (int i = 0; i < len; ++i) {
                this._scopeSelector.addItem((Object)sheetNames[i]);
            }
        }

        void updateValues(NamedObjectNode node, String defaultSelection) {
            this._editNode = node;
            if (this.isInsertState()) {
                this._nameField.setText("");
                this._scopeSelector.setSelectedIndex(0);
                this._scopeSelector.setEnabled(true);
                this._rs.setText(defaultSelection);
            } else {
                this._nameField.setText(node.getName());
                if (node.isLocal()) {
                    this._scopeSelector.setSelectedItem((Object)node.getSheet().getSheetName());
                } else {
                    this._scopeSelector.setSelectedIndex(0);
                }
                this._scopeSelector.setEnabled(false);
                this._rs.setText(node.getRefersTo());
            }
        }

        private void initComponents() {
            this._confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
            this._cancel = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
            this._nameField = new KDTextField();
            this._rs = new RangeSelector(this._context);
            this._scopeSelector = new KDComboBox((Object[])new String[]{CtrlEXTMessages.getMLS("KEY_BOOK", "\u5de5\u4f5c\u7c3f")});
            this._name = new KDLabelContainer(CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"), (JComponent)this._nameField);
            this._name.setBoundLabelUnderline(true);
            this._name.setBoundLabelLength(80);
            this._scope = new KDLabelContainer(CtrlEXTMessages.getMLS("KEY_SCOPE", "\u8303\u56f4"), (JComponent)this._scopeSelector);
            this._scope.setBoundLabelLength(80);
            this._scope.setBoundLabelUnderline(true);
            this._reference = new KDLabelContainer(CtrlEXTMessages.getMLS("KEY_REFPOSITION", "\u5f15\u7528\u4f4d\u7f6e"), (JComponent)this._rs);
            this._reference.setBoundLabelLength(80);
            this._reference.setBoundLabelUnderline(true);
            TableLayout2 layout = new TableLayout2(7, 5);
            layout.setRowsSpacing(TableLayout2.ALL, 3);
            layout.setFixedHeight(new int[]{0, 6}, 10);
            layout.setFixedHeight(new int[]{1, 2, 3, 5}, 20);
            layout.setRatableHeight(4, 100);
            layout.setColsSpacing(TableLayout2.ALL, 4);
            layout.setFixedWidth(new int[]{0, 4}, 10);
            layout.setFixedWidth(new int[]{2, 3}, 72);
            layout.setRatableWidth(1, 100);
            Container cp = this.getContentPane();
            cp.setLayout((LayoutManager)layout);
            cp.add((Component)this._name, TableLayout2.param((int)1, (int)1, (int)1, (int)3));
            cp.add((Component)this._scope, TableLayout2.param((int)2, (int)1, (int)2, (int)3));
            cp.add((Component)this._reference, TableLayout2.param((int)3, (int)1, (int)3, (int)3));
            cp.add((Component)this._confirm, TableLayout2.param((int)5, (int)2));
            cp.add((Component)this._cancel, TableLayout2.param((int)5, (int)3));
            this.initListeners();
        }

        private void initListeners() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            _parent.setVisible(true);
                        }
                    });
                }
            });
            this._confirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String name = _nameField.getText().trim();
                    String ref = _rs.getText().trim();
                    if (StringUtil.isEmptyString((String)ref)) {
                        _context.getFacadeManager().showErrorMessageBox(CtrlEXTMessages.getMLS("referenceLocationEmpty", "\u5f15\u7528\u4f4d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002"), 2);
                        return;
                    }
                    try {
                        Book tempBook = Book.Manager.getNewBook();
                        NamedObjectNode no = Range.validateName(name, tempBook, tempBook.getSheet(0));
                        Range.validateRefersTo(ref, tempBook.getSheet(0), no);
                    }
                    catch (SyntaxErrorException e2) {
                        if (e2.getExtData().equals("name")) {
                            _context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_NAME", "\u540d\u79f0\u65e0\u6548"), 2);
                        } else {
                            _context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE", "\u533a\u57df\u65e0\u6548"), 2);
                            _rs.requestFocus();
                        }
                        return;
                    }
                    Book book = _context.getBook();
                    ExtDataSetManager dsm = book.getDataSetManager();
                    for (int i = dsm.size() - 1; i >= 0; --i) {
                        if (!dsm.getAt(i).getAlias().equalsIgnoreCase(name)) continue;
                        _context.getFacadeManager().showErrorMessageBox(CtrlEXTMessages.getMLS("datasetNameConflict", "{" + name + "}\u5df2\u6709\u540c\u540d\u6570\u636e\u96c6\u3002").replace("#1", name), 2);
                        return;
                    }
                    int sheetIndex = _scopeSelector.getSelectedIndex();
                    if (sheetIndex != 0) {
                        Sheet sheet = book.getSheet(sheetIndex - 1);
                        if (this.checkNameExist(sheet.getNames(), name)) {
                            return;
                        }
                        String oldName = name;
                        if (!this.isInsertState()) {
                            oldName = _editNode.getName();
                            sheet.getNames().remove(_editNode);
                        }
                        sheet.getNames().insert(new NamedObjectNode(name, ref, book, sheet));
                        WizzardNameDefine.updateAllExprsAtSheet(book, sheet, oldName, name);
                    } else {
                        if (this.checkNameExist(book.getNames(), name)) {
                            return;
                        }
                        String oldName = name;
                        if (!this.isInsertState()) {
                            oldName = _editNode.getName();
                            book.getNames().remove(_editNode);
                        }
                        book.getNames().insert(new NamedObjectNode(name, ref, book, null));
                        WizzardNameDefine.updateAllExprsAtBook(book, oldName, name);
                    }
                    this.closeDislog();
                }
            });
            this._cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.closeDislog();
                }
            });
        }

        private boolean isInsertState() {
            return this._editNode == null;
        }

        private boolean checkNameExist(SortedNamedObjectNodeArray names, String newName) {
            if ((this.isInsertState() || !this._editNode.getName().equalsIgnoreCase(newName)) && WizzardNameDefine.isNamed(names, newName)) {
                this._context.getFacadeManager().showErrorMessageBox(CtrlEXTMessages.getMLS("nameNotUnique", "\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\u3002"), 2);
                return true;
            }
            return false;
        }

        void closeDislog() {
            this.setVisible(false);
            this.dispose();
            this._parent.setVisible(true);
        }
    }

    private class ListHandler
    implements KDTSelectListener {
        private ListHandler() {
        }

        public void tableSelectChanged(KDTSelectEvent e) {
            WizzardNameDefine.this._selectedRow = KDTableUtil.getSelectedRow((KDTable)WizzardNameDefine.this._namesList);
            if (WizzardNameDefine.this._selectedRow != null) {
                WizzardNameDefine.this._selectedNode = (NamedObjectNode)WizzardNameDefine.this._selectedRow.getUserObject();
                WizzardNameDefine.this._rs.setText(WizzardNameDefine.this._selectedNode.getRefersTo());
                WizzardNameDefine.this.setConfigButtonState(true);
            }
        }
    }

    private class BtnHandler
    extends AbstractAction {
        private BtnHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (WizzardNameDefine.this._ncd == null) {
                WizzardNameDefine.this._ncd = new NameNodeConfigurationDialog(WizzardNameDefine.this, WizzardNameDefine.this._context);
            }
            if (source == WizzardNameDefine.this._btnInsert) {
                WizzardNameDefine.this.setVisible(false);
                this.updateSheetScope();
                WizzardNameDefine.this._ncd.setTitle(CtrlEXTMessages.getMLS("newName", "\u65b0\u5efa\u540d\u79f0"));
                WizzardNameDefine.this._ncd.updateValues(null, WizzardNameDefine.this._context.getBook().getSelectionRange().toString());
                WizzardNameDefine.this._ncd.setVisible(true);
            } else if (source == WizzardNameDefine.this._btnEdit) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)WizzardNameDefine.this._namesList);
                NamedObjectNode node = (NamedObjectNode)row.getUserObject();
                WizzardNameDefine.this.setVisible(false);
                this.updateSheetScope();
                WizzardNameDefine.this._ncd.setTitle(CtrlEXTMessages.getMLS("editName", "\u7f16\u8f91\u540d\u79f0"));
                WizzardNameDefine.this._ncd.updateValues(node, null);
                WizzardNameDefine.this._ncd.setVisible(true);
            } else if (source == WizzardNameDefine.this._btnCancel) {
                WizzardNameDefine.this.closeDialog();
            } else if (source == WizzardNameDefine.this._btnDelete) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)WizzardNameDefine.this._namesList);
                NamedObjectNode node = (NamedObjectNode)row.getUserObject();
                if (!node.isLocal()) {
                    WizzardNameDefine.this._context.getBook().getNames().remove(node);
                } else {
                    String nameToDelete = node.getName();
                    Sheet sheet = node.getSheet();
                    sheet.getNames().remove(node);
                    WizzardNameDefine.updateAllExprsByDeleteAtSheet(WizzardNameDefine.this._context.getBook(), sheet, nameToDelete);
                }
                WizzardNameDefine.this._selectedRow = null;
                WizzardNameDefine.this.updateValues();
                WizzardNameDefine.this.setConfigButtonState(false);
                WizzardNameDefine.this._rs.setText("");
            } else if (source == WizzardNameDefine.this._clear) {
                WizzardNameDefine.this._rs.setText("");
            } else if (source == WizzardNameDefine.this._commit) {
                WizzardNameDefine.this._selectedRow = null;
                IRow row = KDTableUtil.getSelectedRow((KDTable)WizzardNameDefine.this._namesList);
                NamedObjectNode node = (NamedObjectNode)row.getUserObject();
                node.setRefersTo(WizzardNameDefine.this._rs.getText());
                node.updateExpr(true);
                WizzardNameDefine.this.updateValues();
            }
        }

        private void updateSheetScope() {
            Book book = WizzardNameDefine.this._context.getBook();
            int len = book.getSheetCount();
            String[] sheetNames = new String[len];
            for (int i = 0; i < len; ++i) {
                sheetNames[i] = book.getSheetName(i);
            }
            WizzardNameDefine.this._ncd.setSheetNames(sheetNames);
        }
    }
}

