/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.ConfirmPasswordDialog;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookProtection;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPasswordField;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JComponent;

public final class WizzardProBook
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel _text;
    private KDSeparator _sep;
    private KDCheckBox _structItem;
    private KDCheckBox _windowItem;
    private KDSeparator _sep2;
    private KDPasswordField _pwField;
    private KDLabelContainer _pwLC;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private ActionListener _eventHandle;
    private String _newPassword;
    private int _newOpers;
    private boolean _isChanged;

    public WizzardProBook(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.init();
    }

    public WizzardProBook(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.init();
    }

    @Override
    public void commit() {
        BookProtection pro = this._context.getBook().getProtection();
        if (this.isChanged()) {
            pro.setOperations(this.getNewOperations());
            pro.start(this.getNewPassword());
        }
    }

    @Override
    public boolean prepare() {
        this._isChanged = false;
        BookProtection pro = this._context.getBook().getProtection();
        this.setProtection(pro);
        return !pro.isProtected();
    }

    private void init() {
        this.setSize(252, 180);
        this.setResizable(false);
        this._eventHandle = new ActionHandle();
        this._text = new KDLabel(MultiLanguageKeys.getLocalText("KEY_PROTECTBOOK"));
        this._sep = new KDSeparator();
        this._structItem = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_STRUCT"));
        this._structItem.setSelected(true);
        this._structItem.addActionListener(this._eventHandle);
        this._windowItem = new KDCheckBox(MultiLanguageKeys.getLocalText("KEY_WINDOW"));
        this._windowItem.addActionListener(this._eventHandle);
        this._sep2 = new KDSeparator();
        this._pwField = new KDPasswordField();
        this._pwLC = new KDLabelContainer((JComponent)this._pwField);
        this._pwLC.setBoundLabelText(MultiLanguageKeys.getLocalText("KEY_PASSWORD"));
        this._pwLC.setBoundLabelAlignment(8);
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._btnOk.addActionListener(this._eventHandle);
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CANCEL"));
        this._btnCancel.addActionListener(this._eventHandle);
        this.layoutComponents();
    }

    private void layoutComponents() {
        Container cp = this.getContentPane();
        cp.setLayout(null);
        cp.add((Component)this._text);
        cp.add((Component)this._sep);
        cp.add((Component)this._structItem);
        cp.add((Component)this._windowItem);
        cp.add((Component)this._sep2);
        cp.add((Component)this._pwLC);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        this._text.setBounds(8, 8, 70, 20);
        this._sep.setBounds(80, 18, 162, 2);
        this._structItem.setBounds(15, 30, 80, 20);
        this._windowItem.setBounds(15, 52, 80, 20);
        this._sep2.setBounds(8, 80, 234, 2);
        this._pwLC.setBounds(15, 84, 230, 40);
        this._pwLC.setBoundLabelLength(19);
        this._btnOk.setBounds(90, 126, 30, 20);
        this._btnCancel.setBounds(170, 126, 30, 20);
    }

    private void setProtection(BookProtection pro) {
        if (pro != null) {
            this._windowItem.setSelected(pro.allowOperatorWindow());
            this._structItem.setSelected(pro.allowOperatorStruct());
        }
        this._pwField.setText("");
    }

    private String getNewPassword() {
        return this._newPassword;
    }

    private int getNewOperations() {
        return this._newOpers;
    }

    private boolean isChanged() {
        return this._isChanged;
    }

    private void closeDialog() {
        this.setVisible(false);
        this.dispose();
    }

    private void genOperations() {
        this._newOpers = 0;
        if (this._structItem.isSelected()) {
            ++this._newOpers;
        }
        if (this._windowItem.isSelected()) {
            this._newOpers += 2;
        }
    }

    private boolean genPassword() {
        if (this._pwField.getPassword().length > 0) {
            ConfirmPasswordDialog cpd = this._context.getFacadeManager().getConfirmPWDialog();
            cpd.setLocationRelativeTo((Component)((Object)this));
            cpd.setVisible(true);
            if (cpd.isCanceled()) {
                return false;
            }
            char[] cs = this._pwField.getPassword();
            StringBuilder sb = new StringBuilder();
            for (char c : cs) {
                sb.append(c);
            }
            Arrays.fill(cs, ' ');
            if (!StringUtil.equals((String)sb.toString(), (String)cpd.getPassword())) {
                this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_NOSAMEPASSWORD"), 0);
                return false;
            }
            this._newPassword = cpd.getPassword();
        } else {
            this._newPassword = "";
        }
        return true;
    }

    private class ActionHandle
    implements ActionListener {
        private ActionHandle() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == WizzardProBook.this._btnOk) {
                if (WizzardProBook.this.genPassword()) {
                    WizzardProBook.this.genOperations();
                    WizzardProBook.this._isChanged = true;
                    WizzardProBook.this.closeDialog();
                }
            } else if (e.getSource() == WizzardProBook.this._btnCancel) {
                WizzardProBook.this._isChanged = false;
                WizzardProBook.this.closeDialog();
            } else if (e.getSource() == WizzardProBook.this._structItem || e.getSource() == WizzardProBook.this._windowItem) {
                WizzardProBook.this._btnOk.setEnabled(WizzardProBook.this._structItem.isSelected() || WizzardProBook.this._windowItem.isSelected());
            }
        }
    }
}

