/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.ConfirmPasswordDialog;
import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.impl.facade.rangesel.RangeSelector;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPasswordField;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class WizzardProRange
extends KDDialog
implements ISpreadWizzard {
    private SpreadContext _context;
    private KDLabel _lbName;
    private KDTextField _tfName;
    private KDList _listRanges;
    private KDLabel _lbRef;
    private RangeSelector _rsRef;
    private KDLabel _lbPassword;
    private KDPasswordField _tfPassword;
    private KDButton _btnOk;
    private KDButton _btnCancel;
    private KDButton _btnInsert;
    private KDButton _btnDelete;
    private KDButton _btnProtect;
    private KDButton _btnPermit;

    public WizzardProRange(Frame parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComponents();
        this.initListeners();
    }

    public WizzardProRange(Dialog parent, SpreadContext context) {
        super(parent, true);
        this._context = context;
        this.initComponents();
        this.initListeners();
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean prepare() {
        this.syncComps();
        this._rsRef.prepare();
        return true;
    }

    private void syncComps() {
        Protection.SortedEditalbeAreaArray allBlocks;
        this._listRanges.removeAllElements();
        Book book = this._context.getBook();
        Sheet sheet = book.getActiveSheet();
        Protection pro = sheet.getSheetOption().getProtection(false);
        if (pro != null && (allBlocks = pro.getEditableBlocks()) != null) {
            int size = allBlocks.size();
            for (int i = 0; i < size; ++i) {
                this._listRanges.addElement(allBlocks.get(i));
            }
        }
        this._tfName.setText("");
        this._rsRef.setText("");
        this._tfPassword.setText("");
    }

    private void initComponents() {
        int ins;
        Container cp = this.getContentPane();
        cp.setLayout(null);
        String text = MultiLanguageKeys.getLocalText("KEY_NAME");
        this._lbName = new KDLabel(text);
        this._tfName = new KDTextField();
        this._listRanges = new KDList();
        KDScrollPane sp = new KDScrollPane((Component)this._listRanges);
        this._lbRef = new KDLabel(MultiLanguageKeys.getLocalText("KEY_REFPOSITION") + ":");
        this._rsRef = this._context.getFacadeManager().createRangeSelector(MultiLanguageKeys.getLocalText("KEY_REFPOSITION") + ":");
        this._rsRef.setAbsRangeName(true);
        String pw = MultiLanguageKeys.getLocalText("KEY_PASSWORD");
        this._lbPassword = new KDLabel(pw + ":");
        this._tfPassword = new KDPasswordField();
        this._btnProtect = new KDButton(MultiLanguageKeys.getLocalText("KEY_PROTECTSHEET"));
        this._btnPermit = new KDButton(MultiLanguageKeys.getLocalText("KEY_PERMIT"));
        this._btnPermit.setEnabled(false);
        this._btnOk = new KDButton(MultiLanguageKeys.getLocalText("KEY_OK"));
        this._btnCancel = new KDButton(MultiLanguageKeys.getLocalText("KEY_CLOSE"));
        this._btnInsert = new KDButton(MultiLanguageKeys.getLocalText("KEY_INSERT"));
        this._btnDelete = new KDButton(MultiLanguageKeys.getLocalText("KEY_DELETE"));
        cp.add((Component)this._lbName);
        cp.add((Component)this._tfName);
        cp.add((Component)sp);
        cp.add((Component)this._lbRef);
        cp.add(this._rsRef);
        cp.add((Component)this._lbPassword);
        cp.add((Component)this._tfPassword);
        cp.add((Component)this._btnProtect);
        cp.add((Component)this._btnPermit);
        cp.add((Component)this._btnOk);
        cp.add((Component)this._btnCancel);
        cp.add((Component)this._btnInsert);
        cp.add((Component)this._btnDelete);
        int btnw = 70;
        int lbw = 100;
        int spw = 270;
        int sph = 150;
        int h = 20;
        int x = ins = 5;
        int y = ins;
        this._lbName.setBounds(x, y, lbw, h);
        this._tfName.setBounds(x + lbw + ins, y, 280, h);
        this._lbRef.setBounds(x, y += h + ins, lbw, h);
        this._rsRef.setBounds(x + lbw + ins, y, 280, h);
        this._lbPassword.setBounds(x, y += h + ins, lbw, h);
        this._tfPassword.setBounds(x + lbw + ins, y, 280, h);
        sp.setBounds(x, y += h + ins, spw, sph);
        x = ins * 2 + spw + 30;
        this._btnOk.setLimitedSize(false);
        this._btnOk.setBounds(x, y, btnw, h);
        this._btnCancel.setLimitedSize(false);
        this._btnCancel.setBounds(x, y += h + ins, btnw, h);
        this._btnInsert.setLimitedSize(false);
        this._btnInsert.setBounds(x, y += h + ins, btnw, h);
        this._btnDelete.setLimitedSize(false);
        this._btnDelete.setBounds(x, y += h + ins, btnw, h);
        this._btnPermit.setLimitedSize(false);
        this._btnPermit.setBounds(x, y += h + ins, btnw, h);
        this._btnProtect.setLimitedSize(false);
        this._btnProtect.setBounds(x - 30, y += h + ins, 100, h);
        int w = spw + 100 + 3 * ins + 15;
        h = 6 * ins + h * 4 + sph;
        this.setSize(w, h);
        this.setResizable(false);
    }

    private void initListeners() {
        this.setDefaultCloseOperation(0);
        TheAction bh = new TheAction();
        DeleteRangeAction delAction = new DeleteRangeAction();
        this._tfName.addActionListener((ActionListener)bh);
        this._rsRef.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "enter");
        this._rsRef.getActionMap().put("enter", bh);
        this._btnOk.addActionListener((ActionListener)bh);
        this._btnCancel.addActionListener((ActionListener)bh);
        this._btnInsert.addActionListener((ActionListener)bh);
        this._btnDelete.addActionListener((ActionListener)delAction);
        this._btnProtect.addActionListener((ActionListener)bh);
        this._btnPermit.addActionListener((ActionListener)bh);
        this._listRanges.getInputMap().put(KeyStroke.getKeyStroke(127, 0), "deleterange");
        this._listRanges.getActionMap().put("deleterange", delAction);
        this._listRanges.addListSelectionListener((ListSelectionListener)new ListHandler());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                WizzardProRange.this.closeDialog();
            }
        });
    }

    private void closeDialog() {
        this.setVisible(false);
        super.dispose();
    }

    private class ListHandler
    implements ListSelectionListener {
        private ListHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Protection.EditableArea blocks = (Protection.EditableArea)WizzardProRange.this._listRanges.getSelectedValue();
            WizzardProRange.this._tfName.setText(blocks == null ? "" : blocks.getName());
            WizzardProRange.this._rsRef.setText(blocks == null ? "" : Sheet.getBlocksA1Name(blocks, true));
            WizzardProRange.this._tfPassword.setText(blocks == null ? "" : MultiLanguageKeys.getLocalText("KEY_PASSWORD"));
        }
    }

    private class TheAction
    extends AbstractAction {
        private TheAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            Book book = WizzardProRange.this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            if (source == WizzardProRange.this._btnProtect) {
                WizzardProRange.this.closeDialog();
                WizzardProRange.this._context.getActionManager().getAction("Show_ProtectSheet_Wizzard").actionPerformed(e);
            } else if (source != WizzardProRange.this._btnPermit) {
                if (source == WizzardProRange.this._btnOk || source == WizzardProRange.this._tfName || source == WizzardProRange.this._rsRef || source == WizzardProRange.this._tfPassword || source == WizzardProRange.this._btnInsert) {
                    String name = WizzardProRange.this._tfName.getText();
                    if (StringUtil.isEmptyString((String)name)) {
                        WizzardProRange.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_NAME"), 0);
                        WizzardProRange.this._tfName.requestFocus();
                        return;
                    }
                    Range rg = null;
                    String refersTo = WizzardProRange.this._rsRef.getText();
                    if (!StringUtil.isEmptyString((String)refersTo)) {
                        rg = WizzardProRange.this._context.getRangeManager().findRangeInBook(refersTo, false);
                    }
                    if (rg == null) {
                        WizzardProRange.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_INVALID_RANGE"), 0);
                        WizzardProRange.this._rsRef.requestFocus();
                        return;
                    }
                    Protection pro = sheet.getSheetOption().getProtection(true);
                    Protection.SortedEditalbeAreaArray blocks = pro.getEditableBlocks();
                    if (blocks != null) {
                        int size = blocks.size();
                        for (int i = 0; i < size; ++i) {
                            Protection.EditableArea cea = (Protection.EditableArea)blocks.get(i);
                            if (!cea.isTouched(rg)) continue;
                            WizzardProRange.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_Conflict_RANGE"), 0);
                            WizzardProRange.this._rsRef.requestFocus();
                            return;
                        }
                    }
                    boolean bCreateEditArea = false;
                    Protection.EditableArea ea = pro.getEditableArea(name, false);
                    if (ea == null) {
                        ea = pro.createEditableArea(name);
                        bCreateEditArea = true;
                    }
                    char[] cs = WizzardProRange.this._tfPassword.getPassword();
                    StringBuilder sb = new StringBuilder();
                    for (char c : cs) {
                        sb.append(c);
                    }
                    Arrays.fill(cs, ' ');
                    if (!ea.confirm(sb.toString()) && !StringUtil.isEmptyString((String)sb.toString())) {
                        ConfirmPasswordDialog cpd = WizzardProRange.this._context.getFacadeManager().getConfirmPWDialog();
                        cpd.setLocationRelativeTo((Component)((Object)WizzardProRange.this));
                        cpd.setVisible(true);
                        if (cpd.isCanceled()) {
                            return;
                        }
                        if (!StringUtil.equals((String)sb.toString(), (String)cpd.getPassword())) {
                            WizzardProRange.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_NOSAMEPASSWORD"), 0);
                            WizzardProRange.this._tfPassword.requestFocus();
                            return;
                        }
                    }
                    if (bCreateEditArea) {
                        pro.addEditableArea(ea);
                    } else {
                        ea.clear();
                    }
                    ea.setPassword(sb.toString());
                    ea.addAll(rg);
                    if (source == WizzardProRange.this._btnInsert) {
                        WizzardProRange.this.syncComps();
                    } else {
                        WizzardProRange.this.closeDialog();
                    }
                } else {
                    WizzardProRange.this.closeDialog();
                }
            }
        }
    }

    private class DeleteRangeAction
    extends AbstractAction {
        private DeleteRangeAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Protection.EditableArea ea;
            Book book = WizzardProRange.this._context.getBook();
            Sheet sheet = book.getActiveSheet();
            Protection pro = sheet.getSheetOption().getProtection(false);
            if (pro != null && (ea = pro.getEditableArea(WizzardProRange.this._tfName.getText(), false)) != null) {
                if (ea.confirm("")) {
                    pro.removeEditableArea(WizzardProRange.this._tfName.getText());
                } else {
                    ConfirmPasswordDialog cpd = WizzardProRange.this._context.getFacadeManager().getConfirmPWDialog();
                    cpd.setLocationRelativeTo((Component)((Object)WizzardProRange.this));
                    cpd.setVisible(true);
                    if (cpd.isCanceled()) {
                        return;
                    }
                    if (ea.confirm(cpd.getPassword())) {
                        pro.removeEditableArea(WizzardProRange.this._tfName.getText());
                    } else {
                        WizzardProRange.this._context.getFacadeManager().showErrorMessageBox(MultiLanguageKeys.getLocalText("KEY_NOSAMEPASSWORD"), 0);
                        WizzardProRange.this._tfPassword.requestFocus();
                        return;
                    }
                }
            }
            WizzardProRange.this.syncComps();
        }
    }
}

