/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.render;

import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JComponent;

public final class DragRubberRender {
    private static Paint paint;
    protected Shape _oldClip;
    protected Shape _oldShape;
    private boolean _bFill = true;

    static Paint getDragFillPaint() {
        if (paint == null) {
            Pattern pattern = Pattern.Percent50;
            Color clrPattern = Color.black;
            Color clrGround = Styles.getNullColor();
            byte[] r = new byte[]{(byte)clrGround.getRed(), (byte)clrPattern.getRed()};
            byte[] g = new byte[]{(byte)clrGround.getGreen(), (byte)clrPattern.getGreen()};
            byte[] b = new byte[]{(byte)clrGround.getBlue(), (byte)clrPattern.getBlue()};
            byte[] a = new byte[]{(byte)clrGround.getAlpha(), (byte)clrPattern.getAlpha()};
            IndexColorModel cm = new IndexColorModel(1, 2, r, g, b, a);
            BufferedImage img = new BufferedImage(8, 8, 12, cm);
            byte[] data = pattern.getPatternData();
            DataBufferByte db = new DataBufferByte(data, data.length);
            WritableRaster ras = Raster.createPackedRaster(db, 8, 8, 1, null);
            img.setData(ras);
            Rectangle rc = new Rectangle(0, 0, 8, 8);
            paint = new TexturePaint(img, rc);
        }
        return paint;
    }

    static Graphics2D createDraggedGraphics(JComponent comp) {
        Graphics2D g = (Graphics2D)comp.getGraphics();
        g.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g.setPaint(DragRubberRender.getDragFillPaint());
        g.setXORMode(comp.getBackground());
        g.setClip(comp.getVisibleRect());
        return g;
    }

    static Graphics2D createChartDragGraphcis(JComponent comp) {
        Graphics2D g = (Graphics2D)comp.getGraphics();
        g.setStroke(PenStyle.PS_DASH.getBaseStroke());
        g.setXORMode(comp.getBackground());
        g.setClip(comp.getVisibleRect());
        return g;
    }

    public void setBeFill(boolean bFill) {
        this._bFill = bFill;
    }

    public boolean beFill() {
        return this._bFill;
    }

    public void paint(JComponent comp, Shape shape) {
        Graphics2D g2d = this._bFill ? DragRubberRender.createDraggedGraphics(comp) : DragRubberRender.createChartDragGraphcis(comp);
        Shape clip = g2d.getClip();
        if (this._oldShape != null) {
            g2d.setClip(this._oldClip);
            if (this._bFill) {
                g2d.fill(this._oldShape);
            } else {
                g2d.draw(this._oldShape);
            }
        }
        g2d.setClip(clip);
        if (this._bFill) {
            g2d.fill(shape);
        } else {
            g2d.draw(shape);
        }
        this._oldClip = clip;
        this._oldShape = shape;
    }

    public void endPaint(JComponent comp) {
        Graphics2D g2d = this._bFill ? DragRubberRender.createDraggedGraphics(comp) : DragRubberRender.createChartDragGraphcis(comp);
        Shape clip = g2d.getClip();
        if (this._oldShape != null) {
            g2d.setClip(this._oldClip);
            if (this._bFill) {
                g2d.fill(this._oldShape);
            } else {
                g2d.draw(this._oldShape);
            }
            this._oldClip = null;
            this._oldShape = null;
        }
        g2d.setClip(clip);
    }

    public void clear() {
        this._oldClip = null;
        this._oldShape = null;
    }
}

