/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.render;

import com.kingdee.cosmic.ctrl.kds.core.IExtRender;
import com.kingdee.cosmic.ctrl.kds.core.IMouseController;
import com.kingdee.cosmic.ctrl.kds.core.RenderUtil;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.RowMouseController;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public final class RowExtRender
implements IExtRender {
    private SpreadContext _context;

    public RowExtRender(SpreadContext context) {
        this._context = context;
    }

    @Override
    public int getPaintMode() {
        RowMouseController cs;
        IMouseController mc = this._context.getSpread().getMouseController(2);
        if (mc instanceof RowMouseController && (cs = (RowMouseController)mc).isResizing()) {
            return 2;
        }
        return 0;
    }

    @Override
    public void paint(Graphics2D g2d, SpreadView view, int paintMode) {
        if (paintMode == 2) {
            RowMouseController cs = (RowMouseController)view.getMouseController();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            this.paintImpl(g2d, sheet, cs.getOffset(), cs.getCurRow(), cs.getCurRowVirtualH(), cs.getPressRow());
        }
    }

    public void paintImpl(Graphics2D g2d, Sheet sheet, int offset, int curRow, int curRowHeight, int pressRow) {
        int firstY;
        Rectangle clip = g2d.getClipBounds();
        clip.height -= offset;
        int firstRow = SheetBaseMath.rowAtPoint(sheet, clip.getLocation());
        if (firstRow < 0) {
            return;
        }
        if (firstRow > pressRow) {
            firstRow = pressRow;
        }
        int endRow = SheetBaseMath.rowAtPoint(sheet, new Point(clip.x + clip.width - 1, clip.y + clip.height - 1));
        endRow = SheetBaseMath.dealInvalidRow(endRow);
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int endY = firstY = SheetBaseMath.getRowY(sheet, firstRow) - 1;
        int x1 = 0;
        int w = sheet.getRowHeaderWidth();
        int x2 = w - 1;
        int defH = sheet.getDefRowHeight();
        int preIndex = rowSpans.searchSpan(firstRow - 1);
        boolean preIsHide = preIndex >= 0 && !rowSpans.getAttributeSpan(preIndex).isVisible();
        SortedAttributeSpanArray.AttributeSpan span = null;
        for (int row = firstRow; row <= endRow; ++row) {
            int height;
            if (row > curRow && row <= pressRow) continue;
            boolean isHide = false;
            boolean isDefault = true;
            if (row == curRow) {
                height = curRowHeight;
            } else {
                int index = rowSpans.searchSpan(row);
                if (index >= 0) {
                    span = rowSpans.getAttributeSpan(index);
                    if (span.isVisible()) {
                        isHide = false;
                        isDefault = false;
                    } else {
                        preIsHide = true;
                        if (row < curRow && curRow <= span.getEnd()) {
                            row = curRow - 1;
                            continue;
                        }
                        row = span.getEnd();
                        continue;
                    }
                }
                height = isDefault ? defH : span.getOriginalLength();
            }
            int spacing = SheetBaseMath.getRowSpacing();
            Rectangle rect = new Rectangle(x1, endY + 1, sheet.getRowHeaderWidth(), height + spacing);
            g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
            if (row == pressRow + 1 && pressRow > curRow) {
                preIsHide = true;
            }
            if (preIsHide) {
                g2d.fillRect(x1, endY + 1, w, 1);
            }
            preIsHide = isHide;
            g2d.fillRect(x1, endY, w, 1);
            endY += height + spacing;
            String txt = SheetBaseMath.getRowName(sheet, row);
            RenderUtil.paintHeaderContent(g2d, sheet, txt, rect);
            RenderUtil.paintHeaderBackground(g2d, sheet.getSheetOption().getSelection().getSelectModeAtRow(row), rect);
        }
        g2d.setColor(RenderUtil.HEAD_GRID_COLOR);
        g2d.fillRect(x1, endY, w, 1);
        g2d.fillRect(x1, firstY, 1, endY - firstY + 1);
        g2d.fillRect(x2, firstY, 1, endY - firstY + 1);
    }
}

