/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.render;

import com.kingdee.cosmic.ctrl.kds.core.KDSpread;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public final class SparkRender
implements ActionListener {
    public static Stroke s1 = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 0.0f);
    public static Stroke s2 = new BasicStroke(1.0f, 0, 0, 10.0f, new float[]{4.0f}, 4.0f);
    private SpreadContext _context;
    private boolean _isOffset;
    private boolean _inUse;
    private Object _sparkBlocks;

    public SparkRender(SpreadContext context) {
        this._context = context;
    }

    public boolean isRunning() {
        return this._inUse;
    }

    public void start() {
        this._isOffset = false;
        this._context.getThreadManager().getTimer(150, this).start();
    }

    public void stop() {
        if (this._inUse) {
            this._context.getThreadManager().getTimer(150, this).stop();
            this._inUse = false;
            this.repaintControl();
            this._sparkBlocks = null;
        }
    }

    public void setSparkBlocks(Object sparkBlocks) {
        this._sparkBlocks = sparkBlocks;
    }

    private int sizeOfBlocks(Object blocks) {
        if (blocks instanceof SortedCellBlockArray) {
            return ((SortedCellBlockArray)blocks).size();
        }
        return ((Selection)blocks).size();
    }

    private CellBlock getBlock(Object blocks, int index) {
        if (blocks instanceof SortedCellBlockArray) {
            return ((SortedCellBlockArray)blocks).getBlock(index);
        }
        return ((Selection)blocks).getBlock(index);
    }

    public void paint(Graphics2D g2d, SpreadView view) {
        if (this._sparkBlocks == null) {
            return;
        }
        this._context.getThreadManager().getTimer(150, this).stop();
        KDSpread spread = this._context.getSpread();
        Sheet sheet = spread.getBook().getActiveSheet();
        Stroke oldStroke = g2d.getStroke();
        if (this._isOffset) {
            g2d.setStroke(s2);
        } else {
            g2d.setStroke(s1);
        }
        g2d.setColor(Color.black);
        g2d.setXORMode(view.getBackground());
        Rectangle vRect = view.getVisibleRect();
        int vx = vRect.x;
        int vy = vRect.y;
        int vx2 = vRect.width + vx - 1;
        int vy2 = vRect.height + vy - 1;
        for (int i = this.sizeOfBlocks(this._sparkBlocks) - 1; i >= 0; --i) {
            int ty2;
            int ty;
            int tx2;
            int tx;
            CellBlock cb = this.getBlock(this._sparkBlocks, i);
            Rectangle rect = SheetBaseMath.getBlockRect(sheet, cb, true);
            if (!(rect = SheetBaseMath.bufferRect(rect, 0, 0, -1, -1)).intersects(vRect)) continue;
            int x = rect.x;
            int y = rect.y;
            int x2 = rect.width + x - 1;
            int y2 = rect.height + y - 1;
            if (y >= vy && y <= vy2) {
                tx = Math.max(x, vx);
                tx2 = Math.min(x2, vx2);
                g2d.drawLine(tx, y, tx2, y);
                g2d.drawLine(tx + 1, y + 1, tx2 - 1, y + 1);
            }
            if (y2 >= vy && y2 <= vy2) {
                tx = Math.max(x, vx);
                tx2 = Math.min(x2, vx2);
                g2d.drawLine(tx, y2, tx2, y2);
                g2d.drawLine(tx + 1, y2 - 1, tx2 - 1, y2 - 1);
            }
            if (x >= vx && x <= vx2) {
                ty = Math.max(y, vy);
                ty2 = Math.min(y2, vy2);
                g2d.drawLine(x, ty, x, ty2);
                g2d.drawLine(x + 1, ty + 1, x + 1, ty2 - 1);
            }
            if (x2 < vx || x2 > vx2) continue;
            ty = Math.max(y, vy);
            ty2 = Math.min(y2, vy2);
            g2d.drawLine(x2, ty, x2, ty2);
            g2d.drawLine(x2 - 1, ty + 1, x2 - 1, ty2 - 1);
        }
        g2d.setStroke(oldStroke);
        g2d.setPaintMode();
        this._context.getThreadManager().getTimer(150, this).start();
    }

    private void repaintControl() {
        if (this._sparkBlocks == null) {
            return;
        }
        try {
            KDSpread spread = this._context.getSpread();
            Sheet sheet = spread.getBook().getActiveSheet();
            for (int i = spread.getVerticalCount() - 1; i >= 0; --i) {
                for (int j = spread.getHorizonCount() - 1; j >= 0; --j) {
                    SpreadView view = (SpreadView)spread.getView(i, j);
                    if (view.getViewType() != 3) continue;
                    for (int k = this.sizeOfBlocks(this._sparkBlocks) - 1; k >= 0; --k) {
                        CellBlock cb = this.getBlock(this._sparkBlocks, k);
                        Rectangle rect = SheetBaseMath.getBlockRect(sheet, cb, true);
                        int x = rect.x;
                        int y = rect.y;
                        int w = rect.width;
                        int h = rect.height;
                        int x2 = x + w - 1;
                        int y2 = y + h - 1;
                        view.repaint(x, y, 2, h);
                        view.repaint(x, y, w, 2);
                        view.repaint(x2 - 1, y, 2, h);
                        view.repaint(x, y2 - 1, w, 2);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.repaintControl();
        this._inUse = true;
        this._isOffset = !this._isOffset;
    }
}

