/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.impl.state.mouse;

import com.kingdee.cosmic.ctrl.kds.core.OutlineGroupRowHeader;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.DefaultMouseController;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.DefaultMouseState;
import com.kingdee.cosmic.ctrl.kds.impl.state.mouse.IMouseState;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.awt.event.MouseEvent;

public class OutlineGroupRowHeaderMouseController
extends DefaultMouseController {
    private SpreadContext _context;
    protected IMouseState rh = new OutlineGroupRowHeaderMouseHandle();

    public OutlineGroupRowHeaderMouseController(SpreadContext context) {
        this._context = context;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public IMouseState prePressing(MouseEvent e) {
        this._context.getSpread().setActiveView((SpreadView)e.getSource());
        return this.rh;
    }

    public static void switchTheHandlerWhenBelow(Sheet sheet, int rowId, SortedAttributeSpanArray sasa, int level, boolean isOff) {
        SortedAttributeSpanArray.AttributeSpan as;
        int pos;
        SortedCellBlockArray blocks = new SortedCellBlockArray();
        int i = rowId - 1;
        while ((pos = sasa.searchSpan(i)) >= 0 && (as = sasa.getAttributeSpan(pos)).getOutlineGroupLevel() > level) {
            if (!isOff) {
                blocks.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
            } else {
                int sPos;
                int m = as.getEnd() + 1;
                while ((sPos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(sPos);
                    if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                        if (lookupAs.getStart() == rowId) {
                            blocks.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
                            break;
                        }
                        if (OutlineGroupRowHeaderMouseController.isCollapseWhenHandlerBelow(lookupAs, sasa, rowId)) break;
                        blocks.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
                        break;
                    }
                    ++m;
                }
            }
            i = as.getStart();
            --i;
        }
        if (!blocks.isEmpty()) {
            sheet.getRange(blocks).setRowHidden(!isOff);
        }
        sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(!isOff);
    }

    private static boolean isCollapseWhenHandlerBelow(SortedAttributeSpanArray.AttributeSpan as, SortedAttributeSpanArray sasa, int rowId) {
        SortedAttributeSpanArray.AttributeSpan lookupAs;
        int sPos;
        if (as.isCollapse()) {
            return true;
        }
        int m = as.getEnd() + 1;
        while ((sPos = sasa.searchSpan(m)) >= 0 && (lookupAs = sasa.getAttributeSpan(sPos)).getStart() < rowId) {
            if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                if (lookupAs.isCollapse()) {
                    return true;
                }
                as = lookupAs;
            }
            ++m;
        }
        return false;
    }

    public static void switchTheHandlerWhenAbove(Sheet sheet, int rowId, SortedAttributeSpanArray sasa, int level, boolean isOff, int step) {
        SortedAttributeSpanArray.AttributeSpan as;
        int pos;
        SortedCellBlockArray blocks = new SortedCellBlockArray();
        int i = rowId + step;
        while ((pos = sasa.searchSpan(i)) >= 0 && (as = sasa.getAttributeSpan(pos)).getOutlineGroupLevel() > level) {
            if (!isOff) {
                blocks.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
            } else {
                int sPos;
                int m = as.getStart() - step;
                while ((sPos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(sPos);
                    if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                        if (lookupAs.getEnd() == rowId) {
                            blocks.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
                            break;
                        }
                        if (OutlineGroupRowHeaderMouseController.isCollapseWhenHandlerAbove(lookupAs, sasa, rowId, 1)) break;
                        blocks.insert(CellBlock.getCellBlock(as.getStart(), 0, as.getEnd(), 65535));
                        break;
                    }
                    m -= step;
                }
            }
            i = as.getEnd();
            ++i;
        }
        if (!blocks.isEmpty()) {
            sheet.getRange(blocks).setRowHidden(!isOff);
        }
        sheet.getRowRange(rowId, rowId).setRowOutlineGroupCollapse(!isOff);
    }

    private static boolean isCollapseWhenHandlerAbove(SortedAttributeSpanArray.AttributeSpan as, SortedAttributeSpanArray sasa, int rowId, int step) {
        SortedAttributeSpanArray.AttributeSpan lookupAs;
        int sPos;
        if (as.isCollapse()) {
            return true;
        }
        int m = as.getStart() - step;
        while ((sPos = sasa.searchSpan(m)) >= 0 && (lookupAs = sasa.getAttributeSpan(sPos)).getEnd() > rowId) {
            if (as.getOutlineGroupLevel() > lookupAs.getOutlineGroupLevel()) {
                if (lookupAs.isCollapse()) {
                    return true;
                }
                as = lookupAs;
            }
            --m;
        }
        return false;
    }

    static class OutlineGroupRowHeaderMouseHandle
    extends DefaultMouseState {
        private int cellWidth = 15;

        OutlineGroupRowHeaderMouseHandle() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void mousePressed(MouseEvent e) {
            SpreadView source = (SpreadView)e.getSource();
            if (!(source instanceof OutlineGroupRowHeader)) {
                return;
            }
            OutlineGroupRowHeader view = (OutlineGroupRowHeader)source;
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int rowId = SheetBaseMath.rowAtPoint(sheet, e.getPoint());
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            if (((SpreadView)e.getSource()).getSpread().getBook().getActiveSheet().isAboveOfOutlineGroup()) {
                if (spanPos < 0) {
                    spanPos = sasa.searchSpan(rowId + 1);
                    if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
                    level = 0;
                } else {
                    level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                }
                int nextRowLevel = 0;
                int nextSpanPos = sasa.searchSpan(rowId + 1);
                if (nextSpanPos >= 0) {
                    nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
                }
                if (level >= nextRowLevel) {
                    return;
                }
            } else {
                if (spanPos < 0) {
                    spanPos = sasa.searchSpan(rowId - 1);
                    if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
                    level = 0;
                } else {
                    level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
                }
                int prevRowLevel = 0;
                int prevSpanPos = sasa.searchSpan(rowId - 1);
                if (prevSpanPos >= 0) {
                    prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
                }
                if (level >= prevRowLevel) {
                    return;
                }
            }
            int rowY = SheetBaseMath.getRowY(sheet, rowId);
            int rowHeight = SheetBaseMath.getRowHeight(sheet, rowId);
            int basePos = this.cellWidth * level;
            int rectX1 = basePos + 6;
            int rectY1 = rowY + (rowHeight - this.cellWidth) / 2 + 2;
            int rectX2 = basePos + 6 + this.cellWidth;
            int rectY2 = rowY + (rowHeight - this.cellWidth) / 2 + 2 + this.cellWidth;
            int pressedX = e.getX();
            int pressedY = e.getY();
            if (pressedX <= rectX1 || pressedX >= rectX2 || pressedY <= rectY1 || pressedY >= rectY2) {
                return;
            }
            view.setArmedRowId(rowId);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            if (view instanceof OutlineGroupRowHeader && ((OutlineGroupRowHeader)view).getArmedRowId() >= 0) {
                ((OutlineGroupRowHeader)view).setArmedRowId(-1);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            Book book = ((SpreadView)e.getSource()).getSpread().getBook();
            book.getUndoManager().startGroup();
            if (book.getActiveSheet().isAboveOfOutlineGroup()) {
                this.handleMouseClickedWhenHandlerAbove(e);
            } else {
                this.handleMouseClickedWhenHandlerBelow(e);
            }
            book.getUndoManager().endGroup();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void handleMouseClickedWhenHandlerAbove(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int rowId = SheetBaseMath.rowAtPoint(sheet, e.getPoint());
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(rowId + 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int nextRowLevel = 0;
            int nextSpanPos = sasa.searchSpan(rowId + 1);
            if (nextSpanPos >= 0) {
                nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
            }
            int nextRowHeight = SheetBaseMath.getRowHeight(sheet, rowId + 1);
            boolean isOff = false;
            boolean isDot = false;
            if (level >= nextRowLevel) {
                isDot = true;
            } else {
                isOff = nextRowHeight == 0;
            }
            int rowY = SheetBaseMath.getRowY(sheet, rowId);
            int rowHeight = SheetBaseMath.getRowHeight(sheet, rowId);
            int basePos = this.cellWidth * level;
            int rectX1 = basePos + 6;
            int rectY1 = rowY + (rowHeight - this.cellWidth) / 2 + 2;
            int rectX2 = basePos + 6 + this.cellWidth;
            int rectY2 = rowY + (rowHeight - this.cellWidth) / 2 + 2 + this.cellWidth;
            int pressedX = e.getX();
            int pressedY = e.getY();
            if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenAbove(sheet, rowId, sasa, level, isOff, 1);
                return;
            } else {
                int virtualLevel = (pressedX - 4) / this.cellWidth;
                if (virtualLevel >= level) {
                    return;
                }
                int clickPos = (pressedX - 4) % this.cellWidth;
                if (clickPos < 5 || clickPos > 10) {
                    return;
                }
                boolean conjunctive = false;
                int m = rowId - 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == virtualLevel) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < virtualLevel) break;
                    if (span != null) {
                        m = span.getStart();
                    }
                    --m;
                }
                if (!conjunctive) return;
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenAbove(sheet, m, sasa, virtualLevel, false, 1);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void handleMouseClickedWhenHandlerBelow(MouseEvent e) {
            SpreadView view = (SpreadView)e.getSource();
            Sheet sheet = view.getSpread().getBook().getActiveSheet();
            int rowId = SheetBaseMath.rowAtPoint(sheet, e.getPoint());
            SortedAttributeSpanArray sasa = sheet.getRowSpans();
            int spanPos = sasa.searchSpan(rowId);
            int level = -1;
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(rowId - 1);
                if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
                level = 0;
            } else {
                level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
            }
            int prevRowLevel = 0;
            int prevSpanPos = sasa.searchSpan(rowId - 1);
            if (prevSpanPos >= 0) {
                prevRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
            }
            int prevRowHeight = SheetBaseMath.getRowHeight(sheet, rowId - 1);
            boolean isOff = false;
            boolean isDot = false;
            if (level >= prevRowLevel) {
                isDot = true;
            } else {
                isOff = prevRowHeight == 0;
            }
            int rowY = SheetBaseMath.getRowY(sheet, rowId);
            int rowHeight = SheetBaseMath.getRowHeight(sheet, rowId);
            int basePos = this.cellWidth * level;
            int rectX1 = basePos + 6;
            int rectY1 = rowY + (rowHeight - this.cellWidth) / 2 + 2;
            int rectX2 = basePos + 6 + this.cellWidth;
            int rectY2 = rowY + (rowHeight - this.cellWidth) / 2 + 2 + this.cellWidth;
            int pressedX = e.getX();
            int pressedY = e.getY();
            if (!isDot && pressedX > rectX1 && pressedX < rectX2 && pressedY > rectY1 && pressedY < rectY2) {
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenBelow(sheet, rowId, sasa, level, isOff);
                return;
            } else {
                int virtualLevel = (pressedX - 4) / this.cellWidth;
                if (virtualLevel >= level) {
                    return;
                }
                int clickPos = (pressedX - 4) % this.cellWidth;
                if (clickPos < 5 || clickPos > 10) {
                    return;
                }
                boolean conjunctive = false;
                int m = rowId + 1;
                while (true) {
                    int iteratedLevel;
                    int iteratedSpanPos = sasa.searchSpan(m);
                    SortedAttributeSpanArray.AttributeSpan span = null;
                    if (iteratedSpanPos < 0) {
                        iteratedLevel = 0;
                    } else {
                        span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                        iteratedLevel = span.getOutlineGroupLevel();
                    }
                    if (iteratedLevel == virtualLevel) {
                        conjunctive = true;
                        break;
                    }
                    if (iteratedLevel < virtualLevel) break;
                    if (span != null) {
                        m = span.getEnd();
                    }
                    ++m;
                }
                if (!conjunctive) return;
                OutlineGroupRowHeaderMouseController.switchTheHandlerWhenBelow(sheet, m, sasa, virtualLevel, false);
            }
        }
    }
}

