/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm.explorer;

import com.kingdee.cosmic.ctrl.kds.io.htm.explorer.SimpleHtmlAttributeSpan;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.util.IntArray;

public class HtmlSheetModel {
    private int _rowCount;
    private final int _maxRowIndex;
    private final int _maxColIndex;
    private boolean _isTree;
    private boolean _isHor;
    private int[] _visibleCloumns;
    private int _treePos;
    public static final int NODETYPE_EXTEND = -1;
    public static final int NODETYPE_COLLAPSE = 1;
    public static final int NODETYPE_NORMAL = 0;
    public static final int NODETYPE_UNTREE = 2;
    private SortedSpanArray _items;
    private SortedSpanArray _rows;
    private SortedSpanArray _columns;

    public HtmlSheetModel(Sheet sheet) {
        UserObject colTreePos = sheet.getUserObject("COLUMN_INLINED_TREE_POSITION");
        UserObject rowTreePos = sheet.getUserObject("ROW_INLINED_TREE_POSITION");
        this._maxRowIndex = sheet.getMaxRowIndex();
        this._maxColIndex = sheet.getMaxColIndex();
        this._rowCount = this._maxRowIndex;
        if (colTreePos != null ^ rowTreePos != null) {
            this._isTree = true;
            this._isHor = colTreePos == null;
            UserObject obj = colTreePos != null ? colTreePos : rowTreePos;
            this._treePos = Integer.parseInt(obj.getValue().toString());
        }
        this.initModels(sheet);
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public boolean isTree() {
        return this._isTree;
    }

    public boolean isHorizonTree() {
        return this._isTree && this._isHor;
    }

    public void addListener() {
    }

    public int getTreePos() {
        return this._treePos;
    }

    public int getForwardRowCount(int index) {
        int end;
        SortedSpanArray spans = null != this._rows ? this._rows : this._items;
        boolean changeable = null != this._rows;
        int spanIdx = null != this._rows ? this._rows.searchSpan(index) : this._items.searchSpan(index);
        int count = 0;
        Span span = null;
        if (spanIdx < 0) {
            end = index;
        } else {
            span = spans.getSpan(spanIdx);
            end = span.getStart() - 1;
            if (!changeable || ((SimpleHtmlAttributeSpan)span).isHidden()) {
                count += index - end;
            }
        }
        Span[] array = spans.getSpans(0, end);
        for (int i = 0; i < array.length; ++i) {
            span = array[i];
            if (changeable && !((SimpleHtmlAttributeSpan)span).isHidden()) continue;
            count += span.getExtent();
        }
        return index - count;
    }

    public boolean isHidden(int value, boolean isRow) {
        int index = this._items.searchSpan(value);
        if (index < 0) {
            return false;
        }
        SimpleHtmlAttributeSpan span = (SimpleHtmlAttributeSpan)this._items.getSpan(index);
        return span.isHidden();
    }

    public boolean setItemCollapse(int position) {
        int index = this._items.searchSpan(position);
        boolean skip = false;
        boolean isCollapse = false;
        if (index < 0) {
            int firstChild = this._items.searchSpan(position + 1);
            if (firstChild >= 0) {
                SimpleHtmlAttributeSpan span = (SimpleHtmlAttributeSpan)this._items.getSpan(firstChild);
                isCollapse = !span.isHidden();
                skip = true;
            } else {
                return false;
            }
        }
        if (!skip) {
            SimpleHtmlAttributeSpan span;
            span.setCollapse(!(span = (SimpleHtmlAttributeSpan)this._items.getSpan(index)).isCollapse());
            this.setNextLevleItemsHidden(position, span.getGroupLevel(), span.isCollapse());
        } else {
            this.setNextLevleItemsHidden(position, 0, isCollapse);
        }
        return true;
    }

    private void setNextLevleItemsHidden(int position, int level, boolean isCollapse) {
        SimpleHtmlAttributeSpan span;
        int index = this._items.searchSpan(position);
        int pos = position + 1;
        int expectLevel = level + 1;
        int groupLevel = -1;
        BooleanArray collapses = new BooleanArray(level);
        collapses.insert(isCollapse);
        while ((index = this._items.searchSpan(pos)) >= 0 && (groupLevel = (span = (SimpleHtmlAttributeSpan)this._items.getSpan(index)).getGroupLevel()) >= expectLevel) {
            if (isCollapse) {
                span.setHidden(true);
            } else {
                if (collapses.count() <= groupLevel) {
                    collapses.insert(span.isCollapse());
                } else {
                    collapses.set(groupLevel, span.isCollapse());
                }
                span.setHidden(collapses.getValue(groupLevel - 1));
            }
            pos += span.getExtent();
        }
    }

    public int getMaxRowIndex() {
        return this._maxRowIndex;
    }

    public int getMaxColIndex() {
        return this._maxColIndex;
    }

    public int searchEndRow(int startRow, int rowCount) {
        SortedSpanArray array;
        int endRow = startRow + rowCount - 1;
        Span[] spans = null;
        SortedSpanArray sortedSpanArray = array = this._rows != null ? this._rows : this._items;
        while (true) {
            if (endRow > this._maxRowIndex) {
                return this._maxRowIndex;
            }
            spans = array.getSpans(startRow, endRow);
            int sum = this.calcRow(spans);
            if (sum <= 0) break;
            startRow = endRow;
            endRow += sum;
        }
        return endRow;
    }

    public int searchStartRow(int forecast, boolean isNext) {
        int index;
        boolean checkHidden;
        int startRow = forecast;
        SortedSpanArray array = this._rows != null ? this._rows : this._items;
        boolean bl = checkHidden = this._rows == null;
        while ((index = array.searchSpan(startRow)) >= 0) {
            int symble;
            Span span = array.getSpan(index);
            if (null == span) continue;
            if (checkHidden) {
                if (!((SimpleHtmlAttributeSpan)span).isHidden()) break;
                symble = isNext ? 1 : -1;
                startRow += span.getExtent() * symble;
                continue;
            }
            symble = isNext ? 1 : -1;
            startRow += span.getExtent() * symble;
        }
        if (isNext) {
            return startRow > this._maxRowIndex ? -1 : startRow;
        }
        return startRow < 0 ? -1 : startRow;
    }

    public int searchNextRow(int index) {
        int nextRow = ++index;
        return this.searchStartRow(nextRow, true);
    }

    public int[] getVisibleColumns() {
        return this._visibleCloumns;
    }

    public void refresh_Columns() {
        int count = this.getMaxColIndex() + 1;
        IntArray columns = new IntArray();
        SortedSpanArray array = this._columns == null ? this._items : this._columns;
        boolean checkVisible = this._columns == null;
        for (int i = 0; i < count; ++i) {
            int spanIndex = array.searchSpan(i);
            if (spanIndex < 0) {
                columns.add(i);
                continue;
            }
            Span span = array.getSpan(spanIndex);
            if (checkVisible && !((SimpleHtmlAttributeSpan)span).isHidden()) {
                int end = span.getEnd();
                for (int start = span.getStart(); start <= end; ++start) {
                    columns.add(start);
                }
            }
            i += span.getExtent() - 1;
        }
        if (columns.size() > 0) {
            this._visibleCloumns = columns.toArray();
        }
        columns = null;
    }

    public int[] displayType(int position) {
        int level3;
        int[] result = new int[2];
        int maxIndex = this._isHor ? this._maxColIndex : this._maxRowIndex;
        SimpleHtmlAttributeSpan span2 = null;
        SimpleHtmlAttributeSpan span3 = null;
        int index = 0;
        if (position == maxIndex) {
            span3 = null;
        } else {
            index = this._items.searchSpan(position + 1);
            if (index >= 0) {
                span3 = (SimpleHtmlAttributeSpan)this._items.getSpan(index);
            }
        }
        index = this._items.searchSpan(position);
        if (index >= 0) {
            span2 = (SimpleHtmlAttributeSpan)this._items.getSpan(index);
        }
        int level2 = span2 != null ? span2.getGroupLevel() : 0;
        int n = level3 = span3 != null ? span3.getGroupLevel() : 0;
        int type = level3 > level2 && span3 != null ? (span3.isHidden() ? 1 : -1) : (level2 == 0 && level3 == 0 ? 2 : 0);
        result[0] = type;
        result[1] = level2;
        return result;
    }

    private int calcRow(Span[] spans) {
        int sum = 0;
        for (int i = 0; i < spans.length; ++i) {
            Span span = spans[i];
            sum += span.getExtent();
        }
        return sum;
    }

    private void initModels(Sheet sheet) {
        int size;
        Span span;
        if (this._isTree) {
            int i;
            int size2;
            SortedAttributeSpanArray spans;
            int end;
            if (this._isHor) {
                end = sheet.getMaxColIndex();
                this._items = new SortedSpanArray(end);
                spans = sheet.getColSpans();
                size2 = spans.size();
                for (i = 0; i < size2; ++i) {
                    span = spans.getAttributeSpan(i);
                    if (null == span) continue;
                    this.addChangeableItems(span.getStart(), span.getEnd(), !((SortedAttributeSpanArray.AttributeSpan)span).isVisible(), ((SortedAttributeSpanArray.AttributeSpan)span).isCollapse(), ((SortedAttributeSpanArray.AttributeSpan)span).getOutlineGroupLevel());
                }
            } else {
                end = sheet.getMaxRowIndex();
                this._items = new SortedSpanArray(end);
                spans = sheet.getRowSpans();
                size2 = spans.size();
                for (i = 0; i < size2; ++i) {
                    span = spans.getAttributeSpan(i);
                    if (null == span) continue;
                    this.addChangeableItems(span.getStart(), span.getEnd(), !((SortedAttributeSpanArray.AttributeSpan)span).isVisible(), ((SortedAttributeSpanArray.AttributeSpan)span).isCollapse(), ((SortedAttributeSpanArray.AttributeSpan)span).getOutlineGroupLevel());
                    this._rowCount -= span.getExtent();
                }
            }
        }
        if (!this._isTree || this._isHor) {
            this._rows = new SortedSpanArray(sheet.getMaxRowIndex());
            SortedAttributeSpanArray spans = sheet.getRowSpans();
            size = spans.size();
            for (int i = 0; i < size; ++i) {
                SortedAttributeSpanArray.AttributeSpan assSpan = spans.getAttributeSpan(i);
                if (null == assSpan || assSpan.isVisible()) continue;
                span = new Span(assSpan.getStart(), assSpan.getEnd());
                this._rows.insert(span);
                this._rowCount -= span.getExtent();
            }
        }
        if (!this._isTree || !this._isHor) {
            this._columns = new SortedSpanArray(sheet.getMaxColIndex());
            SortedAttributeSpanArray spans = sheet.getColSpans();
            size = spans.size();
            for (int i = 0; i < size; ++i) {
                SortedAttributeSpanArray.AttributeSpan assSpan = spans.getAttributeSpan(i);
                if (null == assSpan || assSpan.isVisible()) continue;
                span = new Span(assSpan.getStart(), assSpan.getEnd());
                this._columns.insert(span);
            }
        }
        this.refresh_Columns();
    }

    private void addChangeableItems(int start, int end, boolean hidden, boolean collapse, int level) {
        SimpleHtmlAttributeSpan span = new SimpleHtmlAttributeSpan(start, end, hidden, collapse, level);
        this._items.insert(span);
    }

    public SortedSpanArray getItems() {
        return this._items;
    }

    static class BooleanArray {
        private int _count;
        private boolean[] _values;
        private int _start;

        BooleanArray(int start) {
            this._start = start;
            this._values = new boolean[8];
        }

        public int count() {
            return this._count + this._start;
        }

        public void insert(boolean value) {
            if (this._values.length == this._count) {
                boolean[] temp = new boolean[2 * this._values.length];
                System.arraycopy(this._values, 0, temp, 0, this._count);
                this._values = temp;
            }
            this._values[this._count] = value;
            ++this._count;
        }

        public void set(int index, boolean value) {
            int realIndex = index - this._start;
            if (realIndex < this._count) {
                this._values[realIndex] = value;
            }
        }

        public boolean getValue(int index) {
            int realIndex = index - this._start;
            if (realIndex < this._count) {
                return this._values[realIndex];
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this._count - 1; ++i) {
                sb.append('[').append(Boolean.toString(this._values[i])).append(']');
                sb.append(',');
            }
            sb.append('[').append(Boolean.toString(this._values[this._count - 1])).append(']');
            return sb.toString();
        }
    }
}

