/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.htm.extweb;

import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.LengthEntry;
import com.kingdee.cosmic.ctrl.kds.io.htm.extweb.SortedLengthArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;

public class MeasureCalculator {
    private Sheet _sheet;
    private SortedLengthArray _rowHeights;
    private SortedLengthArray _colWidths;
    private int _row1;
    private int _row2;
    private boolean _paging;
    private LRBorderCalc _lrCalc;
    private TBBorderCalc _tbCalc;

    public MeasureCalculator(Sheet sheet, int row1, int row2, boolean paging) {
        this._sheet = sheet;
        this._row1 = row1;
        this._row2 = row2;
        this._paging = paging;
        this._lrCalc = new LRBorderCalc();
        this._tbCalc = new TBBorderCalc();
        this._colWidths = new SortedLengthArray(20);
        this._rowHeights = new SortedLengthArray(this._row2 - this._row1 + 1);
    }

    public void calc() {
        boolean[] col = new boolean[]{true, false};
        SortedLengthArray[] _array = new SortedLengthArray[]{this._colWidths, this._rowHeights};
        SortedAttributeSpanArray[] _sas = new SortedAttributeSpanArray[]{this._sheet.getColSpans(), this._sheet.getRowSpans()};
        block0: for (int c2 = 0; c2 < 2; ++c2) {
            int spanN = _sas[c2].size();
            boolean bCol = col[c2];
            for (int i = 0; i < spanN; ++i) {
                SortedAttributeSpanArray.AttributeSpan span = _sas[c2].getAttributeSpan(i);
                int start = span.getStart();
                int end = span.getEnd();
                if (end < start) continue;
                if (!bCol && this._paging) {
                    boolean flag;
                    boolean bl = flag = this._row1 <= start && start <= this._row2 || this._row1 <= end && end <= this._row2 || start <= this._row1 && end >= this._row2;
                    if (!flag) continue block0;
                    start = Math.max(this._row1, start);
                    end = Math.min(this._row2, end);
                }
                for (int j = start; j <= end; ++j) {
                    if (!bCol) {
                        this._lrCalc.setCol(j);
                    } else {
                        this._tbCalc.setRow(j);
                    }
                    int size = span.getLength() + (!bCol ? this._lrCalc.calc() : this._tbCalc.calc());
                    _array[c2].insert(new LengthEntry(j, size));
                }
            }
        }
    }

    public int getDefaultRowHeightOrColWidth(int idx, boolean col) {
        if (col) {
            this._lrCalc.setCol(idx);
            return this._sheet.getOriginalDefColWidth() + this._lrCalc.calc();
        }
        this._tbCalc.setRow(idx);
        return this._sheet.getOriginalDefRowHeight() + this._tbCalc.calc();
    }

    public SortedLengthArray getRowHeights() {
        return this._rowHeights;
    }

    public SortedLengthArray getColWidths() {
        return this._colWidths;
    }

    private class TBBorderCalc {
        int _row;

        private TBBorderCalc() {
        }

        public void setRow(int row) {
            this._row = row;
        }

        public int calc() {
            int col = MeasureCalculator.this._sheet.getMaxRowIndex(true);
            int top = 0;
            int bottom = 0;
            for (int i = 0; i <= col; ++i) {
                Cell cell = MeasureCalculator.this._sheet.getCell(this._row, i, false);
                if (null == cell) continue;
                Style style = cell.getStyle();
                if (style.hasBorderAttributes(Styles.Position.TOP) && style.hasAttributes(ShareStyleAttributes.BORDER_TOP_LINESTYLE)) {
                    top = Math.max(style.getBorderLineStyle(Styles.Position.TOP).getWidth(), top);
                }
                if (!style.hasBorderAttributes(Styles.Position.BOTTOM) || !style.hasAttributes(ShareStyleAttributes.BORDER_BOTTOM_LINESTYLE)) continue;
                bottom = Math.max(style.getBorderLineStyle(Styles.Position.BOTTOM).getWidth(), bottom);
            }
            return top + bottom;
        }
    }

    private class LRBorderCalc {
        int _col;

        private LRBorderCalc() {
        }

        public void setCol(int col) {
            this._col = col;
        }

        public int calc() {
            int row = MeasureCalculator.this._sheet.getMaxRowIndex(true);
            int left = 0;
            int right = 0;
            for (int i = 0; i <= row; ++i) {
                Cell cell = MeasureCalculator.this._sheet.getCell(i, this._col, false);
                if (null == cell) continue;
                Style style = cell.getStyle();
                if (style.hasBorderAttributes(Styles.Position.LEFT) && style.hasAttributes(ShareStyleAttributes.BORDER_LEFT_LINESTYLE)) {
                    left = Math.max(style.getBorderLineStyle(Styles.Position.LEFT).getWidth(), left);
                }
                if (!style.hasBorderAttributes(Styles.Position.RIGHT) || !style.hasAttributes(ShareStyleAttributes.BORDER_RIGHT_LINESTYLE)) continue;
                right = Math.max(style.getBorderLineStyle(Styles.Position.RIGHT).getWidth(), right);
            }
            return left + right;
        }
    }
}

