/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.SectionByteOutputStream;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.mobile.PhoneNumCalculableProps;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.mobile.PhoneNumModel;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.model.PropellingModel;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.IPreCondition;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDynamicDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.io.BookIOController;
import com.kingdee.cosmic.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.cosmic.ctrl.kds.io.PrintHelper;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSConstants;
import com.kingdee.cosmic.ctrl.kds.io.kds.SectionJarOutputStream;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookProtection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.Comment;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.ISheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetOption;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetProxy;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedColumnArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedUserObjectArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Border;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.BorderSpan;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.BordersSpan;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.SortedBorderSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.SortedBordersSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormat;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormatList;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.util.Condition;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AbstractAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.CellValueModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.ISheetAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetCustomAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetDynamicAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetFirstNAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetItemAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetMultipleItemAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;

public class BookToKds
extends KDSConstants {
    private final byte[] _intBufs = new byte[4];
    private BookIOController _ctrl;

    public static String getVersion() {
        return "2.0.0.12";
    }

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    public void export(Book book, String fileName) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(FilenameUtils.normalize((String)fileName));){
            this.export(book, new KDSDataOutputStream(fos));
        }
    }

    public void export(Book book, KDSDataOutputStream os) throws IOException {
        this.writeBook(book, os);
    }

    private void writeBook(Book book, KDSDataOutputStream out) throws IOException {
        SectionJarOutputStream sos = new SectionJarOutputStream();
        this.writeBookWithJar(book, sos);
        out.write(sos.output());
        Arrays.fill(this._intBufs, (byte)0);
    }

    private void writeBookWithJar(Book book, SectionJarOutputStream sos) throws IOException {
        int i;
        SectionByteOutputStream sBook = new SectionByteOutputStream();
        this.writeBookPrefix(book, new KDSDataOutputStream((OutputStream)sBook));
        sos.addSection(sBook);
        int count = book.getSheetCount();
        int fileVersion = book.getFileVersion();
        if (fileVersion != 0 && KDSConstants.isOlderVersion(fileVersion)) {
            for (i = 0; i < count; ++i) {
                book.getSheet(i);
            }
        }
        for (i = 0; i < count; ++i) {
            ISheet sheet = book.getISheet(i);
            if (sheet instanceof Sheet) {
                SectionByteOutputStream sSheet = new SectionByteOutputStream();
                this.writeSheet((Sheet)sheet, new KDSDataOutputStream((OutputStream)sSheet));
                sos.addSection(sSheet);
                continue;
            }
            SheetProxy sp = (SheetProxy)sheet;
            sos.addSection(sp.getZipBytes());
        }
    }

    private void writeBookPrefix(Book book, KDSDataOutputStream out) throws IOException {
        Dependents deps;
        out.writeString(book.getName());
        int count = book.getSheetCount();
        out.writeInt(count);
        out.writeInt(book.getActiveSheetIndex());
        for (int i = 0; i < count; ++i) {
            ISheet sheet = book.getISheet(i);
            out.writeString(sheet.getID());
            out.writeString(sheet.getSheetName(), false);
            byte flags = 0;
            flags = (byte)(flags | (sheet.isHide() ? 1 : 0));
            flags = (byte)(flags | (sheet.isSelected() ? 2 : 0));
            flags = (byte)(flags | (sheet.hasData() ? 4 : 0));
            out.write(flags);
            Color c2 = sheet.getTabColor();
            if (c2 == null) {
                out.writeInt(0xFFAFAF);
            } else {
                out.writeInt(c2.getRGB());
            }
            out.writeInt(sheet.getSheetType());
        }
        this.writeBookExtendMode(book, out);
        this.writeBookProtection(book, out);
        String value = book.getReleaseDirector();
        if (!StringUtil.isEmptyString((String)value)) {
            book.setUserObject("$ReleaseDirector$", value);
        }
        if (!StringUtil.isEmptyString((String)(value = book.getPassportGrantor()))) {
            book.setUserObject("$PassportGrantor$", value);
        }
        if (book.isAutoCalculate()) {
            book.setUserObject("$AutoCalculate$", Boolean.TRUE.toString());
        }
        book.setUserObject("$Iteration$", (deps = book.getDeps()).isIterate() ? "true" : "false");
        book.setUserObject("$MaxChange$", String.valueOf(deps.getMaxChange()));
        book.setUserObject("$MaxIterations$", String.valueOf(deps.getMaxIterations()));
        SortedUserObjectArray objs = book.getUserObjects();
        this.writeUserObjects(objs, (byte)2, out);
        if (objs != null) {
            objs.remove("$ReleaseDirector$");
            objs.remove("$PassportGrantor$");
        }
        this.writeComment(book.getComment(), (byte)3, out);
        this.writeNames(book.getNames(), (byte)4, out);
        this.writePropellingMode(book.getPropellingModel(), (byte)6, out);
    }

    private void writeBookProtection(Book book, KDSDataOutputStream out) throws IOException {
        BookProtection bp = book.getProtection();
        if (bp.isProtected()) {
            out.write(1);
            out.writeInt(bp.getOperations());
            out.writeString(bp.getEncryptedPassword());
        }
    }

    private void writeBookExtendMode(Book book, KDSDataOutputStream out) throws IOException {
        out.write(5);
        out.writeBoolean(book.getDeps().isExtendMode());
    }

    private void writeStyles(HashMap styles, KDSDataOutputStream out) throws IOException {
        Iterator iterStyles = styles.entrySet().iterator();
        out.write(5);
        while (iterStyles.hasNext()) {
            String numFormat;
            String str;
            Color c2;
            Styles.Position pos;
            LineStyle lineStyle;
            Map.Entry e = iterStyles.next();
            ShareStyleAttributes ssa = (ShareStyleAttributes)e.getValue();
            if (ssa == null) {
                return;
            }
            out.write(0);
            out.writeInt(ssa.getUID());
            if (ssa.hasFontAttributes()) {
                out.write(1);
                String fontName = ssa.getFontName();
                out.writeString(fontName);
                int size = -1;
                if (ssa.hasAttributes(ShareStyleAttributes.FONT_SIZE)) {
                    size = ssa.getFontSize();
                }
                out.writeInt(size);
                Color fc = ssa.getFontColor();
                if (fc == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(fc.getRGB());
                }
                byte flags = 0;
                flags = (byte)(flags | ((ssa.hasAttributes(ShareStyleAttributes.FONT_UNDERLINE) ? ssa.isUnderline() : false) ? 1 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.FONT_BOLD) ? (ssa.isBold() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.FONT_ITALIC) ? (ssa.isItalic() ? 4 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.SHRINK_TEXT) ? (ssa.isShrinkText() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.VERTICAL_TEXT) ? (ssa.isVerticalText() ? 4 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.FONT_STRIKETHROUGH) ? (ssa.isStrikeThrough() ? 8 : 0) : 0));
                out.write(flags);
            }
            if (ssa.hasAlignmentAttributes()) {
                out.write(2);
                Styles.HorizontalAlignment ha = ssa.getHorizontalAlign();
                out.writeInt(ha == null ? -1 : ha.getValue());
                Styles.VerticalAlignment va = ssa.getVerticalAlign();
                out.writeInt(va == null ? -1 : va.getValue());
                out.writeInt(ssa.hasAttributes(ShareStyleAttributes.ROTATION) ? ssa.getRotation() : -1);
                byte flags = 0;
                flags = (byte)(flags | ((ssa.hasAttributes(ShareStyleAttributes.WRAP_TEXT) ? ssa.isWrapText() : false) ? 1 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.SHRINK_TEXT) ? (ssa.isShrinkText() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.VERTICAL_TEXT) ? (ssa.isVerticalText() ? 4 : 0) : 0));
                out.write(flags);
            }
            if (ssa.hasIndentationAttributes()) {
                out.write(12);
                out.writeInt(ssa.getIndentation());
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.TOP)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(4);
                out.writeInt(lineStyle.getBits());
                c2 = ssa.getBorderColor(pos);
                if (c2 == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c2.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.BOTTOM)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(5);
                out.writeInt(lineStyle.getBits());
                c2 = ssa.getBorderColor(pos);
                if (c2 == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c2.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.LEFT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(6);
                out.writeInt(lineStyle.getBits());
                c2 = ssa.getBorderColor(pos);
                if (c2 == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c2.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.RIGHT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(7);
                out.writeInt(lineStyle.getBits());
                c2 = ssa.getBorderColor(pos);
                if (c2 == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c2.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.DIAGONALLEFT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(8);
                out.writeInt(lineStyle.getBits());
                c2 = ssa.getBorderColor(pos);
                if (c2 == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c2.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            if ((lineStyle = ssa.getBorderLineStyle(pos = Styles.Position.DIAGONALRIGHT)) != null && lineStyle != LineStyle.NULL_LINE) {
                out.write(9);
                out.writeInt(lineStyle.getBits());
                c2 = ssa.getBorderColor(pos);
                if (c2 == null) {
                    out.writeInt(0xFFAFAF);
                } else {
                    out.writeInt(c2.getRGB());
                }
                PenStyle ps = ssa.getBorderPenStyle(pos);
                str = "";
                if (ps != null) {
                    str = ps.getName();
                }
                out.writeString(str);
            }
            Color bgcolor = ssa.getBackground();
            Pattern pattern = ssa.getPattern();
            Color pccolor = ssa.getPatternColor();
            if (bgcolor != null || pattern != null && pattern != Pattern.None || pccolor != null) {
                out.write(10);
                out.writeInt(bgcolor == null ? 0xFFAFAF : bgcolor.getRGB());
                if (pattern == null) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(pattern.getID());
                }
                out.writeInt(pccolor == null ? 0xFFAFAF : pccolor.getRGB());
            }
            if (!StringUtil.isEmptyString((String)(numFormat = ssa.getNumberFormat()))) {
                out.write(11);
                out.writeString(numFormat);
            }
            if (ssa.hasProtectionAttributes()) {
                out.write(3);
                byte flags = 0;
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) ? 1 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_HIDDED) ? (ssa.isHided() ? 2 : 0) : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) ? 4 : 0));
                flags = (byte)(flags | (ssa.hasAttributes(ShareStyleAttributes.PROTECTION_LOCKED) ? (ssa.isLocked() ? 8 : 0) : 0));
                out.write(flags);
            }
            out.write(127);
        }
        out.write(127);
    }

    private void writeSheetBorders(Sheet sheet, KDSDataOutputStream out) throws IOException {
        Borders bdrs = sheet.getBorders();
        SortedObjectArray bdArray = bdrs.collectBorderObjs();
        if (bdArray.isEmpty()) {
            return;
        }
        out.write(6);
        out.write(1);
        int iEnd = bdArray.size();
        for (int i = 0; i < iEnd; ++i) {
            Border bdr = (Border)bdArray.get(i);
            out.write(0);
            out.writeInt(bdr.getUID());
            out.writeInt(bdr.getLineStyle().getBits());
            out.writeInt(bdr.getColor().getRGB());
            out.writeString(bdr.getPenStyle().getName());
            out.write(127);
        }
        out.write(127);
        this.writeBordersRoot(bdrs.getRoot(true), (byte)2, out);
        this.writeBordersRoot(bdrs.getRoot(false), (byte)3, out);
        out.write(127);
    }

    private void writeBordersRoot(SortedBordersSpanArray root, byte rootID, KDSDataOutputStream out) throws IOException {
        if (root.isEmpty()) {
            return;
        }
        out.write(rootID);
        int iEnd = root.size();
        for (int i = 0; i < iEnd; ++i) {
            BordersSpan bss = root.getBordersSpan(i);
            out.write(0);
            out.writeInt(bss.getStart());
            out.writeInt(bss.getEnd());
            SortedBorderSpanArray bssArray = bss.getBorderArray();
            int jEnd = bssArray.size();
            for (int j = 0; j < jEnd; ++j) {
                BorderSpan bs = bssArray.getBorderSpan(j);
                out.write(0);
                out.writeInt(bs.getStart());
                out.writeInt(bs.getEnd());
                out.writeInt(bs.getBorder().getUID());
                out.write(127);
            }
            out.write(127);
        }
        out.write(127);
    }

    private void writeSheet(Sheet sheet, KDSDataOutputStream out) throws IOException {
        out.write(0);
        this.writeStyles(this.scanStyle(sheet), out);
        this.writeStyleID(sheet.getSSA(), out);
        this.writeSheetBorders(sheet, out);
        this.writeSheetExtends(sheet, out);
        this.writeSheetOption(sheet.getSheetOption(), out);
        this.writeCols(sheet.getCols(), out);
        this.writeRows(sheet.getRows(), out);
        out.write(127);
    }

    private void writeSheetExtends(Sheet sheet, KDSDataOutputStream out) throws IOException {
        out.write(3);
        this.writeNames(sheet.getNames(), (byte)5, out);
        this.writeUserObjects(sheet.getUserObjects(), (byte)3, out);
        this.writeComment(sheet.getComment(), (byte)4, out);
        this.writeConditionalFormats(sheet.getConditionalFormats(), 8, out);
        this.writeValidations(sheet.getValidations(), out);
        this.writeAttributeSpans(sheet, (byte)2, out, true);
        this.writeAttributeSpans(sheet, (byte)1, out, false);
        this.writeGraphs(sheet.getEmbedments(false), (byte)7, out);
        this.writePageView(sheet, (byte)9, out);
        this.writeFilters(sheet, (byte)10, out);
        if (sheet.getSheetIndex() == 0) {
            this.writeParameter(sheet, (byte)12, out);
            this.writeComplete((byte)13, out);
        }
        this.writeDataSet(sheet, (byte)11, out);
        out.write(127);
    }

    private void writeFilters(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        CellBlock autocb = sheet.getAutoFilterArea();
        if (autocb != null) {
            out.write(id);
            out.write(0);
            out.writeInt(autocb.getRow());
            out.writeInt(autocb.getRow2());
            out.writeInt(autocb.getCol());
            out.writeInt(autocb.getCol2());
            List autoFilters = sheet.getAutoFilters();
            out.writeInt(autoFilters.size());
            for (ISheetAutoFilter autoFilter : autoFilters) {
                AbstractAutoFilter ref;
                out.writeInt(autoFilter.getAutoFilterType());
                out.writeInt(autoFilter.getColIndex());
                if (autoFilter instanceof SheetFirstNAutoFilter) {
                    ref = (SheetFirstNAutoFilter)autoFilter;
                    out.writeInt(((SheetFirstNAutoFilter)ref).getAmount());
                    out.writeBoolean(((SheetFirstNAutoFilter)ref).isAsc());
                    out.writeBoolean(((SheetFirstNAutoFilter)ref).isPercent());
                    continue;
                }
                if (autoFilter instanceof SheetItemAutoFilter) {
                    ref = (SheetItemAutoFilter)autoFilter;
                    this.writeVaraint(((SheetItemAutoFilter)ref).getValue(), out);
                    out.writeString(((SheetItemAutoFilter)ref).getText());
                    continue;
                }
                if (autoFilter instanceof SheetMultipleItemAutoFilter) {
                    ref = (SheetMultipleItemAutoFilter)autoFilter;
                    SortedObjectArray values = ((SheetMultipleItemAutoFilter)ref).getSelectedCellValueModels();
                    out.writeInt(values.size());
                    for (int index = 0; index < values.size(); ++index) {
                        CellValueModel model = (CellValueModel)values.get(index);
                        this.writeVaraint(model.getValue(), out);
                        out.writeString(model.getText());
                    }
                    continue;
                }
                if (autoFilter instanceof SheetDynamicAutoFilter) {
                    ref = (SheetDynamicAutoFilter)autoFilter;
                    out.writeByte(((SheetDynamicAutoFilter)ref).getCustomType());
                    continue;
                }
                if (!(autoFilter instanceof SheetCustomAutoFilter)) continue;
                ref = (SheetCustomAutoFilter)autoFilter;
                out.writeByte(((SheetCustomAutoFilter)ref).getOperator1());
                out.writeString(((SheetCustomAutoFilter)ref).getValue1());
                out.writeByte(((SheetCustomAutoFilter)ref).getLink());
                out.writeByte(((SheetCustomAutoFilter)ref).getOperator2());
                out.writeString(((SheetCustomAutoFilter)ref).getValue2());
            }
        }
    }

    private void writeParameter(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        ExtDataSetManager dsm;
        Map parameters;
        if (this._ctrl != null && this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_BOOK_COMPLETEREPORT) && (parameters = (dsm = sheet.getBook().getDataSetManager()).getExecutionContext().getDataSetParameters()) != null) {
            int size = parameters.size();
            if (size < 1) {
                return;
            }
            out.write(id);
            out.writeInt(size);
            Iterator iter = parameters.entrySet().iterator();
            while (iter.hasNext()) {
                ParameterImpl param = (ParameterImpl)iter.next().getValue();
                out.write(1);
                out.writeString(param.getName());
                out.write(2);
                out.writeString(param.getAlias());
                out.write(3);
                out.writeInt(param.getDataType());
                out.write(4);
                Variant valueObject = param.getValue();
                if (valueObject instanceof Variant && valueObject.isArray()) {
                    Variant[] vts = (Variant[])valueObject.getValue();
                    int length = vts.length;
                    out.writeInt(length);
                    for (int i = 0; i < length; ++i) {
                        this.writeVaraint(vts[i], out);
                    }
                } else {
                    out.writeInt(1);
                    this.writeVaraint(valueObject, out);
                }
                out.write(5);
                out.writeBoolean(param.isNullable());
                out.write(127);
            }
        }
    }

    private void writeComplete(byte id, KDSDataOutputStream out) throws IOException {
        if (this._ctrl != null && this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_BOOK_COMPLETEREPORT)) {
            out.write(id);
        }
    }

    private void writeDataSet(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        ExtDataSetManager dsm = sheet.getBook().getDataSetManager();
        int size = dsm.size();
        if (size == 0) {
            return;
        }
        out.write(id);
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ExtDataSet ds = dsm.getAt(i);
            if (ds instanceof ExtDynamicDataSet) continue;
            out.write(1);
            out.writeString(ds.getName());
            out.write(2);
            out.writeString(ds.getAlias());
            out.write(6);
            out.writeString(ds.getMeta());
            out.write(3);
            out.writeString(ds.getDefine());
            this.writeDataSetColumns(ds, (byte)4, out);
            this.writeDataSetData(ds, (byte)5, out);
            out.write(127);
        }
    }

    private void writeDataSetColumns(ExtDataSet ds, byte id, KDSDataOutputStream out) throws IOException {
        SortedObjectArray so = ds.getColumns();
        int size = so.size();
        if (size == 0) {
            return;
        }
        out.write(id);
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ExtColumn col = (ExtColumn)so.get(i);
            out.write(1);
            out.writeString(col.getName());
            out.write(2);
            out.writeString(col.getAlias());
            out.write(3);
            out.writeInt((Integer)col.getIndex().getValue());
            out.write(4);
            out.writeInt(col.getDataType());
            out.write(127);
        }
    }

    private void writeDataSetData(ExtDataSet ds, byte id, KDSDataOutputStream out) throws IOException {
        if (this._ctrl != null && this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_BOOK_COMPLETEREPORT)) {
            if (ds.isEmpty()) {
                return;
            }
            out.write(id);
            int row = ds.getDataRows();
            int col = ds.getDataColumns();
            out.writeInt(row);
            out.writeInt(col);
            for (int i = 0; i < row; ++i) {
                Variant[] rowData = ds.getRowData(i);
                for (int j = 0; j < col; ++j) {
                    Variant value = rowData[j];
                    int vt = value.getVt();
                    if (vt == 0 || vt == 16384 || vt == 8192 || vt == 16) {
                        out.write(4);
                        out.write(0);
                        continue;
                    }
                    this.writeVaraint(value, out);
                }
            }
        }
    }

    private void writePageView(Sheet sheet, byte id, KDSDataOutputStream out) throws IOException {
        boolean isPageView = sheet.isPageView();
        PlugablePaginationAdvice ppa = sheet.getPlugablePaginationAdvice(false);
        if (!isPageView && ppa == null) {
            return;
        }
        out.write(id);
        out.writeBoolean(isPageView);
        if (isPageView) {
            int i;
            int[] snap = sheet.getRowPaginationPointsSnapshot();
            out.writeInt(snap.length);
            for (i = 0; i < snap.length; ++i) {
                out.writeInt(snap[i]);
            }
            snap = sheet.getColPaginationPointsSnapshot();
            out.writeInt(snap.length);
            for (i = 0; i < snap.length; ++i) {
                out.writeInt(snap[i]);
            }
        }
        int maxRowId = sheet.getMaxRowIndex();
        int maxColId = sheet.getMaxColIndex();
        if (ppa != null) {
            int i;
            int count = 0;
            out.writeBoolean(true);
            int[] temp = ppa.getRowShrinkedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxRowId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
            count = 0;
            temp = ppa.getRowExtendedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxRowId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
            count = 0;
            temp = ppa.getColShrinkedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxColId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
            count = 0;
            temp = ppa.getColExtendedBreaks();
            if (temp != null) {
                for (i = 0; i < temp.length && temp[i] <= maxColId; ++i) {
                    ++count;
                }
            }
            out.writeInt(count);
            for (i = 0; i < count; ++i) {
                out.writeInt(temp[i]);
            }
        } else {
            out.writeBoolean(false);
        }
    }

    private void writeGraphs(EmbedhLayer gl, byte id, KDSDataOutputStream out) throws IOException {
        if (gl == null) {
            return;
        }
        int size = gl.size();
        for (int i = 0; i < size; ++i) {
            out.write(id);
            EmbedObject gr = gl.getEmbed(i);
            out.writeString(gr.getClass().getName());
            out.writeLengthBytes(gr.save());
        }
    }

    private void writeAttributeSpans(Sheet sheet, byte id, KDSDataOutputStream out, boolean isRow) throws IOException {
        SortedAttributeSpanArray spans = isRow ? sheet.getRowSpans() : sheet.getColSpans();
        int size = spans.size();
        for (int i = 0; i < size; ++i) {
            SortedAttributeSpanArray.AttributeSpan span = spans.getAttributeSpan(i);
            out.write(id);
            out.writeInt(span.getStart());
            out.writeInt(span.getExtent());
            this.writeStyleID(span.getSSA(), out);
            int length = span.getOriginalLength();
            out.writeInt(length);
            out.write(span.isVisible() ? 1 : 0);
            out.writeBoolean(sheet.isAboveOfOutlineGroup());
            out.writeBoolean(sheet.isLeftToOutlineGroup());
            out.writeInt(span.getOutlineGroupLevel());
            out.writeBoolean(span.isCollapse());
        }
    }

    private void writeConditionalFormats(ConditionalFormatList cfl, int id, KDSDataOutputStream out) throws IOException {
        if (cfl == null) {
            return;
        }
        out.write(id);
        int size = cfl.size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            ConditionalFormat cf = cfl.getConditionalFormat(i);
            SortedCellBlockArray blocks = cf.getBlocks();
            ShareStyleAttributes[] ssas = cf.getSSAs();
            Condition[] cds = cf.getConditions();
            int valve = ssas.length;
            out.writeInt(valve);
            out.writeString(SheetBaseMath.getBlocksA1Name(blocks, true));
            for (int m = 0; m < valve; ++m) {
                if (ssas[m] == null) {
                    out.writeInt(-1);
                } else {
                    out.writeInt(ssas[m].getUID());
                }
                Condition cd = cds[m];
                out.writeInt(cd.getTypeIndex());
                int qua = cd.getQualifierIndex();
                out.writeInt(qua);
                String min = cd.getMin();
                out.writeString(min);
                if (qua > 1) continue;
                String max = cd.getMax();
                out.writeString(max);
            }
        }
    }

    private void writeValidations(ValidationList vals, KDSDataOutputStream out) throws IOException {
        if (vals == null) {
            return;
        }
        int size = vals.size();
        for (int i = 0; i < size; ++i) {
            Validation va = vals.getValidation(i);
            MessagedValidate validate = va.getMessagedValidate();
            out.write(6);
            out.writeInt(validate.getTypeIndex());
            int qua = validate.getQualifierIndex();
            out.writeInt(qua);
            String range = SheetBaseMath.getBlocksA1Name(va.getBlocks(), true);
            out.writeString(range);
            out.write((byte)validate.getImeMode());
            byte flags = 0;
            flags = (byte)(flags | (validate.hasCellRangeList() ? 1 : 0));
            flags = (byte)(flags | (validate.isUseBlank() ? 2 : 0));
            flags = (byte)(flags | (validate.isInputHide() ? 4 : 0));
            flags = (byte)(flags | (validate.isErrorHide() ? 8 : 0));
            out.write(flags);
            String min = validate.getMin();
            out.writeString(min);
            if (qua <= 1) {
                String max = validate.getMax();
                out.writeString(max);
            }
            String it = validate.getInputTitle();
            out.writeString(it);
            String im = validate.getInputMessage();
            out.writeString(im);
            String es = validate.getErrorStyle();
            out.writeString(es);
            String et = validate.getErrorTitle();
            out.writeString(et);
            String em = validate.getErrorMessage();
            out.writeString(em);
            out.writeString(validate.getRegexString());
            IEditorDefine define = va.getEditorDefine();
            out.writeBoolean(va.isReportingValidation());
            out.writeString(define.getValueEditorType().getType());
            BooleanVFPair pair = define.getEnableFormula();
            if (pair == null) {
                pair = new BooleanVFPair(true, null);
            }
            boolean hasFormula = pair.hasFormula();
            out.writeBoolean(hasFormula);
            String formula = pair.getFormula();
            out.writeString(formula == null ? "" : formula);
            out.writeBoolean(pair.getPrimitiveValue());
            out.writeString(define.serializeToString());
        }
    }

    private void writeSheetOption(SheetOption so, KDSDataOutputStream out) throws IOException {
        out.write(4);
        out.writeInt(so.getScale());
        Color c2 = so.getGridLineColor();
        if (c2 == null) {
            out.writeInt(0xFFAFAF);
        } else {
            out.writeInt(c2.getRGB());
        }
        byte flags = 0;
        flags = (byte)(flags | (so.isShowHoriLines() ? 1 : 0));
        flags = (byte)(flags | (so.isShowVertLines() ? 2 : 0));
        out.write(flags);
        this.writePrintSetup(so.getSheet().getBook(), so.getPrintSetup(false), out);
        this.writeSheetProtection(so.getProtection(false), out);
        this.writeSheetProtectionEditBlocks(so.getProtection(false), out);
        this.writeSelection(so.getSelection(), out);
        this.writeSplit(so, so.getViewSplitInfo(), out);
        this.writeMerge(so.getMerger(false), out);
        out.write(127);
    }

    private void writePrintSetup(Book book, PrintSetup ps, KDSDataOutputStream out) throws IOException {
        if (ps == null) {
            return;
        }
        out.write(6);
        boolean isLandScape = ps.isLandScape();
        boolean isRowFirst = ps.isRowFirst();
        boolean isBlackWhite = ps.isBlackWhite();
        boolean hasGrid = ps.hasGrid();
        boolean hasHead = ps.hasRowHead();
        boolean hasColHead = ps.hasColHead();
        int flags = 0;
        flags = (byte)(flags | (hasColHead ? 2 : 0));
        flags = (byte)(flags | (hasHead ? 1 : 0));
        flags = (byte)(flags | (hasGrid ? 4 : 0));
        flags = (byte)(flags | (isBlackWhite ? 8 : 0));
        flags = (byte)(flags | (isRowFirst ? 16 : 0));
        flags = (byte)(flags | (isLandScape ? 32 : 0));
        out.write(flags);
        int centerHori = ps.getCenterHorizontal();
        out.writeInt(centerHori);
        int centerVert = ps.getCenterVertical();
        out.writeInt(centerVert);
        float topMargin = ps.getTopMargin();
        out.writeInt(Float.floatToIntBits(topMargin));
        float bottomMargin = ps.getBottomMargin();
        out.writeInt(Float.floatToIntBits(bottomMargin));
        float leftMargin = ps.getLeftMargin();
        out.writeInt(Float.floatToIntBits(leftMargin));
        float rightMargin = ps.getRightMargin();
        out.writeInt(Float.floatToIntBits(rightMargin));
        int pageSizeIndex = ps.getPagesizeIndex();
        out.writeInt(pageSizeIndex);
        float pageSizeX = ps.getPagesizeX();
        out.writeInt(Float.floatToIntBits(pageSizeX));
        float pageSizeY = ps.getPagesizeY();
        out.writeInt(Float.floatToIntBits(pageSizeY));
        boolean autoFit = ps.isAutoFit();
        out.writeBoolean(autoFit);
        int scale = ps.getScale();
        out.writeInt(scale);
        int autoFitWidth = ps.getAutoFitWidth();
        out.writeInt(autoFitWidth);
        int autoFitHeight = ps.getAutoFitHeight();
        out.writeInt(autoFitHeight);
        float headMargin = ps.getHeadMargin();
        out.writeInt(Float.floatToIntBits(headMargin));
        String headData = PrintHelper.getHeadFootString(book, ps.getHeadData(), true);
        out.writeString(headData);
        int footAlign = ps.getFootAlign();
        out.writeInt(footAlign);
        int headAlign = ps.getHeadAlign();
        out.writeInt(headAlign);
        float footMargin = ps.getFootMargin();
        out.writeInt(Float.floatToIntBits(footMargin));
        String footData = PrintHelper.getHeadFootString(book, ps.getFootData(), true);
        out.writeString(footData);
        out.write(1);
        boolean isVerEcono = ps.isVerEconomizePaper();
        out.write(1);
        out.writeBoolean(isVerEcono);
        boolean isHorEcono = ps.isHorEconomizePaper();
        out.write(2);
        out.writeBoolean(isHorEcono);
        int verSpace = ps.getVerSpace();
        out.write(3);
        out.writeInt(verSpace);
        int horSpace = ps.getHorSpace();
        out.write(4);
        out.writeInt(horSpace);
        out.write(127);
        out.write(127);
    }

    private void writeSheetProtection(Protection pro, KDSDataOutputStream out) throws IOException {
        if (pro == null) {
            return;
        }
        int opers = pro.getOperations();
        out.write(1);
        out.write(pro.isProtected() ? 1 : 0);
        out.writeInt(opers);
        String pw = pro.getEncryptedPassword();
        out.writeString(pw);
    }

    private void writeSheetProtectionEditBlocks(Protection pro, KDSDataOutputStream out) throws IOException {
        if (pro == null) {
            return;
        }
        Protection.SortedEditalbeAreaArray blocks = pro.getEditableBlocks();
        if (blocks != null) {
            int size = blocks.size();
            for (int i = 0; i < size; ++i) {
                out.write(2);
                Protection.EditableArea ea = (Protection.EditableArea)blocks.get(i);
                String name = ea.getName();
                out.writeString(name);
                String pw = ea.getEncryptedPassword();
                out.writeString(pw);
                String range = SheetBaseMath.getBlocksA1Name(ea, true);
                out.writeString(range);
            }
        }
    }

    private void writeSelection(Selection sel, KDSDataOutputStream out) throws IOException {
        int row = sel.getActiveRow();
        int col = sel.getActiveCol();
        if (row == 0 && col == 0 && sel.isBaseUnit()) {
            return;
        }
        out.write(4);
        out.writeInt(row);
        out.writeInt(col);
        String range = SheetBaseMath.getBlocksA1Name(sel.toSelectionBlocks(), true);
        out.writeString(range);
    }

    private void writeSplit(SheetOption so, ViewSplitInfo vs, KDSDataOutputStream out) throws IOException {
        out.write(3);
        byte flags = 0;
        flags = (byte)(flags | (so.isHide() ? 1 : 0));
        flags = (byte)(flags | (so.isSelected() ? 2 : 0));
        flags = (byte)(flags | (vs.isFreezed() ? 4 : 0));
        out.write(flags);
        out.writeInt(vs.getActivePane());
        out.writeInt(vs.getFirstRow());
        out.writeInt(vs.getFirstCol());
        out.writeInt(vs.getFirstRow2());
        out.writeInt(vs.getFirstCol2());
        out.writeInt(vs.getRowSplit());
        out.writeInt(vs.getColSplit());
    }

    private void writeMerge(MergeBlocks mb, KDSDataOutputStream out) throws IOException {
        if (mb == null || mb.isEmpty()) {
            return;
        }
        out.write(5);
        out.writeString(SheetBaseMath.getBlocksA1Name(mb, false));
    }

    private void writeCols(SortedColumnArray cols, KDSDataOutputStream out) throws IOException {
        int size = cols.size();
        for (int c2 = 0; c2 < size; ++c2) {
            Column col = cols.getAt(c2);
            out.write(2);
            out.writeInt(col.getCol());
            this.writeUserObjects(col.getUserObjects(), (byte)1, out);
            out.write(127);
        }
    }

    private void writeRows(SortedRowArray rows, KDSDataOutputStream out) throws IOException {
        int size = rows.size();
        for (int r = 0; r < size; ++r) {
            Row row = rows.getAt(r);
            out.write(1);
            out.writeInt(row.getRow());
            this.writeUserObjects(row.getUserObjects(), (byte)1, out);
            int justColIndex = 0;
            int rsize = row.size();
            for (int c2 = 0; c2 < rsize; ++c2) {
                Cell cell = row.getAt(c2);
                this.writeCell(cell, justColIndex, out);
                justColIndex = cell.getCol() + 1;
            }
            out.write(127);
        }
    }

    private void writeCell(Cell cell, int justColIndex, KDSDataOutputStream out) throws IOException {
        ExtProps ep;
        Comment comm;
        DiagonalHeader dh;
        SortedUserObjectArray uos;
        ShareStyleAttributes ssa;
        out.write(2);
        int col = cell.getCol();
        if (col != justColIndex) {
            out.write(1);
            out.writeInt(col);
        }
        if ((ssa = cell.getSSA()) != null && !ssa.isEmpty()) {
            out.write(2);
            out.writeInt(ssa.getUID());
        }
        String formula = cell.getFormula();
        if (cell.hasFormula() || cell.isTickFormula() || cell.isBadFormula()) {
            out.write(3);
            out.writeString(formula, false);
        }
        this.writeVaraint(cell.getValue(), out);
        HyperLink link = cell.getHyperLink();
        if (link != null && !StringUtil.isEmptyString((String)link.getLinkTo())) {
            out.write(5);
            out.writeString(link.getLinkTo(), false);
        }
        if ((uos = cell.getUserObjects(false)) != null && !uos.isEmpty()) {
            this.writeUserObjects(uos, (byte)6, out);
        }
        if ((dh = cell.getDiagonalHeader()) != null) {
            this.writeDiagonalHeader(dh, out);
        }
        if ((comm = cell.getComment()) != null) {
            this.writeComment(comm, (byte)7, out);
        }
        if ((ep = cell.getExtProps(false)) != null) {
            out.write(9);
            out.writeBoolean(ep.isReportingGroupRootProps());
            this.writeExtProps(ep, out);
        }
        if (cell.isFirstMergedCell()) {
            out.write(10);
            out.writeBoolean(true);
        }
        out.write(127);
    }

    private void writeVaraint(Variant var, KDSDataOutputStream out) throws IOException {
        if (!var.isNull()) {
            int dataType = 1;
            int vt = var.getVt();
            switch (vt) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: {
                    dataType = 4;
                    break;
                }
                case 8: {
                    dataType = 2;
                    break;
                }
                case 12: 
                case 13: {
                    dataType = 8;
                    break;
                }
                case 16: {
                    dataType = 9;
                    break;
                }
                case 0: 
                case 8192: 
                case 16384: {
                    dataType = 0;
                    break;
                }
            }
            if (dataType != 0) {
                out.write(4);
                out.write(dataType);
                if (dataType == 8) {
                    long lValue;
                    Object value = var.getValue();
                    try {
                        lValue = var.toCalendar().getTimeInMillis();
                    }
                    catch (SyntaxErrorException e) {
                        lValue = vt == 12 ? ((Date)value).getTime() : ((Calendar)value).getTimeInMillis();
                    }
                    out.writeString(Long.toString(lValue), false);
                } else if (dataType == 2) {
                    out.writeBoolean((Boolean)var.getValue());
                } else if (dataType == 9) {
                    Object value = var.getValue();
                    String strValue = value instanceof Exception ? ((Exception)value).getMessage() : value.toString();
                    out.writeString(strValue);
                } else {
                    String sval;
                    Object v = var.getValue();
                    if (v instanceof BigDecimal) {
                        try {
                            sval = String.valueOf(BigDecimal.class.getMethod("toPlainString", null).invoke(v, null));
                        }
                        catch (Throwable th) {
                            sval = v.toString();
                        }
                    } else {
                        sval = var.toString();
                    }
                    out.writeString(sval, false);
                }
            }
        }
    }

    private void writeDiagonalHeader(DiagonalHeader dh, KDSDataOutputStream out) throws IOException {
        int i;
        if (dh == null) {
            return;
        }
        out.write(8);
        out.write(dh.getPosition().byteValue());
        out.writeInt(dh.getRow());
        out.writeInt(dh.getCol());
        out.writeInt(dh.getRow2());
        out.writeInt(dh.getCol2());
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size = rowOffs.length;
            for (i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(rowOffs[i])).append(',');
            }
            sb.append(String.valueOf(rowOffs[size - 1]));
            out.writeString(sb.toString(), false);
        } else {
            out.writeShort(0);
        }
        int[] colOffs = dh.getColOffs();
        if (colOffs != null && colOffs.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size = colOffs.length;
            for (int i2 = 0; i2 < size - 1; ++i2) {
                sb.append(String.valueOf(colOffs[i2])).append(',');
            }
            sb.append(String.valueOf(colOffs[size - 1]));
            out.writeString(sb.toString(), false);
        } else {
            out.writeShort(0);
        }
        int size = dh.size();
        for (i = 0; i < size; ++i) {
            TriangleInfo ti = dh.getTriangleInfo(i);
            byte flags = 0;
            flags = (byte)(flags | (ti.isLean() ? 1 : 0));
            flags = (byte)(flags | (ti.isAutoZoom() ? 2 : 0));
            flags = (byte)(flags | (ti.isDrawBackground() ? 4 : 0));
            out.write(flags);
            this.writeStyleID((ShareStyleAttributes)ti.getStyle(), out);
            out.writeString(ti.getText());
        }
    }

    private void writeUserObjects(SortedUserObjectArray uos, byte userObjectID, KDSDataOutputStream out) throws IOException {
        if (uos == null) {
            return;
        }
        int size = uos.size();
        for (int i = 0; i < size; ++i) {
            String outStr;
            UserObject uo = uos.getUserObject(i);
            String key = uo.getKey();
            Object value = uo.getValue();
            if (value == null) continue;
            Book.IUserObjectProvider trans = null;
            if (this._ctrl != null) {
                trans = this._ctrl.getKmlUOTrans();
            }
            if (trans != null) {
                outStr = trans.getString(key, value);
                if (outStr == null) {
                    continue;
                }
            } else {
                outStr = value.toString();
            }
            this.writeKeyValue(userObjectID, key, outStr, out);
        }
    }

    private void writeNames(SortedNamedObjectNodeArray names, byte nameNodeID, KDSDataOutputStream out) throws IOException {
        if (names == null) {
            return;
        }
        int size = names.size();
        for (int i = 0; i < size; ++i) {
            NamedObjectNode node = names.getObjectNode(i);
            if (!node.isVisible() || node.isUndefined() || node.isNullExpr()) continue;
            this.writeKeyValue(nameNodeID, node.getName(), node.getRefersTo(), out);
        }
    }

    private void writePropellingMode(PropellingModel model, byte propellingModelID, KDSDataOutputStream out) throws IOException {
        out.writeByte(propellingModelID);
        byte[] data = model.serial();
        out.writeInt(data.length);
        out.write(data);
    }

    private void writeComment(Comment comment, byte commentID, KDSDataOutputStream out) throws IOException {
        if (comment == null) {
            return;
        }
        this.writeKeyValue(commentID, comment.getAuthor(), comment.getText(), out);
    }

    private void writeExtProps(ExtProps ep, KDSDataOutputStream out) throws IOException {
        SortedExtPropFormulasArray formulas;
        this.writeExtPropsHead(ep.getHead(true, false), (byte)1, out);
        this.writeExtPropsHead(ep.getHead(false, false), (byte)2, out);
        int ext = ep.getExtensible(false);
        if (ext != -1) {
            out.write(3);
            out.writeInt(ext);
        }
        if ((formulas = ep.getFormulas(false)) != null) {
            Map<String, Object> tars;
            ExprContext ctx = ep.getSheet().getDeps().getExprContext();
            Cell cll = ep.getCell();
            int size = formulas.size();
            for (int i = 0; i < size; ++i) {
                ICalculableProps node = (ICalculableProps)formulas.get(i);
                this.writeKeyValue((byte)4, node.getAction().getStringKey(), node.getFormula(ctx, cll), out);
            }
            SubReportInfo subReportInfo = (SubReportInfo)formulas.get(ExtConst.FORMULA_SUBREPORT);
            this.writeSubReport(out, subReportInfo, ctx, cll);
            HyperlinkCalculableProps hyperlinks = (HyperlinkCalculableProps)formulas.get(ExtConst.FORMULA_HYPERLINK);
            if (hyperlinks != null && (tars = hyperlinks.getTargets()) != null) {
                ETTargets targets = (ETTargets)tars.get("EXTRPT");
                BookToKds.writeTransitionTarget((byte)5, targets, out, ctx, cll);
                InnerLinkTargets innerTargets = (InnerLinkTargets)tars.get("EXT_INNER");
                BookToKds.writeInnerTransitionTarget((byte)7, innerTargets, out, ctx, cll);
                ExternalTargets externalTargets = (ExternalTargets)tars.get("EXTERNAL");
                this.writeExternalTransitionTarget(externalTargets, out, ctx, cll);
                Color color = null;
                if (targets != null) {
                    color = targets.getBehaviorFontColor();
                } else if (externalTargets != null) {
                    color = externalTargets.getBehaviorFontColor();
                }
                this.writeTransitionBehaviorFontColor(out, color);
            }
            this.writePhoneNum(ep, out, ctx, cll, formulas);
        }
        out.write(127);
    }

    private void writePhoneNum(ExtProps ep, KDSDataOutputStream out, ExprContext ctx, Cell cll, SortedExtPropFormulasArray formulas) throws IOException {
        PhoneNumModel model;
        PhoneNumCalculableProps links = (PhoneNumCalculableProps)formulas.get(ExtConst.FORMULA_PHONENUM);
        if (links != null && (model = links.getModel()) != null && !StringUtil.isEmptyString((String)model.getFormula())) {
            out.write(11);
            out.writeString(model.getFormula());
            this.writeTransitionBehaviorCondition(out, model, ctx, cll);
            this.writeTransitionBehaviorFontColor(out, model.getBehaviorFontColor());
        }
    }

    private void writeTransitionBehaviorFontColor(KDSDataOutputStream out, Color color) throws IOException {
        if (color == null) {
            return;
        }
        out.write(9);
        out.writeString(String.valueOf(color.getRGB()));
    }

    private void writeTransitionBehaviorCondition(KDSDataOutputStream out, IPreCondition preCondition, ExprContext ctx, ICalculable owner) throws IOException {
        if (preCondition == null) {
            return;
        }
        Expr expr = preCondition.getBehaviorAction();
        if (expr == null) {
            return;
        }
        out.write(10);
        String formula = expr.decode(ctx, owner);
        out.writeString(formula);
    }

    private void writeSubReport(KDSDataOutputStream out, SubReportInfo subReportInfo, ExprContext ctx, Cell cll) throws IOException {
        if (subReportInfo == null) {
            return;
        }
        ReportProperties rptProps = subReportInfo.getReportProps();
        out.write(8);
        out.writeString(rptProps.getId());
        out.writeString(rptProps.getName());
        out.writeString(rptProps.getPath());
        out.writeString(rptProps.getAlias());
        out.writeString(rptProps.getPathAlias());
        out.writeString(rptProps.getDomain());
        Map<String, IParameter> params = subReportInfo.getParams();
        if (params != null) {
            BookToKds.writeParams(params, out, ctx, cll);
        } else {
            out.writeInt(0);
        }
    }

    public static void writeTransitionTarget(byte flag, ETTargets targets, KDSDataOutputStream out, ExprContext ctx, ICalculable owner) throws IOException {
        if (targets == null) {
            return;
        }
        out.write(flag);
        Expr non = targets.getBehaviorAction();
        String expr = "";
        String name_hyper = "";
        if (non != null) {
            expr = non.decode(ctx, owner);
            name_hyper = "";
        }
        out.writeString(expr);
        out.writeString(name_hyper);
        List list = targets.getTargets();
        ExtTransitionTarget dt = targets.getDefaultTarget();
        int tcount = list.size();
        out.writeInt(tcount);
        int dIdx = 0;
        for (int i = 0; i < tcount; ++i) {
            ExtTransitionTarget tt = (ExtTransitionTarget)list.get(i);
            if (tt == dt) {
                dIdx = i;
            }
            ReportProperties fulleName = tt.getReportProps();
            out.writeString(fulleName.getId());
            out.writeString(fulleName.getName());
            out.writeString(fulleName.getPath());
            out.writeString(fulleName.getAlias());
            out.writeString(fulleName.getPathAlias());
            out.writeString(fulleName.getDomain());
            Map<String, IParameter> params = tt.getParameters();
            if (params != null) {
                BookToKds.writeParams(params, out, ctx, owner);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(dIdx);
    }

    public static void writeInnerTransitionTarget(byte flag, InnerLinkTargets innerTargets, KDSDataOutputStream out, ExprContext ctx, ICalculable owner) throws IOException {
        if (innerTargets == null) {
            return;
        }
        out.write(flag);
        Expr non = innerTargets.getBehaviorAction();
        String expr = "";
        String name_hyper = "";
        if (non != null) {
            expr = non.decode(ctx, owner);
            name_hyper = "";
        }
        out.writeString(expr);
        out.writeString(name_hyper);
        List<InnerLinkTransitionTarget> list = innerTargets.getTargets();
        InnerLinkTransitionTarget dt = innerTargets.getDefaultTarget();
        int tcount = list.size();
        out.writeInt(tcount);
        int dIdx = 0;
        for (int i = 0; i < tcount; ++i) {
            InnerLinkTransitionTarget tt = list.get(i);
            if (tt == dt) {
                dIdx = i;
            }
            InnerLinkTargetProperties fulleName = tt.getTargetProps();
            out.writeString(fulleName.getId(owner));
            out.writeString(fulleName.getName());
            out.writeString(tt.getTargetType());
            Map<String, IParameter> params = tt.getParams();
            if (params != null) {
                BookToKds.writeParams(params, out, ctx, owner);
                continue;
            }
            out.writeInt(0);
        }
        out.writeInt(dIdx);
    }

    private static void writeParams(Map params, KDSDataOutputStream out, ExprContext ctx, ICalculable owner) throws IOException {
        if (params == null) {
            return;
        }
        Set set = params.keySet();
        out.writeInt(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            IParameter param = (IParameter)params.get(iterator.next());
            String name = param.isUserDefine() ? "_userdefine_" + param.getName() : param.getName();
            out.writeString(name);
            String formula = ((ICalculableProps)((Object)param)).getFormula(ctx, owner);
            out.writeString(formula);
            out.writeString(param.getAlias());
            out.writeInt(param.getDataType());
            out.writeBoolean(param.isNullable());
        }
    }

    private void writeExternalTransitionTarget(ExternalTargets externalTargets, KDSDataOutputStream out, ExprContext ctx, Cell cll) throws IOException {
        if (externalTargets == null) {
            return;
        }
        out.write(6);
        List<Map<String, Object>> list = externalTargets.getAllAssembledTargets();
        out.write(1);
        int count = list.size();
        out.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Map<String, Object> mapPack = list.get(i);
            Set<Map.Entry<String, Object>> set = mapPack.entrySet();
            out.writeInt(set.size());
            for (Map.Entry<String, Object> entry : set) {
                int m;
                int propsCount;
                out.writeString(entry.getKey());
                Object o = entry.getValue();
                if (o instanceof CommonCalculableProps) {
                    String formula = ((CommonCalculableProps)o).getFormula(ctx, cll);
                    out.writeInt(2);
                    out.writeString(formula);
                    continue;
                }
                if (o instanceof CommonCalculableProps[]) {
                    out.writeInt(3);
                    CommonCalculableProps[] props = (CommonCalculableProps[])o;
                    propsCount = props.length;
                    out.writeInt(propsCount);
                    for (m = 0; m < propsCount; ++m) {
                        String formula = props[m].getFormula(ctx, cll);
                        out.writeString(formula);
                    }
                    continue;
                }
                if (o instanceof String[]) {
                    out.writeInt(4);
                    String[] strings = (String[])o;
                    propsCount = strings.length;
                    out.writeInt(propsCount);
                    for (m = 0; m < propsCount; ++m) {
                        out.writeString(strings[m]);
                    }
                    continue;
                }
                if (o instanceof Map) {
                    out.writeInt(5);
                    BookToKds.writeParams((Map)o, out, ctx, cll);
                    continue;
                }
                out.writeInt(1);
                out.writeString(o.toString());
            }
        }
        out.write(2);
        out.writeInt(externalTargets.getDefaultIndex());
        this.writeTransitionBehaviorCondition(out, externalTargets, ctx, cll);
        out.write(127);
    }

    private void writeExtPropsHead(ExtProps head, byte id, KDSDataOutputStream out) throws IOException {
        if (head == null) {
            return;
        }
        out.write(id);
        if (head.isCell00()) {
            out.writeLong(Long.MAX_VALUE);
        } else {
            Cell cll = head.getCell();
            long row = cll.getRow();
            out.writeLong(row << 32 | (long)cll.getCol());
        }
    }

    private HashMap scanStyle(Sheet sheet) {
        int j;
        HashMap styles = new HashMap();
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps != null) {
            this.scanHeadFooterStyleImpl(sheet.getBook(), ps.getHeadData(), styles);
            this.scanHeadFooterStyleImpl(sheet.getBook(), ps.getFootData(), styles);
        }
        this.addSSA(sheet.getSSA(), styles);
        Sheet.ICellsIterator iter = sheet.getCellsIterator(null, false, false);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            DiagonalHeader dh = cell.getDiagonalHeader();
            if (dh != null) {
                int size = dh.size();
                for (j = 0; j < size; ++j) {
                    Style ssa = dh.getTriangleInfo(j).getStyle();
                    if (ssa == null || ssa.isEmpty()) continue;
                    this.addSSA((ShareStyleAttributes)ssa, styles);
                }
            }
            this.addSSA(cell.getSSA(), styles);
        }
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int size = rowSpans.size();
        for (int j2 = 0; j2 < size; ++j2) {
            this.addSSA(rowSpans.getAttributeSpan(j2).getSSA(), styles);
        }
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        size = colSpans.size();
        for (j = 0; j < size; ++j) {
            this.addSSA(colSpans.getAttributeSpan(j).getSSA(), styles);
        }
        ConditionalFormatList cfl = sheet.getConditionalFormats();
        if (cfl != null) {
            int valve = cfl.size();
            for (int i = 0; i < valve; ++i) {
                ShareStyleAttributes[] ssas = cfl.getConditionalFormat(i).getSSAs();
                for (int j3 = 0; j3 < ssas.length; ++j3) {
                    this.addSSA(ssas[j3], styles);
                }
            }
        }
        return styles;
    }

    private void scanHeadFooterStyleImpl(Book book, List listData, HashMap styles) {
        if (listData == null) {
            return;
        }
        ListIterator iter = listData.listIterator();
        while (iter.hasNext()) {
            HeadFootRow row = (HeadFootRow)iter.next();
            StyleAttributes sa = row.getSA();
            if (sa == null) continue;
            ShareStyleAttributes ssa = book.getSSA(sa);
            this.addSSA(ssa, styles);
        }
    }

    private void addSSA(ShareStyleAttributes ssa, HashMap styles) {
        if (ssa != null && !ssa.isEmpty()) {
            Integer key = ssa.getUID();
            styles.put(key, ssa);
        }
    }

    private void writeKeyValue(byte id, String key, String value, KDSDataOutputStream out) throws IOException {
        out.write(id);
        out.writeString(key);
        out.writeString(value);
    }

    public void writeStyleID(ShareStyleAttributes ssa, KDSDataOutputStream out) throws IOException {
        int uid = -1;
        if (ssa != null && !ssa.isEmpty()) {
            uid = ssa.getUID();
        }
        out.writeInt(uid);
    }
}

