/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.mobile.PhoneNumCalculableProps;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.mobile.PhoneNumModel;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.reporting.ReportingFactory;
import com.kingdee.cosmic.ctrl.ext.reporting.model.ValueEditorType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.NullEditorDefine;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectCache;
import com.kingdee.cosmic.ctrl.extcommon.util.SOAUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.SortedObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExceptionMessageWrapper;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.LineStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.Pattern;
import com.kingdee.cosmic.ctrl.kdf.util.style.PenStyle;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.IPreCondition;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.CommonCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtColumn;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetType;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.ChartInnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.io.BookIOController;
import com.kingdee.cosmic.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.cosmic.ctrl.kds.io.PrintHelper;
import com.kingdee.cosmic.ctrl.kds.io.kds.HighVersionException;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSConstants;
import com.kingdee.cosmic.ctrl.kds.io.kds.KDSReadException;
import com.kingdee.cosmic.ctrl.kds.io.kds.SectionJarInputStream;
import com.kingdee.cosmic.ctrl.kds.io.kds.SectionJarUtil;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookProtection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellPropAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.Comment;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.IBookProvider;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetOption;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetProxy;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Border;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.Borders;
import com.kingdee.cosmic.ctrl.kds.model.struct.borders.SortedBordersSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormat;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.util.Condition;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.CellValueModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetCustomAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetDynamicAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetEmptyAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetFirstNAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetItemAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetMultipleItemAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.SheetNonEmptyAutoFilter;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.ConstNamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import com.kingdee.cosmic.ctrl.print.printjob.table.SheetPlugablePaginationAdvice;
import java.awt.Color;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public final class KDSBinaryBook
extends KDSConstants
implements IBookProvider {
    private static final Logger logger = LogUtil.getPackageLogger(KDSBinaryBook.class);
    private BookIOController _ctrl;
    private String _bookName;
    private int _sheetCount;
    private int _activeSheetIndex;
    private ArrayList _sheetInfos;
    private KDSDataInputStream _bookInfos;
    private int fileVersion;
    private boolean skipReporting;

    public KDSBinaryBook(SectionJarInputStream sis, BookIOController ctrl) throws IOException, HighVersionException {
        this._ctrl = ctrl;
        int size = sis.size();
        if (size < 1) {
            throw new IllegalArgumentException("bytes is illegal");
        }
        this.fileVersion = sis.getFileVersion();
        if (KDSBinaryBook.isHigherVersion(this.fileVersion)) {
            throw new HighVersionException(this.fileVersion);
        }
        this._bookInfos = new KDSDataInputStream(sis.getSection(0));
        this.initBookBase(this._bookInfos);
        for (int i = 1; i < size; ++i) {
            SheetProxy si = (SheetProxy)this._sheetInfos.get(i - 1);
            si.setZipBytes(sis.getByteSection(i));
        }
    }

    public int fileVersion() {
        return this.fileVersion;
    }

    @Override
    public int getActiveSheetIndex() {
        return this._activeSheetIndex;
    }

    @Override
    public String getBookName() {
        return this._bookName;
    }

    @Override
    public int getSheetCount() {
        return this._sheetCount;
    }

    @Override
    public SheetProxy getSheetProxy(int index) {
        return (SheetProxy)this._sheetInfos.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initBookOptions(Book book) {
        book.setFileVersion(this.fileVersion);
        try {
            while (true) {
                byte id;
                if ((id = this._bookInfos.readByte()) == 5) {
                    boolean extendMode = this._bookInfos.readBoolean();
                    if (!extendMode) continue;
                    book.getDeps().setExtendMode(extendMode);
                    book.setAutoCalculate(false);
                    continue;
                }
                if (id == 1) {
                    BookProtection bp = book.getProtection();
                    bp.setOperations(this._bookInfos.readInt());
                    bp.startWithEncryptedPassword(this._bookInfos.readString());
                    continue;
                }
                if (id == 2) {
                    String key = this._bookInfos.readString();
                    String strVal = this._bookInfos.readString();
                    if (this._ctrl != null && !this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_BOOK_USEROBJECT)) continue;
                    Object value = this.getUoTransObject(key, strVal);
                    book.setUserObject(key, value);
                    continue;
                }
                if (id == 3) {
                    String author = this._bookInfos.readString();
                    String text = this._bookInfos.readString();
                    if (this._ctrl != null && !this._ctrl.touchModeFlag(IBookFieldFlags.FLAG_CELL_COMMENT)) continue;
                    book.setComment(new Comment(author, text));
                    continue;
                }
                if (id == 4) {
                    String name = this._bookInfos.readString();
                    String refersTo = this._bookInfos.readString();
                    NamedObjectNode nod = book.getNames().searchByName(name);
                    if (nod != null) {
                        if (nod instanceof ConstNamedObjectNode) continue;
                        Expr expr = book.getActiveSheet().getExpr(nod, refersTo);
                        nod.setExpr(expr);
                        continue;
                    }
                    book.getNames().insert(new NamedObjectNode(name, refersTo, book, null));
                    continue;
                }
                if (id == 6) {
                    int length = this._bookInfos.readInt();
                    byte[] data = new byte[length];
                    this._bookInfos.read(data);
                    book.getPropellingModel().load(data);
                    continue;
                }
                break;
            }
        }
        catch (IOException id) {
        }
        finally {
            this._bookInfos = null;
        }
        Dependents deps = book.getDeps();
        UserObject uo = book.getUserObject("$Iteration$");
        if (uo != null) {
            deps.setIterate(((String)uo.getValue()).equals("true"));
            book.removeUserObject("$Iteration$");
        }
        if ((uo = book.getUserObject("$MaxIterations$")) != null) {
            deps.setMaxIterations(Integer.parseInt((String)uo.getValue()));
            book.removeUserObject("$MaxIterations$");
        }
        if ((uo = book.getUserObject("$MaxChange$")) != null) {
            deps.setMaxChange(Double.parseDouble((String)uo.getValue()));
            book.removeUserObject("$MaxChange$");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSheet(Sheet sheet, byte[] bytes) throws IOException {
        Book book = sheet.getBook();
        boolean oldCalc = book.setAutoCalculate(false);
        boolean oldEnable = book.getUndoManager().isEnable();
        book.getUndoManager().enable(false);
        boolean oldLoading = book.setLoading(true);
        boolean oldA1Style = book.setA1Style(true);
        KDSDataInputStream is = null;
        try {
            is = new KDSDataInputStream((InputStream)SectionJarUtil.unzip(bytes));
            this.readSheet(sheet, is);
            if (is.available() > 0) {
                System.out.println("is.available() > 0");
                this.readSheetAgain(sheet, is);
            }
            if (this.fileVersion < 20005) {
                sheet.getBorders().buildFromSSA();
            }
        }
        catch (KDSReadException e) {
            System.out.println(e.getMessage());
            this.readSheetAgain(sheet, is);
        }
        catch (EOFException e) {
            System.out.println("end of file:" + e.getMessage());
            this.readSheetAgain(sheet, is);
        }
        finally {
            book.setAutoCalculate(oldCalc);
            book.getUndoManager().enable(oldEnable);
            book.setLoading(oldLoading);
            book.setA1Style(oldA1Style);
        }
    }

    private void readSheetAgain(Sheet sheet, KDSDataInputStream is) throws IOException {
        if (is != null && is.markSupported()) {
            System.out.println("skip read reporting and read sheet(" + sheet.getSheetName() + ") again");
            this.skipReporting = true;
            is.reset();
            this.readSheet(sheet, is);
            if (this.fileVersion < 20005) {
                sheet.getBorders().buildFromSSA();
            }
        }
    }

    private void initBookBase(KDSDataInputStream is) throws IOException {
        this._bookName = is.readString();
        this._sheetCount = is.readInt();
        this._activeSheetIndex = is.readInt();
        this._sheetInfos = new ArrayList(this._sheetCount);
        for (int i = 0; i < this._sheetCount; ++i) {
            String sheetId = is.readString();
            String sheetName = is.readString();
            SheetProxy si = new SheetProxy(this, sheetId, sheetName);
            byte flags = is.readByte();
            boolean hide = this.touchFlag(flags, 1);
            boolean selected = this.touchFlag(flags, 2);
            boolean hasData = this.touchFlag(flags, 4);
            Color color = null;
            int rgb = is.readInt();
            if (rgb != 0xFFAFAF) {
                color = new Color(rgb, true);
            }
            if (this.fileVersion > 20001) {
                si.setSheetType(is.readInt());
            }
            si.setHide(hide);
            si.setSelected(selected);
            si.setHasData(hasData);
            si.setTabColor(color);
            this._sheetInfos.add(si);
        }
    }

    private Object getUoTransObject(String key, String strVal) {
        Book.IUserObjectProvider trans = null;
        if (this._ctrl != null) {
            trans = this._ctrl.getKmlUOTrans();
        }
        if (trans != null) {
            return trans.getObject(key, strVal);
        }
        return strVal;
    }

    private void readSheet(Sheet sheet, KDSDataInputStream is) throws IOException {
        ShareStyleAttributes ssa;
        int styleid;
        is.readByte();
        HashMap styles = new HashMap();
        byte id = is.readByte();
        if (id == 5) {
            this.readStyles(is, styles);
        }
        if ((styleid = is.readInt()) != -1 && (ssa = (ShareStyleAttributes)styles.get(styleid)) != null) {
            sheet.appendSSA(ssa);
        }
        block7: while (true) {
            id = is.readByte();
            switch (id) {
                case 1: {
                    this.readRow(sheet, is, styles);
                    continue block7;
                }
                case 3: {
                    this.readSheetExtends(sheet, is, styles);
                    continue block7;
                }
                case 4: {
                    this.readSheetOption(sheet, is, styles);
                    continue block7;
                }
                case 2: {
                    this.readCol(sheet, is);
                    continue block7;
                }
                case 6: {
                    this.readSheetBorders(sheet, is);
                    continue block7;
                }
            }
            break;
        }
        this.clearMergeCells(sheet);
    }

    private void clearMergeCells(Sheet sheet) {
        MergeBlocks merges = sheet.getMerger(true);
        if (merges != null) {
            int size = merges.size();
            for (int i = 0; i < size; ++i) {
                CellBlock mergeBlock = merges.getBlock(i);
                Sheet.ICellsIterator iter = sheet.getCellsIterator(mergeBlock, true, false);
                Cell firstCell = sheet.getFirstCell(mergeBlock, false);
                while (iter.hasNext()) {
                    Cell next = iter.next();
                    if (next == firstCell) continue;
                    next.getRowObject().remove(next.getIntMark());
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readSheetExtends(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        block25: while (true) {
            if ((id = is.readByte()) == 5) {
                name = is.readString();
                refersTo = is.readString();
                try {
                    sheet.getRange(0, 0).setName(sheet.getSyntaxName() + '!' + name, refersTo);
                }
                catch (SyntaxErrorException e) {
                    KDSBinaryBook.logger.error((Object)"err", (Throwable)e);
                }
                continue;
            }
            if (id == 3) {
                key = is.readString();
                strVal = is.readString();
                value = this.getUoTransObject(key, strVal);
                sheet.setUserObject(key, value);
                continue;
            }
            if (id == 6) {
                this.readValidation(sheet, is);
                continue;
            }
            if (id == 4) {
                author = is.readString();
                text = is.readString();
                sheet.setComment(new Comment(author, text));
                continue;
            }
            if (id == 2 || id == 1) {
                start = is.readInt();
                extent = is.readInt();
                span = new Span(start, start + extent - 1);
                uid = is.readInt();
                ssa = null;
                if (uid != -1) {
                    ssa = (ShareStyleAttributes)styles.get(uid);
                }
                length = is.readInt();
                visible = this.touchFlag(is.readByte(), 1);
                sheet.setAboveOfOutlineGroup(is.readBoolean());
                sheet.setLeftToOutlineGroup(is.readBoolean());
                level = is.readInt();
                collapse = is.readBoolean();
                if (id == 1) {
                    sheet.getColSpans().setSpanAttribute(span, ssa, (Integer)length, (Boolean)visible, (Integer)level, (Boolean)collapse, false);
                    continue;
                }
                sheet.getRowSpans().setSpanAttribute(span, ssa, (Integer)length, (Boolean)visible, (Integer)level, (Boolean)collapse, false);
                continue;
            }
            if (id == 7) {
                className = is.readString();
                data = is.readLengthBytes();
                try {
                    if (className.contains("com.kingdee.bos.ctrl")) {
                        className = className.replace("com.kingdee.bos.ctrl", "com.kingdee.cosmic.ctrl");
                    }
                    emb = null;
                    clazz = Class.forName(className);
                    con = clazz.getConstructor(new Class[]{Sheet.class});
                    emb = (EmbedObject)con.newInstance(new Sheet[]{sheet});
                    if (emb == null) continue;
                    emb.load(data, false);
                    sheet.getEmbedments(true).addEmbed(emb);
                }
                catch (Exception e) {
                    KDSBinaryBook.logger.error((Object)"err", (Throwable)e);
                }
                continue;
            }
            if (id == 8) {
                size = is.readInt();
                cfl = sheet.getConditionalFormats();
                i = 0;
                while (true) {
                    if (i >= size) continue block25;
                    cf = new ConditionalFormat();
                    valve = is.readInt();
                    scba = SheetBaseMath.getSortedBlocks(sheet, is.readString(), true);
                    readBlockError = false;
                    if (scba.size() == 0) {
                        readBlockError = true;
                    }
                    cf.setBlocks(scba);
                    ssas = new ShareStyleAttributes[valve];
                    cds = new Condition[valve];
                    for (j = 0; j < valve; ++j) {
                        findex = is.readInt();
                        ssas[j] = findex < 0 ? null : (ShareStyleAttributes)styles.get(findex);
                        cds[j] = cd = new Condition();
                        cd.setTypeIndex(is.readInt());
                        quaIndex = is.readInt();
                        cd.setQualifierIndex(quaIndex);
                        min = is.readString();
                        max = null;
                        if (quaIndex <= 1) {
                            max = is.readString();
                        }
                        cd.setMinMax(min, max, sheet);
                        cd.setOwner(cf);
                    }
                    cf.setSSAs(ssas);
                    cf.setConditions(cds);
                    if (!readBlockError) {
                        cfl.addConditionalFormat(cf);
                    }
                    ++i;
                }
            }
            if (id == 9) {
                isPageView = is.readBoolean();
                sheet.setPageView(isPageView);
                if (isPageView) {
                    length = is.readInt();
                    snapshot = new int[length];
                    for (i = 0; i < length; ++i) {
                        snapshot[i] = is.readInt();
                    }
                    sheet.setRowPaginationPointsSnapshot(snapshot);
                    length = is.readInt();
                    snapshot = new int[length];
                    for (i = 0; i < length; ++i) {
                        snapshot[i] = is.readInt();
                    }
                    sheet.setColPaginationPointsSnapshot(snapshot);
                }
                if (!is.readBoolean()) continue;
                ppa = new SheetPlugablePaginationAdvice();
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert(ObjectCache.getInteger(is.readInt()));
                }
                ppa.setRowShrinkedBreaks(SOAUtil.ext2common(array));
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert(ObjectCache.getInteger(is.readInt()));
                }
                ppa.setRowExtendedBreaks(SOAUtil.ext2common(array));
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert(ObjectCache.getInteger(is.readInt()));
                }
                ppa.setColShrinkedBreaks(SOAUtil.ext2common(array));
                length = is.readInt();
                array = new SortedObjectArray(length);
                for (i = 0; i < length; ++i) {
                    array.insert(ObjectCache.getInteger(is.readInt()));
                }
                ppa.setColExtendedBreaks(SOAUtil.ext2common(array));
                sheet.setPlugablePaginationAdvice((PlugablePaginationAdvice)ppa);
                continue;
            }
            if (id == 10) {
                this.readFilters(sheet, is);
                continue;
            }
            if (id == 12) {
                sheet.getSheetOption().setSheetType(1);
                context = sheet.getBook().getDataSetManager().getExecutionContext();
                size = is.readInt();
                parameters = new HashMap<String, ParameterImpl>(size);
                for (i = 0; i < size; ++i) {
                    name = null;
                    alias = null;
                    description = null;
                    dataType = 0;
                    value = null;
                    isNullAble = false;
                    userDefine = false;
                    block35: while (true) {
                        y = is.readByte();
                        switch (y) {
                            case 1: {
                                name = is.readString();
                                continue block35;
                            }
                            case 2: {
                                alias = is.readString();
                                continue block35;
                            }
                            case 3: {
                                dataType = is.readInt();
                                continue block35;
                            }
                            case 4: {
                                length = is.readInt();
                                if (length > 1) {
                                    v = new Variant[length];
                                    for (l = 0; l < length; ++l) {
                                        is.readByte();
                                        v[l] = this.readVariant(is);
                                    }
                                    value = new Variant(v, 512);
                                    continue block35;
                                }
                                is.readByte();
                                value = this.readVariant(is);
                                continue block35;
                            }
                            case 5: {
                                isNullAble = is.readBoolean();
                                continue block35;
                            }
                        }
                        break;
                    }
                    impl = new ParameterImpl(name, alias, dataType, value, isNullAble);
                    impl.setDescription(description);
                    impl.setUserDefine(userDefine);
                    parameters.put(name, impl);
                }
                context.setDataSetParameters(parameters);
                sheet.getBook().getDataSetManager().setFlag(2, true);
                continue;
            }
            if (id == 13) {
                sheet.getBook().getDataSetManager().setFlag(2, true);
                continue;
            }
            if (id != 11) break;
            book = sheet.getBook();
            dm = book.getDataSetManager();
            size = is.readInt();
            i = 0;
            while (true) {
                if (i < size) ** break;
                continue block25;
                isRealDataSet = false;
                name = null;
                alias = null;
                define = null;
                cacheMeta = null;
                ds = null;
                block38: while (true) {
                    y = is.readByte();
                    switch (y) {
                        case 1: {
                            isRealDataSet = true;
                            name = is.readString();
                            break;
                        }
                        case 2: {
                            alias = is.readString();
                            break;
                        }
                        case 6: {
                            cacheMeta = is.readString();
                            break;
                        }
                        case 3: {
                            define = is.readString();
                            type = ExtDataSetType.getExtDataSetType(define);
                            ds = new ExtDataSet(book, name, type.trimPrefix(define), type);
                            if (alias != null) {
                                ds.setAlias(alias);
                            }
                            if (cacheMeta == null) continue block38;
                            ds.setMeta(cacheMeta);
                            break;
                        }
                        case 4: {
                            cols = is.readInt();
                            c = 0;
                            while (true) {
                                if (c >= cols) continue block38;
                                colName = null;
                                colAlias = null;
                                index = 0;
                                dataType = 0;
                                block40: while (true) {
                                    b = is.readByte();
                                    switch (b) {
                                        case 1: {
                                            colName = is.readString();
                                            break;
                                        }
                                        case 2: {
                                            colAlias = is.readString();
                                            break;
                                        }
                                        case 3: {
                                            index = is.readInt();
                                            break;
                                        }
                                        case 4: {
                                            dataType = is.readInt();
                                            col = new ExtColumn(ds, colName, index, 2);
                                            col.setDataType(dataType);
                                            if (colAlias != null) {
                                                col.setAlias(colAlias);
                                            }
                                            if (null == ds) continue block40;
                                            ds.addColumn(col);
                                            break;
                                        }
                                        default: {
                                            break block40;
                                        }
                                    }
                                }
                                ++c;
                            }
                        }
                        case 5: {
                            row = is.readInt();
                            col = is.readInt();
                            data = new Variant[row][col];
                            for (r = 0; r < row; ++r) {
                                for (c = 0; c < col; ++c) {
                                    is.readByte();
                                    data[r][c] = this.readVariant(is);
                                }
                            }
                            if (null != ds) {
                                ds.setData(data);
                            }
                            dm.setFlag(1, true);
                            break;
                        }
                        default: {
                            if (isRealDataSet) break block38;
                            break block25;
                        }
                    }
                }
                if (ds != null) {
                    dm.addDataSet(ds);
                }
                ++i;
            }
            break;
        }
    }

    private void readSheetBorders(Sheet sheet, KDSDataInputStream is) throws IOException {
        Borders bdrs = sheet.getBorders();
        HashMap<Integer, Border> bdMap = new HashMap<Integer, Border>();
        Span spMaster = new Span(0, 0);
        Span spMinor = new Span(0, 0);
        block0: while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                while (true) {
                    if ((id = is.readByte()) != 0) continue block0;
                    int uid = is.readInt();
                    LineStyle ls = LineStyle.getLineStyleByBits((int)is.readInt());
                    Color clr = new Color(is.readInt(), true);
                    PenStyle ps = PenStyle.getPenStyle((String)is.readString());
                    is.readByte();
                    bdMap.put(uid, Borders.getBorder(ps, ls, clr));
                }
            }
            if (id == 2) {
                this.readBordersRoot(is, bdrs, true, spMaster, spMinor, bdMap);
                continue;
            }
            if (id != 3) break;
            this.readBordersRoot(is, bdrs, false, spMaster, spMinor, bdMap);
        }
    }

    private void readBordersRoot(KDSDataInputStream is, Borders bdrs, boolean vert, Span spMaster, Span spMinor, HashMap bdMap) throws IOException {
        SortedBordersSpanArray root = bdrs.getRoot(vert);
        while (is.readByte() == 0) {
            spMaster.setPos(is.readInt(), is.readInt());
            while (is.readByte() == 0) {
                spMinor.setPos(is.readInt(), is.readInt());
                int uid = is.readInt();
                is.readByte();
                Border bdr = (Border)bdMap.get(uid);
                bdrs.setOneBorder(root, spMaster, spMinor, bdr, null);
            }
        }
    }

    private void readFilters(Sheet sheet, KDSDataInputStream is) throws IOException {
        byte b2 = is.readByte();
        if (b2 == 0) {
            int row = is.readInt();
            int row2 = is.readInt();
            int col = is.readInt();
            int col2 = is.readInt();
            sheet.setAutoFilterArea(CellBlock.getCellBlock(row, col, row2, col2));
            List autoFilters = sheet.getAutoFilters();
            int count = is.readInt();
            block9: for (int i = 0; i < count; ++i) {
                int id = is.readInt();
                int colIndex = is.readInt();
                switch (id) {
                    case 0: {
                        int amount = is.readInt();
                        boolean isAsc = is.readBoolean();
                        boolean isPercent = is.readBoolean();
                        autoFilters.add(new SheetFirstNAutoFilter(sheet, colIndex, amount, isAsc, isPercent));
                        continue block9;
                    }
                    case 1: {
                        is.readByte();
                        Variant variant = this.readVariant(is);
                        String text = is.readString();
                        autoFilters.add(new SheetItemAutoFilter(sheet, colIndex, variant, text));
                        continue block9;
                    }
                    case 2: {
                        autoFilters.add(new SheetEmptyAutoFilter(sheet, colIndex));
                        continue block9;
                    }
                    case 3: {
                        autoFilters.add(new SheetNonEmptyAutoFilter(sheet, colIndex));
                        continue block9;
                    }
                    case 4: {
                        int afcount = is.readInt();
                        SheetMultipleItemAutoFilter af = new SheetMultipleItemAutoFilter(sheet, colIndex);
                        for (int index = 0; index < afcount; ++index) {
                            is.readByte();
                            Variant variant = this.readVariant(is);
                            String text = is.readString();
                            af.addSelectedCellValueModel(new CellValueModel(variant, text));
                        }
                        autoFilters.add(af);
                        continue block9;
                    }
                    case 5: {
                        byte operator1 = is.readByte();
                        String value1 = is.readString();
                        byte link = is.readByte();
                        byte operator2 = is.readByte();
                        String value2 = is.readString();
                        autoFilters.add(new SheetCustomAutoFilter(sheet, colIndex, operator1, value1, link, operator2, value2));
                        continue block9;
                    }
                    case 6: {
                        byte type = is.readByte();
                        autoFilters.add(new SheetDynamicAutoFilter(sheet, colIndex, type));
                        continue block9;
                    }
                    default: {
                        throw new IllegalArgumentException(CtrlEXTMessages.getMLS("errorFilterIdentifier", "\u9519\u8bef\u7684\u7b5b\u9009\u5668\u6807\u8bc6!"));
                    }
                }
            }
        } else {
            throw new IllegalArgumentException(CtrlEXTMessages.getMLS("errorFilterIdentifier", "\u9519\u8bef\u7684\u7b5b\u9009\u5668\u6807\u8bc6!"));
        }
    }

    private void readValidation(Sheet sheet, KDSDataInputStream is) throws IOException {
        Validation val = new Validation(sheet, new MessagedValidate(), null);
        MessagedValidate mv = val.getMessagedValidate();
        mv.setTypeIndex(is.readInt());
        int quaIndex = is.readInt();
        mv.setQualifierIndex(quaIndex);
        val.setBlocks(SheetBaseMath.getSortedBlocks(sheet, is.readString(), true));
        mv.setImeMode(is.readByte());
        byte flags = is.readByte();
        mv.setCellRangeList(this.touchFlag(flags, 1));
        mv.setUseBlank(this.touchFlag(flags, 2));
        mv.setInputHide(this.touchFlag(flags, 4));
        mv.setErrorHide(this.touchFlag(flags, 8));
        String min = is.readString();
        String max = null;
        if (quaIndex <= 1) {
            max = is.readString();
        }
        mv.setMinMax(min, max, sheet);
        mv.setInputTitle(is.readString());
        mv.setInputMessage(is.readString());
        mv.setErrorStyle(is.readString());
        mv.setErrorTitle(is.readString());
        mv.setErrorMessage(is.readString());
        if (this.fileVersion >= 20006 && !this.skipReporting) {
            mv.setRegexString(is.readString());
            val.setReportingValidation(is.readBoolean());
            IEditorDefine define = ReportingFactory.fetchRuntimeProvider().generateDesignEditorDefine(ValueEditorType.getInstance(is.readString()));
            val.setEditorDefine(define);
            boolean hasFormula = is.readBoolean();
            String formula = is.readString();
            boolean primitiveValue = is.readBoolean();
            BooleanVFPair pair = new BooleanVFPair(true, null);
            if (hasFormula) {
                pair.setFormula(formula);
            } else {
                pair.setValue(primitiveValue);
            }
            define.setEnableFormula(pair);
            define.setModel(is.readString());
        } else {
            val.setEditorDefine(new NullEditorDefine());
        }
        sheet.getValidations().addValidation(val);
    }

    private void readSheetOption(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        SheetOption so = sheet.getSheetOption();
        so.setScale(is.readInt());
        int rgb = is.readInt();
        if (rgb != 0xFFAFAF) {
            so.setGridLineColor(new Color(rgb, true));
        }
        byte flags = is.readByte();
        so.setShowHoriLines(this.touchFlag(flags, 1));
        so.setShowVertLines(this.touchFlag(flags, 2));
        while (true) {
            Protection pro;
            byte id;
            if ((id = is.readByte()) == 6) {
                this.readPrintSetup(sheet, is, styles);
                continue;
            }
            if (id == 1) {
                pro = sheet.getSheetOption().getProtection(true);
                boolean start = is.read() != 0;
                pro.setOperations(is.readInt());
                String str = is.readString();
                if (start) {
                    pro.startWithEncryptedPassword(str);
                    continue;
                }
                pro.setEncryptedPassword(str);
                continue;
            }
            if (id == 2) {
                pro = sheet.getSheetOption().getProtection(true);
                String name = is.readString();
                String pw = is.readString();
                String range = is.readString();
                Protection.EditableArea ea = pro.createEditableArea(name);
                ea.setEncryptedPassword(pw);
                ea.addAll(SheetBaseMath.getSortedBlocks(sheet, range, true));
                pro.addEditableArea(ea);
                continue;
            }
            if (id == 4) {
                this.readSelection(sheet, is);
                continue;
            }
            if (id == 3) {
                this.readSplitInfo(sheet, is);
                continue;
            }
            if (id != 5) break;
            this.readMerge(sheet, is);
        }
    }

    private void readPrintSetup(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        block15: {
            PrintSetup ps = sheet.getSheetOption().getPrintSetup(true);
            byte flags = is.readByte();
            ps.setLandScape(this.touchFlag(flags, 32));
            ps.setRowFirst(this.touchFlag(flags, 16));
            ps.setBlackWhite(this.touchFlag(flags, 8));
            ps.setHasGrid(this.touchFlag(flags, 4));
            ps.setHasRowHead(this.touchFlag(flags, 1));
            ps.setHasColHead(this.touchFlag(flags, 2));
            ps.setCenterHorizontal(is.readInt());
            ps.setCenterVertical(is.readInt());
            ps.setTopMargin(Float.intBitsToFloat(is.readInt()));
            ps.setBottomMargin(Float.intBitsToFloat(is.readInt()));
            ps.setLeftMargin(Float.intBitsToFloat(is.readInt()));
            ps.setRightMargin(Float.intBitsToFloat(is.readInt()));
            ps.setPagesizeIndex(is.readInt());
            ps.setPagesizeX(Float.intBitsToFloat(is.readInt()));
            ps.setPagesizeY(Float.intBitsToFloat(is.readInt()));
            if (this.fileVersion < 20001) {
                ps.setScale(is.readInt());
            } else {
                ps.setAutoFit(is.readBoolean());
                ps.setScale(is.readInt());
                ps.setAutoFitWidth(is.readInt());
                ps.setAutoFitHeight(is.readInt());
            }
            ps.setHeadMargin(Float.intBitsToFloat(is.readInt()));
            ps.setHeadData(PrintHelper.genHeaderFootList(is.readString(), styles, true));
            ps.setFootAlign(is.readInt());
            ps.setHeadAlign(is.readInt());
            ps.setFootMargin(Float.intBitsToFloat(is.readInt()));
            ps.setFootData(PrintHelper.genHeaderFootList(is.readString(), styles, true));
            if (this.fileVersion < 20004) break block15;
            block11: while (true) {
                byte b2 = is.readByte();
                switch (b2) {
                    case 1: {
                        block12: while (true) {
                            byte y = is.readByte();
                            switch (y) {
                                case 1: {
                                    ps.setVerEconomizePaper(is.readBoolean());
                                    continue block12;
                                }
                                case 2: {
                                    ps.setHorEconomizePaper(is.readBoolean());
                                    continue block12;
                                }
                                case 3: {
                                    ps.setVerSpace(is.readInt());
                                    continue block12;
                                }
                                case 4: {
                                    ps.setHorSpace(is.readInt());
                                    continue block12;
                                }
                                case 127: {
                                    continue block11;
                                }
                            }
                            break;
                        }
                        continue block11;
                    }
                    case 127: {
                        break block11;
                    }
                }
                break;
            }
        }
    }

    private void readSelection(Sheet sheet, KDSDataInputStream is) throws IOException {
        int row = is.readInt();
        int col = is.readInt();
        String range = is.readString();
        Selection sel = sheet.getSheetOption().getSelection();
        ArrayList al = SheetBaseMath.getListBlocks(sheet, range, true);
        if (al != null) {
            sel.setData(al, 0, row, col);
        }
    }

    private void readMerge(Sheet sheet, KDSDataInputStream is) throws IOException {
        String range = is.readString();
        SortedCellBlockArray merges = SheetBaseMath.getSortedBlocks(sheet, range, true);
        sheet.getSheetOption().getMerger(true).addAll(merges);
    }

    private void readSplitInfo(Sheet sheet, KDSDataInputStream is) throws IOException {
        SheetOption so = sheet.getSheetOption();
        ViewSplitInfo vs = so.getViewSplitInfo();
        byte flags = is.readByte();
        so.setHide(this.touchFlag(flags, 1));
        so.setSelected(this.touchFlag(flags, 2));
        vs.setFreezed(this.touchFlag(flags, 4));
        vs.setActivePane(is.readInt());
        vs.setFirstRow(is.readInt());
        vs.setFirstCol(is.readInt());
        vs.setFirstRow2(is.readInt());
        vs.setFirstCol2(is.readInt());
        vs.setRowSplit(is.readInt());
        vs.setColSplit(is.readInt());
    }

    private void readCol(Sheet sheet, KDSDataInputStream is) throws IOException {
        byte id;
        int index = is.readInt();
        Column colObject = sheet.getColumn(index, true);
        while ((id = is.readByte()) == 1) {
            String key = is.readString();
            String strVal = is.readString();
            Object value = this.getUoTransObject(key, strVal);
            colObject.setUserObject(key, value);
        }
    }

    private void readRow(Sheet sheet, KDSDataInputStream is, HashMap styles) throws IOException {
        int rowIndex = is.readInt();
        int cellIndex = 0;
        Row row = sheet.getRow(rowIndex, true);
        while (true) {
            byte id;
            if ((id = is.readByte()) == 1) {
                String key = is.readString();
                String strVal = is.readString();
                Object value = this.getUoTransObject(key, strVal);
                row.setUserObject(key, value);
                continue;
            }
            if (id != 2) break;
            cellIndex = this.readCell(row, cellIndex, is, styles);
        }
    }

    private int readCell(Row row, int cellIndex, KDSDataInputStream is, HashMap styles) throws IOException {
        Cell _bufCell = null;
        int id = is.readByte();
        if (id == 1) {
            cellIndex = is.readInt();
            _bufCell = row.getCell(cellIndex++, true);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 2) {
            ShareStyleAttributes ssa;
            int styleid = is.readInt();
            if (styleid != -1 && (ssa = (ShareStyleAttributes)styles.get(styleid)) != null) {
                if (_bufCell == null) {
                    _bufCell = row.getCell(cellIndex++, true);
                }
                _bufCell.setSSA(ssa);
            }
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 3) {
            String fm = is.readString();
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setFormula(fm);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 4) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setValue(this.readVariant(is));
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 5) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setHyperLink(new HyperLink("", is.readString()));
            id = -1;
        }
        while (true) {
            if (id == -1) {
                id = is.readByte();
            }
            if (id != 6) break;
            String key = is.readString();
            String strVal = is.readString();
            Object value = this.getUoTransObject(key, strVal);
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setUserObject(key, value);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 7) {
            String author = is.readString();
            String text = is.readString();
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setComment(new Comment(author, text));
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 8) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            this.readDiagonal(_bufCell, is, styles);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 9) {
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            this.readExtProps(_bufCell, is);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (id == 10) {
            boolean merge = is.readBoolean();
            if (_bufCell == null) {
                _bufCell = row.getCell(cellIndex++, true);
            }
            _bufCell.setMerged(merge);
            id = -1;
        }
        if (id == -1) {
            id = is.readByte();
        }
        if (_bufCell == null) {
            _bufCell = row.getCell(cellIndex++, true);
        }
        return cellIndex;
    }

    private Variant readVariant(KDSDataInputStream is) throws IOException {
        Variant var;
        byte type = is.readByte();
        if (1 == type) {
            String valueString = is.readString();
            var = new Variant(valueString, 11);
        } else if (4 == type) {
            String valueString = is.readString();
            try {
                var = new Variant(new BigDecimal(valueString), 10);
            }
            catch (NumberFormatException ex) {
                if (MiscUtil.shouldLog()) {
                    MiscUtil.log(ex);
                }
                System.out.println("---------Fatal Error ocurred during loading kds file---------------");
                logger.error((Object)"err", (Throwable)ex);
                var = new Variant(valueString, 11);
            }
        } else if (8 == type) {
            long lTime;
            String valueString = is.readString();
            try {
                lTime = Long.parseLong(valueString);
            }
            catch (NumberFormatException e) {
                lTime = 0L;
            }
            Calendar cal = Variant.getGMTCalender();
            cal.setTimeInMillis(lTime);
            var = new Variant(cal, 13);
        } else if (2 == type) {
            var = new Variant(is.readBoolean(), 8);
        } else if (9 == type) {
            String valueString = is.readString();
            ExceptionMessageWrapper exception = new ExceptionMessageWrapper(valueString);
            var = new Variant(exception, 16);
        } else {
            var = Variant.nullVariant;
        }
        return var;
    }

    private void readDiagonal(Cell cell, KDSDataInputStream is, HashMap styles) throws IOException {
        byte pos = is.readByte();
        int row = is.readInt();
        int col = is.readInt();
        int row2 = is.readInt();
        int col2 = is.readInt();
        String srowoffs = is.readString();
        String scoloffs = is.readString();
        DiagonalHeader dh = new DiagonalHeader();
        dh.setSheet(cell.getSheet());
        int[] rowOffs = null;
        if (!StringUtil.isEmptyString((String)srowoffs)) {
            String[] strs = srowoffs.split(",");
            rowOffs = new int[strs.length];
            for (int i = strs.length - 1; i >= 0; --i) {
                rowOffs[i] = Integer.parseInt(strs[i]);
            }
        }
        int[] colOffs = null;
        if (!StringUtil.isEmptyString((String)scoloffs)) {
            String[] strs = scoloffs.split(",");
            colOffs = new int[strs.length];
            for (int i = strs.length - 1; i >= 0; --i) {
                colOffs[i] = Integer.parseInt(strs[i]);
            }
        }
        dh.setRowCol(row, col, row2, col2);
        dh.setSplitInfo(Integer.valueOf(pos), rowOffs, colOffs);
        cell.setDiagonalHeader(dh);
        Book book = cell.getSheet().getBook();
        int size = dh.size();
        for (int i = 0; i < size; ++i) {
            ShareStyleAttributes ssa;
            byte flags = is.readByte();
            dh.setLean((flags & 1) != 0, i);
            dh.setAutoZoom((flags & 2) != 0, i);
            dh.setDrawBackground((flags & 4) != 0, i);
            int uid = is.readInt();
            if (uid != -1 && (ssa = (ShareStyleAttributes)styles.get(uid)) != null) {
                dh.setStyle(book.getStyle(ssa), i);
            }
            dh.setText(is.readString(), i);
        }
    }

    private void readExtProps(Cell cell, KDSDataInputStream is) throws IOException {
        Sheet sheet = cell.getSheet();
        ExtProps ep = cell.getExtProps(true);
        if (this.fileVersion >= 20006 && !this.skipReporting) {
            byte ch = is.readByte();
            if (ch == 127) {
                return;
            }
            ep.setReportingGroupRootProps(ch != 0);
        }
        ETTargets targets = null;
        ExternalTargets eTargets = null;
        while (true) {
            int col;
            byte id;
            if ((id = is.readByte()) == 1) {
                long l = is.readLong();
                if (l == Long.MAX_VALUE) {
                    ep.setHead(sheet.TOP00, true);
                    continue;
                }
                int row = (int)(l >> 32);
                col = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                ExtProps leftHead = sheet.getCell(row, col, true).getExtProps(true);
                ep.setHead(leftHead, true);
                continue;
            }
            if (id == 2) {
                long l = is.readLong();
                if (l == Long.MAX_VALUE) {
                    ep.setHead(sheet.LEFT00, false);
                    continue;
                }
                int row = (int)(l >> 32);
                col = (int)(l & 0xFFFFFFFFFFFFFFFFL);
                ExtProps topHead = sheet.getCell(row, col, true).getExtProps(true);
                ep.setHead(topHead, false);
                continue;
            }
            if (id == 3) {
                ep.setExtensible(is.readInt());
                continue;
            }
            if (id == 4) {
                String strKey = is.readString();
                String formula = is.readString();
                ep.getFormulas(true).insert(CellPropAction.getAction(strKey), formula);
                continue;
            }
            if (id == 8) {
                SubReportInfo rptInfo = this.readSubReport(is, sheet, cell);
                ep.getFormulas(true).insert(rptInfo);
                continue;
            }
            if (id == 5) {
                targets = KDSBinaryBook.readTransitionTarget(is, sheet, cell, this.fileVersion);
                this.putTargets(ep, "EXTRPT", targets);
                continue;
            }
            if (id == 7) {
                InnerLinkTargets itTargets = KDSBinaryBook.readInnerTransitionTarget(is, sheet, cell);
                this.putTargets(ep, "EXT_INNER", itTargets);
                continue;
            }
            if (id == 6) {
                eTargets = this.readExternalTarget(is, sheet, cell);
                this.putTargets(ep, "EXTERNAL", eTargets);
                continue;
            }
            if (id == 9) {
                String colorStr = is.readString();
                int colorRGB = Integer.parseInt(colorStr);
                Color color = new Color(colorRGB);
                if (targets != null) {
                    targets.setBehaviorFontColor(color);
                }
                if (eTargets == null) continue;
                eTargets.setBehaviorFontColor(color);
                continue;
            }
            if (id != 11 || (id = this.readPhoneNum(is, sheet, cell)) == 127) break;
        }
    }

    private byte readPhoneNum(KDSDataInputStream is, Sheet sheet, Cell cell) throws IOException {
        byte flag = 0;
        boolean isContinue = true;
        PhoneNumModel model = new PhoneNumModel();
        model.setFormula(is.readString());
        block4: while (isContinue) {
            flag = is.readByte();
            switch (flag) {
                case 10: {
                    String behavior = is.readString();
                    if (StringUtil.isEmptyString((String)behavior)) continue block4;
                    model.setBehaviorAction(sheet.getExpr(cell, behavior));
                    continue block4;
                }
                case 9: {
                    String rgb = is.readString();
                    if (StringUtil.isEmptyString((String)rgb)) continue block4;
                    model.setBehaviorFontColor(new Color(Integer.parseInt(rgb)));
                    continue block4;
                }
            }
            isContinue = false;
        }
        PhoneNumCalculableProps phonePros = new PhoneNumCalculableProps();
        phonePros.setModel(model);
        ExtProps props = cell.getExtProps(true);
        props.getFormulas(true).insert(phonePros);
        return flag;
    }

    private SubReportInfo readSubReport(KDSDataInputStream is, Sheet sheet, Cell cell) throws IOException {
        String rptId = is.readString();
        String rptName = is.readString();
        String rptPath = is.readString();
        String alias = is.readString();
        String pathAlias = is.readString();
        String rptDomain = is.readString();
        ReportProperties rptProps = new ReportProperties(rptId, rptName, rptPath);
        rptProps.setDomain(rptDomain);
        rptProps.setAlias(alias);
        Expr expr = sheet.getExpr(cell, alias);
        rptProps.setCalculableProps(new CommonCalculableProps(ExtConst.FORMULA_HYPERLINK, expr));
        rptProps.setPathAlias(pathAlias);
        Map params = KDSBinaryBook.readParams(is, sheet, cell);
        SubReportInfo rptInfo = new SubReportInfo();
        rptInfo.setReportProps(rptProps);
        rptInfo.setParams(params);
        cell.setSubReportInfo(rptInfo);
        sheet.addSubReportCell(cell);
        return rptInfo;
    }

    public static ETTargets readTransitionTarget(KDSDataInputStream is, Sheet sheet, ICalculable owner, int fileVersion) throws IOException {
        ETTargets targets = new ETTargets();
        if (fileVersion < 0 || fileVersion >= 20005) {
            String formula = is.readString();
            is.readString();
            if (!StringUtil.isEmptyString((String)formula)) {
                targets.setBehaviorAction(sheet.getExpr(owner, formula));
            }
        }
        int tcount = is.readInt();
        ArrayList<ExtTransitionTarget> list = new ArrayList<ExtTransitionTarget>(tcount);
        for (int i1 = 0; i1 < tcount; ++i1) {
            String rId = is.readString();
            String rName = is.readString();
            String rPath = is.readString();
            String rAlias = is.readString();
            String rPathAlias = is.readString();
            String rDomain = is.readString();
            ReportProperties fullName = new ReportProperties(rId, rName, rPath);
            if (!StringUtil.isEmptyString((String)rAlias)) {
                fullName.setAlias(rAlias);
                Expr expr = sheet.getExpr(owner, rAlias);
                fullName.setCalculableProps(new CommonCalculableProps(ExtConst.FORMULA_HYPERLINK, expr));
            }
            if (!StringUtil.isEmptyString((String)rPathAlias)) {
                fullName.setPathAlias(rPathAlias);
            }
            if (!StringUtil.isEmptyString((String)rDomain)) {
                fullName.setDomain(rDomain);
            }
            Map params = KDSBinaryBook.readParams(is, sheet, owner);
            ExtTransitionTarget tt = new ExtTransitionTarget(fullName, params);
            list.add(tt);
        }
        int didx = is.readInt();
        targets.setDefaultTarget((ExtTransitionTarget)list.get(didx));
        targets.setTargets(list);
        return targets;
    }

    public static InnerLinkTargets readInnerTransitionTarget(KDSDataInputStream is, Sheet sheet, ICalculable owner) throws IOException {
        InnerLinkTargets innerTargets = new InnerLinkTargets();
        String formula = is.readString();
        is.readString();
        if (!StringUtil.isEmptyString((String)formula)) {
            innerTargets.setBehaviorAction(sheet.getExpr(owner, formula));
        }
        int tcount1 = is.readInt();
        ArrayList<InnerLinkTransitionTarget> list1 = new ArrayList<InnerLinkTransitionTarget>(tcount1);
        for (int i1 = 0; i1 < tcount1; ++i1) {
            String rId = is.readString();
            String rName = is.readString();
            String targetType = is.readString();
            InnerLinkTargetProperties fullName = null;
            fullName = "fusionChart".equals(targetType) ? new ChartInnerLinkTargetProperties() : new InnerLinkTargetProperties();
            fullName.setId(owner, rId);
            fullName.setName(rName);
            if ("subReport".equals(targetType)) {
                KDSBinaryBook.fixInnerLinkTargets(sheet, fullName, owner);
            }
            Map params = KDSBinaryBook.readParams(is, sheet, owner);
            InnerLinkTransitionTarget tt = new InnerLinkTransitionTarget(fullName, params);
            tt.setTargetType(targetType);
            list1.add(tt);
        }
        int didx1 = is.readInt();
        innerTargets.setDefaultTarget((InnerLinkTransitionTarget)list1.get(didx1));
        innerTargets.setTargets(list1);
        return innerTargets;
    }

    private static void fixInnerLinkTargets(Sheet dstSheet, InnerLinkTargetProperties props, ICalculable owner) {
        Expr expr = props.getExpr();
        if (null == expr) {
            return;
        }
        String cellName = expr.decode(dstSheet.getDeps().getExprContext(), owner);
        if (!StringUtil.isEmptyString((String)cellName) && !cellName.contains("!")) {
            cellName = dstSheet.getSyntaxName() + "!" + cellName;
        }
        props.setId(owner, cellName);
        String name = props.getName();
        if (!StringUtil.isEmptyString((String)name) && name.contains("]")) {
            int index = name.indexOf("]");
            name = name.substring(index + 1);
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(cellName).append("]").append(name);
            props.setName(sb.toString());
        }
        Expr fixExpr = KDSBinaryBook.fixExpr(expr, dstSheet, owner);
        props.setExpr(fixExpr);
    }

    private static Expr fixExpr(Expr oldExpr, Sheet dstSheet, ICalculable owner) {
        Expr dstExpr = null;
        if (null == oldExpr) {
            return null;
        }
        IExprNode[] nodes = oldExpr.getAllNodes();
        for (int j = nodes.length - 1; j >= 0; --j) {
            IExprNode node = nodes[j];
            if (node.getExprType() != 4) continue;
            CellBlockNode newNode = (CellBlockNode)((CellBlockNode)node).clone();
            newNode.setSheet(dstSheet);
            newNode.setRefs(null);
            nodes[j] = newNode.getSheet().setDependent(owner, newNode);
        }
        dstExpr = Expr.getExpr(dstSheet.getDeps(), nodes, oldExpr.getExprNodeState(), 0, nodes.length);
        return dstExpr;
    }

    private static Map readParams(KDSDataInputStream is, Sheet sheet, ICalculable owner) throws IOException {
        int pcount = is.readInt();
        TreeMap<String, ParameterImpl> params = null;
        if (pcount != 0) {
            params = new TreeMap<String, ParameterImpl>();
        }
        for (int j = 0; j < pcount; ++j) {
            ParameterImpl pi = new ParameterImpl();
            String name = is.readString();
            boolean userDefined = name.startsWith("_userdefine_");
            if (userDefined) {
                name = name.substring(12);
            }
            pi.setName(name);
            String formula = is.readString();
            Expr expr = sheet.getExpr(owner, formula);
            pi.setExpr(expr);
            pi.setAlias(is.readString());
            pi.setDataType(is.readInt());
            pi.setNullable(is.readBoolean());
            pi.setUserDefine(userDefined);
            params.put(pi.getName(), pi);
        }
        return params;
    }

    private ExternalTargets readExternalTarget(KDSDataInputStream is, Sheet sheet, Cell cell) throws IOException {
        byte iid;
        ExternalTargets targets = new ExternalTargets();
        block12: while ((iid = is.readByte()) != 0) {
            switch (iid) {
                case 1: {
                    ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
                    int count = is.readInt();
                    for (int i = 0; i < count; ++i) {
                        HashMap<String, String[]> map = new HashMap<String, String[]>();
                        int eleCount = is.readInt();
                        for (int j = 0; j < eleCount; ++j) {
                            Object value;
                            String key = is.readString();
                            int datatype = is.readInt();
                            switch (datatype) {
                                case 1: {
                                    value = is.readString();
                                    break;
                                }
                                case 2: {
                                    String formula = is.readString();
                                    Expr expr = sheet.getExpr(cell, formula);
                                    CommonCalculableProps prop = new CommonCalculableProps(ExtConst.FORMULA_HYPERLINK, null);
                                    prop.setExpr(expr);
                                    value = prop;
                                    break;
                                }
                                case 4: {
                                    int propsCount = is.readInt();
                                    String[] strings = new String[propsCount];
                                    for (int x = 0; x < propsCount; ++x) {
                                        strings[x] = is.readString();
                                    }
                                    value = strings;
                                    break;
                                }
                                case 3: {
                                    int propsCount = is.readInt();
                                    CommonCalculableProps[] props = new CommonCalculableProps[propsCount];
                                    for (int x = 0; x < propsCount; ++x) {
                                        String formula = is.readString();
                                        Expr expr = sheet.getExpr(cell, formula);
                                        CommonCalculableProps prop = new CommonCalculableProps(ExtConst.FORMULA_HYPERLINK, null);
                                        prop.setExpr(expr);
                                        props[x] = prop;
                                    }
                                    value = props;
                                    break;
                                }
                                case 5: {
                                    value = KDSBinaryBook.readParams(is, sheet, cell);
                                    break;
                                }
                                default: {
                                    throw new IllegalArgumentException();
                                }
                            }
                            map.put(key, (String[])value);
                        }
                        list.add(map);
                    }
                    targets.setTargets(list);
                    continue block12;
                }
                case 2: {
                    targets.setDefaultIndex(is.readInt());
                    continue block12;
                }
                case 10: {
                    String formula = is.readString();
                    if (StringUtil.isEmptyString((String)formula)) continue block12;
                    targets.setBehaviorAction(sheet.getExpr(cell, formula));
                    continue block12;
                }
            }
            break;
        }
        return targets;
    }

    private void putTargets(ExtProps ep, String type, IPreCondition targets) {
        HyperlinkCalculableProps hyperlinks = null;
        SortedExtPropFormulasArray formulas = ep.getFormulas(true);
        ICalculableProps obj = formulas.get(ExtConst.FORMULA_HYPERLINK);
        if (obj instanceof HyperlinkCalculableProps) {
            hyperlinks = (HyperlinkCalculableProps)obj;
        }
        if (hyperlinks == null) {
            hyperlinks = new HyperlinkCalculableProps();
            hyperlinks.setTargets(new HashMap<String, Object>());
            formulas.insert(hyperlinks);
        }
        hyperlinks.getTargets().put(type, targets);
    }

    private void readStyles(KDSDataInputStream is, HashMap styles) throws IOException {
        byte id;
        while ((id = is.readByte()) == 0) {
            this.readStyle(is, styles);
        }
    }

    private void readStyle(KDSDataInputStream is, HashMap styles) throws IOException {
        block32: {
            StyleAttributes _cursa = Styles.getEmptySA();
            _cursa.setUID(is.readInt());
            while (true) {
                int intls;
                byte id;
                if ((id = is.readByte()) == 1) {
                    byte flags;
                    int colorRGB;
                    int size;
                    String fontName = is.readString();
                    if (!StringUtil.isEmptyString((String)fontName)) {
                        _cursa.setFontName(fontName);
                    }
                    if ((size = is.readInt()) != -1) {
                        _cursa.setFontSize(size);
                    }
                    if ((colorRGB = is.readInt()) != 0xFFAFAF) {
                        _cursa.setFontColor(new Color(colorRGB, true));
                    }
                    if (this.touchFlag(flags = is.readByte(), 1)) {
                        _cursa.setUnderline(true);
                    }
                    if (this.touchFlag(flags, 2)) {
                        _cursa.setBold(true);
                    }
                    if (this.touchFlag(flags, 4)) {
                        _cursa.setItalic(true);
                    }
                    if (!this.touchFlag(flags, 8)) continue;
                    _cursa.setStrikeThrough(true);
                    continue;
                }
                if (id == 12) {
                    _cursa.setIndentation(is.readInt());
                    continue;
                }
                if (id == 2) {
                    byte flags;
                    int rotat;
                    int vval;
                    int hval = is.readInt();
                    if (hval != -1) {
                        _cursa.setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((int)hval));
                    }
                    if ((vval = is.readInt()) != -1) {
                        _cursa.setVerticalAlign(Styles.VerticalAlignment.getAlignment((int)vval));
                    }
                    if ((rotat = is.readInt()) != -1) {
                        _cursa.setRotation(rotat);
                    }
                    if (this.touchFlag(flags = is.readByte(), 1)) {
                        _cursa.setWrapText(true);
                    }
                    if (this.touchFlag(flags, 2)) {
                        _cursa.setShrinkText(true);
                    }
                    if (!this.touchFlag(flags, 4)) continue;
                    _cursa.setVerticalText(true);
                    continue;
                }
                if (id == 4) {
                    String penName;
                    Styles.Position pos = Styles.Position.TOP;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 5) {
                    String penName;
                    Styles.Position pos = Styles.Position.BOTTOM;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 6) {
                    String penName;
                    Styles.Position pos = Styles.Position.LEFT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 7) {
                    String penName;
                    Styles.Position pos = Styles.Position.RIGHT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 8) {
                    String penName;
                    Styles.Position pos = Styles.Position.DIAGONALLEFT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 9) {
                    String penName;
                    Styles.Position pos = Styles.Position.DIAGONALRIGHT;
                    intls = is.readInt();
                    _cursa.setBorderLineStyle(pos, LineStyle.getLineStyleByBits((int)intls));
                    int clrRGB = is.readInt();
                    if (clrRGB != 0xFFAFAF) {
                        _cursa.setBorderColor(pos, new Color(clrRGB, true));
                    }
                    if (StringUtil.isEmptyString((String)(penName = is.readString()))) continue;
                    _cursa.setBorderPenStyle(pos, PenStyle.getPenStyle((String)penName));
                    continue;
                }
                if (id == 10) {
                    int pid;
                    int rgb = is.readInt();
                    if (rgb != 0xFFAFAF) {
                        _cursa.setBackground(new Color(rgb, true));
                    }
                    if ((pid = is.readInt()) >= 0) {
                        Pattern p = Pattern.getPattern((int)pid);
                        _cursa.setPattern(p);
                    }
                    if ((rgb = is.readInt()) == 0xFFAFAF) continue;
                    _cursa.setPatternColor(new Color(rgb, true));
                    continue;
                }
                if (id == 11) {
                    String nf = is.readString();
                    _cursa.setNumberFormat(nf);
                    continue;
                }
                if (id != 3) break;
                byte flags = is.readByte();
                if (this.touchFlag(flags, 1)) {
                    _cursa.setHided(this.touchFlag(flags, 2));
                }
                if (!this.touchFlag(flags, 4)) continue;
                _cursa.setLocked(this.touchFlag(flags, 8));
            }
            if (_cursa.isEmpty()) break block32;
            styles.put(_cursa.getUID(), _cursa);
        }
    }
}

