/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kds;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.SectionByteInputStream;
import com.kingdee.cosmic.ctrl.common.util.SectionByteOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class SectionJarUtil {
    public static final int SectionCountLength = 4;
    public static final int SectionLength = 4;
    public static final float GZIPFACTOR = 0.03f;
    public static final float MAX_BUFFER = 131072.0f;

    public static byte[] zip(SectionByteOutputStream os) throws IOException {
        if (os == null || os.size() < 1) {
            return null;
        }
        int size = os.size();
        float initCapacity = (float)size * Math.min(0.03f, 1.0f);
        if (initCapacity > 131072.0f) {
            initCapacity = 131072.0f;
        }
        SectionByteOutputStream bout = new SectionByteOutputStream();
        SectionJarUtil.writeCount((OutputStream)bout, size);
        GZIPOutputStream zout = new GZIPOutputStream((OutputStream)bout);
        os.writeTo((OutputStream)zout);
        zout.flush();
        bout.flush();
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static byte[] zip(ByteArrayOutputStream os) throws IOException {
        if (os == null || os.size() < 1) {
            return null;
        }
        int size = os.size();
        float initCapacity = (float)size * Math.min(0.03f, 1.0f);
        if (initCapacity > 131072.0f) {
            initCapacity = 131072.0f;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream((int)initCapacity);
        SectionJarUtil.writeCount(bout, size);
        GZIPOutputStream zout = new GZIPOutputStream(bout);
        os.writeTo(zout);
        zout.flush();
        bout.flush();
        zout.close();
        bout.close();
        return bout.toByteArray();
    }

    public static SectionByteInputStream unzip(byte[] source) throws IOException {
        int len;
        if (source == null || source.length < 1) {
            throw new IllegalArgumentException("source " + CtrlEXTMessages.getMLS("cannotBeEmptyOrLengthLessThanOne", "\u4e0d\u80fd\u4e3a\u7a7a\u6216\u957f\u5ea6\u5c0f\u4e8e1"));
        }
        ByteArrayInputStream bin = new ByteArrayInputStream(source);
        int count = SectionJarUtil.readCount(bin);
        if (count == Integer.MAX_VALUE) {
            bin.close();
            throw new IllegalArgumentException("count" + CtrlEXTMessages.getMLS("tooLargeCannotUnzip", "\u8fc7\u5927\uff0c\u65e0\u6cd5\u89e3\u538b"));
        }
        if (count < 1) {
            bin.close();
            throw new IllegalArgumentException("count" + CtrlEXTMessages.getMLS("lessThanOrEqualToZeroCannotUnzip", "\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u65e0\u6cd5\u89e3\u538b"));
        }
        GZIPInputStream zin = new GZIPInputStream(bin);
        SectionByteInputStream sbis = new SectionByteInputStream();
        int sectionLen = sbis.getSectionLength();
        byte[] res = null;
        int num = 0;
        while ((len = count - num) > 0) {
            int len2;
            int count2;
            res = new byte[sectionLen];
            int num2 = 0;
            int n = count2 = count < sectionLen ? count : sectionLen;
            while ((len2 = count2 - num2) >= 0) {
                int n2;
                if (len2 > 4096) {
                    len2 = 4096;
                }
                if ((n2 = zin.read(res, num2, len2)) <= 0) break;
                num2 += n2;
            }
            sbis.addBytes(res, num2);
            num += num2;
        }
        zin.close();
        bin.close();
        if (num != count) {
            throw new IllegalArgumentException(CtrlEXTMessages.getMLS("unzipSizeMismatchCompressedSize", "\u89e3\u538b\u540e\u5927\u5c0f\u548c\u538b\u7f29\u524d\u4e0d\u4e00\u81f4"));
        }
        return sbis;
    }

    private static int readCount(ByteArrayInputStream input) {
        int res = 0;
        for (int i = 0; i < 4; ++i) {
            int sz = input.read();
            if (sz < 0) {
                return 0;
            }
            if (i > 0) {
                res <<= 8;
            }
            res |= sz;
        }
        return res;
    }

    private static void writeCount(OutputStream output, int size) throws IOException {
        for (int i = 3; i >= 0; --i) {
            output.write(size >> i * 8 & 0xFF);
        }
    }
}

