/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kml;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.bos.qing.common.xml.impl.XmlDomWriter;
import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.AbstractTableSplitRectInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.splitrectangle.TriangleInfo;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleParser;
import com.kingdee.cosmic.ctrl.kds.io.BookIOController;
import com.kingdee.cosmic.ctrl.kds.io.IBookFieldFlags;
import com.kingdee.cosmic.ctrl.kds.io.PrintHelper;
import com.kingdee.cosmic.ctrl.kds.io.kml.IKmlConstants;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlStyleParser;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookFormulaHelper;
import com.kingdee.cosmic.ctrl.kds.model.struct.BookProtection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Column;
import com.kingdee.cosmic.ctrl.kds.model.struct.Comment;
import com.kingdee.cosmic.ctrl.kds.model.struct.DiagonalHeader;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetOption;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedUserObjectArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.ViewSplitInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.SortedNamedObjectNodeArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.Validate;
import com.kingdee.cosmic.ctrl.print.printjob.table.PlugablePaginationAdvice;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public final class BookToKml
extends IBookFieldFlags
implements IKmlConstants {
    private static final Logger logger = LogUtil.getPackageLogger(BookToKml.class);
    static final char LeftBracket = '<';
    static final char RightBracket = '>';
    static final char Diagonal = '/';
    static final char Blank = ' ';
    static final char QuotationMark = '\"';
    static final char Colon = ':';
    static final char Equal = '=';
    static final String NewLine = "\r\n";
    static final String InitSource = "<?xml version=\"1.0\"?>\r\n<?mso-application progid=\"Excel.Sheet\" version=\"1.0\"?>\r\n";
    private static final String Xmlns = "xmlns";
    private static ThreadLocal<DateFormat> sdf = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'SSS");
        }
    };
    private StringBuffer _reuseSb = new StringBuffer();
    private HashMap _saCache;
    private BookIOController _ctrl;

    public void setBookIOController(BookIOController ctrl) {
        this._ctrl = ctrl;
    }

    private boolean touchControllerFlag(int flag) {
        if (this._ctrl == null) {
            return true;
        }
        return this._ctrl.touchModeFlag(flag);
    }

    private boolean isToClipboard() {
        if (this._ctrl == null) {
            return false;
        }
        return this._ctrl.isToClipboard();
    }

    private boolean isForExcel() {
        if (this._ctrl == null) {
            return false;
        }
        return this._ctrl.isForExcel();
    }

    private Book.IUserObjectProvider getKmlUOTrans() {
        if (this._ctrl == null) {
            return null;
        }
        return this._ctrl.getKmlUOTrans();
    }

    public void export(Book book, String fileName) throws IOException {
        this.export(book, fileName, null);
    }

    public void export(Book book, Writer writer) throws IOException {
        this.export(book, writer, null);
    }

    public void export(Book book, OutputStream os) throws IOException {
        this.export(book, os, null);
    }

    public void export(Book book, OutputStream os, String[] sheetNames) throws IOException {
        KmlOutputter outter = this.createKmlOutputter();
        this.export(book, outter.makeWriter(os), sheetNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(Book book, String fileName, String[] sheetNames) throws IOException {
        KmlOutputter outter = this.createKmlOutputter();
        try (FileOutputStream fos = null;){
            fos = new FileOutputStream(FilenameUtils.normalize((String)fileName));
            this.export(book, outter.makeWriter(fos), sheetNames);
        }
    }

    public void export(Book book, Writer out, String[] sheetNames) throws IOException {
        KmlOutputter outter = this.createKmlOutputter();
        this.exportImpl(book, outter, out, sheetNames);
    }

    private String getNamespaceString(String prefix, String uri) {
        this._reuseSb.delete(0, this._reuseSb.length());
        if (StringUtil.isEmptyString((String)prefix)) {
            this._reuseSb.append(Xmlns).append('=').append('\"').append(uri).append('\"');
        } else {
            this._reuseSb.append(Xmlns).append(':').append(prefix).append('=').append('\"').append(uri).append('\"');
        }
        return this._reuseSb.toString();
    }

    private String getAttributeString(String name, String value) {
        this._reuseSb.delete(0, this._reuseSb.length());
        this._reuseSb.append(name).append('=').append('\"').append(value).append('\"');
        return this._reuseSb.toString();
    }

    private HashMap getSaCache() {
        if (this._saCache == null) {
            this._saCache = new HashMap();
        }
        return this._saCache;
    }

    private boolean needImported(String sheetName, String[] sheetNames) {
        boolean importSheet = true;
        if (sheetNames != null) {
            importSheet = false;
            int c2 = sheetNames.length;
            for (int j = 0; j < c2; ++j) {
                if (!sheetNames[j].equals(sheetName)) continue;
                importSheet = true;
                break;
            }
        }
        return importSheet;
    }

    private void scanStyle(Book book, String[] sheetNames) {
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            int count = book.getSheetCount();
            for (int i = 0; i < count; ++i) {
                int j;
                Sheet sheet = book.getSheet(i);
                boolean importSheet = this.needImported(sheet.getSheetName(), sheetNames);
                if (!importSheet) continue;
                PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
                if (ps != null) {
                    this.scanHeadFooterStyleImpl(book, ps.getHeadData());
                    this.scanHeadFooterStyleImpl(book, ps.getFootData());
                }
                this.addSSA(sheet.getSSA());
                Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, sheet.getMaxRowIndex(), sheet.getMaxColIndex(), false, false);
                while (iter.hasNext()) {
                    Cell cell = iter.next();
                    DiagonalHeader dh = cell.getDiagonalHeader();
                    if (dh != null) {
                        int size = dh.size();
                        for (j = 0; j < size; ++j) {
                            Style ssa = dh.getTriangleInfo(j).getStyle();
                            if (ssa == null || ssa.isEmpty()) continue;
                            this.addSSA((ShareStyleAttributes)ssa);
                        }
                    }
                    this.addSSA(cell.getSSA());
                }
                SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
                int size = rowSpans.size();
                for (int j2 = 0; j2 < size; ++j2) {
                    this.addSSA(rowSpans.getAttributeSpan(j2).getSSA());
                }
                SortedAttributeSpanArray colSpans = sheet.getColSpans();
                size = colSpans.size();
                for (j = 0; j < size; ++j) {
                    this.addSSA(colSpans.getAttributeSpan(j).getSSA());
                }
            }
        }
    }

    private void scanHeadFooterStyleImpl(Book book, List listData) {
        if (listData == null) {
            return;
        }
        ListIterator iter = listData.listIterator();
        while (iter.hasNext()) {
            HeadFootRow row = (HeadFootRow)iter.next();
            StyleAttributes sa = row.getSA();
            if (sa == null) continue;
            ShareStyleAttributes ssa = book.getSSA(sa);
            this.addSSA(ssa);
        }
    }

    private void addSSA(ShareStyleAttributes ssa) {
        if (ssa != null && !ssa.isEmpty()) {
            Integer key = ssa.getUID();
            this.getSaCache().put(key, ssa);
        }
    }

    private KmlOutputter createKmlOutputter() {
        return new KmlOutputter("\t", true, "UTF-8");
    }

    private void exportImpl(Book book, KmlOutputter outter, Writer out, String[] sheetNames) throws IOException {
        outter.writeString(InitSource, out);
        this.buildBook(book, sheetNames, outter, out);
        out.flush();
    }

    private void buildBook(Book book, String[] sheetNames, KmlOutputter outter, Writer out) throws IOException {
        boolean oldA1style = book.getDeps().isA1Style();
        book.setA1Style(false);
        book.clearEmptyCells();
        StringBuilder sb = new StringBuilder(200);
        outter.writeStart("Workbook", sb.toString(), out);
        this.buildBookExtends(book, outter, out);
        this.buildExcelBook(book, outter, out);
        if (this.touchControllerFlag(IBookFieldFlags.FLAG_STYLE)) {
            this.scanStyle(book, sheetNames);
            IXmlElement stylesE = XmlUtil.createNode((String)"Styles");
            KmlStyleParser.buildStylesElement(stylesE, this.getSaCache().entrySet().iterator());
            outter.output(stylesE, out);
            outter.writeString(NewLine, out);
        }
        if (this.touchControllerFlag(FLAG_BOOK_NAMES)) {
            this.buildNames(book, book.getNames(), outter, out);
        }
        int count = book.getSheetCount();
        for (int i = 0; i < count; ++i) {
            Sheet sheet = book.getSheet(i);
            if (!this.needImported(sheet.getSheetName(), sheetNames)) continue;
            this.buildSheet(sheet, outter, out);
        }
        outter.writeEnd("Workbook", out);
        book.setA1Style(oldA1style);
        this.getSaCache().clear();
    }

    private void buildBookExtends(Book book, KmlOutputter outter, Writer out) throws IOException {
        boolean buo = this.touchControllerFlag(FLAG_BOOK_USEROBJECT);
        boolean bcom = this.touchControllerFlag(FLAG_BOOK_COMMENT);
        if (!buo && !bcom) {
            return;
        }
        Comment comment = book.getComment();
        SortedUserObjectArray uos = book.getUserObjects();
        if ((uos == null || uos.isEmpty()) && comment == null) {
            return;
        }
        outter.writeStart("KingdeeDefined", out);
        if (buo) {
            this.buildUserObjects(uos, outter, out);
        }
        if (bcom) {
            this.buildComment(comment, outter, out);
        }
        outter.writeEnd("KingdeeDefined", out);
    }

    private void buildExcelBook(Book book, KmlOutputter outter, Writer out) throws IOException {
        outter.writeStart("ExcelWorkbook", " ", out);
        int aIndex = book.getActiveSheetIndex();
        if (aIndex != 0) {
            outter.writeElementWithData("ActiveSheet", String.valueOf(aIndex), out);
        }
        if (this.touchControllerFlag(FLAG_BOOK_PROTECTION)) {
            BookProtection pro = book.getProtection();
            if (!pro.allowOperatorStruct()) {
                outter.writeElementWithData("ProtectStructure", "True", out);
            }
            if (!pro.allowOperatorWindow()) {
                outter.writeElementWithData("ProtectWindows", "True", out);
            }
            String pw = pro.getEncryptedPassword();
            if (pro.isProtected() && !StringUtil.isEmptyString((String)pw)) {
                String attr = " BookProtectionFlag=\"md5\"";
                outter.writeElementWithData("Password", attr, KmlUtil.toXmlString(pw), out);
            }
        }
        outter.writeEnd("ExcelWorkbook", out);
    }

    private void buildSheet(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        Protection pro;
        StringBuilder sb = new StringBuilder(30);
        sb.append(' ').append(this.getAttributeString("Name", KmlUtil.toXmlString(sheet.getSheetName())));
        if (this.touchControllerFlag(FLAG_SHEET_PROTECTION) && (pro = sheet.getSheetOption().getProtection(false)) != null && pro.isProtected()) {
            sb.append(' ').append(this.getAttributeString("Protected", "1"));
        }
        outter.writeStart("Worksheet", sb.toString(), out);
        this.buildSheetExtends(sheet, outter, out);
        if (this.touchControllerFlag(FLAG_SHEET_NAMES)) {
            this.buildNames(sheet.getBook(), sheet.getNames(), outter, out);
        }
        this.buildSheetTable(sheet, outter, out);
        this.buildSheetOptionElement(sheet, outter, out);
        if (this.touchControllerFlag(FLAG_SHEET_VALIDATION)) {
            this.buildValidations(sheet, outter, out);
        }
        outter.writeEnd("Worksheet", out);
    }

    private void buildSheetExtends(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        boolean buo = this.touchControllerFlag(FLAG_SHEET_USEROBJECT);
        boolean bcom = this.touchControllerFlag(FLAG_SHEET_COMMENT);
        if (!buo && !bcom) {
            return;
        }
        SortedUserObjectArray uos = sheet.getUserObjects();
        Comment comment = sheet.getComment();
        String id = sheet.getID();
        if ((uos == null || uos.isEmpty()) && comment == null && StringUtil.isEmptyString((String)id)) {
            return;
        }
        outter.writeStart("KingdeeDefined", out);
        if (!StringUtil.isEmptyString((String)id)) {
            outter.writeElementWithData("ID", KmlUtil.toXmlString(id), out);
        }
        if (buo) {
            this.buildUserObjects(uos, outter, out);
        }
        if (bcom) {
            this.buildComment(comment, outter, out);
        }
        outter.writeEnd("KingdeeDefined", out);
    }

    private void buildSheetTable(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        int rindex;
        int cindex;
        ShareStyleAttributes ssa;
        StringBuilder sb = new StringBuilder(100);
        sb.append(' ');
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = sheet.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa)));
        }
        if (this.isToClipboard()) {
            CellBlock cb = sheet.getSheetOption().getSelection().toSortedBlocks().getBounds();
            cindex = cb.getCol2() + 1;
            rindex = cb.getRow2() + 1;
        } else {
            cindex = Math.max(0, sheet.getMaxColIndex(true) + 1);
            rindex = Math.max(0, sheet.getMaxRowIndex(true) + 1);
        }
        sb.append(' ').append(this.getAttributeString("ExpandedColumnCount", String.valueOf(cindex))).append(' ').append(this.getAttributeString("ExpandedRowCount", String.valueOf(rindex))).append(' ').append(this.getAttributeString("DefaultRowHeight", String.valueOf(KmlUtil.toStoreValue(sheet.getOriginalDefRowHeight())))).append(' ').append(this.getAttributeString("DefaultColumnWidth", String.valueOf(KmlUtil.toStoreValue(sheet.getOriginalDefColWidth()))));
        if (cindex > 0 || rindex > 0) {
            outter.writeStart("Table", sb.toString(), out);
            this.buildAllColumns(sheet, outter, out);
            this.buildAllRows(sheet, outter, out);
            outter.writeEnd("Table", out);
        } else {
            outter.writeSingleElement("Table", sb.toString(), out);
        }
    }

    private void buildSheetOptionElement(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        Color tc;
        IXmlElement soe = XmlUtil.createNode((String)"WorksheetOptions");
        int scale = sheet.getSheetOption().getScale();
        if (scale != 100) {
            IXmlElement e = XmlUtil.createNode((String)"Zoom");
            e.addCData(String.valueOf(scale));
            soe.addChild(e);
        }
        if ((tc = sheet.getSheetOption().getTabColor()) != null && !tc.equals(Color.white)) {
            IXmlElement e = XmlUtil.createNode((String)"TabColor");
            e.addCData(StyleParser.colorToHex((Color)tc));
            soe.addChild(e);
        }
        if (this.touchControllerFlag(FLAG_SHEET_PRINTSETUP)) {
            this.buildPrintSetupElement(sheet, soe);
            this.buildPrintElement(sheet, soe);
            this.buildPageViewElement(sheet, soe);
        }
        if (this.touchControllerFlag(FLAG_SHEET_SPLITINFO)) {
            this.buildSplitElement(sheet, soe);
        }
        if (this.touchControllerFlag(FLAG_SHEET_SELECTION)) {
            this.buildSelectionElement(sheet, soe);
        }
        if (this.touchControllerFlag(FLAG_SHEET_PROTECTION)) {
            this.buildSheetProtectionElement(sheet, soe);
        }
        outter.output(soe, out);
        outter.writeString(NewLine, out);
    }

    private void buildValidations(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        ValidationList validations = sheet.getValidations();
        int size = validations.size();
        for (int i = 0; i < size; ++i) {
            String em;
            String et;
            String es;
            String im;
            String it;
            outter.writeStart("DataValidation", " ", out);
            Validation va = validations.getValidation(i);
            MessagedValidate validate = va.getMessagedValidate();
            String range = SheetBaseMath.getBlocksA1Name(va.getBlocks(), true);
            outter.writeElementWithData("Range", range, out);
            outter.writeElementWithData("Type", validate.getType(), out);
            String qua = validate.getQualifier();
            if (!StringUtil.equals((String)qua, (String)Validate.Between)) {
                outter.writeElementWithData("Qualifier", qua, out);
            }
            if (validate.getImeMode() > 0) {
                outter.writeElementWithData("IMEMode", String.valueOf(validate.getImeMode()), out);
            }
            if (validate.hasCellRangeList()) {
                outter.writeSingleElement("CellRangeList", out);
            }
            if (validate.isUseBlank()) {
                outter.writeSingleElement("UseBlank", out);
            }
            if (Validate.Between.equals(validate.getQualifier()) || Validate.NotBetween.equals(validate.getQualifier())) {
                outter.writeElementWithData("Min", KmlUtil.toXmlString(validate.getMin()), out);
                outter.writeElementWithData("Max", KmlUtil.toXmlString(validate.getMax()), out);
            } else {
                outter.writeElementWithData("Value", KmlUtil.toXmlString(validate.getMin()), out);
            }
            if (validate.isInputHide()) {
                outter.writeSingleElement("InputHide", out);
            }
            if (!StringUtil.isEmptyString((String)(it = validate.getInputTitle()))) {
                outter.writeElementWithData("InputTitle", it, out);
            }
            if (!StringUtil.isEmptyString((String)(im = validate.getInputMessage()))) {
                outter.writeElementWithData("InputMessage", im, out);
            }
            if (validate.isErrorHide()) {
                outter.writeSingleElement("ErrorHide", out);
            }
            if (!StringUtil.isEmptyString((String)(es = validate.getErrorStyle()))) {
                outter.writeElementWithData("ErrorStyle", es, out);
            }
            if (!StringUtil.isEmptyString((String)(et = validate.getErrorTitle()))) {
                outter.writeElementWithData("ErrorTitle", et, out);
            }
            if (!StringUtil.isEmptyString((String)(em = validate.getErrorMessage()))) {
                outter.writeElementWithData("ErrorMessage", em, out);
            }
            outter.writeEnd("DataValidation", out);
        }
    }

    private void buildAllColumns(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        Sheet.ColsIterator ci = sheet.getColsIterator(0, 65535, false);
        while (ci.hasNext()) {
            Column col = ci.next();
            this.buildColumn2(col, outter, out);
        }
        int defaultColSpanIndex = 0;
        SortedAttributeSpanArray colSpans = sheet.getColSpans();
        int colspanN = colSpans.size();
        for (int i = 0; i < colspanN; ++i) {
            this.buildColSpanElement(colSpans.getAttributeSpan(i), defaultColSpanIndex, outter, out);
            defaultColSpanIndex = colSpans.getSpan(i).getEnd() + 1;
        }
    }

    private void buildColSpanElement(SortedAttributeSpanArray.AttributeSpan colSpan, int defaultColSpanIndex, KmlOutputter outter, Writer out) throws IOException {
        double length;
        ShareStyleAttributes ssa;
        StringBuilder sb = new StringBuilder();
        int index = colSpan.getStart();
        if (index != defaultColSpanIndex) {
            sb.append(' ').append(this.getAttributeString("Index", String.valueOf(index + 1)));
        }
        if (colSpan.getExtent() > 1) {
            sb.append(' ').append(this.getAttributeString("Span", String.valueOf(colSpan.getExtent() - 1)));
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = colSpan.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(' ').append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa)));
        }
        if ((length = (double)colSpan.getOriginalLength()) > 0.0) {
            length = KmlUtil.toStoreValue(length);
            sb.append(' ').append(this.getAttributeString("Width", String.valueOf(length)));
        }
        if (!colSpan.isVisible()) {
            sb.append(' ').append(this.getAttributeString("Hidden", "1"));
        }
        outter.writeSingleElement("Column", sb.toString(), out);
    }

    private void buildAllRows(Sheet sheet, KmlOutputter outter, Writer out) throws IOException {
        int defaultRowIndex = 0;
        SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
        int numOfRowSpans = rowSpans.size();
        for (int i = 0; i < numOfRowSpans; ++i) {
            SortedAttributeSpanArray.AttributeSpan rowSpan = rowSpans.getAttributeSpan(i);
            if (rowSpan.getStart() - 1 >= defaultRowIndex) {
                Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, rowSpan.getStart() - 1, false);
                while (iter.hasNext()) {
                    Row row = iter.next();
                    this.buildRow(row, defaultRowIndex, outter, out);
                    defaultRowIndex = row.getRow() + 1;
                }
            }
            int start = rowSpan.getStart();
            Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, rowSpan.getEnd(), false);
            while (iter.hasNext()) {
                Row row = iter.next();
                int end = row.getRow() - 1;
                if (start <= end) {
                    this.buildRowSpan(rowSpan, null, start, end, defaultRowIndex, outter, out);
                    defaultRowIndex = end + 1;
                }
                this.buildRowSpan(rowSpan, row, row.getRow(), row.getRow(), defaultRowIndex, outter, out);
                start = defaultRowIndex = row.getRow() + 1;
            }
            if (start <= rowSpan.getEnd()) {
                this.buildRowSpan(rowSpan, null, start, rowSpan.getEnd(), defaultRowIndex, outter, out);
            }
            defaultRowIndex = rowSpan.getEnd() + 1;
        }
        if (defaultRowIndex <= sheet.getMaxRowIndex()) {
            Sheet.RowsIterator iter = sheet.getRowsIterator(defaultRowIndex, sheet.getMaxRowIndex(), false);
            while (iter.hasNext()) {
                Row row = iter.next();
                this.buildRow(row, defaultRowIndex, outter, out);
                defaultRowIndex = row.getRow() + 1;
            }
        }
    }

    private void buildRowSpan(SortedAttributeSpanArray.AttributeSpan rowSpan, Row row, int start, int end, int defaultRowIndex, KmlOutputter outter, Writer out) throws IOException {
        double length;
        ShareStyleAttributes ssa;
        StringBuilder sb = new StringBuilder(100);
        if (start > defaultRowIndex) {
            sb.append(' ').append(this.getAttributeString("Index", String.valueOf(start + 1)));
        }
        if (end > start) {
            sb.append(' ').append(this.getAttributeString("Span", String.valueOf(end - start)));
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = rowSpan.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(' ').append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa)));
        }
        if ((length = (double)rowSpan.getOriginalLength()) > 0.0) {
            sb.append(' ');
            length = KmlUtil.toStoreValue(length);
            sb.append(this.getAttributeString("Height", String.valueOf(length)));
        }
        if (!rowSpan.isVisible()) {
            sb.append(' ').append(this.getAttributeString("Hidden", "1"));
        }
        if (row != null) {
            outter.writeStart("Row", sb.toString(), out);
            this.buildRowExtends(row, outter, out);
            this.buildCells(row, outter, out);
            outter.writeEnd("Row", out);
        } else {
            outter.writeSingleElement("Row", sb.toString(), out);
        }
    }

    private void buildColumn2(Column col, KmlOutputter outter, Writer out) throws IOException {
        SortedUserObjectArray uos = col.getUserObjects();
        if (uos == null || uos.isEmpty()) {
            return;
        }
        String str = ' ' + this.getAttributeString("Index", String.valueOf(col.getCol() + 1));
        outter.writeStart("Column2", str, out);
        outter.writeStart("KingdeeDefined", out);
        if (this.touchControllerFlag(FLAG_COL_USEROBJECT)) {
            this.buildUserObjects(uos, outter, out);
        }
        outter.writeEnd("KingdeeDefined", out);
        outter.writeEnd("Column2", out);
    }

    private void buildRow(Row row, int defaultRowIndex, KmlOutputter outter, Writer out) throws IOException {
        String str = "";
        if (row.getRow() > defaultRowIndex) {
            str = ' ' + this.getAttributeString("Index", String.valueOf(row.getRow() + 1));
        }
        outter.writeStart("Row", str, out);
        this.buildRowExtends(row, outter, out);
        this.buildCells(row, outter, out);
        outter.writeEnd("Row", out);
    }

    private void buildRowExtends(Row row, KmlOutputter outter, Writer out) throws IOException {
        SortedUserObjectArray uos = row.getUserObjects();
        if (uos == null || uos.isEmpty()) {
            return;
        }
        outter.writeStart("KingdeeDefined", out);
        if (this.touchControllerFlag(FLAG_ROW_USEROBJECT)) {
            this.buildUserObjects(uos, outter, out);
        }
        outter.writeEnd("KingdeeDefined", out);
    }

    private void buildCells(Row row, KmlOutputter outter, Writer out) throws IOException {
        if (!row.isEmptyContent()) {
            int defaultCellIndex = 0;
            Sheet.ICellsIterator iter = row.getCellsIterator(0, row.getMaxIntMark(), false, false);
            while (iter.hasNext()) {
                Cell cell = iter.next();
                if (!this.buildCell(cell, defaultCellIndex, outter, out)) continue;
                defaultCellIndex = cell.getCol() + 1;
            }
        }
    }

    private boolean isOutputFomula(Cell cell, String formula) {
        return this._ctrl == null || this._ctrl.isToClipboard() || !this._ctrl.isForExcel() || BookFormulaHelper.isExcelFunction(cell.getSheet().getBook(), cell.getSheet(), formula);
    }

    private boolean buildCell(Cell cell, int defaultCellIndex, KmlOutputter outter, Writer out) throws IOException {
        HyperLink link;
        ShareStyleAttributes ssa;
        boolean bInnerMerger;
        int r = cell.getRow();
        int c2 = cell.getCol();
        CellBlock mb = cell.getSheet().getMergeBlock(cell);
        StringBuilder sb = new StringBuilder(100);
        boolean bl = bInnerMerger = mb != null && (mb.getRow() != r || mb.getCol() != c2);
        if (bInnerMerger && this.isForExcel()) {
            return false;
        }
        if (c2 > defaultCellIndex || bInnerMerger) {
            sb.append(' ').append(this.getAttributeString("Index", String.valueOf(c2 + 1)));
        }
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = cell.getSSA()) != null && !ssa.isEmpty()) {
            sb.append(' ').append(this.getAttributeString("StyleID", KmlStyleParser.buildStyleID(ssa)));
        }
        if (this.touchControllerFlag(FLAG_FORMULA)) {
            String formula = cell.getFormula();
            if (cell.hasFormula() && this.isOutputFomula(cell, formula)) {
                sb.append(' ').append(this.getAttributeString("Formula", KmlUtil.toXmlString(formula)));
            }
        }
        if ((link = cell.getHyperLink()) != null) {
            sb.append(' ').append(this.getAttributeString("HRef", KmlUtil.toXmlString(link.getLinkTo())));
        }
        if (mb != null && mb.getRow() == r && mb.getCol() == c2) {
            if (mb.getWidth() - 1 > 0) {
                sb.append(' ').append(this.getAttributeString("MergeAcross", String.valueOf(mb.getWidth() - 1)));
            }
            if (mb.getHeight() - 1 > 0) {
                sb.append(' ').append(this.getAttributeString("MergeDown", String.valueOf(mb.getHeight() - 1)));
            }
        }
        outter.writeStart("Cell", sb.toString(), out);
        this.buildCellExtends(cell, outter, out);
        if (this.touchControllerFlag(FLAG_CELL_COMMENT)) {
            this.buildComment(cell.getComment(), outter, out);
        }
        if (this.touchControllerFlag(FLAG_DATA)) {
            this.buildCellData(cell, cell.isTickFormula(), outter, out);
        }
        outter.writeEnd("Cell", out);
        return true;
    }

    private void buildCellData(Cell cell, boolean ticked, KmlOutputter outter, Writer out) throws IOException {
        String data;
        if (cell.isEmptyContent()) {
            return;
        }
        String dataType = "String";
        Variant var = cell.getValue();
        int vt = var.getVt();
        switch (vt) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: {
                dataType = "Number";
                break;
            }
            case 8: {
                dataType = "Boolean";
                break;
            }
            case 12: 
            case 13: {
                dataType = "DateTime";
                break;
            }
            case 0: 
            case 16: 
            case 8192: 
            case 16384: {
                return;
            }
        }
        if ("Boolean".equals(dataType)) {
            data = (Boolean)var.getValue() != false ? "1" : "0";
        } else if ("DateTime".equals(dataType)) {
            try {
                Date date = var.toDate();
                data = sdf.get().format(date);
            }
            catch (SyntaxErrorException e) {
                data = KmlUtil.toXmlString(var.toString());
            }
        } else {
            data = KmlUtil.toXmlString(var.toString());
        }
        if (ticked || !StringUtil.isEmptyString((String)data)) {
            String attr = ' ' + this.getAttributeString("Type", dataType);
            if (ticked) {
                attr = attr + ' ' + this.getAttributeString("Ticked", "1");
            }
            outter.writeElementWithData("Data", attr, data, out);
        }
    }

    private void buildCellExtends(Cell cell, KmlOutputter outter, Writer out) throws IOException {
        SortedUserObjectArray uos = cell.getUserObjects(false);
        DiagonalHeader d2 = cell.getDiagonalHeader();
        if ((uos == null || uos.isEmpty()) && d2 == null) {
            return;
        }
        outter.writeStart("KingdeeDefined", out);
        if (this.touchControllerFlag(FLAG_CELL_USEROBJECT)) {
            this.buildUserObjects(uos, outter, out);
        }
        this.buildDiagonalHeaderElement(d2, outter, out);
        outter.writeEnd("KingdeeDefined", out);
    }

    private void buildPrintSetupElement(Sheet sheet, IXmlElement pe) {
        int cv;
        int ch;
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps == null) {
            return;
        }
        IXmlElement setupE = XmlUtil.createNode((String)"PageSetup");
        IXmlElement layoutE = null;
        String ori = "";
        if (ps.isLandScape()) {
            String str = OrientationRequested.LANDSCAPE.toString();
            StringBuilder sb = new StringBuilder(str);
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
            ori = sb.toString();
        }
        if (!StringUtil.isEmptyString((String)ori)) {
            if (layoutE == null) {
                layoutE = XmlUtil.createNode((String)"Layout");
            }
            layoutE.setAttribute("Orientation", ori);
        }
        if ((ch = ps.getCenterHorizontal()) == 1) {
            if (layoutE == null) {
                layoutE = XmlUtil.createNode((String)"Layout");
            }
            layoutE.setAttribute("CenterHorizontal", "" + ch);
        }
        if ((cv = ps.getCenterVertical()) == 1) {
            if (layoutE == null) {
                layoutE = XmlUtil.createNode((String)"Layout");
            }
            layoutE.setAttribute("CenterVertical", "" + cv);
        }
        if (layoutE != null) {
            setupE.addChild(layoutE);
        }
        IXmlElement he = XmlUtil.createNode((String)"Header");
        he.setAttribute("Margin", String.valueOf(ps.getHeadMargin()));
        String str = PrintHelper.getHeadFootString(sheet.getBook(), ps.getHeadData(), false);
        if (!StringUtil.isEmptyString((String)str)) {
            he.setAttribute("Data", KmlUtil.toXmlString(str));
        }
        setupE.addChild(he);
        IXmlElement footE = XmlUtil.createNode((String)"Footer");
        footE.setAttribute("Align", String.valueOf(ps.getFootAlign()));
        footE.setAttribute("Align2", String.valueOf(ps.getHeadAlign()));
        footE.setAttribute("Margin", String.valueOf(ps.getFootMargin()));
        str = PrintHelper.getHeadFootString(sheet.getBook(), ps.getFootData(), false);
        if (!StringUtil.isEmptyString((String)str)) {
            footE.setAttribute("Data", KmlUtil.toXmlString(str));
        }
        setupE.addChild(footE);
        IXmlElement pageE = XmlUtil.createNode((String)"PageMargins");
        pageE.setAttribute("Bottom", String.valueOf(ps.getBottomMargin()));
        pageE.setAttribute("Left", String.valueOf(ps.getLeftMargin()));
        pageE.setAttribute("Right", String.valueOf(ps.getRightMargin()));
        pageE.setAttribute("Top", String.valueOf(ps.getTopMargin()));
        setupE.addChild(pageE);
        pe.addChild(setupE);
    }

    private void buildPrintElement(Sheet sheet, IXmlElement pe) {
        int scale;
        int index;
        PrintSetup ps = sheet.getSheetOption().getPrintSetup(false);
        if (ps == null) {
            return;
        }
        IXmlElement printE = XmlUtil.createNode((String)"Print");
        if (ps.isRowFirst()) {
            printE.addChild(XmlUtil.createNode((String)"LeftToRight"));
        }
        if (ps.isBlackWhite()) {
            printE.addChild(XmlUtil.createNode((String)"BlackAndWhite"));
        }
        if ((index = ps.getPagesizeIndex()) >= 0) {
            IXmlElement e = XmlUtil.createNode((String)"PaperSizeIndex");
            e.addCData(String.valueOf(index));
            float x = ps.getPagesizeX();
            float y = ps.getPagesizeY();
            if (x > 0.0f) {
                e.setAttribute("x", "" + x);
                e.setAttribute("y", "" + y);
            }
            printE.addChild(e);
        }
        if ((scale = ps.getScale()) >= 0) {
            IXmlElement e = XmlUtil.createNode((String)"Scale");
            e.addCData(String.valueOf(scale));
            if (ps.isAutoFit()) {
                e.setAttribute("AutoFit", "true");
                e.setAttribute("Height", String.valueOf(ps.getAutoFitHeight()));
                e.setAttribute("Width", String.valueOf(ps.getAutoFitWidth()));
            }
            printE.addChild(e);
        }
        if (ps.hasGrid()) {
            printE.addChild(XmlUtil.createNode((String)"Gridlines"));
        }
        if (ps.hasRowHead() || ps.hasColHead()) {
            IXmlElement e = XmlUtil.createNode((String)"RowColHeadings");
            if (!ps.hasRowHead()) {
                e.setAttribute("RowHead", "False");
            }
            if (!ps.hasColHead()) {
                e.setAttribute("ColHead", "False");
            }
            printE.addChild(e);
        }
        pe.addChild(printE);
    }

    private void buildPageViewElement(Sheet sheet, IXmlElement pe) {
        PlugablePaginationAdvice advice = sheet.getPlugablePaginationAdvice(false);
        if (advice != null) {
            IXmlElement e = XmlUtil.createNode((String)"PageView");
            String sTemp = KmlUtil.intArrayToString(advice.getColExtendedBreaks());
            if (sTemp != null) {
                e.setAttribute("ColExtended", sTemp);
            }
            if ((sTemp = KmlUtil.intArrayToString(advice.getRowExtendedBreaks())) != null) {
                e.setAttribute("RowExtended", sTemp);
            }
            if ((sTemp = KmlUtil.intArrayToString(advice.getColShrinkedBreaks())) != null) {
                e.setAttribute("ColShrinked", sTemp);
            }
            if ((sTemp = KmlUtil.intArrayToString(advice.getRowShrinkedBreaks())) != null) {
                e.setAttribute("RowShrinked", sTemp);
            }
            pe.addChild(e);
        }
    }

    private void buildSplitElement(Sheet sheet, IXmlElement pe) {
        int ap;
        int cs;
        int rs;
        int fc2;
        int fr2;
        int fc;
        int fr;
        boolean b2;
        IXmlElement e;
        SheetOption so = sheet.getSheetOption();
        ViewSplitInfo vs = sheet.getSheetOption().getViewSplitInfo();
        boolean bHide = so.isHide();
        if (bHide) {
            e = XmlUtil.createNode((String)"Visible");
            e.addCData("SheetHidden");
            pe.addChild(e);
        }
        if (b2 = so.isSelected()) {
            pe.addChild(XmlUtil.createNode((String)"Selected"));
        }
        if (b2 = vs.isFreezed()) {
            pe.addChild(XmlUtil.createNode((String)"FreezePanes"));
        }
        if ((fr = vs.getFirstRow()) != 0) {
            e = XmlUtil.createNode((String)"TopRowVisible");
            e.addCData(String.valueOf(fr));
            pe.addChild(e);
        }
        if ((fc = vs.getFirstCol()) != 0) {
            e = XmlUtil.createNode((String)"LeftColumnVisible");
            e.addCData(String.valueOf(fc));
            pe.addChild(e);
        }
        if ((fr2 = vs.getFirstRow2()) != 0) {
            e = XmlUtil.createNode((String)"TopRowBottomPane");
            e.addCData(String.valueOf(fr2));
            pe.addChild(e);
        }
        if ((fc2 = vs.getFirstCol2()) != 0) {
            e = XmlUtil.createNode((String)"LeftColumnRightPane");
            e.addCData(String.valueOf(fc2));
            pe.addChild(e);
        }
        if ((rs = vs.getRowSplit()) != 0) {
            e = XmlUtil.createNode((String)"SplitHorizontal");
            if (b2) {
                e.addCData(String.valueOf(rs));
            } else {
                e.addCData(String.valueOf(KmlUtil.toStoreHoriSplit(rs)));
            }
            pe.addChild(e);
        }
        if ((cs = vs.getColSplit()) != 0) {
            e = XmlUtil.createNode((String)"SplitVertical");
            if (b2) {
                e.addCData(String.valueOf(cs));
            } else {
                e.addCData(String.valueOf(KmlUtil.toStoreVertSplit(cs)));
            }
            pe.addChild(e);
        }
        if ((ap = vs.getActivePane()) != 3) {
            e = XmlUtil.createNode((String)"ActivePane");
            e.addCData(String.valueOf(ap));
            pe.addChild(e);
        }
    }

    private void buildSheetProtectionElement(Sheet sheet, IXmlElement pe) {
        Protection.SortedEditalbeAreaArray blocks;
        Protection pro = sheet.getSheetOption().getProtection(false);
        IXmlElement e = XmlUtil.createNode((String)"ProtectObjects");
        if (pro == null || pro.allowEditObjects()) {
            e.addCData("False");
        } else {
            e.addCData("True");
        }
        pe.addChild(e);
        e = XmlUtil.createNode((String)"ProtectScenarios");
        if (pro == null || pro.allowEditScenarios()) {
            e.addCData("False");
        } else {
            e.addCData("True");
        }
        pe.addChild(e);
        if (pro == null) {
            return;
        }
        if (!pro.hasOperation(1)) {
            e = XmlUtil.createNode((String)"EnableSelection");
            if (!pro.hasOperation(2)) {
                e.addCData("NoSelection");
            } else {
                e.addCData("UnlockedCells");
            }
            pe.addChild(e);
        }
        if (pro.hasOperation(4)) {
            pe.addChild(XmlUtil.createNode((String)"AllowFormatCells"));
        }
        if (pro.hasOperation(8)) {
            pe.addChild(XmlUtil.createNode((String)"AllowSizeCols"));
        }
        if (pro.hasOperation(16)) {
            pe.addChild(XmlUtil.createNode((String)"AllowSizeRows"));
        }
        if (pro.hasOperation(32)) {
            pe.addChild(XmlUtil.createNode((String)"AllowInsertCols"));
        }
        if (pro.hasOperation(64)) {
            pe.addChild(XmlUtil.createNode((String)"AllowInsertRows"));
        }
        if (pro.hasOperation(128)) {
            pe.addChild(XmlUtil.createNode((String)"AllowInsertHyperlinks"));
        }
        if (pro.hasOperation(256)) {
            pe.addChild(XmlUtil.createNode((String)"AllowDeleteCols"));
        }
        if (pro.hasOperation(512)) {
            pe.addChild(XmlUtil.createNode((String)"AllowDeleteRows"));
        }
        if (pro.hasOperation(1024)) {
            pe.addChild(XmlUtil.createNode((String)"AllowSort"));
        }
        if (pro.hasOperation(2048)) {
            pe.addChild(XmlUtil.createNode((String)"AllowFilter"));
        }
        if (pro.hasOperation(4096)) {
            pe.addChild(XmlUtil.createNode((String)"AllowUsePivotTables"));
        }
        if (pro.hasOperation(32768)) {
            pe.addChild(XmlUtil.createNode((String)"AllowCommont"));
        }
        String pw = pro.getEncryptedPassword();
        if (pro.isProtected() && !StringUtil.isEmptyString((String)pw)) {
            e = XmlUtil.createNode((String)"Protection");
            e.setAttribute("BookProtectionFlag", "md5");
            e.setAttribute("Password", KmlUtil.toXmlString(pw));
            pe.addChild(e);
        }
        if ((blocks = pro.getEditableBlocks()) != null) {
            int size = blocks.size();
            for (int i = 0; i < size; ++i) {
                Protection.EditableArea ea = (Protection.EditableArea)blocks.get(i);
                e = XmlUtil.createNode((String)"EditBlocks");
                e.setAttribute("Name", KmlUtil.toXmlString(ea.getName()));
                e.setAttribute("BookProtectionFlag", "md5");
                pw = ea.getEncryptedPassword();
                if (!StringUtil.isEmptyString((String)pw)) {
                    e.setAttribute("Password", KmlUtil.toXmlString(pw));
                }
                String range = SheetBaseMath.getBlocksA1Name(ea, true);
                e.setAttribute("RangeSelection", range);
                pe.addChild(e);
            }
        }
    }

    private void buildSelectionElement(Sheet sheet, IXmlElement pe) {
        Selection sel = sheet.getSheetOption().getSelection();
        IXmlElement panesE = XmlUtil.createNode((String)"Panes");
        IXmlElement paneE = XmlUtil.createNode((String)"Pane");
        IXmlElement numberE = XmlUtil.createNode((String)"Number");
        numberE.addCData(String.valueOf(sheet.getSheetOption().getViewSplitInfo().getActivePane()));
        IXmlElement activeRowE = XmlUtil.createNode((String)"ActiveRow");
        activeRowE.addCData(String.valueOf(sel.getActiveRow()));
        IXmlElement activeColE = XmlUtil.createNode((String)"ActiveCol");
        activeColE.addCData(String.valueOf(sel.getActiveCol()));
        IXmlElement rangeSelE = XmlUtil.createNode((String)"RangeSelection");
        rangeSelE.addCData(SheetBaseMath.getBlocksName(sel.toSortedBlocks(), false, true));
        paneE.addChild(numberE);
        paneE.addChild(activeRowE);
        paneE.addChild(activeColE);
        paneE.addChild(rangeSelE);
        panesE.addChild(paneE);
        pe.addChild(panesE);
    }

    private void buildDiagonalHeaderElement(AbstractTableSplitRectInfo dh, KmlOutputter outter, Writer out) throws IOException {
        int[] colOffs;
        int i;
        int size;
        if (dh == null) {
            return;
        }
        IXmlElement dhe = XmlUtil.createNode((String)"DiagonalHeader");
        dhe.setAttribute("Position", dh.getPosition().toString());
        dhe.setAttribute("Row", String.valueOf(dh.getRow()));
        dhe.setAttribute("Col", String.valueOf(dh.getCol()));
        dhe.setAttribute("Row2", String.valueOf(dh.getRow2()));
        dhe.setAttribute("Col2", String.valueOf(dh.getCol2()));
        int[] rowOffs = dh.getRowOffs();
        if (rowOffs != null && rowOffs.length > 0) {
            StringBuilder sb = new StringBuilder();
            size = rowOffs.length;
            for (i = 0; i < size - 1; ++i) {
                sb.append(String.valueOf(rowOffs[i])).append(',');
            }
            sb.append(String.valueOf(rowOffs[size - 1]));
            dhe.setAttribute("RowOffers", sb.toString());
        }
        if ((colOffs = dh.getColOffs()) != null && colOffs.length > 0) {
            StringBuilder sb = new StringBuilder();
            int size2 = colOffs.length;
            for (int i2 = 0; i2 < size2 - 1; ++i2) {
                sb.append(String.valueOf(colOffs[i2])).append(',');
            }
            sb.append(String.valueOf(colOffs[size2 - 1]));
            dhe.setAttribute("ColOffers", sb.toString());
        }
        size = dh.size();
        for (i = 0; i < size; ++i) {
            this.buildTraingleInfoElement(dh, i, dhe);
        }
        outter.output(dhe, out);
    }

    private void buildTraingleInfoElement(AbstractTableSplitRectInfo dh, int index, IXmlElement pElement) {
        Style ssa;
        IXmlElement te = XmlUtil.createNode((String)"Triangle");
        TriangleInfo ti = dh.getTriangleInfo(index);
        if (this.touchControllerFlag(FLAG_STYLE) && (ssa = ti.getStyle()) != null && !ssa.isEmpty()) {
            te.setAttribute("StyleID", KmlStyleParser.buildStyleID((ShareStyleAttributes)ssa));
        }
        te.setAttribute("Index", String.valueOf(index));
        if (!StringUtil.isEmptyString((String)ti.getText())) {
            te.setAttribute("String", KmlUtil.toXmlString(ti.getText()));
        }
        te.setAttribute("Lean", ti.isLean() ? "True" : "False");
        te.setAttribute("Zoom", ti.isAutoZoom() ? "True" : "False");
        te.setAttribute("DrawBack", ti.isDrawBackground() ? "True" : "False");
        pElement.addChild(te);
    }

    private void buildComment(Comment comment, KmlOutputter outter, Writer out) throws IOException {
        if (comment != null) {
            String author = "";
            if (comment.getAuthor() != null) {
                author = comment.getAuthor();
            }
            author = KmlUtil.toXmlString(author);
            outter.writeStart("Comment", ' ' + this.getAttributeString("Author", author), false, out);
            String text = "";
            if (comment.getAuthor() != null) {
                text = comment.getText();
            }
            text = KmlUtil.toXmlString(text);
            outter.writeElementWithData("", text, out);
            outter.writeEnd("Comment", out);
        }
    }

    private void buildNames(Book book, SortedNamedObjectNodeArray names, KmlOutputter outter, Writer out) throws IOException {
        if (names != null && !names.isEmpty()) {
            outter.writeStart("Names", out);
            int size = names.size();
            for (int i = 0; i < size; ++i) {
                NamedObjectNode node = names.getObjectNode(i);
                if (!node.isVisible() || node.isUndefined()) continue;
                StringBuilder sb = new StringBuilder(50);
                sb.append(' ');
                sb.append(this.getAttributeString("Name", KmlUtil.toXmlString(node.getName())));
                sb.append(' ');
                sb.append(this.getAttributeString("RefersTo", KmlUtil.toXmlString(node.getRefersTo())));
                outter.writeSingleElement("NamedRange", sb.toString(), out);
            }
            outter.writeEnd("Names", out);
        }
    }

    private void buildUserObjects(SortedUserObjectArray uos, KmlOutputter outter, Writer out) throws IOException {
        if (uos != null && !uos.isEmpty()) {
            int size = uos.size();
            for (int i = 0; i < size; ++i) {
                String outStr;
                UserObject uo = uos.getUserObject(i);
                String key = uo.getKey();
                Object value = uo.getValue();
                if (value == null) continue;
                Book.IUserObjectProvider trans = this.getKmlUOTrans();
                if (trans != null) {
                    outStr = trans.getString(key, value);
                    if (outStr == null) {
                        continue;
                    }
                } else {
                    outStr = value.toString();
                }
                if (outStr == null) continue;
                outStr = KmlUtil.toXmlString(outStr);
                outter.writeElementWithData("UserObject", ' ' + this.getAttributeString("Key", KmlUtil.toXmlString(key)), outStr, out);
            }
        }
    }

    private static class KmlOutputter
    extends XmlDomWriter {
        public KmlOutputter(String indent, boolean newlines, String encoding) {
            this.setIndent(indent);
            this.setNewline(newlines);
        }

        public void output(IXmlElement element, Writer writer) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            outputStream.write(writer.toString().getBytes("UTF-8"));
            XmlUtil.save((IXmlElement)element, (OutputStream)outputStream);
        }

        public Writer makeWriter(OutputStream out) {
            try {
                return new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)"err", (Throwable)e);
                return null;
            }
        }

        private void writeString(String str, Writer out) throws IOException {
            out.write(str);
        }

        private void writeString(char c2, Writer out) throws IOException {
            out.write(c2);
        }

        public void writeElementWithData(String name, String data, Writer out) throws IOException {
            this.writeElementWithData(name, "", data, out);
        }

        public void writeElementWithData(String name, String userStr, String data, Writer out) throws IOException {
            this.writeStart(name, userStr, false, out);
            this.writeString(data, out);
            this.writeEnd(name, out);
        }

        public void writeSingleElement(String name, String userStr, Writer out) throws IOException {
            this.writeSingleElement(name, userStr, true, out);
        }

        public void writeSingleElement(String name, Writer out) throws IOException {
            this.writeSingleElement(name, "", true, out);
        }

        public void writeSingleElement(String name, boolean bnewline, Writer out) throws IOException {
            this.writeSingleElement(name, "", bnewline, out);
        }

        public void writeSingleElement(String name, String userStr, boolean bnewline, Writer out) throws IOException {
            this.writeString('<', out);
            this.writeString(name, out);
            this.writeString(userStr, out);
            this.writeString('/', out);
            this.writeString('>', out);
            if (bnewline) {
                this.writeString(BookToKml.NewLine, out);
            }
        }

        public void writeStart(String name, String userStr, Writer out) throws IOException {
            this.writeStart(name, userStr, true, out);
        }

        public void writeStart(String name, boolean bnewline, Writer out) throws IOException {
            this.writeStart(name, "", bnewline, out);
        }

        public void writeStart(String name, Writer out) throws IOException {
            this.writeStart(name, "", true, out);
        }

        public void writeStart(String name, String userStr, boolean bnewline, Writer out) throws IOException {
            this.writeString('<', out);
            this.writeString(name, out);
            this.writeString(userStr, out);
            this.writeString('>', out);
            if (bnewline) {
                this.writeString(BookToKml.NewLine, out);
            }
        }

        public void writeEnd(String name, boolean bnewline, Writer out) throws IOException {
            this.writeString('<', out);
            this.writeString('/', out);
            this.writeString(name, out);
            this.writeString('>', out);
            if (bnewline) {
                this.writeString(BookToKml.NewLine, out);
            }
        }

        public void writeEnd(String name, Writer out) throws IOException {
            this.writeEnd(name, true, out);
        }
    }
}

