/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.io.kml;

import com.kingdee.cosmic.ctrl.kds.io.kml.AbsElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.BasicElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.DefaultElement;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlToBook;
import com.kingdee.cosmic.ctrl.kds.io.kml.KmlUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Comment;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class CommentElement
extends BasicElement {
    private AbsElement _de;

    CommentElement() {
    }

    private AbsElement getFitParser(String uri, String localName, String qName) {
        if ("Data".equals(KmlUtil.getLocalName(qName)) || "Font".equals(KmlUtil.getLocalName(qName))) {
            if (this._de == null) {
                this._de = new DataElement();
            }
            return this._de;
        }
        return null;
    }

    @Override
    boolean isCurrentElement(String uri, String localName, String qName) {
        return "Comment".equals(KmlUtil.getLocalName(qName));
    }

    @Override
    void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
        if (this.isCurrentElement(uri, localName, qName)) {
            if (ktb.touchModeFlag(FLAG_CELL_COMMENT)) {
                String author = attributes.getValue(KmlUtil.getNSName("Author", "ss"));
                if (author != null) {
                    author = KmlUtil.toBookString(author);
                }
                Object parent = dataCache.getCurUOParent();
                Comment comment = new Comment();
                comment.setAuthor(author);
                if (parent instanceof Cell) {
                    ((Cell)parent).setComment(comment);
                } else if (parent instanceof Sheet) {
                    ((Sheet)parent).setComment(comment);
                } else if (parent instanceof Book) {
                    ((Book)parent).setComment(comment);
                }
            }
        } else {
            AbsElement parser = this.getFitParser(uri, localName, qName);
            if (parser != null) {
                parserCache.push(parser);
                parser.startElement(uri, localName, qName, attributes, parserCache, dataCache, ktb);
            }
        }
    }

    static class DataElement
    extends DefaultElement {
        DataElement() {
        }

        @Override
        void startElement(String uri, String localName, String qName, Attributes attributes, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            this.bufString.delete(0, this.bufString.length());
        }

        @Override
        void characters(char[] ch, int start, int length, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            if (ktb.touchModeFlag(FLAG_CELL_COMMENT)) {
                this.bufString.append(ch, start, length);
            }
        }

        @Override
        void endElement(String uri, String localName, String qName, KmlToBook.ElementStack parserCache, KmlToBook.DataCache dataCache, KmlToBook ktb) throws SAXException {
            super.endElement(uri, localName, qName, parserCache, dataCache, ktb);
            if (this.isCurrentElement(uri, localName, qName)) {
                if (!ktb.touchModeFlag(FLAG_CELL_COMMENT)) {
                    return;
                }
                Object parent = dataCache.getCurUOParent();
                if (parent == null) {
                    return;
                }
                String str = KmlUtil.toBookString(this.bufString.toString());
                if (parent instanceof Cell) {
                    ((Cell)parent).getComment().setText(str);
                } else if (parent instanceof Sheet) {
                    ((Sheet)parent).getComment().setText(str);
                } else if (parent instanceof Book) {
                    ((Book)parent).getComment().setText(str);
                }
            }
        }
    }
}

