/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.expr;

import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.expr.TraceVariant;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;

public class ExprExtPos
implements IExprNode {
    private ExtProps _dst;
    private ExtProps _epOwner;
    private CellBlock _pos;
    private ExtProps[] _yPath;
    private ExtProps[] _xPath;

    public static ExprExtPos getExprExtPos(WeakHashSet buffer, ExtProps src, CellBlock pos) {
        ExprExtPos ep = new ExprExtPos(src, pos);
        if (buffer != null) {
            ep = (ExprExtPos)buffer.add(ep);
        }
        return ep;
    }

    public ExprExtPos(ExtProps src, CellBlock pos) {
        this._dst = src;
        this._pos = pos;
        this._yPath = this.getPath(src, true, pos.getRow2());
        this._xPath = this.getPath(src, false, pos.getCol2());
    }

    private ExtProps[] getPath(ExtProps src, boolean yDir, int level) {
        ExtProps[] path = null;
        if (level != Integer.MIN_VALUE) {
            path = new ExtProps[level];
            ExtProps head = src;
            for (int i = 0; i < level; ++i) {
                path[level - i - 1] = head;
                head = head.getHead(yDir, false);
            }
        }
        return path;
    }

    public int hashCode() {
        int h = this._dst.hashCode();
        if (this._pos != null) {
            h ^= this._pos.hashCode();
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        ExprExtPos cmp = (ExprExtPos)obj;
        if (cmp == null) {
            return false;
        }
        return this._dst == cmp._dst && this._pos.equals(cmp._pos);
    }

    public void setExprOwner(ExtProps epOwner) {
        this._epOwner = epOwner;
    }

    @Override
    public void action(ExprContext ctx, ICalculable exprOwner) throws SyntaxErrorException {
        Variant varDst = this._getDestCellBlockVar(ctx, exprOwner, true);
        CellBlockNode cb = (CellBlockNode)varDst.getValue();
        boolean queueLast = false;
        Sheet sheet = exprOwner.getSheet();
        Dependents deps = sheet.getDeps();
        if (cb.isSingleCell()) {
            Cell referTo = cb.getFirstCell(false);
            if (referTo != null && !(queueLast = referTo.isQueueLast())) {
                deps.calcReferTo(exprOwner, referTo);
                queueLast = referTo.isQueueLast();
            }
        } else {
            Sheet.ICellsIterator ci = sheet.getCellsIterator(cb, false, true);
            while (ci.hasNext()) {
                Cell referTo = ci.next();
                if (!referTo.isQueueLast()) {
                    deps.calcReferTo(exprOwner, referTo);
                }
                queueLast |= referTo.isQueueLast();
            }
        }
        if (queueLast) {
            throw SyntaxErrorException.CALC_LAST;
        }
        ctx.getCurrentExprStack().push(ctx.isTraceMode() ? new TraceVariant(varDst, ctx) : varDst);
    }

    private Variant _getDestCellBlockVar(ExprContext ctx, ICalculable exprOwner, boolean createDep) {
        Sheet sheet = exprOwner.getSheet();
        ExtProps epCurr = ((Cell)exprOwner).getExtProps(false);
        ExtProps epOwner = this._epOwner == null ? epCurr : this._epOwner;
        ExtProps dst = epOwner.getLevelHead(true, this._pos.getRow()).getSub(this._yPath, true);
        int row = dst.getRow();
        dst = epOwner.getLevelHead(false, this._pos.getCol()).getSub(this._xPath, false);
        int col = dst.getCol();
        if (this._epOwner != null) {
            ExtProps epDstSource = sheet.getCell(row, col, false).getExtProps(false).getSource();
            ExtProps head = epCurr.getHeadBySource(epDstSource, true);
            if (head != null) {
                row = head.getRow();
            }
            if ((head = epCurr.getHeadBySource(epDstSource, false)) != null) {
                col = head.getCol();
            }
        }
        CellBlockNode cb = CellBlockNode.getCellBlockNode(sheet, row, col, row, col, 0);
        if (createDep) {
            cb = sheet.setDependent(exprOwner, cb);
        }
        return new Variant(cb, 18);
    }

    @Override
    public String decode(ExprContext ctx, ICalculable exprOwner) {
        Variant varDst = this._getDestCellBlockVar(ctx, exprOwner, false);
        if (varDst.isNull()) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        ((CellBlockNode)varDst.getValue()).getBlockName(sb, exprOwner);
        return sb.toString();
    }

    @Override
    public int getExprType() {
        return 0x200000;
    }
}

