/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.expr;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.ExprErr;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.extcommon.variant.WeakHashSet;
import com.kingdee.cosmic.ctrl.kds.io.htm.serial.String2Variant;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprArray;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprConst;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprExpressionMark;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprOperator;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprUID;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprUnknownMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprBuffer;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.FunctionManager;
import com.kingdee.cosmic.ctrl.kds.model.struct.ICalculable;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlock3DNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;

public class Parser {
    private static long[] _quickTokens = new long[128];
    private ObjectArray _nodeQueue;
    private String _formula;
    private int _formulaLength;
    private long _currentToken;
    private int _currentTokenPos;
    private int _currentTokenLength;
    private boolean _transChar;
    private ICalculable _formulaOwner;
    private IExprBuffer _buffer;
    private boolean _supportSheet = true;
    private boolean _bParseParams;
    private boolean _bParseArray;
    private boolean _bCommaArray;
    private boolean _bA1Style;
    private int _row;
    private int _col;
    private int _baseRow;
    private int _baseCol;
    private boolean _absRow;
    private boolean _absCol;
    private int _nodesState;

    public Parser(boolean bA1Style) {
        this._bA1Style = bA1Style;
        this._nodeQueue = new ObjectArray(20);
        this.init(null, null);
    }

    public boolean isA1Style() {
        return this._bA1Style;
    }

    public void setA1Style(boolean bA1) {
        this._bA1Style = bA1;
    }

    private long init(ICalculable formulaOwner, String formula) {
        this._nodeQueue.clear();
        this._transChar = false;
        this._formula = formula;
        this._formulaOwner = formulaOwner;
        if (!this._bA1Style) {
            this._baseCol = 0;
            this._baseRow = 0;
            if (formulaOwner instanceof Cell) {
                Cell cll = (Cell)this._formulaOwner;
                this._baseRow = cll.getRow();
                this._baseCol = cll.getCol();
            }
        }
        this._currentTokenPos = !StringUtil.isEmptyString((String)formula) && formula.charAt(0) == '=' ? 1 : 0;
        this._currentTokenLength = 0;
        if (StringUtil.isEmptyString((String)this._formula)) {
            this._formulaLength = 0;
            this._currentToken = 0x1000000000000000L;
        } else {
            this._formulaLength = this._formula.length();
            this._currentToken = 0x100000000L;
        }
        return this._currentToken;
    }

    public void clear() {
        this._formulaOwner = null;
        this._buffer = null;
        this._bParseParams = false;
        this._bParseArray = false;
        this._bCommaArray = false;
        this._nodeQueue.clear();
        this._nodesState = 0;
    }

    public Object parse(ICalculable formulaOwner, String formula) {
        this.init(formulaOwner, formula);
        Comparable<Boolean> ret = Boolean.FALSE;
        try {
            this._nodeQueue.clear();
            this._buffer = formulaOwner.getSheet().getDeps();
            this.advance();
            if (!this.meet(0x1000000000000000L)) {
                this.statement();
                if (!this.meet(0x1000000000000000L)) {
                    ExprErr.goError(4096L, this.getCurrentWord());
                }
                ret = Boolean.TRUE;
            }
        }
        catch (SyntaxErrorException e) {
            this.setState(3, true);
            Variant var = new Variant(e, 16);
            WeakHashSet constBuffer = this._buffer.getConstBuffer();
            this._nodeQueue.append(ExprConst.getExprConst(constBuffer, var));
            ret = var;
        }
        catch (Exception e) {
            this.setState(3, true);
            Variant var = new Variant(new SyntaxErrorException(64L, (Object)e), 16);
            WeakHashSet constBuffer = this._buffer.getConstBuffer();
            this._nodeQueue.append(ExprConst.getExprConst(constBuffer, var));
            ret = var;
        }
        return ret;
    }

    public Expr getExpr() {
        int size = this._nodeQueue.size();
        if (size == 0) {
            return null;
        }
        Object[] nodes = new IExprNode[size];
        this._nodeQueue.toArray(nodes, 0);
        return Expr.getExpr(this._buffer, (IExprNode[])nodes, this._nodesState, 0, nodes.length);
    }

    public void statement() throws SyntaxErrorException {
        this.andExpression();
        while (this.touchToken(0x60000000000L)) {
            long oldToken = this._currentToken;
            int oldTokenPos = this._currentTokenPos;
            int oldTokenLen = this._currentTokenLength;
            this.advance();
            this.andExpression();
            if (oldToken == 0x20000000000L) {
                this._nodeQueue.append(ExprOperator.EQUAL);
                continue;
            }
            if (this._formula.charAt(oldTokenPos) == '>') {
                if (oldTokenLen == 1) {
                    this._nodeQueue.append(ExprOperator.G);
                    continue;
                }
                this._nodeQueue.append(ExprOperator.GE);
                continue;
            }
            if (oldTokenLen == 1) {
                this._nodeQueue.append(ExprOperator.L);
                continue;
            }
            if (this._formula.charAt(oldTokenPos + 1) == '=') {
                this._nodeQueue.append(ExprOperator.LE);
                continue;
            }
            this._nodeQueue.append(ExprOperator.NE);
        }
    }

    private final void andExpression() throws SyntaxErrorException {
        this.expression();
        while (this.meet(0x10000000000L)) {
            this.advance();
            this.expression();
            this._nodeQueue.append(ExprOperator.STRCAT);
        }
    }

    private final void expression() throws SyntaxErrorException {
        this.array();
        while (this.touchToken(0xC00000000L)) {
            long oldToken = this._currentToken;
            this.advance();
            this.array();
            if (oldToken == 0x400000000L) {
                this._nodeQueue.append(ExprOperator.PLUS);
                continue;
            }
            this._nodeQueue.append(ExprOperator.MINUS);
        }
    }

    private final void array() throws SyntaxErrorException {
        if (!this.meet(0x2000000000000L)) {
            this.term();
            if (this.touchToken(0x200000000000L) && !this._bParseParams && !this._bParseArray && !this._bCommaArray) {
                boolean bCommaArray = this._bCommaArray;
                this._bCommaArray = true;
                int argCount = 1;
                do {
                    this.advance();
                    this.statement();
                    ++argCount;
                } while (this.touchToken(0x200000000000L));
                this._nodeQueue.append(ExprArray.getInstance(argCount));
                this.setState(16384, true);
                this._bCommaArray = bCommaArray;
            }
        } else {
            boolean parseArray = this._bParseArray;
            this._bParseArray = true;
            this.advance();
            this._nodeQueue.append(ExprOperator.LARRAY);
            int argCount = 1;
            this.statement();
            while (this.touchToken(0x200000000000L)) {
                this.advance();
                this.statement();
                ++argCount;
            }
            this._nodeQueue.append(ExprArray.getInstance(argCount));
            if (!this.meet(0x4000000000000L)) {
                ExprErr.goError(16384L, "}");
            }
            this.advance();
            this._nodeQueue.append(ExprOperator.RARRAY);
            this._bParseArray = parseArray;
            this.setState(16384, true);
        }
    }

    private final void term() throws SyntaxErrorException {
        this.power();
        while (this.touchToken(0x3000000000L)) {
            long oldToken = this._currentToken;
            this.advance();
            this.power();
            if (oldToken == 0x1000000000L) {
                this._nodeQueue.append(ExprOperator.MULTIPLY);
                continue;
            }
            this._nodeQueue.append(ExprOperator.DIVIDE);
        }
    }

    private final void power() throws SyntaxErrorException {
        this.percent();
        while (this.meet(0x8000000000L)) {
            this.advance();
            this.percent();
            this._nodeQueue.append(ExprOperator.POWER);
        }
    }

    private final void percent() throws SyntaxErrorException {
        this.unary();
        while (this.meet(0x4000000000L)) {
            this.advance();
            this._nodeQueue.append(ExprOperator.PERCENT);
        }
    }

    private final void unary() throws SyntaxErrorException {
        boolean neg = false;
        while (this.touchToken(0xC00000000L)) {
            if (this.meet(0x800000000L)) {
                neg = !neg;
            }
            this.advance();
        }
        this.factor();
        if (neg) {
            this._nodeQueue.append(ExprOperator.NEG);
        }
    }

    private final void factor() throws SyntaxErrorException {
        if (this.touchToken(0x1C0000000000000L)) {
            this.setState(4, true);
            this.parseCell(null, null);
        } else if (this.meet(0x20000000000000L)) {
            String word = this.getCurrentWord();
            this.advance();
            if (this.meet(0x80000000000L)) {
                this.function(word);
            } else {
                if (this._supportSheet) {
                    this.setState(8, true);
                    Sheet sheet = this._formulaOwner.getSheet();
                    Book book = sheet.getBook();
                    NamedObjectNode namedObj = sheet.getNamedObject(word, true);
                    if (namedObj == null) {
                        this.setState(0x800000, true);
                        namedObj = NamedObjectNode.createUndefinedNamedObject(word, book, null);
                        book.getNames().insert(namedObj);
                    } else if (namedObj.isUndefined()) {
                        this.setState(0x800000, true);
                    }
                    NamedObjectNode depNo = book.setDependent(this._formulaOwner, namedObj);
                    this._nodeQueue.append(depNo == null ? namedObj : depNo);
                    return;
                }
                ExprErr.goError(131072L, word);
            }
        } else if (this.touchToken(0x18000000000000L)) {
            this.setState(2, true);
            Variant num = this.identifyNumber(this.getCurrentWord(), this._currentToken == 0x8000000000000L);
            this._nodeQueue.append(ExprConst.getExprConst(this._buffer.getConstBuffer(), num));
            this.advance();
        } else if (this.meet(0x1000000000000L)) {
            this.setState(2, true);
            Variant varStr = String2Variant.toVariant(this.parseString(), 0);
            this._nodeQueue.append(ExprConst.getExprConst(this._buffer.getConstBuffer(), varStr));
            this.advance();
        } else if (this.meet(0x200000000000000L)) {
            Sheet sheet = null;
            Sheet sheet2 = null;
            Book thisBook = this._formulaOwner.getSheet().getBook();
            String sheetName = this.getCurrentWord();
            if (sheetName.charAt(0) == '\'') {
                int pos = (sheetName = Parser.getSheetName(sheetName)).indexOf(58);
                if (pos < 0) {
                    sheet = sheet2 = this.getSheetByName(thisBook, sheetName);
                } else if (pos > 0) {
                    sheet = this.getSheetByName(thisBook, sheetName.substring(0, pos));
                    sheet2 = this.getSheetByName(thisBook, sheetName.substring(pos + 1));
                } else {
                    ExprErr.goError(16384L, "Sheet");
                }
            } else {
                sheet = sheet2 = this.getSheetByName(thisBook, sheetName);
            }
            this.advance();
            if (sheet2 == sheet && this.meet(0x400000000000L)) {
                this.advance();
                if (!this.meet(0x200000000000000L)) {
                    ExprErr.goError(16384L, "Sheet");
                }
                sheet2 = this.getSheetByName(thisBook, Parser.getSheetName(this.getCurrentWord()));
                this.advance();
            }
            if (!this.meet(0x400000000000000L)) {
                ExprErr.goError(16384L, "!");
            }
            this.advance();
            if (this.touchToken(0x20000000000000L)) {
                if (sheet != sheet2 && null != sheet) {
                    ExprErr.goError(1L, sheet.getSheetName() + ":" + sheet2.getSheetName());
                }
                this.setState(8, true);
                if (null != sheet) {
                    NamedObjectNode depNo;
                    Book book = sheet.getBook();
                    String name = this.getCurrentWord();
                    NamedObjectNode namedObj = sheet.getNamedObject(name, false);
                    if (namedObj == null) {
                        namedObj = NamedObjectNode.createUndefinedNamedObject(name, book, sheet);
                        sheet.getNames().insert(namedObj);
                    }
                    if (namedObj.isVisible() && (depNo = book.setDependent(this._formulaOwner, namedObj)) != null) {
                        namedObj = depNo;
                    }
                    this._nodeQueue.append(namedObj);
                }
                this.advance();
            } else {
                if (!this.touchToken(0x1C0000000000000L)) {
                    ExprErr.goError(16384L, "Cell");
                }
                this.setState(4, true);
                this.parseCell(sheet, sheet2);
            }
        } else if (this.meet(0x80000000000L)) {
            this._nodeQueue.append(ExprOperator.LP);
            this.advance();
            this.statement();
            if (!this.meet(0x100000000000L)) {
                ExprErr.goError(16384L, ")");
            }
            this._nodeQueue.append(ExprOperator.RP);
            this.advance();
        } else if (this.meet(0x800000000000000L)) {
            this.setState(2, true);
            Variant varError = new Variant(ExprErr.getErrorObj(this.getCurrentWord()), 16);
            this._nodeQueue.append(ExprConst.getExprConst(this._buffer.getConstBuffer(), varError));
            this.advance();
        } else if (this._bParseParams && this.touchToken(0x300000000000L)) {
            this.setState(512, true);
            this._nodeQueue.append(ExprConst.DEFAULT_PARAM);
        } else {
            ExprErr.goError(8192L, this.getCurrentWord());
        }
    }

    private Sheet getSheetByName(Book book, String sheetName) {
        Sheet sheet = null;
        try {
            sheet = book.getSheetByName(sheetName);
        }
        catch (SyntaxErrorException e) {
            this.setState(1, true);
            sheet = (Sheet)e.getExtData();
            book.pendingSheet(sheetName, this._formulaOwner);
        }
        return sheet;
    }

    private final void function(String funcName) throws SyntaxErrorException {
        Sheet sheet = this._formulaOwner.getSheet();
        Dependents deps = sheet.getDeps();
        FunctionManager funcManager = deps.getFunctionManager();
        ExprMethod[] funcList = funcManager.getFuncList(funcName);
        int paramStart = this._nodeQueue.size() + 1;
        boolean supposeNeedExpParam = funcManager.isNeedExpParam(funcList);
        int paramCount = this.params(supposeNeedExpParam);
        if (funcList != null) {
            ExprMethod em = funcManager.getExprMethod(funcList, paramCount);
            if (em == null) {
                throw new SyntaxErrorException(8L, String.valueOf(paramCount));
            }
            boolean needExpParam = em.isNeedExpParam();
            if (needExpParam != supposeNeedExpParam) {
                ExprErr.goError(16L, "NeedExpParam");
            }
            if (em.isVarietyParams()) {
                this.setState(16384, true);
                this._nodeQueue.append(ExprArray.getInstance(paramCount));
            }
            if (em.isBatchMethod() || !em.isLocalMethod()) {
                int size = this._nodeQueue.size() - 1;
                for (int i = paramStart; i < size; ++i) {
                    CellBlockNode cb;
                    Object node = this._nodeQueue.get(i);
                    if (!(node instanceof CellBlockNode) || (cb = (CellBlockNode)node).isSingleCell()) continue;
                    ExprErr.goError(512L, cb.toString());
                }
                this._nodeQueue.append(ExprUID.getNewInstance());
            }
            if (em.isNeedContext()) {
                this.setState(32768, true);
                this._nodeQueue.insert(paramStart, deps.getExprContext());
            }
            if (em.isInnerMethod()) {
                this.setState(256, true);
                if (em.isExtFamilyMethod()) {
                    this.setState(0x1000000, true);
                }
                if (em.isExcelMethod()) {
                    this.setState(1024, true);
                    if (em.isSubTotal()) {
                        this.setState(4096, true);
                    }
                } else if (em.isExtensibleMethod() && (!this._bParseParams || em.isExtEnableMethod())) {
                    this.setState(8192, true);
                } else if (em.isDynamicDataSetMethod()) {
                    this.setState(0x400000, true);
                } else if (em.isExtField()) {
                    this.setState(0x100000, true);
                } else if (em.isMacro()) {
                    this.setState(0x2000000, true);
                } else if (em.getName().equals("$")) {
                    this.setState(0x4000000, true);
                }
            } else {
                this.setState(128, true);
            }
            this._nodeQueue.append(em);
        } else {
            ExprUnknownMethod unknown = this._formulaOwner.getSheet().getDeps().getUnknownMethodManager().getUnknownFunction(funcName, paramCount);
            this._nodeQueue.append(unknown);
            this.setState(2048, true);
        }
    }

    private final int params(boolean needExpParam) throws SyntaxErrorException {
        if (!this.meet(0x80000000000L)) {
            ExprErr.goError(16384L, "(");
        }
        this._nodeQueue.append(ExprOperator.LP);
        this.advance();
        int paramCount = 0;
        if (!this.meet(0x100000000000L)) {
            boolean bParseParams = this._bParseParams;
            this._bParseParams = true;
            this.param(needExpParam);
            ++paramCount;
            while (this.meet(0x200000000000L)) {
                this.advance();
                this.param(needExpParam);
                ++paramCount;
            }
            this._bParseParams = bParseParams;
        }
        if (!this.meet(0x100000000000L)) {
            ExprErr.goError(16384L, ")");
        }
        this._nodeQueue.append(ExprOperator.RP);
        this.advance();
        return paramCount;
    }

    private final void param(boolean needExpParam) throws SyntaxErrorException {
        if (needExpParam) {
            int paramStart = this._nodeQueue.size();
            int bak = this._nodesState;
            this._nodesState = 0;
            this.statement();
            int newState = this._nodesState;
            this._nodesState |= bak;
            int paramEnd = this._nodeQueue.size();
            if (paramEnd - paramStart > 1) {
                this.setState(131072, true);
                this._nodeQueue.insert(paramStart, new ExprExpressionMark(paramEnd - paramStart, newState));
            }
        } else {
            this.statement();
        }
    }

    private final Variant identifyNumber(String numberString, boolean isFloat) {
        Variant var;
        try {
            Book thisBook = this._formulaOwner.getSheet().getBook();
            var = thisBook.getBufferedDecimal(numberString);
        }
        catch (SyntaxErrorException e) {
            var = Variant.zeroVariant;
        }
        return var;
    }

    private final String parseString() {
        int start = this._currentTokenPos + 1;
        int end = start + this._currentTokenLength - 2;
        if (!this._transChar) {
            return this._formula.substring(start, end);
        }
        this._transChar = false;
        return Parser.transParseString(this._formula, start, end);
    }

    public static String transParseString(String str, int start, int end) {
        StringBuilder sb = new StringBuilder(end - start);
        for (int i = start; i < end; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i < end - 1) {
                char chT = str.charAt(i + 1);
                switch (chT) {
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case '\"': {
                        sb.append('\"');
                        break;
                    }
                    case '\'': {
                        sb.append('\'');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    default: {
                        sb.append('\\').append(chT);
                    }
                }
                ++i;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private final void parseCell(Sheet sheet, Sheet sheet2) throws SyntaxErrorException {
        boolean absCol;
        boolean absCol2;
        boolean absRow;
        boolean absRow2;
        int col;
        int col2;
        int row;
        int row2;
        if (sheet == null) {
            sheet = sheet2 = this._formulaOwner.getSheet();
        }
        if (this.meet(0x40000000000000L)) {
            row = row2 = this._row;
            col = col2 = this._col;
            absRow = absRow2 = this._absRow;
            absCol = absCol2 = this._absCol;
            this.advance();
            if (this.meet(0x400000000000L)) {
                this.advance();
                if (!this.meet(0x40000000000000L)) {
                    ExprErr.goError(16384L, "Cell");
                }
                row2 = this._row;
                col2 = this._col;
                absRow2 = this._absRow;
                absCol2 = this._absCol;
                this.advance();
            }
        } else if (this.meet(0x80000000000000L)) {
            if (!this.isRow(this._currentTokenPos)) {
                ExprErr.goError(16384L, "Row");
            }
            row = this._row;
            absRow = this._absRow;
            this.advance();
            if (this.meet(0x400000000000L)) {
                this.advance();
                if (!this.isRow(this._currentTokenPos)) {
                    ExprErr.goError(16384L, "Row");
                }
                row2 = this._row;
                absRow2 = this._absRow;
                this.advance();
            } else {
                if (this._bA1Style) {
                    ExprErr.goError(16384L, "Row");
                }
                row2 = row;
                absRow2 = absRow;
            }
            col = 0;
            col2 = 65535;
            absCol2 = false;
            absCol = false;
        } else {
            if (!this.isColumn(this._currentTokenPos)) {
                ExprErr.goError(16384L, "Column");
            }
            col = this._col;
            absCol = this._absCol;
            this.advance();
            if (this.meet(0x400000000000L)) {
                this.advance();
                if (!this.isColumn(this._currentTokenPos)) {
                    ExprErr.goError(16384L, "Column");
                }
                col2 = this._col;
                absCol2 = this._absCol;
                this.advance();
            } else {
                if (this._bA1Style) {
                    ExprErr.goError(16384L, "Column");
                }
                col2 = col;
                absCol2 = absCol;
            }
            row = 0;
            row2 = 1048575;
            absRow2 = false;
            absRow = false;
        }
        if (!sheet.isDisposed()) {
            CellBlockNode cb;
            int absFlags = CellBlockNode.getAbsFlags(absRow, absCol, absRow2, absCol2);
            if (sheet == sheet2) {
                CellBlockNode depCB;
                cb = CellBlockNode.getCellBlockNode(sheet, row, col, row2, col2, absFlags);
                if (cb.equals(depCB = sheet.setDependent(this._formulaOwner, cb))) {
                    cb = depCB;
                }
            } else {
                CellBlockNode depCB;
                CellBlock3DNode cb3 = CellBlock3DNode.getCellBlock3DNode(this._buffer.getCellBlockNodeBuffer(), sheet, sheet2, row, col, row2, col2, absFlags);
                cb = cb3.equals(depCB = sheet.getBook().setDependent(this._formulaOwner, cb3)) ? depCB : cb3;
            }
            this._nodeQueue.append(cb);
        }
    }

    public final boolean meet(long token) {
        return this._currentToken == token;
    }

    public final void advance() throws SyntaxErrorException {
        this._currentToken = this.lex();
    }

    private final long lex() throws SyntaxErrorException {
        block10: for (int pos = this._currentTokenPos + this._currentTokenLength; pos < this._formulaLength; ++pos) {
            long token;
            this._currentTokenPos = pos;
            this._currentTokenLength = 1;
            char ch = this._formula.charAt(pos);
            if (ch < '\u0080') {
                token = _quickTokens[ch];
                if (token > 0x200000000L) {
                    return token;
                }
                if (token == 0x100000000L) continue;
            }
            switch (ch) {
                case '\"': {
                    do {
                        if (++pos >= this._formulaLength) {
                            ch = '\u0000';
                            break;
                        }
                        ch = this._formula.charAt(pos);
                        if (ch != '\"') continue;
                        this._transChar = true;
                        if (pos <= 0 || this.getChar(pos - 1) != '\\') continue;
                        ch = this.getChar(++pos);
                    } while (ch != '\"');
                    if (ch == '\"') {
                        ++pos;
                    } else {
                        ExprErr.goError(16384L, "\"");
                    }
                    this._currentTokenLength = pos - this._currentTokenPos;
                    return 0x1000000000000L;
                }
                case '>': {
                    if (this.getChar(pos + 1) == '=') {
                        ++this._currentTokenLength;
                    }
                    return 0x40000000000L;
                }
                case '<': {
                    ch = this.getChar(pos + 1);
                    if (ch == '=' || ch == '>') {
                        ++this._currentTokenLength;
                    }
                    return 0x40000000000L;
                }
                case '@': {
                    token = this.ident(++pos);
                    if (token != 0x20000000000000L) {
                        ExprErr.goError(16384L, "ID");
                    }
                    return token;
                }
                case '.': {
                    if (Character.isDigit(this.getChar(pos + 1))) {
                        return this.ident(pos);
                    }
                    return 0x800000000000L;
                }
                case '[': {
                    do {
                        if (++pos < this._formulaLength) continue;
                        ch = '\u0000';
                        break;
                    } while ((ch = this._formula.charAt(pos)) != ']');
                    if (ch == ']') {
                        ++pos;
                    } else {
                        ExprErr.goError(16384L, "]");
                    }
                    this._currentTokenLength = pos - this._currentTokenPos;
                    return 0x20000000000000L;
                }
                case '#': {
                    do {
                        if (++pos < this._formulaLength) continue;
                        ch = '\u0000';
                        break;
                    } while ((ch = this._formula.charAt(pos)) != '!' && ch != '?');
                    if (ch == '!' || ch == '?') {
                        ++pos;
                    } else {
                        ExprErr.goError(16384L, "!");
                    }
                    this._currentTokenLength = pos - this._currentTokenPos;
                    return 0x800000000000000L;
                }
                case '\'': {
                    do {
                        if (++pos >= this._formulaLength) {
                            ch = '\u0000';
                            break;
                        }
                        ch = this._formula.charAt(pos);
                        if (ch != '\'' || pos <= 0 || this.getChar(pos + 1) != '\'') continue;
                        this._transChar = true;
                        ch = this.getChar(pos += 2);
                    } while (ch != '\'');
                    if (ch == '\'') {
                        ++pos;
                    } else {
                        ExprErr.goError(16384L, "'");
                    }
                    this._currentTokenLength = pos - this._currentTokenPos;
                    if (this._supportSheet && this._currentTokenLength > 2) {
                        return 0x200000000000000L;
                    }
                    ExprErr.goError(16384L, "'SheetName'");
                    continue block10;
                }
                default: {
                    return this.ident(pos);
                }
            }
        }
        return 0x1000000000000000L;
    }

    private final long ident(int pos) throws SyntaxErrorException {
        char ch = this.getChar(pos);
        if (Character.isDigit(ch) || ch == '.') {
            boolean sawDot;
            boolean bl = sawDot = ch == '.';
            do {
                if ((ch = this.getChar(++pos)) != '.') continue;
                if (sawDot) {
                    this._currentTokenPos = pos;
                    ExprErr.goError(1024L, this.getCurrentWord());
                    continue;
                }
                sawDot = true;
            } while (Character.isDigit(ch) || ch == '.');
            if (ch == 'e' || ch == 'E') {
                sawDot = true;
                if ((ch = this.getChar(++pos)) == '-' || ch == '+') {
                    ch = this.getChar(++pos);
                }
                if (!Character.isDigit(ch)) {
                    this._currentTokenPos = pos;
                    ExprErr.goError(2048L, "DIGIT");
                }
                while (Character.isDigit(ch = this.getChar(++pos))) {
                }
            }
            this._currentTokenLength = pos - this._currentTokenPos;
            if (sawDot) {
                return 0x8000000000000L;
            }
            long token = 0x10000000000000L;
            if (ch == ':' && this.isRow(++pos)) {
                token = 0x80000000000000L;
            }
            return token;
        }
        if (Character.isJavaIdentifierStart(ch)) {
            while (this.isFunctionChar(this.getChar(++pos))) {
            }
            this._currentTokenLength = pos - this._currentTokenPos;
            while (Character.isWhitespace(ch = this.getChar(pos))) {
                ++pos;
            }
            if (ch == '!') {
                if (this._supportSheet) {
                    return 0x200000000000000L;
                }
                ExprErr.goError(512L, "!");
            } else if (ch == '(') {
                return 0x20000000000000L;
            }
            if (this._supportSheet) {
                if (this.isCell(this._currentTokenPos)) {
                    long token = 0x40000000000000L;
                    if (ch == ':') {
                        int len = this._currentTokenLength;
                        int row = this._row;
                        int col = this._col;
                        boolean absRow = this._absRow;
                        boolean absCol = this._absCol;
                        if (!this.isCell(this._currentTokenPos + this._currentTokenLength + 1)) {
                            token = 0x200000000000000L;
                        }
                        this._currentTokenLength = len;
                        this._row = row;
                        this._col = col;
                        this._absRow = absRow;
                        this._absCol = absCol;
                    }
                    return token;
                }
                if (this.isRow(this._currentTokenPos)) {
                    long token;
                    long l = token = this._bA1Style ? 0x200000000000000L : 0x80000000000000L;
                    if (ch == ':') {
                        int len = this._currentTokenLength;
                        int r = this._row;
                        boolean abs = this._absRow;
                        token = this.isRow(this._currentTokenPos + this._currentTokenLength + 1) ? 0x80000000000000L : 0x200000000000000L;
                        this._currentTokenLength = len;
                        this._row = r;
                        this._absRow = abs;
                    }
                    return token;
                }
                if (this.isColumn(this._currentTokenPos)) {
                    long token;
                    long l = token = this._bA1Style ? 0x20000000000000L : 0x100000000000000L;
                    if (ch == ':') {
                        int len = this._currentTokenLength;
                        int c = this._col;
                        boolean abs = this._absCol;
                        int currPos = this._currentTokenPos;
                        this._currentTokenPos += this._currentTokenLength + 1;
                        token = this.isColumn(this._currentTokenPos) ? 0x100000000000000L : 0x200000000000000L;
                        this._currentTokenPos = currPos;
                        this._currentTokenLength = len;
                        this._col = c;
                        this._absCol = abs;
                    }
                    return token;
                }
                if (ch == ':') {
                    return 0x200000000000000L;
                }
            }
            return 0x20000000000000L;
        }
        ExprErr.goError(256L, String.valueOf(ch));
        return 0x1000000000000000L;
    }

    private boolean isFunctionChar(char ch) {
        return Character.isLetterOrDigit(ch) || ch > '\u00ff' || ch == '_' || ch == '$' || ch == '.';
    }

    private int judgeA1Column(int pos) {
        char ch = this.getChar(pos);
        this._absCol = false;
        if (ch == '$') {
            this._absCol = true;
            ch = this.getChar(++pos);
        }
        this._col = 0;
        int type = Character.getType(ch);
        while (type == 2 || type == 1) {
            this._col = this._col * 26 + (Character.toUpperCase(ch) - 65 + 1);
            ch = this.getChar(++pos);
            type = Character.getType(ch);
        }
        if (this._col == 0 || this._col > 65536) {
            return -1;
        }
        return pos;
    }

    private int judgeRCColumn(int pos) {
        char ch = this.getChar(pos);
        if (ch != 'C' && ch != 'c') {
            return -1;
        }
        boolean bMatchBracket = false;
        boolean bNeg = false;
        ch = this.getChar(++pos);
        this._absCol = true;
        if (ch == '[') {
            this._absCol = false;
            bMatchBracket = true;
            if ((ch = this.getChar(++pos)) == '-' || ch == '+') {
                bNeg = ch == '-';
                ch = this.getChar(++pos);
            }
        }
        this._col = 0;
        if (Character.isDigit(ch)) {
            while (Character.isDigit(ch)) {
                this._col = this._col * 10 + (ch - 48);
                ch = this.getChar(++pos);
            }
            if (bNeg) {
                this._col = -this._col;
            }
        } else {
            if (ch != '\u0000' && Character.isJavaIdentifierPart(ch)) {
                return -1;
            }
            this._absCol = false;
        }
        if (bMatchBracket) {
            if (ch != ']') {
                return -1;
            }
            ++pos;
        }
        return pos;
    }

    private int judgeA1Row(int pos) {
        char ch = this.getChar(pos);
        this._absRow = false;
        if (ch == '$') {
            this._absRow = true;
            ch = this.getChar(++pos);
        }
        this._row = 0;
        while (Character.isDigit(ch)) {
            this._row = this._row * 10 + (ch - 48);
            ch = this.getChar(++pos);
        }
        if (this._row == 0 || this._row > 0x100000) {
            return -1;
        }
        return pos;
    }

    private int judgeRCRow(int pos) {
        char ch = this.getChar(pos);
        if (ch != 'R' && ch != 'r') {
            return -1;
        }
        boolean bMatchBracket = false;
        boolean bNeg = false;
        ch = this.getChar(++pos);
        this._absRow = true;
        if (ch == '[') {
            this._absRow = false;
            bMatchBracket = true;
            if ((ch = this.getChar(++pos)) == '-' || ch == '+') {
                bNeg = ch == '-';
                ch = this.getChar(++pos);
            }
        }
        this._row = 0;
        if (Character.isDigit(ch)) {
            while (Character.isDigit(ch)) {
                this._row = this._row * 10 + (ch - 48);
                ch = this.getChar(++pos);
            }
            if (bNeg) {
                this._row = -this._row;
            }
        } else {
            if (ch != '\u0000' && Character.isJavaIdentifierPart(ch) && ch != 'C' && ch != 'c') {
                return -1;
            }
            this._absRow = false;
        }
        if (bMatchBracket) {
            if (ch != ']') {
                return -1;
            }
            ch = this.getChar(++pos);
        }
        return pos;
    }

    private final boolean isCell(int pos) throws SyntaxErrorException {
        char ch;
        if (this._bA1Style) {
            if ((pos = this.judgeA1Column(pos)) < 0) {
                return false;
            }
            if ((pos = this.judgeA1Row(pos)) < 0) {
                return false;
            }
        } else {
            if ((pos = this.judgeRCRow(pos)) < 0) {
                return false;
            }
            if ((pos = this.judgeRCColumn(pos)) < 0) {
                return false;
            }
            if (!this._absRow) {
                this._row += this._baseRow + 1;
            }
            if (!this._absCol) {
                this._col += this._baseCol + 1;
            }
        }
        if ((ch = this.getChar(pos)) != '\u0000' && (Character.isJavaIdentifierPart(ch) || ch == '!' || ch == '.')) {
            return false;
        }
        this._currentTokenLength = pos - this._currentTokenPos;
        --this._row;
        --this._col;
        return true;
    }

    private final boolean isColumn(int pos) throws SyntaxErrorException {
        if (this._bA1Style) {
            if ((pos = this.judgeA1Column(pos)) < 0) {
                return false;
            }
        } else {
            if ((pos = this.judgeRCColumn(pos)) < 0) {
                return false;
            }
            if (!this._absCol) {
                if (!(this._formulaOwner instanceof Cell)) {
                    ExprErr.goError(262144L, this.getCurrentWord());
                }
                this._col += ((Cell)this._formulaOwner).getCol() + 1;
            }
        }
        if (pos != this._currentTokenPos + this._currentTokenLength) {
            return false;
        }
        this._currentTokenLength = pos - this._currentTokenPos;
        --this._col;
        return true;
    }

    private final boolean isRow(int pos) throws SyntaxErrorException {
        if (this._bA1Style) {
            if ((pos = this.judgeA1Row(pos)) < 0) {
                return false;
            }
        } else {
            if ((pos = this.judgeRCRow(pos)) < 0) {
                return false;
            }
            if (!this._absRow) {
                if (!(this._formulaOwner instanceof Cell)) {
                    ExprErr.goError(262144L, this.getCurrentWord());
                }
                this._row += ((Cell)this._formulaOwner).getRow() + 1;
            }
        }
        this._currentTokenLength = pos - this._currentTokenPos;
        --this._row;
        return true;
    }

    public final char getChar(int index) {
        return index < this._formulaLength ? this._formula.charAt(index) : (char)'\u0000';
    }

    public String getCurrentWord() {
        String word = null;
        word = this._formula.charAt(this._currentTokenPos) == '[' ? this._formula.substring(this._currentTokenPos + 1, this._currentTokenPos + this._currentTokenLength - 1) : this._formula.substring(this._currentTokenPos, this._currentTokenPos + this._currentTokenLength);
        return word;
    }

    public static String getSheetName(String sheetName) {
        if (sheetName.charAt(0) == '\'') {
            sheetName = sheetName.substring(1, sheetName.length() - 1);
        }
        return sheetName.indexOf(39) != -1 ? StringUtil.getExcelStrDescape((String)sheetName) : sheetName;
    }

    public int getTokenPos() {
        return this._currentTokenPos;
    }

    public final boolean touchToken(long tokens) {
        return (this._currentToken & tokens) != 0L;
    }

    private void setState(int state, boolean set) {
        this._nodesState = set ? (this._nodesState |= state) : (this._nodesState &= ~state);
    }

    static {
        for (int i = 0; i < 128; ++i) {
            Parser._quickTokens[i] = 0x200000000L;
        }
        Parser._quickTokens[43] = 0x400000000L;
        Parser._quickTokens[45] = 0x800000000L;
        Parser._quickTokens[42] = 0x1000000000L;
        Parser._quickTokens[47] = 0x2000000000L;
        Parser._quickTokens[40] = 0x80000000000L;
        Parser._quickTokens[41] = 0x100000000000L;
        Parser._quickTokens[44] = 0x200000000000L;
        Parser._quickTokens[37] = 0x4000000000L;
        Parser._quickTokens[94] = 0x8000000000L;
        Parser._quickTokens[38] = 0x10000000000L;
        Parser._quickTokens[58] = 0x400000000000L;
        Parser._quickTokens[61] = 0x20000000000L;
        Parser._quickTokens[33] = 0x400000000000000L;
        Parser._quickTokens[123] = 0x2000000000000L;
        Parser._quickTokens[125] = 0x4000000000000L;
        Parser._quickTokens[32] = 0x100000000L;
        Parser._quickTokens[9] = 0x100000000L;
        Parser._quickTokens[10] = 0x100000000L;
        Parser._quickTokens[13] = 0x100000000L;
    }
}

