/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.kdf.headfootdesigner.HeadFootRow;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.model.struct.PrintSetup;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

public class PrintSetupUtil {
    private static final Logger logger = LogUtil.getPackageLogger(PrintSetupUtil.class);
    private static String PRINT_SETUP = "PRINT_SETUP";
    private static String HAS_ROW_HEAD = "HAS_ROW_HEAD";
    private static String HAS_COL_HEAD = "HAS_COL_HEAD";
    private static String HAS_GRID = "HAS_GRID";
    private static String IS_BLACK_WHITE = "IS_BLACK_WHITE";
    private static String IS_LAND_SCAPE = "IS_LAND_SCAPE";
    private static String IS_ROW_FIRST = "IS_ROW_FIRST";
    private static String AUTO_FIT = "AUTO_FIT";
    private static String CENTER_HORIZONTAL = "CENTER_HORIZONTAL";
    private static String CENTER_VERTICAL = "CENTER_VERTICAL";
    private static String TOP_MARGIN = "TOP_MARGIN";
    private static String BOTTOM_MARGIN = "BOTTOM_MARGIN";
    private static String LEFT_MARGIN = "LEFT_MARGIN";
    private static String RIGHT_MARGIN = "RIGHT_MARGIN";
    private static String HEAD_MARGIN = "HEAD_MARGIN";
    private static String FOOT_MARGIN = "FOOT_MARGIN";
    private static String PAGESIZE_INDEX = "PAGESIZE_INDEX";
    private static String PAGESIZE_X = "PAGESIZE_X";
    private static String PAGESIZE_Y = "PAGESIZE_Y";
    private static String SCALE = "SCALE";
    private static String AUTO_FIT_HEIGHT = "AUTO_FIT_HEIGHT";
    private static String AUTO_FIT_WIDTH = "AUTO_FIT_WIDTH";
    private static String FOOT_ALIGN = "FOOT_ALIGN";
    private static String HEAD_ALIGN = "HEAD_ALIGN";
    private static String PAGE_ADJUST_X = "PAGE_ADJUST_X";
    private static String PAGE_ADJUST_Y = "PAGE_ADJUST_Y";
    private static String PRINT_AREAS = "PRINT_AREAS";
    private static String TOP_TITLES_ROWS = "TOP_TITLES_ROWS";
    private static String LEFT_TITLES_COLUMS = "LEFT_TITLES_COLUMS";
    private static String IS_VER_ECONOMIZE_PAPER = "IS_VER_ECONOMIZE_PAPER";
    private static String IS_HOR_ECONOMIZE_PAPER = "IS_HOR_ECONOMIZE_PAPER";
    private static String VER_DISTANCE = "VER_DISTANCE";
    private static String HOR_DISTANCE = "HOR_DISTANCE";
    private static String HEAD_DATA = "HEAD_DATA";
    private static String FOOT_DATA = "FOOT_DATA";
    private static String HEAD_FOOT_ROW = "HeadFootRow";

    public static String toXml(PrintSetup ps) {
        List footDataList;
        IXmlElement rootElement = XmlUtil.createNode((String)PRINT_SETUP);
        rootElement.setAttribute(HAS_ROW_HEAD, Boolean.toString(ps.hasRowHead()));
        rootElement.setAttribute(HAS_COL_HEAD, Boolean.toString(ps.hasColHead()));
        rootElement.setAttribute(HAS_GRID, Boolean.toString(ps.hasGrid()));
        rootElement.setAttribute(IS_BLACK_WHITE, Boolean.toString(ps.isBlackWhite()));
        rootElement.setAttribute(IS_LAND_SCAPE, Boolean.toString(ps.isLandScape()));
        rootElement.setAttribute(IS_ROW_FIRST, Boolean.toString(ps.isRowFirst()));
        rootElement.setAttribute(AUTO_FIT, Boolean.toString(ps.isAutoFit()));
        rootElement.setAttribute(CENTER_HORIZONTAL, String.valueOf(ps.getCenterHorizontal()));
        rootElement.setAttribute(CENTER_VERTICAL, String.valueOf(ps.getCenterVertical()));
        rootElement.setAttribute(TOP_MARGIN, String.valueOf(ps.getTopMargin()));
        rootElement.setAttribute(BOTTOM_MARGIN, String.valueOf(ps.getBottomMargin()));
        rootElement.setAttribute(LEFT_MARGIN, String.valueOf(ps.getLeftMargin()));
        rootElement.setAttribute(RIGHT_MARGIN, String.valueOf(ps.getRightMargin()));
        rootElement.setAttribute(HEAD_MARGIN, String.valueOf(ps.getHeadMargin()));
        rootElement.setAttribute(FOOT_MARGIN, String.valueOf(ps.getFootMargin()));
        rootElement.setAttribute(PAGESIZE_INDEX, String.valueOf(ps.getPagesizeIndex()));
        rootElement.setAttribute(PAGESIZE_X, String.valueOf(ps.getPagesizeX()));
        rootElement.setAttribute(PAGESIZE_Y, String.valueOf(ps.getPagesizeY()));
        rootElement.setAttribute(SCALE, String.valueOf(ps.getScale()));
        rootElement.setAttribute(AUTO_FIT_HEIGHT, String.valueOf(ps.getAutoFitHeight()));
        rootElement.setAttribute(AUTO_FIT_WIDTH, String.valueOf(ps.getAutoFitWidth()));
        rootElement.setAttribute(FOOT_ALIGN, String.valueOf(ps.getFootAlign()));
        rootElement.setAttribute(HEAD_ALIGN, String.valueOf(ps.getHeadAlign()));
        rootElement.setAttribute(PAGE_ADJUST_X, String.valueOf(ps.getPageAdjustX()));
        rootElement.setAttribute(PAGE_ADJUST_Y, String.valueOf(ps.getPageAdjustY()));
        rootElement.setAttribute(PRINT_AREAS, ps.getPrintAreas() == null ? "" : ps.getPrintAreas());
        rootElement.setAttribute(TOP_TITLES_ROWS, ps.getTopTitleRows() == null ? "" : ps.getTopTitleRows());
        rootElement.setAttribute(LEFT_TITLES_COLUMS, ps.getLeftTitleColumns() == null ? "" : ps.getLeftTitleColumns());
        rootElement.setAttribute(IS_VER_ECONOMIZE_PAPER, Boolean.toString(ps.isVerEconomizePaper()));
        rootElement.setAttribute(IS_HOR_ECONOMIZE_PAPER, Boolean.toString(ps.isHorEconomizePaper()));
        rootElement.setAttribute(VER_DISTANCE, String.valueOf(ps.getVerSpace()));
        rootElement.setAttribute(HOR_DISTANCE, String.valueOf(ps.getHorSpace()));
        List headDataList = ps.getHeadData();
        if (headDataList != null) {
            IXmlElement headData = XmlUtil.createNode((String)HEAD_DATA);
            ListIterator it = headDataList.listIterator();
            int i = 0;
            while (it.hasNext()) {
                HeadFootRow row = (HeadFootRow)it.next();
                if (row.getSA() == null) {
                    row.setSA(Styles.getDefaultSA());
                }
                headData.addChild(row.writeToXmlNode("row" + ++i));
            }
            rootElement.addChild(headData);
        }
        if ((footDataList = ps.getFootData()) != null) {
            IXmlElement footData = XmlUtil.createNode((String)FOOT_DATA);
            ListIterator it = footDataList.listIterator();
            int i = 0;
            while (it.hasNext()) {
                HeadFootRow row = (HeadFootRow)it.next();
                if (row.getSA() == null) {
                    row.setSA(Styles.getDefaultSA());
                }
                footData.addChild(row.writeToXmlNode("row" + ++i));
            }
            rootElement.addChild(footData);
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            XmlUtil.save((IXmlElement)rootElement, (OutputStream)stream);
            return stream.toString("UTF-8");
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }

    public static PrintSetup fromXml(String xml) {
        byte[] bytes = null;
        try {
            bytes = xml.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            logger.error((Object)"err", (Throwable)e1);
            return new PrintSetup();
        }
        PrintSetup ps = new PrintSetup();
        ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
        try {
            IXmlElement foot;
            IXmlElement rootElement = XmlUtil.loadRootElement((InputStream)stream);
            ps.setHasRowHead(PrintSetupUtil.getBooleanAttr(HAS_ROW_HEAD, rootElement));
            ps.setHasColHead(PrintSetupUtil.getBooleanAttr(HAS_COL_HEAD, rootElement));
            ps.setHasGrid(PrintSetupUtil.getBooleanAttr(HAS_GRID, rootElement));
            ps.setBlackWhite(PrintSetupUtil.getBooleanAttr(IS_BLACK_WHITE, rootElement));
            ps.setLandScape(PrintSetupUtil.getBooleanAttr(IS_LAND_SCAPE, rootElement));
            ps.setRowFirst(PrintSetupUtil.getBooleanAttr(IS_ROW_FIRST, rootElement));
            ps.setAutoFit(PrintSetupUtil.getBooleanAttr(AUTO_FIT, rootElement));
            ps.setCenterHorizontal(PrintSetupUtil.getIntAttr(CENTER_HORIZONTAL, rootElement));
            ps.setCenterVertical(PrintSetupUtil.getIntAttr(CENTER_VERTICAL, rootElement));
            ps.setTopMargin(PrintSetupUtil.getFloatAttr(TOP_MARGIN, rootElement));
            ps.setBottomMargin(PrintSetupUtil.getFloatAttr(BOTTOM_MARGIN, rootElement));
            ps.setLeftMargin(PrintSetupUtil.getFloatAttr(LEFT_MARGIN, rootElement));
            ps.setRightMargin(PrintSetupUtil.getFloatAttr(RIGHT_MARGIN, rootElement));
            ps.setHeadMargin(PrintSetupUtil.getFloatAttr(HEAD_MARGIN, rootElement));
            ps.setFootMargin(PrintSetupUtil.getFloatAttr(FOOT_MARGIN, rootElement));
            ps.setPagesizeIndex(PrintSetupUtil.getIntAttr(PAGESIZE_INDEX, rootElement));
            ps.setPagesizeX(PrintSetupUtil.getFloatAttr(PAGESIZE_X, rootElement));
            ps.setPagesizeY(PrintSetupUtil.getFloatAttr(PAGESIZE_Y, rootElement));
            ps.setScale(PrintSetupUtil.getIntAttr(SCALE, rootElement));
            ps.setAutoFitHeight(PrintSetupUtil.getIntAttr(AUTO_FIT_HEIGHT, rootElement));
            ps.setAutoFitWidth(PrintSetupUtil.getIntAttr(AUTO_FIT_WIDTH, rootElement));
            ps.setFootAlign(PrintSetupUtil.getIntAttr(FOOT_ALIGN, rootElement));
            ps.setHeadAlign(PrintSetupUtil.getIntAttr(HEAD_ALIGN, rootElement));
            ps.setPageAdjustX(PrintSetupUtil.getFloatAttr(PAGE_ADJUST_X, rootElement));
            ps.setPageAdjustY(PrintSetupUtil.getFloatAttr(PAGE_ADJUST_Y, rootElement));
            ps.setPrintAreas(rootElement.getAttribute(PRINT_AREAS));
            ps.setTopTitleRows(rootElement.getAttribute(TOP_TITLES_ROWS));
            ps.setLeftTitleColumns(rootElement.getAttribute(LEFT_TITLES_COLUMS));
            ps.setVerEconomizePaper(PrintSetupUtil.getBooleanAttr(IS_VER_ECONOMIZE_PAPER, rootElement));
            ps.setHorEconomizePaper(PrintSetupUtil.getBooleanAttr(IS_HOR_ECONOMIZE_PAPER, rootElement));
            ps.setVerSpace(PrintSetupUtil.getIntAttr(VER_DISTANCE, rootElement));
            ps.setHorSpace(PrintSetupUtil.getIntAttr(HOR_DISTANCE, rootElement));
            IXmlElement head = rootElement.getChild(HEAD_DATA);
            if (head != null) {
                ArrayList<HeadFootRow> newList = new ArrayList<HeadFootRow>();
                Iterator rowsIt = head.searchChildren(HEAD_FOOT_ROW).iterator();
                while (rowsIt.hasNext()) {
                    HeadFootRow row = new HeadFootRow();
                    if (!row.readFromXmlNode((IXmlElement)rowsIt.next())) continue;
                    newList.add(row);
                }
                ps.setHeadData(newList);
            }
            if ((foot = rootElement.getChild(FOOT_DATA)) != null) {
                ArrayList<HeadFootRow> newList = new ArrayList<HeadFootRow>();
                Iterator rowsIt = foot.searchChildren(HEAD_FOOT_ROW).iterator();
                while (rowsIt.hasNext()) {
                    HeadFootRow row = new HeadFootRow();
                    if (!row.readFromXmlNode((IXmlElement)rowsIt.next())) continue;
                    newList.add(row);
                }
                ps.setFootData(newList);
            }
        }
        catch (Exception e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return ps;
    }

    private static boolean getBooleanAttr(String key, IXmlElement element) {
        return Boolean.parseBoolean(element.getAttribute(key));
    }

    private static float getFloatAttr(String key, IXmlElement element) {
        return Float.parseFloat(element.getAttribute(key));
    }

    private static int getIntAttr(String key, IXmlElement element) {
        return Integer.parseInt(element.getAttribute(key));
    }

    public static boolean checkPrintSchemeInfo(PrintSetup psModel, PrintSetup psSheet) {
        if (psModel == null) {
            return false;
        }
        if (psSheet == null) {
            return true;
        }
        return PrintSetupUtil.isDefPrintSetup(psSheet) || !PrintSetupUtil.isChange(psModel, psSheet);
    }

    private static boolean isDefPrintSetup(PrintSetup ps) {
        PrintSetup psDef = new PrintSetup();
        return !PrintSetupUtil.isChange(psDef, ps);
    }

    private static boolean isChange(PrintSetup psModel, PrintSetup psSheet) {
        if (psModel.getAutoFitHeight() != psSheet.getAutoFitHeight() || psModel.getAutoFitWidth() != psSheet.getAutoFitWidth() || psModel.getBottomMargin() != psSheet.getBottomMargin() || psModel.getCenterHorizontal() != psSheet.getCenterHorizontal() || psModel.getCenterVertical() != psSheet.getCenterVertical() || psModel.getFootAlign() != psSheet.getFootAlign() || psModel.getFootMargin() != psSheet.getFootMargin() || psModel.getHeadAlign() != psSheet.getHeadAlign() || psModel.getHeadMargin() != psSheet.getHeadMargin() || psModel.getLeftMargin() != psSheet.getLeftMargin() || psModel.getPageAdjustX() != psSheet.getPageAdjustX() || psModel.getPageAdjustY() != psSheet.getPageAdjustY() || psModel.getPagesizeIndex() != psSheet.getPagesizeIndex() || psModel.getPagesizeX() != psSheet.getPagesizeX() || psModel.getPagesizeY() != psSheet.getPagesizeY() || psModel.getRightMargin() != psSheet.getRightMargin() || psModel.getScale() != psSheet.getScale() | psModel.getTopMargin() != psSheet.getTopMargin() || psModel.isAutoFit() != psSheet.isAutoFit() || psModel.isBlackWhite() != psSheet.isBlackWhite() || psModel.isLandScape() != psSheet.isLandScape() || psModel.isRowFirst() != psSheet.isRowFirst() || psModel.hasColHead() != psSheet.hasColHead() || psModel.hasGrid() != psSheet.hasGrid() || psModel.hasRowHead() != psSheet.hasRowHead()) {
            return true;
        }
        List modelHead = psModel.getHeadData();
        List sheetHead = psSheet.getHeadData();
        if (modelHead == null && sheetHead != null || modelHead != null && sheetHead == null) {
            return true;
        }
        if (modelHead != null && sheetHead != null) {
            if (modelHead.size() != sheetHead.size()) {
                return true;
            }
            for (int i = 0; i < modelHead.size(); ++i) {
                if (modelHead.get(i) == null && sheetHead.get(i) != null) {
                    return true;
                }
                if (modelHead.get(i) == null || modelHead.get(i).equals(sheetHead.get(i))) continue;
                return true;
            }
        }
        List modelFoot = psModel.getFootData();
        List sheetFoot = psSheet.getFootData();
        if (modelFoot == null && sheetFoot != null || modelFoot != null && sheetFoot == null) {
            return true;
        }
        if (modelFoot != null && sheetFoot != null) {
            if (modelFoot.size() != sheetFoot.size()) {
                return true;
            }
            for (int i = 0; i < modelFoot.size(); ++i) {
                if (modelFoot.get(i) == null && sheetFoot.get(i) != null) {
                    return true;
                }
                if (modelFoot.get(i) == null || modelFoot.get(i).equals(sheetFoot.get(i))) continue;
                return true;
            }
        }
        return false;
    }
}

