/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedUserObjectArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.util.AbstractIntMarkArray;
import com.kingdee.cosmic.ctrl.kds.model.util.IntMarkEntry;

public class Row
extends AbstractIntMarkArray
implements IntMarkEntry {
    public static final int ROWTYPE_TABLE_HEADER = 1;
    public static final int ROWTYPE_PAGE_HEADER = 2;
    public static final int ROWTYPE_NORMAL = 3;
    public static final int ROWTYPE_PAGE_FOOTER = 4;
    public static final int ROWTYPE_TABLE_FOOTER = 5;
    private Sheet _sheet;
    private int _row;
    private int _type;
    private SortedUserObjectArray _userObjects;

    public Row(Sheet sheet, int row) {
        this._sheet = sheet;
        this._row = row;
        this._type = 3;
    }

    public Cell getCell(int col, boolean bCreatIfEmpty) {
        Cell cll = null;
        int pos = this.search(col);
        if (pos >= 0) {
            cll = (Cell)this._array[pos];
        } else if (bCreatIfEmpty) {
            cll = Cell.getNewCell(this, this._sheet.getColumn(col, true));
            this.insert(cll, pos);
        }
        return cll;
    }

    public Cell getAt(int index) {
        return (Cell)this._array[index];
    }

    public boolean isEmpty() {
        return this.isEmptyContent() && this.isEmptyAttribute();
    }

    public int getType() {
        return this._type;
    }

    public boolean isEmptyAttribute() {
        return this._sheet.getRowSpans().searchSpan(this._row) < 0;
    }

    public boolean isEmptyContent() {
        return this.size() == 0 && (this._userObjects == null || this._userObjects.size() == 0);
    }

    public UserObject getUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.getUserObject(key);
        }
        return null;
    }

    public Object getUserObjectValue(String key) {
        UserObject uo;
        if (this._userObjects != null && (uo = this._userObjects.getUserObject(key)) != null) {
            return uo.getValue();
        }
        return null;
    }

    public UserObject setUserObject(String key, Object obj) {
        UserObject uo = new UserObject(key, obj);
        if (this._userObjects == null) {
            this._userObjects = new SortedUserObjectArray();
        }
        return (UserObject)this._userObjects.insert(uo);
    }

    public UserObject removeUserObject(String key) {
        if (this._userObjects != null) {
            return this._userObjects.removeByKey(key);
        }
        return null;
    }

    public SortedUserObjectArray getUserObjects() {
        return this._userObjects;
    }

    @Override
    public String toString() {
        return SheetBaseMath.getRowName(this._row, 0, true, true);
    }

    public Sheet.ICellsIterator getCellsIterator(int col, int col2, boolean bDescend, boolean forContentCell) {
        if (forContentCell) {
            return new ContentCellsIterator(col, col2, bDescend);
        }
        return new CellsIterator(col, col2, bDescend);
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    @Override
    public int getIntMark() {
        return this._row;
    }

    @Override
    public void setIntMark(int row) {
        this._row = row;
    }

    public int getRow() {
        return this._row;
    }

    @Override
    protected int getIndexLimit() {
        return 65535;
    }

    public void setDelete(boolean bDelete) {
        for (int i = 0; i < this._count; ++i) {
            Cell cll = (Cell)this._array[i];
            cll.setDeleted(bDelete);
            if (!bDelete) continue;
            cll.queue();
        }
    }

    public Cell insert(Cell cll) {
        cll.setRowObject(this);
        cll.setDeleted(false);
        cll.setQueued(false);
        cll.updateStyle();
        cll.queue();
        return (Cell)super.insert(cll);
    }

    public void insertCell(Cell cll, int col) {
        if (cll == null) {
            return;
        }
        cll.setColObject(this._sheet.getColumn(col, true));
        this.insert(cll);
    }

    @Override
    public int insert(IntMarkEntry[] aIns) {
        if (aIns != null) {
            for (int i = 0; i < aIns.length; ++i) {
                Cell cll = (Cell)aIns[i];
                cll.setRowObject(this);
                cll.setDeleted(false);
                cll.setQueued(false);
                cll.updateStyle();
                cll.queue();
            }
        }
        return super.insert(aIns);
    }

    @Override
    public IntMarkEntry[] insert(int from, int to, boolean updateIntMark, boolean bState) {
        boolean queueRefer = this._sheet.getBook().isAutoCalculate();
        Dependents deps = this._sheet.getDeps();
        this.queueAllFrom(from, deps, queueRefer);
        IntMarkEntry[] aOut = super.insert(from, to, updateIntMark, bState);
        if (aOut != null) {
            for (int i = 0; i < aOut.length; ++i) {
                ((Cell)aOut[i]).setDeleted(true);
            }
        }
        this.queueAllFrom(from, deps, queueRefer);
        return aOut;
    }

    private void queueAllFrom(int from, Dependents deps, boolean queueRefer) {
        int pos = this.search(from);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        while (pos < this._count) {
            Cell cll = this.getAt(pos);
            cll.setQueued(false);
            cll.queue(deps, queueRefer);
            ++pos;
        }
    }

    @Override
    public IntMarkEntry[] remove(int from, int to, boolean updateIntMark, boolean bState) {
        IntMarkEntry[] aDels;
        if (from > this.getMaxIntMark()) {
            return null;
        }
        Dependents deps = this._sheet.getDeps();
        boolean queueRefer = this._sheet.getBook().isAutoCalculate();
        boolean queueAll = false;
        if (updateIntMark) {
            int pos2;
            int pos = this.getProperPos(from, false);
            boolean bl = queueAll = pos < (pos2 = this.getProperPos(to, true));
        }
        if (queueAll) {
            this.queueAllFrom(from, deps, queueRefer);
        }
        if ((aDels = super.remove(from, to, updateIntMark, bState)) != null) {
            for (int i = 0; i < aDels.length; ++i) {
                ((Cell)aDels[i]).setDeleted(true);
            }
        }
        if (queueAll) {
            this.queueAllFrom(from, deps, queueRefer);
        }
        return aDels;
    }

    private class CellsIterator
    implements Sheet.ICellsIterator {
        private int _c;
        private int _c2;
        private Cell _cll;
        private boolean _bDescend;

        private CellsIterator(int col, int col2, boolean bDescend) {
            if (col < 0 || col2 < 0) {
                return;
            }
            this._bDescend = bDescend;
            int minCol = Math.min(col, col2);
            int maxCol = Math.max(col, col2);
            this._c = Row.this.getProperPos(bDescend ? maxCol : minCol, bDescend);
            this._c2 = Row.this.getProperPos(bDescend ? minCol : maxCol, !bDescend);
            if (this._bDescend ? this._c >= this._c2 : this._c <= this._c2) {
                this._cll = Row.this.getAt(this._c);
            }
        }

        @Override
        public boolean hasNext() {
            return this._cll != null;
        }

        @Override
        public Cell next() {
            Cell ret = this._cll;
            this._c += this._bDescend ? -1 : 1;
            this._cll = null;
            if (this._bDescend ? this._c >= this._c2 : this._c <= this._c2) {
                this._cll = Row.this.getAt(this._c);
            }
            return ret;
        }

        @Override
        public boolean hasData() {
            boolean flag = false;
            CellsIterator ri = new CellsIterator(this._c, this._c2, this._bDescend);
            while (ri.hasNext()) {
                Cell cell = ri.next();
                if (cell.isEmpty()) continue;
                flag = true;
                break;
            }
            return flag;
        }
    }

    private final class ContentCellsIterator
    implements Sheet.ICellsIterator {
        int col;
        int col2;
        boolean bDescend;
        private CellsIterator _cells;
        private Cell _cll;

        private ContentCellsIterator(int col, int col2, boolean bDescend) {
            this.init(col, col2, bDescend);
        }

        private void init(int col, int col2, boolean bDescend) {
            this.col = col;
            this.col2 = col2;
            this.bDescend = bDescend;
            this._cells = new CellsIterator(col, col2, bDescend);
            this.getNextCell();
        }

        private void getNextCell() {
            this._cll = null;
            while (this._cells.hasNext()) {
                this._cll = this._cells.next();
                if (!this._cll.isEmptyContent()) break;
                this._cll = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this._cll != null;
        }

        @Override
        public Cell next() {
            Cell ret = this._cll;
            this.getNextCell();
            return ret;
        }

        @Override
        public boolean hasData() {
            boolean flag = false;
            CellsIterator ri = new CellsIterator(this.col, this.col2, this.bDescend);
            while (ri.hasNext()) {
                Cell cell = ri.next();
                if (cell.isEmptyContent2()) continue;
                flag = true;
                break;
            }
            return flag;
        }
    }
}

