/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.common.util.CollectionUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.URState;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import java.util.ArrayList;
import java.util.List;

public class SheetAction_AutoFilter_ShowAll
extends SheetAction {
    public SheetAction_AutoFilter_ShowAll(Range rg) {
        super(rg, SheetChangeEvent.Changed_AutoFilter);
        if (rg.size() > 1) {
            throw new IllegalArgumentException("range should not be list");
        }
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        this.showAll(sheet);
        state.setData("AutoFilters", CollectionUtil.cloneList((List)sheet.getAutoFilters()));
        sheet.getAutoFilters().clear();
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        List autoFilters = sheet.getAutoFilters();
        autoFilters.clear();
        autoFilters.addAll((List)state.get("AutoFilters"));
    }

    protected void showAll(Sheet sheet) {
        if (sheet.getAutoFilterArea() != null) {
            ArrayList<Integer> list = AlgorithmUtil.getBeforeFilterArea(sheet, -1);
            ArrayList<Integer> showRows = new ArrayList<Integer>();
            for (int index : list) {
                if (!SheetBaseMath.isHideRow(sheet, index)) continue;
                showRows.add(index);
            }
            AlgorithmUtil.showRow(sheet, showRows, false);
            if (showRows.size() > 0) {
                sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_Resize);
                sheet.calc();
            }
        }
    }
}

