/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargetProperties;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.KDClipboard;
import com.kingdee.cosmic.ctrl.kds.model.struct.LinkPasteInfo;
import com.kingdee.cosmic.ctrl.kds.model.struct.MergeBlocks;
import com.kingdee.cosmic.ctrl.kds.model.struct.PasteMode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Protection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Row;
import com.kingdee.cosmic.ctrl.kds.model.struct.Selection;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedRowArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedSpanArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Span;
import com.kingdee.cosmic.ctrl.kds.model.struct.URState;
import com.kingdee.cosmic.ctrl.kds.model.struct.cformat.ConditionalFormatList;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedIntArray;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedSheetArray;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SheetAction_Paste
extends SheetAction {
    private URState _sheetState;
    private Sheet[] _srcSheets;
    private Sheet _srcSheet;
    private SortedCellBlockArray _sel;
    private CellBlock _blockInfo;
    private PasteMode _mode;
    private String[] _userKeys;
    private LinkPasteInfo _linkInfo;

    public SheetAction_Paste(Range rg, Book srcBook, SortedCellBlockArray sel, CellBlock blockInfo, PasteMode mode, String[] userKeys) {
        super(rg, SheetChangeEvent.Changed_Content | SheetChangeEvent.Changed_Style);
        int srcSheetCount = srcBook.getSheetCount();
        this._srcSheets = new Sheet[srcSheetCount];
        for (int i = 0; i < srcSheetCount; ++i) {
            this._srcSheets[i] = srcBook.getSheet(i);
        }
        this._sel = sel;
        this._blockInfo = blockInfo;
        this._mode = mode;
        this._userKeys = userKeys;
        if (mode.touchFlag(PasteMode.Link)) {
            this._linkInfo = new LinkPasteInfo(KDClipboard.getSourceSheets(), KDClipboard.getSourceSelection());
        }
    }

    private Sheet getSourceSheet(Sheet dstSheet) {
        SortedSheetArray sheets = this._rg._sheets;
        int size = sheets.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            if (sheets.getSheet(i) != dstSheet) continue;
            index = i;
            break;
        }
        return this._srcSheets[index];
    }

    @Override
    protected void preActionBlock(Sheet sheet, CellBlock cb, boolean enableUndo) {
        this._srcSheet = this.getSourceSheet(sheet);
        this._sheetState = this.pasteSheetProps(enableUndo, this._srcSheet, sheet, cb, this._sel, this._blockInfo, this._mode);
    }

    @Override
    protected void preResumeBlock(Sheet sheet, CellBlock cb, boolean enableUndo) {
        if (this._sheetState != null) {
            this.resumePasteSheetProps(this._sheetState, sheet, cb);
            this._sheetState = null;
        }
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        int top;
        boolean pasteMerge = this._mode.touchFlag(PasteMode.MergeBlock);
        boolean pasteFormat = this._mode.touchFlag(PasteMode.Style);
        MergeBlocks dstMerger = sheet.getMerger(pasteMerge);
        if (pasteMerge) {
            SortedCellBlockArray coverdMergeBlocks;
            SortedCellBlockArray sortedCellBlockArray = coverdMergeBlocks = dstMerger == null ? null : dstMerger.getContainedBlocks(cb);
            if (coverdMergeBlocks != null) {
                if (state != null) {
                    state.setData("MERGE_BLOCKS", coverdMergeBlocks);
                }
                dstMerger.remove(coverdMergeBlocks);
            }
        }
        SortedCellBlockArray srcMergeBlocks = this.getPasteMergeInfo(this._srcSheet, this._sel, this._blockInfo, this._mode, this._linkInfo);
        int row = cb.getRow();
        int row2 = cb.getRow2();
        int col = cb.getCol();
        int col2 = cb.getCol2();
        int compactRows = this._blockInfo.getRow2();
        int compactCols = this._blockInfo.getCol2();
        CellBlock srcFirstBlock = this._sel.getBlock(0);
        int srcBlockCount = this._sel.size();
        for (int srcIndex = 0; srcIndex < srcBlockCount; ++srcIndex) {
            CellBlock srcBlock = this._sel.getBlock(srcIndex);
            int offsetX = srcBlock.getCol() - srcFirstBlock.getCol();
            int offsetY = srcBlock.getRow() - srcFirstBlock.getRow();
            int height = srcBlock.getHeight();
            int width = srcBlock.getWidth();
            for (int top2 = row; top2 <= row2; top2 += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    int r = top2 + offsetY;
                    int c = left + offsetX;
                    CellBlock dstBlock = CellBlock.getCellBlock(r, c, r + height - 1, c + width - 1);
                    this.pasteBlock(state, this._srcSheet, sheet, this._sel, this._mode, this._userKeys, srcIndex, dstBlock, this._linkInfo);
                }
            }
        }
        ConditionalFormatList srcFormats = this._srcSheet.getConditionalFormats();
        if (pasteFormat && srcFormats.size() > 0) {
            for (int top3 = row; top3 <= row2; top3 += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    sheet.getConditionalFormats().merge(srcFormats, top3, left);
                }
            }
        }
        ValidationList srcValidations = this._srcSheet.getValidations();
        if (this._mode.touchFlag(PasteMode.Validation) && srcValidations.size() > 0) {
            for (top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    sheet.getValidations().merge(sheet, srcValidations, top, left);
                }
            }
        }
        if (pasteFormat && srcMergeBlocks.size() > 0) {
            for (top = row; top <= row2; top += compactRows) {
                for (int left = col; left <= col2; left += compactCols) {
                    int size = srcMergeBlocks.size();
                    for (int i = 0; i < size; ++i) {
                        CellBlock block = CellBlock.getCellBlock(srcMergeBlocks.getBlock(i));
                        block.offset(top, left);
                        if (dstMerger != null) {
                            dstMerger.insert(block);
                        }
                        this.clearCoveredCells(sheet, block);
                    }
                }
            }
        }
        this.checkedAutoFilter(sheet, state);
    }

    private void checkedAutoFilter(Sheet sheet, URState state) {
        CellBlock autoFilterArea = sheet.getAutoFilterArea();
        if (autoFilterArea == null) {
            return;
        }
        CellBlock newArea = new CellBlock(autoFilterArea);
        SheetBaseMath.unCancerizeCellBlock(sheet, newArea);
        if (newArea.getCol() == -1 || newArea.getCol2() == -1 || newArea.getRow() == -1 || newArea.getRow2() == -1) {
            this.colseAutoFilter(sheet, state, autoFilterArea);
            return;
        }
        SheetBaseMath.cancerizeCellBlock(sheet, newArea, false, true, false);
        state.setData("AutoFilterArea", sheet.getAutoFilterArea());
        sheet.setAutoFilterArea(newArea);
        sheet.getBook().fireSheetChange(sheet, null, SheetChangeEvent.Changed_AutoFilter);
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        SortedCellBlockArray coverdMergeBlocks;
        MergeBlocks merger;
        boolean justLink = this._mode.touchFlag(PasteMode.Link);
        ObjectArray clls = (ObjectArray)state.get("CELL_OBJ");
        if (clls != null) {
            ObjectArray values = (ObjectArray)state.get("CELL_VALUE");
            for (int i = clls.size() - 1; i >= 0; --i) {
                Cell props = (Cell)clls.get(i);
                Cell dstCell = sheet.getCell(props.getRow(), props.getCol(), true);
                if (justLink) {
                    dstCell.setVar(values.get(i));
                    continue;
                }
                dstCell.resumeCopyFrom(props, this._mode, this._userKeys);
            }
        }
        if ((merger = sheet.getMerger(false)) != null) {
            merger.remove(merger.getContainedBlocks(cb));
        }
        if ((coverdMergeBlocks = (SortedCellBlockArray)state.get("MERGE_BLOCKS")) != null) {
            sheet.getMerger(true).addAll(coverdMergeBlocks);
        }
        this.resumeAutoFilter(sheet, state);
    }

    private SortedCellBlockArray getPasteMergeInfo(Sheet srcSheet, SortedCellBlockArray srcSelect, CellBlock blockInfo, PasteMode mode, LinkPasteInfo linkInfo) {
        boolean justLink = mode.touchFlag(PasteMode.Link);
        MergeBlocks srcMerger = justLink ? linkInfo.getSourceSheet(srcSheet.getSheetName()).getMerger(false) : srcSheet.getMerger(false);
        SortedCellBlockArray srcMergeBlocks = new SortedCellBlockArray();
        if (mode.touchFlag(PasteMode.Style) && !justLink) {
            int blockRows = blockInfo.getRow();
            int blockCols = blockInfo.getCol();
            CellBlock srcFirstBlock = srcSelect.getBlock(0);
            int row = srcFirstBlock.getRow();
            for (int rBlock = 0; rBlock < blockRows; ++rBlock) {
                CellBlock block = null;
                int srcLeftIndex = rBlock * blockCols;
                int col = srcFirstBlock.getCol();
                for (int cBlock = 0; cBlock < blockCols; ++cBlock) {
                    SortedCellBlockArray mergeBlocks;
                    block = srcSelect.getBlock(srcLeftIndex + cBlock);
                    SortedCellBlockArray sortedCellBlockArray = mergeBlocks = srcMerger == null ? null : srcMerger.getContainedBlocks(block);
                    if (mergeBlocks != null) {
                        int offetY = -srcFirstBlock.getRow() + (row - block.getRow());
                        int offetX = -srcFirstBlock.getCol() + (col - block.getCol());
                        int size = mergeBlocks.size();
                        for (int i = 0; i < size; ++i) {
                            CellBlock cb = CellBlock.getCellBlock(mergeBlocks.getBlock(i));
                            cb.offset(offetY, offetX);
                            srcMergeBlocks.insert(cb);
                        }
                    }
                    if (null == block) continue;
                    col += block.getWidth();
                }
                if (null == block) continue;
                row += block.getHeight();
            }
        }
        return srcMergeBlocks;
    }

    private void pasteBlock(URState state, Sheet srcSheet, Sheet sheet, SortedCellBlockArray srcSelect, PasteMode mode, String[] userKeys, int srcBlockIndex, CellBlock dstBlock, LinkPasteInfo linkInfo) {
        if (srcSelect.size() == 1 && srcSelect.getBlock(0).isWholeSheet()) {
            int destMaxRow = sheet.getMaxRowIndex();
            int destMaxCol = sheet.getMaxColIndex();
            int srcMaxRow = srcSheet.getMaxRowIndex();
            int srcMaxCol = srcSheet.getMaxColIndex();
            int maxRow = destMaxRow > srcMaxRow ? destMaxRow : srcMaxRow;
            int maxCol = destMaxCol > srcMaxCol ? destMaxCol : srcMaxCol;
            srcSelect.getBlock(0).setRowCol(0, 0, maxRow, maxCol);
            dstBlock.setRowCol(0, 0, maxRow, maxCol);
        }
        if (mode.touchFlag(PasteMode.Link)) {
            this.pasteBlockLink(state, srcSheet, sheet, srcBlockIndex, dstBlock, linkInfo);
        } else {
            int pos;
            CellBlock srcBlock = srcSelect.getBlock(srcBlockIndex);
            int dstTop = dstBlock.getRow();
            int dstLeft = dstBlock.getCol();
            int dstRight = dstBlock.getCol2();
            int srcTop = srcBlock.getRow();
            int srcLeft = srcBlock.getCol();
            int srcRight = srcBlock.getCol2();
            boolean skipBlank = mode.touchFlag(PasteMode.SkipBlanks);
            boolean pasteFormat = mode.touchFlag(PasteMode.Style);
            int rowIdx = 0;
            int colIdx = 0;
            SortedIntArray sia = new SortedIntArray();
            SortedRowArray srcRows = srcSheet.getRows();
            int pos2 = srcRows.getProperPos(srcBlock.getRow2(), true);
            for (pos = srcRows.getProperPos(srcTop, false); pos <= pos2; ++pos) {
                sia.insert(srcRows.getAt(pos).getRow() - srcTop);
            }
            SortedRowArray dstRows = sheet.getRows();
            pos2 = dstRows.getProperPos(dstBlock.getRow2(), true);
            for (pos = dstRows.getProperPos(dstTop, false); pos <= pos2; ++pos) {
                sia.insert(dstRows.getAt(pos).getRow() - dstTop);
            }
            if (pasteFormat) {
                int r;
                int end;
                SortedAttributeSpanArray.AttributeSpan span;
                int i;
                SortedAttributeSpanArray sa = srcSheet.getRowSpans().getSpecifiedAttributeSpansClone(srcBlock.getRow(), srcBlock.getRow2());
                int size = sa.size();
                for (i = 0; i < size; ++i) {
                    span = sa.getAttributeSpan(i);
                    end = span.getEnd();
                    for (r = span.getStart(); r <= end; ++r) {
                        if (srcSheet.getRow(r - srcTop, false) == null) continue;
                        sia.insert(r - srcTop);
                    }
                }
                sa = sheet.getRowSpans().getSpecifiedAttributeSpansClone(dstBlock.getRow(), dstBlock.getRow2());
                size = sa.size();
                for (i = 0; i < size; ++i) {
                    span = sa.getAttributeSpan(i);
                    end = span.getEnd();
                    for (r = span.getStart(); r <= end; ++r) {
                        if (srcSheet.getRow(r - srcTop, false) == null) continue;
                        sia.insert(r - dstTop);
                    }
                }
            }
            boolean bState = state != null;
            ObjectArray clls = bState ? (ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, null) : null;
            boolean protectedhidedrows = SheetBaseMath.isSecuritySheet(srcSheet);
            int[] secRows = srcSheet.getSecHidedRows();
            int[] secCols = srcSheet.getSecHidedCols();
            HashMap<String, Cell> subCellMap = new HashMap<String, Cell>(sia.size());
            ArrayList<Cell> dstCells = new ArrayList<Cell>(sia.size());
            int size = sia.size();
            for (int ai = 0; ai < size; ++ai) {
                int r = sia.getAt(ai);
                int dstRow = dstTop + r - rowIdx;
                int srcRow = srcTop + r;
                Row srcRowObj = srcSheet.getRow(srcRow, false);
                if (protectedhidedrows && srcRowObj != null && AlgorithmUtil.contain(secRows, srcRowObj.getRow())) {
                    ++rowIdx;
                    continue;
                }
                int pos3 = 0;
                int pos22 = -1;
                if (srcRowObj != null) {
                    pos3 = srcRowObj.getProperPos(srcLeft, false);
                    pos22 = srcRowObj.getProperPos(srcRight, true);
                }
                if (pos3 <= pos22) {
                    Row dstRowObj = this.getStateRow(state, sheet, dstRow);
                    int srcPos = srcRowObj.getAt(pos3).getCol() - srcLeft;
                    if (srcPos > 0 && !skipBlank) {
                        this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft, dstRow, dstLeft, dstLeft + srcPos - 1);
                    }
                    int dstPos = 0;
                    colIdx = 0;
                    while (pos3 <= pos22) {
                        srcPos = srcRowObj.getAt(pos3).getCol() - srcLeft;
                        Cell srcCell = srcRowObj.getAt(pos3);
                        if (protectedhidedrows && AlgorithmUtil.contain(secCols, srcCell.getCol())) {
                            ++colIdx;
                        } else {
                            if (dstPos < srcPos) {
                                if (!skipBlank) {
                                    this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft + dstPos, dstRow, dstLeft + dstPos, dstLeft + srcPos - 1);
                                }
                                dstPos = srcPos;
                            }
                            Cell dstCell = this.getStateCell(state, sheet, dstRowObj, dstLeft + dstPos++ - colIdx);
                            Protection pro = sheet.getSheetOption().getProtection(false);
                            boolean bProtected = pro != null && pro.isProtected();
                            Cell copied = dstCell.copyFrom(srcCell, mode, true, userKeys, bProtected);
                            dstCells.add(dstCell);
                            if (dstCell.getSubReportInfo() != null) {
                                sheet.addSubReportCell(dstCell);
                                subCellMap.put(srcCell.getName(false, true), dstCell);
                            }
                            if (bState && copied != null) {
                                clls.append(copied);
                            }
                        }
                        ++pos3;
                    }
                    srcPos = srcRowObj.getAt(pos22).getCol() - srcLeft;
                    if (dstLeft + srcPos >= dstRight || skipBlank) continue;
                    this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft + srcPos + 1, dstRow, dstLeft + srcPos + 1, dstRight);
                    continue;
                }
                if (skipBlank) continue;
                this.pasteEmptyCells(state, srcSheet, sheet, mode, userKeys, srcRow, srcLeft, dstRow, dstLeft, dstRight);
            }
            this.handleInnerLinkCells(dstCells, subCellMap);
            CellBlock cllBlk = sheet.getSelectionRange().getBounds();
            Selection sel = sheet.getSheetOption().getSelection();
            sel.changeSelection(CellBlock.getCellBlock(cllBlk.getRow(), cllBlk.getCol(), cllBlk.getRow2() - rowIdx, cllBlk.getCol2() - colIdx), sel.getSelectMode());
        }
    }

    private void pasteEmptyCells(URState state, Sheet srcSheet, Sheet sheet, PasteMode mode, String[] userKeys, int srcRow, int srcCol, int dstRow, int dstCol, int dstCol2) {
        int pos2;
        Protection pro = sheet.getSheetOption().getProtection(false);
        boolean bProtected = pro != null && pro.isProtected();
        boolean bState = state != null;
        ObjectArray clls = bState ? (ObjectArray)state.getData("CELL_OBJ", ObjectArray.class, null) : null;
        Row dstRowObj = this.getStateRow(state, sheet, dstRow);
        int pos = dstRowObj.getProperPos(dstCol, false);
        if (pos <= (pos2 = dstRowObj.getProperPos(dstCol2, true))) {
            boolean bFormulas = mode.touchFlag(PasteMode.Formulas);
            boolean bValues = mode.touchFlag(PasteMode.Values);
            boolean bStyles = mode.touchFlag(PasteMode.Formats);
            boolean bComments = mode.touchFlag(PasteMode.Comments);
            while (pos <= pos2) {
                Cell dstCell = dstRowObj.getAt(pos);
                Cell props = dstCell.clear(bFormulas, bValues, bStyles, bComments, userKeys);
                if (props != null) {
                    dstCell.copyStyle(srcSheet.getCellStyle(srcRow, srcCol + (dstCell.getCol() - dstCol)), null, mode, null, bProtected);
                    if (bState) {
                        clls.append(props);
                    }
                }
                ++pos;
            }
            if (dstCol == dstCol2) {
                return;
            }
        }
        for (int col = dstCol; col <= dstCol2; ++col) {
            Style dstStyle;
            Style srcStyle;
            if (dstRowObj.getCell(col, false) != null || (srcStyle = srcSheet.getCellStyle(srcRow, srcCol + (col - dstCol))) == (dstStyle = sheet.getCellStyle(dstRow, col))) continue;
            Cell dstCell = this.getStateCell(state, sheet, dstRowObj, col);
            dstCell.copyStyle(srcStyle, null, mode, null, bProtected);
        }
    }

    private void pasteBlockLink(URState state, Sheet srcSheet, Sheet sheet, int srcBlockIndex, CellBlock dstBlock, LinkPasteInfo linkInfo) {
        String formulaPrefix = "";
        Sheet sheetFrom = linkInfo.getSourceSheet(srcSheet.getSheetName());
        formulaPrefix = sheetFrom == null || sheetFrom.getBook() == sheet.getBook() ? "=" : "=[" + sheetFrom.getBook().getName() + "]";
        if (sheetFrom != null && sheetFrom != sheet) {
            formulaPrefix = formulaPrefix + sheetFrom.getSyntaxName() + "!";
        }
        CellBlock srcBlock = linkInfo.getSourceSelection().getBlock(srcBlockIndex);
        int height = srcBlock.getHeight();
        int width = srcBlock.getWidth();
        int dstTop = dstBlock.getRow();
        int dstLeft = dstBlock.getCol();
        int srcTop = srcBlock.getRow();
        int srcLeft = srcBlock.getCol();
        for (int r = 0; r < height; ++r) {
            Row dstRowObj = this.getStateRow(state, sheet, dstTop + r);
            int srcRow = srcTop + r;
            for (int c = 0; c < width; ++c) {
                Cell dstCell = this.getStateCell(state, sheet, dstRowObj, dstLeft + c);
                String formula = dstCell.getFormula();
                Variant value = dstCell.getValue();
                if (!StringUtil.isEmptyString((String)formula) || !value.isNull()) {
                    this.setCellState(state, dstCell, formula, value);
                }
                formula = formulaPrefix + SheetBaseMath.getBlockA1Name(srcRow, srcLeft + c, false, false);
                dstCell.setFormula(formula);
            }
        }
    }

    private void clearCoveredCells(Sheet sheet, CellBlock cb) {
        int left = cb.getCol();
        int right = cb.getCol2();
        Row row = sheet.getRow(cb.getRow(), false);
        row.remove(left + 1, right, false, false);
        if (cb.getHeight() > 1) {
            Sheet.RowsIterator ri = sheet.getRowsIterator(cb.getRow() + 1, cb.getRow2(), false);
            while (ri.hasNext()) {
                row = ri.next();
                row.remove(left, right, false, false);
            }
        }
    }

    private void handleInnerLinkCells(List<Cell> dstCells, Map<String, Cell> subCellMap) {
        if (subCellMap == null || subCellMap.isEmpty()) {
            return;
        }
        for (Cell dstCell : dstCells) {
            HyperlinkCalculableProps hyperLinkCalProps;
            Map<String, Object> tars;
            InnerLinkTargets innerLinkTargets;
            SortedExtPropFormulasArray formulas;
            ICalculableProps prop;
            ExtProps dstProps = dstCell.getExtProps(false);
            if (dstProps == null || (prop = (formulas = dstProps.getFormulas(false)).get(ExtConst.FORMULA_HYPERLINK)) == null || (innerLinkTargets = (InnerLinkTargets)(tars = (hyperLinkCalProps = (HyperlinkCalculableProps)prop).getTargets()).get("EXT_INNER")) == null) continue;
            List<InnerLinkTransitionTarget> innerLinkTransitionTargets = innerLinkTargets.getTargets();
            for (InnerLinkTransitionTarget innerLinkTransitionTarget : innerLinkTransitionTargets) {
                Map<String, IParameter> parameterMap;
                InnerLinkTargetProperties innerLinkTargetProperties;
                String linkCellName;
                if (!"subReport".equalsIgnoreCase(innerLinkTransitionTarget.getTargetType()) || subCellMap.get(linkCellName = (innerLinkTargetProperties = innerLinkTransitionTarget.getTargetProps()).getId(dstCell)) == null) continue;
                Cell subCellAfterPaste = subCellMap.get(linkCellName);
                SubReportInfo rptInfo = subCellAfterPaste.getSubReportInfo();
                if (rptInfo != null) {
                    String cellName = subCellAfterPaste.getName(false, true);
                    String alias = "[" + cellName + "]" + rptInfo.getReportProps().getAlias();
                    innerLinkTargetProperties.setId(dstCell, cellName);
                    innerLinkTargetProperties.setName(alias);
                }
                if ((parameterMap = innerLinkTransitionTarget.getParams()) == null) continue;
                for (Map.Entry<String, IParameter> entry : parameterMap.entrySet()) {
                    IParameter parameter = entry.getValue();
                    if (!(parameter instanceof ParameterImpl)) continue;
                    ((ParameterImpl)parameter).setExpr(null);
                }
            }
        }
    }

    public void resumePasteSheetProps(URState state, Sheet sheet, CellBlock cb) {
        HashMap spans;
        if (state.isEmpty()) {
            return;
        }
        state.resumeDeleted();
        ShareStyleAttributes sheetSSA = (ShareStyleAttributes)state.get("SHEET_SSA");
        if (sheetSSA != null) {
            sheet.setSSA(sheetSSA);
        }
        if ((spans = (HashMap)state.get("ROW_SSA")) != null) {
            SortedAttributeSpanArray rowSpans = sheet.getRowSpans();
            for (Map.Entry e : spans.entrySet()) {
                rowSpans.clearStyle((Span)e.getKey(), false);
                rowSpans.setSpans((SortedSpanArray)e.getValue());
            }
        }
        if ((spans = (HashMap)state.get("COL_SSA")) != null) {
            SortedAttributeSpanArray colSpans = sheet.getColSpans();
            for (Map.Entry e : spans.entrySet()) {
                colSpans.clearStyle((Span)e.getKey(), false);
                colSpans.setSpans((SortedSpanArray)e.getValue());
            }
        }
        state.resumeCreated();
    }

    @Override
    public boolean isDone() {
        boolean bDone;
        boolean bl = bDone = this._sheetState != null && !this._sheetState.isEmpty();
        if (!bDone) {
            bDone = super.isDone();
        }
        return bDone;
    }

    @Override
    public String getPresentationName() {
        return CtrlEXTMessages.getMLS("paste", "\u7c98\u8d34") + super.getPresentationName();
    }
}

