/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct;

import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction;
import com.kingdee.cosmic.ctrl.kds.model.struct.URState;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.SheetChangeEvent;

public class SheetAction_Scale
extends SheetAction {
    private int _scale;

    public SheetAction_Scale(Range rg, int scale) {
        super(rg, SheetChangeEvent.Changed_Sheet_Scale);
        this._scale = scale;
    }

    @Override
    protected void actionBlock(URState state, Sheet sheet, CellBlock cb) {
        int old;
        if (sheet.getBook().getActiveSheet() == sheet && (old = sheet.getSheetOption().setScale(this._scale)) > 0) {
            state.setData("Sheet_Scale", old);
        }
    }

    @Override
    protected void resumeBlock(URState state, Sheet sheet, CellBlock cb) {
        Object scale;
        if (sheet.getBook().getActiveSheet() == sheet && (scale = state.get("Sheet_Scale")) != null) {
            sheet.getSheetOption().setScale((Integer)scale);
        }
    }

    @Override
    protected void invalidate(long changedState) {
        Book book = this._rg._sheets.getSheet(0).getBook();
        book.fireSheetChange(book.getActiveSheet(), book.getCellBlockBuffer(), changedState);
    }
}

