/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.kds.model.struct.embed;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.AbstractBookUndoableEdit;
import com.kingdee.cosmic.ctrl.kds.model.struct.Global;
import com.kingdee.cosmic.ctrl.kds.model.struct.ISelectMode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedRange;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.HotSpot;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImageType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.event.GraphChangedEvent;
import com.kingdee.cosmic.ctrl.kds.model.struct.undo.UndoException;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedSheetArray;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class EmbedhLayer
implements ISelectMode {
    private Sheet _sheet;
    private ArrayList _graphs;
    private ArrayList _selGraphs;
    private Rectangle[] _visibleRects;

    public EmbedhLayer(Sheet sheet) {
        this._sheet = sheet;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public EmbedObject getEmbed(int index) {
        return (EmbedObject)this._graphs.get(index);
    }

    public int size() {
        if (this._graphs != null) {
            return this._graphs.size();
        }
        return 0;
    }

    public boolean hasSelection() {
        return this.hasSelectionImpl();
    }

    public boolean addEmbeds(EmbedObject[] graphs) {
        try {
            this._sheet.getBook().getUndoManager().startGroup();
            for (int i = 0; i < graphs.length; ++i) {
                this.addEmbed(graphs[i]);
            }
        }
        finally {
            this._sheet.getBook().getUndoManager().endGroup();
        }
        return true;
    }

    public boolean addEmbed(EmbedObject graph) {
        if (graph == null || this.contains(graph)) {
            return false;
        }
        return new GraphInsActionEdit("Graph_Insert", graph).run();
    }

    public EmbedhLayer copy(Sheet destSheet) {
        if (this._graphs == null || this._graphs.isEmpty()) {
            return null;
        }
        EmbedhLayer layer = new EmbedhLayer(destSheet);
        for (Object embedObject : this._graphs) {
            if (embedObject instanceof EChart) {
                EChart eChart = new EChart(destSheet);
                eChart.copy((ChartRectEmbedment)embedObject);
                layer.addEmbed(eChart);
                continue;
            }
            if (embedObject instanceof QingChart) {
                QingChart qingChart = new QingChart(destSheet);
                qingChart.copy((ChartRectEmbedment)embedObject);
                layer.addEmbed(qingChart);
                continue;
            }
            if (!(embedObject instanceof EmbedImage)) continue;
            EmbedImage destImage = new EmbedImage(destSheet);
            destImage.copy((EmbedImage)embedObject);
            layer.addEmbed(destImage);
        }
        return layer;
    }

    public String getNewEmbedName(EmbedObject graph, boolean copySign) {
        String newName;
        String seedName = graph.getName();
        if (StringUtil.isEmptyString((String)seedName)) {
            String sheetNamePrefix = Global.getStringProperity("ChartNamePrefix", CtrlEXTMessages.getMLS("icon", "\u56fe\u6807"));
            if (graph instanceof EmbedImage) {
                sheetNamePrefix = Global.getStringProperity("PictureNamePrefix", CtrlEXTMessages.getMLS("image", "\u56fe\u7247"));
            }
            int num = this.size() + 1;
            newName = sheetNamePrefix + num;
            while (this.findEmbed(newName) != null) {
                newName = sheetNamePrefix + ++num;
            }
        } else {
            int dup = 2;
            int rightIndex = seedName.lastIndexOf(41);
            int leftIndex = seedName.lastIndexOf(40);
            if (leftIndex >= 0 && rightIndex > leftIndex - 1 && rightIndex == seedName.length() - 1) {
                try {
                    dup = Integer.parseInt(seedName.substring(leftIndex + 1, rightIndex));
                    seedName = seedName.substring(0, leftIndex);
                }
                catch (Exception e) {
                    dup = 2;
                }
            }
            newName = seedName;
            int seedLen = seedName.length();
            while (this.findEmbed(newName) != null && copySign) {
                String tail = "(" + dup + ")";
                int tLen = tail.length();
                newName = seedLen + tLen > 31 ? seedName.substring(0, 31 - tLen) + tail : seedName + tail;
                ++dup;
            }
        }
        return newName;
    }

    public boolean contains(EmbedObject graph) {
        return this.size() > 0 && this._graphs.contains(graph);
    }

    public boolean removeSelectedEmbeds() {
        if (!this.hasSelectionImpl()) {
            return false;
        }
        return new GraphRemoveActionEdit("Graph_Remove").run();
    }

    public void abortImageObservers() {
        if (this._graphs == null) {
            return;
        }
        for (EmbedObject embed : this._graphs) {
            if (!(embed instanceof EmbedImage)) continue;
            ((EmbedImage)embed).imageUpdate(null, 128, 0, 0, 0, 0);
        }
    }

    private void removeEmbedImageNotify(EmbedObject embed) {
        if (embed instanceof EmbedImage) {
            ((EmbedImage)embed).imageUpdate(null, 128, 0, 0, 0, 0);
        }
    }

    private void removeEmbedImageNotify(List embeds) {
        Iterator iterator = embeds.iterator();
        while (iterator.hasNext()) {
            this.removeEmbedImageNotify((EmbedObject)iterator.next());
        }
    }

    public boolean cancelSelectedEmbeds() {
        boolean ret = false;
        if (this.hasSelectionImpl()) {
            EmbedObject[] graphs = this.getSelectedEmbedArray();
            GraphChangedEvent e = new GraphChangedEvent(this._sheet, graphs, "Graph_PreDeselected", true);
            this._sheet.getBook().fireGraphChange(e);
            for (int i = this._selGraphs.size() - 1; i >= 0; --i) {
                boolean b = this.setEmbedSelected(this.getSelectedEmbed(i), false);
                if (ret) continue;
                ret = b;
            }
            if (ret) {
                e = new GraphChangedEvent(this._sheet, graphs, "Graph_Deselected", true);
                this._sheet.getBook().fireGraphChange(e);
            }
        }
        return ret;
    }

    public boolean moveSelectedEmbedsTop() {
        return this.moveSelectedEmbedssLevel(true, -1);
    }

    public boolean moveSelectedEmbedsBottom() {
        return this.moveSelectedEmbedssLevel(false, -1);
    }

    public boolean moveSelectedEmbedssLevel(boolean toTop, int deltLev) {
        if (this.size() <= 0) {
            return false;
        }
        if (!this.hasSelectionImpl()) {
            return false;
        }
        if (toTop) {
            if (deltLev < 0) {
                ArrayList<EmbedObject> al = new ArrayList<EmbedObject>();
                int size = this.size();
                for (int i = 0; i < size; ++i) {
                    EmbedObject gr = this.getEmbed(i);
                    if (!gr.isSelected()) continue;
                    this._graphs.remove(gr);
                    al.add(gr);
                }
                this._graphs.addAll(al);
                return true;
            }
            if (deltLev > 0) {
                int size;
                for (int i = size = this.size() - 1; i >= 0; --i) {
                    EmbedObject gr = this.getEmbed(i);
                    if (!gr.isSelected()) continue;
                    this._graphs.remove(gr);
                    this._graphs.add(Math.min(i + deltLev, size), gr);
                }
                return true;
            }
            return false;
        }
        if (deltLev < 0) {
            ArrayList<EmbedObject> al = new ArrayList<EmbedObject>();
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                EmbedObject gr = this.getEmbed(i);
                if (!gr.isSelected()) continue;
                this._graphs.remove(gr);
                al.add(gr);
            }
            this._graphs.addAll(0, al);
            return true;
        }
        if (deltLev > 0) {
            int size = this.size() - 1;
            for (int i = 0; i <= size; ++i) {
                EmbedObject gr = this.getEmbed(i);
                if (!gr.isSelected()) continue;
                this._graphs.remove(gr);
                this._graphs.add(Math.max(i - deltLev, 0), gr);
            }
            return true;
        }
        return false;
    }

    public boolean setEmbed(EmbedObject old, EmbedObject currentObject) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            EmbedObject gr = this.getEmbed(i);
            if (old != gr) continue;
            return this.setEmbed(i, currentObject);
        }
        return false;
    }

    public boolean setEmbed(int index, EmbedObject currentObject) {
        if (index >= 0 && index < this._graphs.size()) {
            this._graphs.set(index, currentObject);
            return true;
        }
        return false;
    }

    public EmbedObject findEmbed(String name) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            EmbedObject gr = this.getEmbed(i);
            if (!gr.getName().equalsIgnoreCase(name)) continue;
            return gr;
        }
        return null;
    }

    public void selectAllEmbeds() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            EmbedObject g = this.getEmbed(i);
            if (g.isSelected()) continue;
            this.selectEmbed(g, 1);
        }
    }

    public void selectEmbed(String name, int selMode) {
        this.selectEmbed(this.findEmbed(name), selMode);
    }

    public void selectEmbed(EmbedObject graph, int selMode) {
        boolean old = this.hasSelectionImpl();
        if (selMode == 2) {
            this.cancelSelectedEmbeds();
            this.setEmbedSelected(graph, true);
            this._sheet.getBook().fireGraphChange(new GraphChangedEvent(this._sheet, graph, "Graph_Selected", old != this.hasSelectionImpl()));
        } else {
            boolean oldStatus = graph.isSelected();
            this.setEmbedSelected(graph, !oldStatus);
            this._sheet.getBook().fireGraphChange(new GraphChangedEvent(this._sheet, graph, oldStatus ? "Graph_Deselected" : "Graph_Selected", old != this.hasSelectionImpl()));
        }
    }

    public Object selectEmbed(Point p, int selMode) {
        boolean old = this.hasSelectionImpl();
        HotSpot hs = this.getTouchHotSpot(p);
        if (hs != null) {
            return hs;
        }
        if (selMode == 2) {
            EmbedObject gr = this.getTouchEmbed(p);
            if (gr == null) {
                gr = this.isFocusArea(p);
                if (gr != null) {
                    return gr;
                }
                gr = this.getFocusedEmbed(p);
                if (gr != null) {
                    return gr;
                }
                this.cancelSelectedEmbeds();
                return null;
            }
            if (!gr.isSelected()) {
                this.cancelSelectedEmbeds();
                this.setEmbedSelected(gr, true);
                this._sheet.getBook().fireGraphChange(new GraphChangedEvent(this._sheet, gr, "Graph_Selected", old != this.hasSelectionImpl()));
                return gr;
            }
            return gr;
        }
        EmbedObject gr = this.getTouchEmbed(p);
        if (gr != null) {
            boolean oldStatus = gr.isSelected();
            this.setEmbedSelected(gr, !oldStatus);
            this._sheet.getBook().fireGraphChange(new GraphChangedEvent(this._sheet, gr, oldStatus ? "Graph_Deselected" : "Graph_Selected", old != this.hasSelectionImpl()));
            return gr;
        }
        return null;
    }

    public Shape getOffsetShape(HotSpot hs, int dx, int dy) {
        Area area = new Area();
        int size = this.selectionSize();
        for (int i = 0; i < size; ++i) {
            EmbedObject o = this.getSelectedEmbed(i);
            if (o instanceof EmbedImage) {
                if (!((EmbedImage)o).isDragEnable()) {
                    area.add(new Area(o.getOutLine(hs, 0, 0)));
                    continue;
                }
                area.add(new Area(o.getOutLine(hs, dx, dy)));
                continue;
            }
            area.add(new Area(o.getOutLine(hs, dx, dy)));
        }
        return area;
    }

    public EmbedObject getTouchEmbed(Point p) {
        EmbedIterator iter = this.getIterator(true);
        while (iter.hasNext()) {
            EmbedObject g = iter.next();
            if (!g.contains(p.x, p.y)) continue;
            return g;
        }
        return null;
    }

    public HotSpot getTouchHotSpot(Point p) {
        EmbedIterator iter = this.getIterator(true, true);
        while (iter.hasNext()) {
            EmbedImageType type;
            EmbedObject g = iter.next();
            if (g instanceof EmbedImage && (type = ((EmbedImage)g).getType()) != EmbedImageType.Referred_Image && type != EmbedImageType.Static_Embed_Image && type != EmbedImageType.Referred_Path_Image && (type != EmbedImageType.Embeded_Image || !((EmbedImage)g).isDragEnable())) continue;
            HotSpot[] hs = g.getHotSpots();
            for (int i = hs.length - 1; i >= 0; --i) {
                Shape shape = hs[i].getShape();
                if (!shape.contains(p)) continue;
                return hs[i];
            }
        }
        return null;
    }

    public EmbedObject isFocusArea(Point p) {
        EmbedIterator iter = this.getIterator(true, true);
        while (iter.hasNext()) {
            EmbedObject g = iter.next();
            if (!(g instanceof ChartRectEmbedment) || !((ChartRectEmbedment)g).isInFocusArea(p)) continue;
            return g;
        }
        return null;
    }

    public EmbedObject getFocusedEmbed(Point p) {
        EmbedIterator iter = this.getIterator(true, true);
        while (iter.hasNext()) {
            EmbedObject g = iter.next();
            if (!(g instanceof ChartRectEmbedment) || !((ChartRectEmbedment)g).isInTransformRect(p)) continue;
            return g;
        }
        return null;
    }

    public void paint(Graphics g) {
        EmbedObject grp;
        EmbedObject activeObject = null;
        if (this._selGraphs != null && this._selGraphs.size() == 1) {
            activeObject = this.getActiveSelectedEmbed();
        }
        EmbedIterator iter = this.getIterator(false);
        while (iter.hasNext()) {
            grp = iter.next();
            if (grp == activeObject || !this.isVisibleInView(grp)) continue;
            grp.paintData(g);
        }
        if (activeObject == null) {
            iter = this.getIterator(false, true);
            while (iter.hasNext()) {
                grp = iter.next();
                grp.paintFocus(g);
            }
        } else {
            activeObject.paintData(g);
            activeObject.paintFocus(g);
        }
    }

    public EmbedIterator getIterator(boolean bTopBottom) {
        return this.getIterator(bTopBottom, false);
    }

    public EmbedRange getSelectionRange() {
        return new EmbedRange(this, this.getSelectedEmbedArray());
    }

    public EmbedRange getEmbedRange(EmbedObject eo) {
        if (!this._graphs.contains(eo)) {
            return null;
        }
        return new EmbedRange(this, new EmbedObject[]{eo});
    }

    public EmbedRange getEmbedRange(EmbedObject[] eos) {
        if (!this._graphs.containsAll(Arrays.asList(eos))) {
            return null;
        }
        return new EmbedRange(this, eos);
    }

    private boolean setEmbedSelected(EmbedObject graph, boolean bSel) {
        if (graph.isSelected() == bSel) {
            return false;
        }
        graph.setSelected(bSel);
        if (bSel) {
            if (this._selGraphs == null) {
                this._selGraphs = new ArrayList();
            }
            this._selGraphs.add(graph);
        } else if (this.hasSelectionImpl()) {
            this._selGraphs.remove(graph);
        }
        return true;
    }

    private void clearChart(EmbedObject graph) {
        if (graph instanceof EChart || graph instanceof QingChart) {
            graph.merge();
        }
    }

    public int selectionSize() {
        if (this._selGraphs != null) {
            return this._selGraphs.size();
        }
        return 0;
    }

    public EmbedObject getActiveSelectedEmbed() {
        if (this.hasSelectionImpl()) {
            return this.getSelectedEmbed(0);
        }
        return null;
    }

    private boolean hasSelectionImpl() {
        return this._selGraphs != null && this._selGraphs.size() > 0;
    }

    public EmbedObject getSelectedEmbed(int index) {
        return (EmbedObject)this._selGraphs.get(index);
    }

    private EmbedObject[] getSelectedEmbedArray() {
        if (this._selGraphs == null) {
            return new EmbedObject[0];
        }
        return this._selGraphs.toArray(new EmbedObject[0]);
    }

    private EmbedIterator getIterator(boolean bTopBottom, boolean bSelect) {
        return new EmbedIterator(bTopBottom, bSelect);
    }

    public void setVisibleRects(Rectangle[] visibleRects) {
        this._visibleRects = visibleRects;
    }

    public boolean isVisibleInView(EmbedObject em) {
        if (!this.contains(em)) {
            return false;
        }
        Rectangle bounds = em.getBounds();
        if (this._visibleRects != null) {
            boolean visible = false;
            int size = this._visibleRects.length;
            for (int i = size - 1; i >= 0; --i) {
                if (this._visibleRects[i] == null || !(visible = this._visibleRects[i].intersects(bounds))) continue;
                return true;
            }
        }
        return false;
    }

    class GraphRemoveActionEdit
    extends EmbedActionEdit {
        private ArrayList _delGraphs;
        private ArrayList _indexs;

        GraphRemoveActionEdit(String type) {
            super(type);
            this._delGraphs = new ArrayList(EmbedhLayer.this.selectionSize());
            this._indexs = new ArrayList(EmbedhLayer.this.selectionSize());
            for (int i = EmbedhLayer.this.size() - 1; i >= 0; --i) {
                EmbedObject gr = EmbedhLayer.this.getEmbed(i);
                if (!gr.isSelected()) continue;
                this._indexs.add(i);
                this._delGraphs.add(gr);
                gr.setSelected(false);
            }
        }

        @Override
        protected boolean action(Sheet sheet, boolean redo, boolean withUndo) {
            EmbedhLayer.this._selGraphs.clear();
            if (redo) {
                EmbedhLayer.this.removeEmbedImageNotify(this._delGraphs);
                EmbedhLayer.this._graphs.removeAll(this._delGraphs);
            } else {
                for (int i = this._indexs.size() - 1; i >= 0; --i) {
                    int index = (Integer)this._indexs.get(i);
                    EmbedhLayer.this._graphs.add(index, this._delGraphs.get(i));
                }
            }
            return true;
        }

        @Override
        protected EmbedObject[] getChangedGraphs() {
            return this._delGraphs.toArray(new EmbedObject[0]);
        }

        @Override
        public String getPresentationName() {
            if (this._delGraphs.size() > 1) {
                return CtrlEXTMessages.getMLS("clearMultipleObjects", "\u6e05\u9664\u591a\u4e2a\u5bf9\u8c61");
            }
            if (this._delGraphs.size() > 0) {
                return CtrlEXTMessages.getMLS("clear", "\u6e05\u9664") + ((EmbedObject)this._delGraphs.get(0)).getName();
            }
            return "";
        }
    }

    class GraphInsActionEdit
    extends EmbedActionEdit {
        private EmbedObject _graph;

        GraphInsActionEdit(String type, EmbedObject graph) {
            super(type);
            this._graph = graph;
            this._graph.setName(EmbedhLayer.this.getNewEmbedName(this._graph, false));
        }

        @Override
        protected boolean action(Sheet sheet, boolean redo, boolean withUndo) {
            if (redo) {
                if (EmbedhLayer.this._graphs == null) {
                    EmbedhLayer.this._graphs = new ArrayList();
                }
            } else {
                EmbedhLayer.this.removeEmbedImageNotify(this._graph);
                EmbedhLayer.this._graphs.remove(this._graph);
                EmbedhLayer.this.setEmbedSelected(this._graph, false);
                EmbedhLayer.this.clearChart(this._graph);
                return true;
            }
            EmbedhLayer.this._graphs.add(this._graph);
            return true;
        }

        @Override
        protected EmbedObject[] getChangedGraphs() {
            return new EmbedObject[]{this._graph};
        }

        @Override
        public String getPresentationName() {
            return CtrlEXTMessages.getMLS("KEY_INSERT", "\u63d2\u5165") + this._graph.getName();
        }
    }

    abstract class EmbedActionEdit
    extends AbstractBookUndoableEdit {
        protected String _type;

        protected EmbedActionEdit(String type) {
            this._type = type;
        }

        @Override
        public SortedSheetArray getRelatedSheets() {
            SortedSheetArray sheets = new SortedSheetArray();
            sheets.insert(EmbedhLayer.this.getSheet());
            return sheets;
        }

        public boolean run() {
            boolean withUndo = EmbedhLayer.this._sheet.getBook().getUndoManager().isEnable();
            boolean oldSel = EmbedhLayer.this.hasSelectionImpl();
            boolean bAction = this.action(EmbedhLayer.this._sheet, true, withUndo);
            if (bAction) {
                this.invalidate(oldSel);
                if (withUndo) {
                    EmbedhLayer.this._sheet.getBook().getUndoManager().addEdit(this);
                }
            }
            return bAction;
        }

        @Override
        public void undo() throws UndoException {
            this.unredo(false);
        }

        @Override
        public void redo() throws UndoException {
            this.unredo(true);
        }

        private void unredo(boolean redo) throws UndoException {
            if (redo) {
                super.redo();
            } else {
                super.undo();
            }
            boolean withUndo = EmbedhLayer.this._sheet.getBook().getUndoManager().isEnable();
            boolean oldSel = EmbedhLayer.this.hasSelectionImpl();
            this.action(EmbedhLayer.this._sheet, redo, withUndo);
            this.invalidate(oldSel);
        }

        protected void invalidate(boolean oldSel) {
            EmbedhLayer.this._sheet.getBook().fireGraphChange(new GraphChangedEvent(EmbedhLayer.this._sheet, this.getChangedGraphs(), this._type, oldSel != EmbedhLayer.this.hasSelectionImpl()));
        }

        protected abstract boolean action(Sheet var1, boolean var2, boolean var3);

        protected abstract EmbedObject[] getChangedGraphs();
    }

    public class EmbedIterator {
        private int _index;
        private boolean _bTopBottom;
        private boolean _bSelect;

        public EmbedIterator(boolean bTopBottom, boolean bSelect) {
            this._bTopBottom = bTopBottom;
            this._bSelect = bSelect;
            this._index = this._bTopBottom ? (this._bSelect ? EmbedhLayer.this.selectionSize() : EmbedhLayer.this.size()) - 1 : 0;
        }

        public boolean hasNext() {
            return this._bTopBottom ? this._index >= 0 : this._index < (this._bSelect ? EmbedhLayer.this.selectionSize() : EmbedhLayer.this.size());
        }

        public EmbedObject next() {
            int n;
            if (this._bSelect) {
                int n2;
                if (this._bTopBottom) {
                    int n3 = this._index;
                    n2 = n3;
                    this._index = n3 - 1;
                } else {
                    int n4 = this._index;
                    n2 = n4;
                    this._index = n4 + 1;
                }
                return EmbedhLayer.this.getSelectedEmbed(n2);
            }
            if (this._bTopBottom) {
                int n5 = this._index;
                n = n5;
                this._index = n5 - 1;
            } else {
                int n6 = this._index;
                n = n6;
                this._index = n6 + 1;
            }
            return EmbedhLayer.this.getEmbed(n);
        }
    }
}

